CREATE TABLE `word_en` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `w_code` varchar(64) NOT NULL COMMENT 'code',
  `word` varchar(64) NOT NULL COMMENT 'word',
  `accent` varchar(64) NOT NULL COMMENT 'accent',
  `mean_cn` varchar(1024) NOT NULL COMMENT 'mean_cn',
  `mean_en` varchar(1024) DEFAULT NULL COMMENT 'mean_en',
  `sentence` varchar(1024) DEFAULT NULL COMMENT 'sentence',
  `sentence_trans` varchar(1024) DEFAULT NULL COMMENT 'sentence_trans',
  `sentence_phrase` varchar(1024) DEFAULT NULL COMMENT 'sentence_phrase',
  `word_etyma` varchar(1024) DEFAULT NULL COMMENT 'word_etyma',
  `level` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'level',
  `weight` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'weight',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_code` (`w_code`),
  KEY `idx_word` (`word`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='英文词汇表'
;

INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1,'get_close_(to)','get close (to)','/ɡet kloʊs tu/','phr. 接近','be close to','It wasn\'t until I got close to the end that I realized I had won the race.','直到我接近终点我才意识到我已经赢得了比赛。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2,'acute','acute','/əˈkjut/','adj.严重的','very serious or severe','When she was working, she felt an acute pain in her neck.','工作的时候，她感到脖子一阵剧痛。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (3,'humble','humble','/ˈhʌmbl/','adj. 卑微的；谦逊的；  v. 使……谦逊，使……卑下','to make somebody feel that they are not as good or important as they thought they were','The general rose from humble beginnings.','那位将军出身卑微。','','hum土地 + ble形容词后缀 → 接近地面 → humble谦恭的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (4,'skilful_at','skilful at','/ˈskɪlfl æt/','phr.擅长，善于','','She\'s skilful at drawing.','她擅长绘画。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (5,'detour','detour','/ˈdiːtʊr/','n. 弯路，绕行之路；  v. 绕道，迂回','a longer route that you take in order to avoid a problem or to visit a place; a road or route that is used when the usual one is closed','I had to take a detour to the destination because my usual shortcut was blocked off.','我不得不绕路前往目的地，因为我常用的捷径被阻断了。','','de加强动作 + tour旋转；迂回 → 转着走 → 迂路；曲折',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (6,'million','million','/ˈmɪljən/','num.百万','1 000 000; a very large amount','The businessman holds one million dollars in his arms.','这个商人怀里抱着一百万美元。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (7,'before','before','/bɪˈfɔːr/','prep.在……前面（空间）；  conj.在……之前（时间）；  adv.以前','','There\'s only one person before me in line!','在队伍里我前面就只有一个人。','only one person before me','be在 + fore在前的 → before在…以前',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (8,'scold','scold','/skoʊld/','v.怒骂，责骂，训斥','to speak angrily to somebody, especially a child, because they have done something wrong','The mother scolds her child.','那位母亲斥责她的小孩。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (9,'overall','overall','/ˌoʊvərˈɔːl/','n.罩衫，工装服；  adj.全面的，全部的','a pair of pants with an extra piece attached that covers the chest and has straps that go over the shoulders','In old factory photos, all the steel workers wore overalls.','在旧工厂照片里，所有的钢铁工人都穿着工装服。','','over覆盖 + all全部 → 覆盖全部 → overall全部的，全面的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (10,'literature','literature','/ˈlɪtrətʃər/','n.文学；文献；宣传册','pieces of writing that are valued as works of art, especially novels, plays and poems (in contrast to technical books and newspapers, magazines, etc.)','The professor is giving a lecture on modern Chinese literature.','教授正在进行一场有关中国现代文学的讲座。','','litera=letter文字，字母 + ture状态 → 文字状态 → literature文学',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (11,'sufficient','sufficient','/səˈfɪʃnt/','adj.足够的，充足的','enough for a particular purpose; as much as you need','The animal has sufficient food for winter.','这只动物有充足的食物来过冬。','','suffic足以 + ient形容词后缀 → sufficient 足够的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (12,'continuity','continuity','/ˌkɑːntəˈnuːəti/','n. 连续性','the fact of not stopping or not changing; a logical connection between the parts of something, or between two things','This loop can clearly visualize continuity.','这个环形象的表现出连续性。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (13,'bacterium','bacterium','/bæk\'tɪriəm/','n. 细菌','the simplest and smallest forms of life. Bacteria exist in large numbers in air, water and soil, and also in living and dead creatures and plants, and are often a cause of disease.','This kind of bacterium can cause a very dangerous disease.','这种细菌能引发非常危险的疾病。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (14,'midnight','midnight','/ˈmɪdnaɪt/','n.子夜，午夜；午夜蓝','12 o’clock at night','When the clock shows 12 at night, it is midnight.','当时钟在晚上显示12点时，那便是午夜。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (15,'poise','poise','/pɔɪz/','n. 泰然自若，信心；  v. 使相等，使平衡','a calm, confident manner','We were all impressed by her poise and confidence.','她的镇定、自信给我们留下了深刻的印象。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (16,'able','able','/ˈeɪbl/','adj. 能够……的；有能力的','(used as a modal verb) to have the skill, intelligence, opportunity, etc. needed to do something','Now he is able to walk without the help of crutches.','现在他能够脱离拐杖走路了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (17,'signal','signal','/ˈsɪɡnəl/','n.信号；  v.发信号','a movement or sound that you make to give somebody information, instructions, a warning, etc.; a series of electrical waves that carry sounds, pictures or messages, for example to a radio, television or mobile/cell phone; a piece of equipment that uses different coloured lights to tell drivers to go slower, stop, etc., used especially on railways/railroads and roads','The ship sent out a signal for help.','这艘船发出了求救信号。','','sign标志 + al名词/形容词后缀 → signal信号/显要的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (18,'lucid','lucid','/ˈluːsɪd/','adj.明晰的；头脑清楚的','able to be seen through with clarity','The professor gives a lucid presentation about how to put an elephant in a fridge.','教授在如何把大象放进冰箱的问题上给出了明晰的介绍。','a lucid presentation','luc光，照亮 + id形容词后缀 → lucid透明的，清楚的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (19,'weapon','weapon','/ˈwepən/','n. 武器；手段','an object such as a knife, gun, bomb, etc. that is used for fighting or attacking somebody','There are a number of different kinds of weapons on the floor.','地上有很多种不同的武器。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (20,'devastation','devastation','/ˌdevəˈsteɪʃn/','n. 毁坏，荒废；荒芜，凄凉','The act of devastating, or the state of being devastated; a laying waste.','A tsunami caused mass devastation in this city.','海啸给这座城市造成了极大的破坏。','','de 加强意义 + vast去掉，摧毁 + ation [名词后缀],表示行为、情况、状态、过程、结果 → devastation毁坏，荒废',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (21,'in_touch_with','in touch with','/ɪn tʌtʃ wɪð/','phr. 与……保持联系','','She stays in touch with her friends and family. ','她与朋友和家人保持着联系。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (22,'appeal_for','appeal for','/əˈpiːl fɔːr/','phr. 要求，呼吁','make a request','Many people are on parade to appeal for government changes.','很多人上街游行来要求政府作出改变。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (23,'aggravation','aggravation','/ˌæɡrəˈveɪʃn/','n.恶化，加剧','an exasperated feeling of annoyance','With the aggravation of pollution, there are fewer and fewer fishes populating our rivers.','随着污染的加剧，河流中的鱼越来越少了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (24,'audience','audience','/ˈɔːdiəns/','n.观众，听众','the group of people who have gathered to watch or listen to something (a play, concert, somebody speaking, etc.)','The audience in the conference hall stayed quiet during his speech.','他讲话时，会议厅里的听众都很安静。','','audi听 + ence表名词 → 听众，观众，读者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (25,'considering','considering','/kənˈsɪdərɪŋ/','conj.考虑到，鉴于','','Considering she\'s only three, she can draw pretty well.','考虑到她只有三岁，她已经画得很好了。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (26,'Asian','Asian','/ˈeɪʃn/','adj.亚洲的；  n.亚洲人','of or connected with Asia','The Asian continent is a vast area.','亚洲大陆幅员辽阔。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (27,'diary','diary','/ˈdaɪəri/','n.日记','a book in which you can write down the experiences you have each day, your private thoughts, etc.','The girl keeps a diary every day.','女孩儿每天都写日记。','keeps a diary','di日子 + ary表名词 → diary日记',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (28,'ferocious','ferocious','/fəˈroʊʃəs/','adj. 凶猛的；强烈的，严重的','very fierce or violent','The lion looked ferocious as he bared his teeth.','狮子露出牙齿的时候看起来真凶猛。','looked ferocious','feroci凶猛 ＋ ous...的 → ferocious凶猛的，凶恶的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (29,'assault','assault','/əˈsɔːlt/','n. 攻击，袭击；  v. 攻击，袭击，殴打','the crime of attacking somebody physically; (by an army, etc.) the act of attacking a building, an area, etc. in order to take control of it; an act of criticizing somebody/something severely','The troops are conducting an assault on the enemy lines.','军队正在对敌方防线展开袭击。','','as一再 + sault跳 → 跳起来 → assault进攻',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (30,'jail','jail','/dʒeɪl/','n. 监狱；看守所；  v. 监禁；拘留','a prison','The prisoner can do nothing but sleep in his jail cell.','这名犯人在监狱里除了睡觉之外什么事都不能做。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (31,'deterrent','deterrent','/dɪˈtɜːrənt/','n.威慑物','something that prevents people from doing something by making them afraid of what will happen to them if they do it','The armed guards are a deterrent to potential robbers.','这些武装警卫对潜在的劫匪来说具有威慑作用。','','deter威慑 + ent……的 → 威慑的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (32,'mandatory','mandatory','/ˈmændətɔːri/','adj. 命令的，强制性的','required by a law or rule','Uniform hairstyle is a mandatory requirement for military training.','统一发型是军训的强制性要求。','a mandatory requirement','mand命令 + atory...的 → mandatory命令性的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (33,'custodian','custodian','/kʌˈstoʊdiən/','n. 监护人，保管人，看守人','a person who cleans and takes care of a building','He is happy to be a custodian of this forest.','他很乐意当一个森林看护人。','a custodian of this forest','custod=custody监管+ian职业，地位 →管理员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (34,'horrify','horrify','/ˈhɔːrɪfaɪ/','v. 吓，使战悚，使惊骇','to make somebody feel extremely shocked, disgusted or frightened','Your costume will horrify many children.','你的服饰会吓到很多小朋友。','','horr颤抖，害怕 + i + fy使… → 使人害怕 → horrify吓，使战悚',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (35,'popular','popular','/ˈpɑːpjələr/','adj.受欢迎的','liked or enjoyed by a large number of people','This man is so popular that many people invited him.','这个人非常受欢迎，很多人邀请了他。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (36,'comfort','comfort','/ˈkʌmfərt/','v. 安慰；使舒适；  n. 舒适','to make somebody who is worried or unhappy feel better by being kind and sympathetic towards them','The woman tries to comfort her crying daughter.','那个女人在安慰正在哭泣的女儿。','','com共同 + fort加强 → 精神强大 → comfort安慰',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (37,'nearby','nearby','/ˌnɪrˈbaɪ/','adj.附近的，邻近的；  adv.在附近','near in position; not far away','My bluetooth phone can exchange information with any similar phone that is nearby.','我的蓝牙手机可以跟附近任何相似的手机交换信息。','','near附近 + by旁边 → nearby附近的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (38,'fixture','fixture','/ˈfɪkstʃər/','n. 固定装置','a thing such as a bath/ bathtub or a toilet that is fixed in a house and that you do not take with you when you move house','Bathtubs and toilets are common fixtures in bathrooms.','浴缸和马桶是浴室中常见的固定装置。','','fix固定 + ture表名词 → 固定物，修理',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (39,'anguish','anguish','/ˈæŋɡwɪʃ/','n. 痛苦；苦恼；  v. 感到极度痛苦','severe pain, mental suffering or unhappiness','He\'s crying out in anguish because he lost money.','他因为丢钱而痛苦得放声大哭。','','angu苦恼 + ish……的 → anguish苦恼的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (40,'registrar','registrar','/ˌredʒɪˈstrɑːr/','n. 登记员，记录员','someone who is in charge of keeping records especially of births, marriages, and deaths','You have to fill in a form at the registrar\'s if you want to vote.','如果你想要投票，得先在登记员那儿填表。','at the registrar\'s','registr=regisyter注册 ＋ ar表名词 → registrar注册员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (41,'password','password','/ˈpæswɜːrd/','n. 密码，口令','a series of letters or numbers that you must type into a computer or computer system in order to be able to use it.','The computer is locked; do you know the right password?','这个电脑锁上了，你知道它的密码吗？','','pass通过+word命令→密码,口令',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (42,'visa','visa','/ˈviːzə/','n.签证','a stamp or mark put in your passport by officials of a foreign country that gives you permission to enter, pass through or leave their country','I\'ve got my visa ready, and now I can travel around the world!','我拿到了我的签证，现在我可以环游世界啦！','','vis看 + a → 审视，审查 → 审查后的签证 → visa签证，签准',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (43,'dilute','dilute','/daɪˈluːt/','v. 使变淡，稀释；使病弱','to make a liquid weaker by adding water or another liquid to it','Water dilutes the solution quickly.','水可以很快稀释溶液。','','di使…变成，分开 + lute冲洗 → 冲洗开 → dilute冲淡',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (44,'dryer','dryer','/ˈdraɪər/','n.吹风机；烘干机','(especially in compounds) a machine for drying something','I use a dryer to dry off my hands.','我用烘干机来烘干我的手。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (45,'fisherman','fisherman','/ˈfɪʃərmən/','n.渔夫','a person (especially a man) who catches fish','The fisherman hoped that his net would be full of fish.','渔夫希望他的渔网满是鱼。','','fisher钓鱼的人 + man人 → fisherman渔民，渔夫',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (46,'marginal','marginal','/ˈmɑːrdʒɪnl/','adj.微小的，不重要的；边缘的','small and not important','There has been only a marginal improvement in her score.','她的分数只有略微的提高。','','margin边缘 + al表示属于……的、具有……性质的、如……的 → marginal微小的，不重要的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (47,'care_for','care for','/ker fɔr/','phr. 照料（看），喜欢','to look after somebody who is sick, very old, very young, etc.','The mother cared for her daughter when she was sick.','妈妈在女儿生病的时候照顾她。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (48,'mansion','mansion','/ˈmænʃn/','n.官邸，巨宅，公馆','a large impressive house','Look at how huge that mansion is!','你看这座宅邸多宏伟！','','mans=manse住宅 + ion物 → mansion大厦',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (49,'analog','analog','/ˈænəlɑːɡ/','adj. 有长短针的；  n. 类似物；  adj. 模拟的；  n. 模拟','a thing that is similar to another thing','An analog watch utilizes a pointer on a dial rather than digitized numbers.','不同于以数字形式显示时间的手表，指针式手表通过表盘上的指针显示时间。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (50,'glasshouse','glasshouse','/ˈɡlæshaʊs/','n. 温室，暖房','a building with glass sides and a glass roof, for growing plants in; a type of large greenhouse','Plants grow faster in the glasshouse.','温室里的植物长得格外得快。','in the glasshouse','glass给某物加玻璃 + house房子 → 加玻璃的房子 → 暖房',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (51,'emperor','emperor','/ˈempərər/','n. 皇帝','the ruler of an empire','In ancient China, the emperor was the most powerful man.','在中国古代，皇帝是最有权力的人。','','emper命令，统治 ＋ or表示人 → 统治者 → emperor皇帝',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (52,'emphasis','emphasis','/ˈemfəsɪs/','n. 重点；强调；重要性','special importance that is given to something','The word has been highlighted to provide emphasis.','标亮单词，以示重点。','','em进入 + phasis显示 → 进入显示 → emphasis强调',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (53,'chat','chat','/tʃæt/','n. 闲谈，聊天；  v. 闲谈，聊天','to talk in a friendly informal way to somebody','They usually have a chat while drinking coffee.','他们通常在喝咖啡时闲聊。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (54,'March','March','/mɑːrtʃ/','n.三月','march in a procession','Women\'s Day is on March 8th every year.','每年的三月八日是妇女节。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (55,'cellular','cellular','/ˈseljələr/','adj. 细胞的，无线的；蜂窝式的','connected with or consisting of the cells of plants or animals; connected with a telephone system that works by radio instead of wires','My cellular phone lets me call anybody, anywhere, anytime.','我的移动电话让我随时随地都能给任何人通话。','','cell细胞 + u + lar形容词后缀 → cellular细胞的，移动电话',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (56,'sponsor','sponsor','/ˈspɑːnsər/','vt. 赞助；做……的保人；  n. 赞助人','a person or company that pays for a radio or television programme, or for a concert or sporting event, usually in return for advertising','This TV program is sponsored by a number of companies.','这个电视节目由多家企业赞助。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (57,'collaborate','collaborate','/kəˈlæbəreɪt/','v. 合作','to work together with somebody in order to produce or achieve something','They collaborated to draw up a business plan.','他们合作起草了一个商业计划。','','col共同 + labor劳动 + ate使 → 共同劳动 → 合作；勾结',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (58,'take_sb._out','take sb. out','/teɪk ˈsʌmbədi aʊt/','phr. 带…出去；淘汰出局','take somebody somewhere','My father often takes me out for hamburger.','我爸爸经常带我出去吃汉堡。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (59,'rehearsal','rehearsal','/rɪˈhɜːrsl/','n.排练，排演','time that is spent practising a play or piece of music in preparation for a public performance','The four girls are having a rehearsal now.','这四个女孩正在排练。','','rehears(e)排练 + al名词后缀 → rehearsal排练',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (60,'jerk','jerk','/dʒɜːrk/','v. 猛拉；使猝然一动；  n. 急推；急拉；蠢货；古怪的人','to move or to make something move with a sudden short sharp movement','He jerked the pen away from his friend.','他猛地把笔从朋友手里拿开。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (61,'wait','wait','/weɪt/','v.等待；  n.等待','to stay where you are or delay doing something until somebody/something comes or something happens','She is waiting for her flight.','她正在等她的航班。','waiting for','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (62,'glider','glider','/ˈɡlaɪdər/','n.滑翔伞；滑翔机','a light aircraft that flies without an engine','The turtle explored the world with its glider.','乌龟乘着它的滑翔伞探索世界。','','glid=glide滑行 + er名词后缀 → 滑行(或物)，滑翔机',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (63,'between','between','/bɪˈtwiːn/','prep. 在……中间','in or into the space separating two or more points, objects, people, etc.','The dragon is between the two boxes.','小龙在两个箱子中间。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (64,'preclude','preclude','/prɪˈkluːd/','v. 阻止，妨碍','to prevent something from happening or somebody from doing something; to make something impossible','The bad weather precluded him from attending the meeting in time.','恶劣的天气妨碍了他及时出席会议。','precluded him from','pre…前的，预先 + clude关闭 → 提前关闭 → preclude阻止',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (65,'whitewash','whitewash','/ˈwaɪtwɑːʃ/','v. 用石灰水把……刷白；  n. 石灰水，白色涂料，白粉胶泥水，涂脂抹粉','to cover something such as a wall with whitewash','This wall is covered in stains, so it will need to be whitewashed.','这堵墙表面覆盖着污斑，所以需要进行粉刷。','','white白色 + wash洗刷 → 用白色液体刷建筑 → whitewash白色涂料，石灰水',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (66,'slander','slander','/ˈslændər/','v.诽谤，诋毁；  n.诽谤，诋毁','to make a false spoken statement about somebody that is intended to damage the good opinion that people have of them','The actress was slandered by people for her social media post.','这位女演员因为社交软件上的发文而被诽谤。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (67,'ensue','ensue','/ɪnˈsuː/','v. 跟着发生，接踵而来','to happen after or as a result of another event','Landslide ensued after the storm.','风暴之后，随之而来的是泥石流。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (68,'blind','blind','/blaɪnd/','adj.失明的；  v.使失明；  n.卷帘','unable to see','The blind woman is crossing the street with her guide dog.','这位失明的女士正和她的导盲犬一起过街。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (69,'tugboat','tugboat','/ˈtʌɡˌbot/','n. 拖船','a powerful small boat designed to pull or push larger ships','The smaller tugboat is pulling the large ship.','小拖船正在拖那艘大船。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (70,'hunting','hunting','/ˈhʌntɪŋ/','n. 打猎','the pursuit and killing or capture of wild animals regarded as a sport','He went hunting with his hound.','他带着猎犬去打猎。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (71,'domain','domain','/doʊˈmeɪn/','n.管区，势力圈；领域','lands owned or ruled by a particular person, government, etc., especially in the past','Don\'t cross the line. This is my domain!','别越过这条线。这是我的地盘！','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (72,'bridge','bridge','/brɪdʒ/','n.桥，桥梁；起连接作用的东西，纽带；  v.把……连接起来；架桥','a structure that is built over a road, railway/railroad, river, etc. so that people or vehicles can cross from one side to the other','There is a small wooden bridge crossing the stream in the woods.','树林里的小溪上有一座木制小桥。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (73,'certain','certain','/ˈsɜːrtn/','adj.有把握的；肯定的，必然的','that you can rely on to happen or to be true','This actor is certain that he will win the award.','这个演员确信他可以获奖。','','cert确实 + ain形容词后缀 → certain确实的，一定的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (74,'exotic','exotic','/ɪɡˈzɑːtɪk/','adj. 奇异的，珍奇的，来自异国的','from or in another country, especially a tropical one; seeming exciting and unusual because it is connected with foreign countries','I have never seen those exotic flowers before.','我过去从未见过这些奇异的花朵。','','exo外部的，外面 + tic形容词后缀 → 从外面来的 → 来自异国的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (75,'stare','stare','/ster/','v. 盯，凝视','to look at somebody/something for a long time','Don\'t stare at my food, you little dog.','不要盯着我的吃的看了，你这只小狗狗。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (76,'generator','generator','/ˈdʒenəreɪtər/','n. 发电机','a machine that produces electricity','The generator is providing electricity to the restaurant.','发电机正在为餐厅供电。','','gener出生，产生+ator表名称，物→产生[电]的东西→发电机',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (77,'aide','aide','/eɪd/','n. 助手','an officer who acts as military assistant to a more senior officer','The spokesman\'s aide handed him the relevant documents before the interview.','采访开始前，这位发言人的助手把相关文件递给了他。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (78,'relic','relic','/ˈrelɪk/','n. 遗迹','an object, a tradition, a system, etc. that has survived from the past','The temple is a relic of the ancient civilization.','这座神庙是古文明的一处遗迹。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (79,'satisfactory','satisfactory','/ˌsætɪsˈfæktəri/','adj.令人满意的','good enough for a particular purpose','The little boy had a satisfactory service at the barber shop.','小男孩在理发店得到了令他满意的服务。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (80,'porch','porch','/pɔːrtʃ/','n. 门廊；走廊','a small area at the entrance to a building, such as a house or a church, that is covered by a roof and often has walls; a platform with an open front and a roof, built onto the side of a house on the ground floor','I love to sit on the front porch and feel the wind.','我喜欢坐在前门廊吹风。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (81,'crime','crime','/kraɪm/','n.罪行；犯罪行为，非法活动','an illegal act or activity that can be punished by law','They are committing a crime in the old couple\'s house.','他们在这对老夫妇的家里实施犯罪。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (82,'carpet','carpet','/ˈkɑːrpɪt/','n. 地毯','a thick woven material made of wool, etc. for covering floors or stairs; a piece of carpet used as a floor covering, especially when shaped to fit a room; a thick layer of something on the ground','I put my books on the carpet.','我把我的书放在了地毯上。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (83,'thrill','thrill','/θrɪl/','n.兴奋，激动；  v.（使）非常兴奋，（使）非常激动','a strong feeling of excitement or pleasure; an experience that gives you this feeling; a sudden strong feeling that produces a physical effect','It gave me a real thrill to ride the rollercoaster!','坐过山车真是太刺激啦！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (84,'hibernation','hibernation','/ˌhaɪbərˈneɪʃn/','n.冬眠','a state like deep sleep in which some animals spend the winter','Shhhhh! The bear is in hibernation now. Don\'t wake him up!','小点儿声！这只熊在冬眠呢，别把它吵醒啦！','in hibernation','hibernat冬眠 + ion名词后缀 → hibernation冬眠；过冬；避寒',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (85,'second-hand','second-hand','/ˌsekənd ˈhænd/','adj. 二手的，旧的，用过的','if you buy something second-hand, it is not new but has been owned by somebody else before','I bought these second-hand items at good prices!','我以好价钱买到了这些二手货。','second-hand items','second第二 ＋ -hand手 → second-hand二手的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (86,'harass','harass','/həˈræs/','v.使困扰，使烦恼','','Stop harassing me with your snoring! Go sleep in the other room!','不要再让你的鼾声打扰我了！去另一个房间睡觉！','Stop harassing me','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (87,'artillery','artillery','/ɑːrˈtɪləri/','n. 大炮，炮兵','large, heavy guns which are often moved on wheels; the section of an army trained to use these guns','The old artillery has been put by the seaside for many years.','这门老旧的大炮放在海边很久了。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (88,'repent','repent','/rɪˈpent/','v. 后悔；悔改','to feel or show that you are sorry for something bad or wrong that you did','The fox repents for his past bullying, hoping they will forgive him.','狐狸后悔过去的欺凌行为，希望他们能原谅他。','','re反 + pent处罚 → 反过来惩罚自己 → repent后悔，悔悟',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (89,'first','first','/fɜːrst/','det. 第一；  adv. 最初','happening or coming before all other similar things or people; 1st','Crossing the finish line in first place is an amazing feeling.','第一个越过终点线是一种很棒的感觉。','in first place','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (90,'retrospect','retrospect','/ˈretrəspekt/','n. 回顾，追溯；  v. 回顾，回想，追溯','a review or contemplation of things in the past','When I look in retrospect of 2016, it had both positive and negative moments.','当我回顾2016年时，我既有开心也有难过的时刻。','','retro向后，倒退+spect看 → retrospect回顾',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (91,'firework','firework','/ˈfaɪərwɜːrk/','n.烟花，烟火','a display of fireworks; a small device containing powder that burns or explodes and produces bright coloured lights and loud noises, used especially at celebrations','Many people come to watch the beautiful fireworks display.','很多人都来看这场美丽的烟花表演。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (92,'extravagant','extravagant','/ɪkˈstrævəɡənt/','adj. 奢侈的，无节制的','spending a lot more money or using a lot more of something than you can afford or than is necessary; costing a lot more money than you can afford or is necessary; (of ideas, speech or behaviour) very extreme or impressive but not reasonable or practical','The extravagant woman spent a large amount of money on these shoes.','那位奢侈的女士花了一大笔钱买这双鞋。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (93,'salty','salty','/ˈsɔːlti/','adj. 含盐的，咸味的','containing salt or too much salt','Fish from the sea taste salty because of the salt in the sea water.','因为海水里有盐，所以海鱼吃起来是咸的。','taste salty','salt盐 + y形容词后缀 → salty 咸的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (94,'identify','identify','/aɪˈdentɪfaɪ/','v.识别出；确定，鉴定','to find or discover somebody/something','Your fingerprints are unique, so they can help identify you to police.','你的指纹是独一无二的，所以它们可以帮助警察识别出你。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (95,'as_usual','as usual','/æz ˈjuːʒuəl/','phr. 通常，平常地','in the way that is normal or usual; as often happens','As usual, he went to the coffee shop to buy his coffee.','和往常一样，他去咖啡店买了一杯咖啡。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (96,'bead','bead','/biːd/','n. 珠子','a small piece of glass, wood, etc. with a hole through it, that can be put on a string with others of the same type and worn as jewellery, etc.','On an abacus, each bead represents part of a number.','在算盘上，每颗珠子代表一个数。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (97,'crises','crises','/ˈkraɪsiːz/','n. 危机，紧要关头，危险期','a time of great danger, difficulty or confusion when problems must be solved or important decisions must be made; a time when a problem, a bad situation or an illness is at its worst point','After a series of crises, our company had to shut down.','经历一连串的危机后，我们的公司只能倒闭了。','','cris危机 + es表复数→ crises危机，紧要关头',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (98,'cool','cool','/kuːl/','adj.凉的；  v.（使）冷却','to become or to make somebody/something become cool or cooler; to become calmer, less excited or less enthusiastic','Washing face with cold water is so cool.','用冷水洗脸特别凉爽！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (99,'define','define','/dɪˈfaɪn/','v.给（词、短语等）下定义；界定，解释','to say or explain what the meaning of a word or phrase is','A puppy boy is defined as a younger boyfriend who is handsome and obedient.','“小奶狗”被定义为帅气又听话的年轻男友。','','de加强语意 + fine边界 → define下定义',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (100,'imagination','imagination','/ɪˌmædʒɪˈneɪʃn/','n. 想象力','the ability to create pictures in your mind; the part of your mind that does this; the ability to have new and exciting ideas','It\'s fun to use your imagination to find pictures in the clouds.','靠你的想象在云朵中找图画很有趣。','','imagin想象 + ation名词后缀 → imagination想象',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (101,'explore','explore','/ɪkˈsplɔːr/','v.探险；探讨，研究','to travel to or around an area or a country in order to learn about it','They will explore the dark cave.','他们即将探索这个漆黑的洞穴。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (102,'go_out','go out','/ɡoʊ aʊt/','v. 外出，参加社交活动，熄灭，（衣服式样）过时，出去，交往','leave the house to go somewhere','She\'s ready to go out and have fun with her friends.','她准备外出和闺蜜一起哈皮了(●\'◡\'●)！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (103,'trip','trip','/trɪp/','n.旅行，远足；  v.绊倒，失足','a journey to a place and back again, especially a short one for pleasure or a particular purpose; the experience that somebody has if they take a powerful drug that affects the mind and makes them imagine things','He is going to make a trip by plane.','他打算坐飞机去旅行。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (104,'perturb','perturb','/pərˈtɜːrb/','vt. 使不安；使紊乱','to cause (someone) to be worried or upset','The coming test perturbs the unprepared student.','即将来临的考试使这位毫无准备的学生非常不安。','','per贯穿，自始自终 ＋ turb搅动 → 始终搅动 → perturb扰乱',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (105,'rear','rear','/rɪr/','adj.背面的；  n.后部；  v.抚养','[only before noun] at or near the back of something','I could only see a tree in my rear-view mirror.','从后视镜里我只能看到一棵树。','rear-view mirror','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (106,'decision_on','decision on','/dɪˈsɪʒn ɑːn/','phr.……的决定','','He had to make a decision on which way to go.','他必须做出走哪条路的决定。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (107,'fuse','fuse','/fjuːz/','n.导火线，引信；保险丝；  v.（使……）因保险丝熔断而中断工作；熔合，合并','a small wire or device inside a piece of electrical equipment that breaks and stops the current if the flow of electricity is too strong; a long piece of string or paper which is lit to make a bomb or a firework explode; a device that makes a bomb explode when it hits something or at a particular time','Once the fuse has burned, the bomb will explode!','一旦导火线烧完，炸弹就会爆炸！','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (108,'strap','strap','/stræp/','v. 捆扎；  n. 带子','to fasten somebody/something in place using a strap or straps; to wrap strips of material around a wound or an injured part of the body','Strap the safety belt before driving.','开车前先为自己系上安全带。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (109,'deadlock','deadlock','/ˈdedlɑːk/','n.僵局；不分胜负；  v.（使）相持不下；僵持','a situation in which players, teams, etc., have the same score','Talks between the two sides ended in deadlock.','双方的谈判陷入了僵局。','','dead死的+lock锁 → 僵局，停顿',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (110,'awfully','awfully','/ˈɔːfli/','adv. 十分，非常，很','very; extremely','Whereas the first two arms show minor injuries, the bottom one looks awfully injured.','前两只手臂只是一点轻伤，最下面这只手臂伤得很可怕。','awfully injured','awful可怕的 + ly副词后缀 → awfully可怕地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (111,'rocket','rocket','/ˈrɑːkɪt/','n.火箭，火箭弹','a spacecraft in the shape of a tube that is driven by a stream of gases let out behind it when fuel is burned inside','The red rocket is flying over the clouds.','红色的火箭在云层上飞行。','The red rocket','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (112,'carefree','carefree','/ˈkerfriː/','adj.无忧无虑的','having no worries or responsibilities','Under so much pressure now, she really misses her carefree childhood.','如今压力山大，她十分想念从前无忧无虑的童年。','','care关心 + free自由的，免除的 → 没有可以关心的 → carefree无忧无虑的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (113,'erosion','erosion','/ɪˈroʊʒn/','n. 侵蚀；磨损；削弱；减少','the process by which the surface of something is gradually destroyed through the action of wind, rain, etc.','The strange shape of the rock was caused by wind erosion.','这块岩石的奇怪形状是风力侵蚀的结果。','','e出 + ros咬 + ion名词后缀 → 侵蚀，腐蚀',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (114,'dilemma','dilemma','/dɪˈlemə/','n.进退两难的窘境','a situation which makes problems, often one in which you have to make a very difficult choice between things of equal importance','I am in a dilemma. Both ways are so dangerous!','我处在进退两难的困境里，两条路都好危险啊！','','di两个，双 + lemma争论 → 二种争论 → dilemma进退两难',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (115,'bowel','bowel','/ˈbaʊəl/','n. 肠；内部','the tube along which food passes after it has been through the stomach, especially the end where waste is collected before it is passed out of the body','The doctor tells me that my bowel is very healthy.','医生告诉我，我的肠道很健康。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (116,'later_on','later on','/\'leɪtər ɔn/','adv. 稍后','happening at a time subsequent to a reference time','He told the customer that her package would arrive later on.','他告诉顾客她的包裹稍后会到。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (117,'slavish','slavish','/ˈsleɪvɪʃ/','adj. 盲从的','following or copying somebody/something exactly without having any original thought at all','The employees who are slavish followers of the rules are like robots .','员工们就像机器人一样，盲目遵守规则。','','slav=slave奴隶 + ish表形容词，“像…一样，有的…” → 奴隶般的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (118,'lake','lake','/leɪk/','n. 湖','a large area of water that is surrounded by land','The lake lies in the pretty, green valley.','这个湖位于美丽的绿色山谷中。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (119,'postgraduate','postgraduate','/ˌpoʊstˈɡrædʒuət/','n. 研究生；  adj. 大学毕业后的，研究生的','a person who already holds a first degree and who is doing advanced study or research; a graduate student','I have completed two years of postgraduate study and still have one year to go.','我已经完成了两年的研究生学习，还要再读一年。','','post在后面 + graduate毕业 → postgraduate大学毕业后的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (120,'build_confidence','build confidence','/bɪld ˈkɑnfɪdəns/','phr. 树立信心','make someone to be confident to do something','The encouragement from my boss helped me build confidence.','领导对我的鼓励帮助我建立了更好工作的信心。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (121,'adhesive','adhesive','/ədˈhiːsɪv/','n. 粘合剂，胶水；  adj. 带粘性的','a substance that you use to make things stick together','The man is putting a strong adhesive on the wood.','他正在往木块上涂粘合剂。','','ad增加 + hes粘附 + ive形容词后缀 → 一再粘附的 → adhesive发粘的；胶带',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (122,'fall_through','fall through','/fɔːl θrʊ/','phr. 失败',' fail utterly; collapse','His vacation plans fell through because of the forest fire.','他的度假计划因为森林火灾而泡汤了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (123,'prelude','prelude','/ˈpreljuːd/','n. 序幕，前奏','a short piece of music that introduces a longer piece','The musician performed a song as the prelude in the concert.','这位乐手演奏了一首曲子来作为演唱会的序曲。','','pre前面 ＋ lude玩，演奏 → 先演奏 → prelude序曲',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (124,'allow_for','allow for','/əˈlaʊ fɔːr/','phr. 考虑到',' make a possibility or provide opportunity for; permit to be attainable or cause to remain','She chose a larger size, allowing for shrinking when the dress was washed.','考虑到这条裙子洗时会缩水，她就选了大一号的尺码。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (125,'overtake','overtake','/ˌoʊvərˈteɪk/','v.超过，赶上','to go past a moving vehicle or person ahead of you because you are going faster than they are;','The flying car could easily overtake the racing car.','这辆飞车可以轻松超过那辆赛车。','','over越过 + take得到 → 追上,超过',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (126,'transaction','transaction','/trænˈzækʃn/','n.交易；学报','a piece of business that is done between people, especially an act of buying or selling','I paid him and he gave me the house—it was an easy transaction.','我给他钱，他给我房子——这是一笔轻松的交易。','','trans变换，转移 + action行动 → 交换行动 → 交易',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (127,'obstacle_to','obstacle to','/ˈɑːbstəkl tuː/','phr.对 ... 的障碍','','There\'s a huge obstacle to his career.','他的职业生涯面临巨大的障碍。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (128,'outnumber','outnumber','/ˌaʊtˈnʌmbər/','v.在数量上超过','to be greater in number than somebody/something','Yellow rubber ducks outnumber the black ones.','黄色橡胶鸭的数量超过了黑色的。','','out超过 + number数量 → outnumber在数量上超过',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (129,'run_parallel_to','run parallel to','/rʌn ˈpærəˌlɛl tu/','phr. 与…平行','being side by side and having the same distance continuously with something','The trains run parallel to each other.','这两辆火车与对方并排而行。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (130,'mortgage','mortgage','/ˈmɔːrɡɪdʒ/','n.抵押贷款；  v.抵押','a legal agreement by which a bank or similar organization lends you money to buy a house, etc., and you pay the money back over a particular number of years; the sum of money that you borrow','He took out a mortgage, meaning he borrowed money to buy his home.','他办理过抵押贷款，这意味着他是借钱买的房子。','','mort死 + gage抵押品 → mortgage抵押',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (131,'feel_at_home','feel at home','/fi:l æt həum/','phr. 感到很舒服','feel comfortable','He slept well on the plane and felt at home.','他在飞机上睡的很好很舒服。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (132,'crouch','crouch','/kraʊtʃ/','v. 蹲；弯腰','to lower your body to the ground by bending your legs','The blonde woman in the blue skirt crouches.','那个穿蓝色裙子的金发女士蹲下了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (133,'olive','olive','/ˈɑːlɪv/','n. 橄榄；橄榄树；  adj. 橄榄色的','a small green or black fruit with a strong taste, used in cooking and for its oil','The best cooking oil is made from olives.','最好的烹饪油是用橄榄制作的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (134,'facsimile','facsimile','/fækˈsɪməli/','n. 复制本，摹本；  adj. 复制的；  v. 传真','an exact copy of something','She is making a facsimile of that famous painting.','她正在临摹那幅名画。','making a facsimile of','fac做，制作 ＋ simile相同 → 做出相同的东西 → facsimile复写，传真',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (135,'contrary','contrary','/ˈkɑːntreri/','adj.对立的，矛盾的；叛逆的','different from something; against something; completely different in nature or direction','The lady and the man hold contrary views.','这位女士和男士持有相反的意见。','contrary views','contr反对，相反 + ary形容词后缀 → contrary相反的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (136,'on_purpose','on purpose','/ɒn, ‘pə:pəs/','phr.故意','with intention; in an intentional manner','The football player committed the foul on purpose to prevent the goal from being scored.','这个球员故意犯规防止对方进球得分。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (137,'deliberate','deliberate','/dɪˈlɪbərət/','adj.故意的；沉着的，小心谨慎的','done on purpose rather than by accident','Your making me fall wasn\'t an accident—it was deliberate!','你害我跌倒不是意外，你就是故意的！','','de否定 + liber自由 + ate……的 → 不是任意而为 → deliberate故意的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (138,'rebuke','rebuke','/rɪˈbjuːk/','v. 指责；  n. 谴责','to speak severely to somebody because they have done something wrong','The boss rebuked his employee for not completing the assignment on time.','老板责备他的员工没有按时完成任务。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (139,'Chinese','Chinese','/ˌtʃaɪˈniːz/','adj. 中国的；  n. 中国人','from or connected with China','Happy Chinese New Year!','春节快乐！','Chinese New Year','Chin = China中国 + ese某国人或语言 → Chinese中国的（人），汉语',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (140,'hundreds_of','hundreds of','/hʌndrədz əv/','phr. 成百上千','a lot of','The pool is filled with hundreds of colorful balls.','池子里装满了成百上千的彩球。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (141,'prince','prince','/prɪns/','n.王子','a male member of a royal family who is not king, especially the son or grandson of the king or queen','The prince looks more charming with his blue cape on.','穿上蓝色的斗篷，这位王子显得更加迷人了。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (142,'residential','residential','/ˌrezɪˈdenʃl/','adj.住宅的，居住的；寄宿的','(of an area of a town) suitable for living in; consisting of houses rather than factories or offices','The residential area is separate from the business district.','住宅区和商业区是分开的。','','resident居民 + ial形容词后缀 → residential居住的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (143,'clothe','clothe','/kloʊð/','v. 穿衣','to dress somebody/yourself; to provide clothes for somebody to wear','After his bath, my dog likes me to clothe him in his own little bathrobe.','洗澡后，狗狗喜欢我给它穿上它自己的浴袍。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (144,'ivory','ivory','/ˈaɪvəri/','n.象牙；乳白色','a hard yellowish-white substance like bone that forms the tusks (= long teeth) of elephants and some other animals; an object made of ivory','It is not very common to see ivory crossing with another like this.','像这样交叉的象牙比较少见。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (145,'inclination','inclination','/ˌɪnklɪˈneɪʃn/','n.倾斜；点头；做……的倾向，意愿','a degree of sloping','The leaning tower is at a large inclination to the vertical.','这座斜塔倾斜得很厉害。','','in进入 + clin倾斜，斜坡 + ation抽象名词后缀 → inclination倾斜，倾向',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (146,'adverb','adverb','/ˈædvɜːrb/','n. 副词（缩写形式为adv.）','a word that adds more information about place, time, manner, cause or degree to a verb, an adjective, a phrase or another adverb','Adverbs can be used to modify verbs.','副词可以用来修饰动词。','','ad强调 + verb动词 → 修饰强调动词的词 → adverb副词',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (147,'kerosene','kerosene','/ˈkerəsiːn/','n. 煤油','a type of fuel oil that is made from petroleum and that is used in the engines of planes and for heat and light. In British English it is usually called paraffin when it is used for heat and light.','If you have no electricity, you can light your house with a kerosene lamp.','在没有电的时候，你可以点煤油灯照明。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (148,'enhance','enhance','/ɪnˈhæns/','vt.提高（强度、力量、数量等）；增加，加强','to increase or further improve the good quality, value or status of somebody/something','Clicking this icon can enhance the image.','点这个图标可以提高画质。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (149,'armor','armor','/ˈɑrmər/','n. 盔甲','special metal clothing that soldiers wore in the past to protect their bodies while fighting','You should wear armor—enemies tend to hit back!','你必须穿上盔甲——因为敌人会回击你。','','arm武器 + or名词后缀 → 盔甲',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (150,'brilliant','brilliant','/ˈbrɪliənt/','adj.聪颖的；卓越的，有才气的','extremely clever or impressive; very intelligent or skillful','The brilliant girl can solve the math problems easily.','这个聪明的女孩可以轻松解决这些数学难题。','brilliant girl','brilli=brill光辉 + ant…的 → brilliant光辉的；卓越的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (151,'complexion','complexion','/kəmˈplekʃn/','n. 肤色','the natural colour and condition of the skin on a person’s face','They have different complexions but they formed a profound friendship.','虽然他们肤色不同，但是他们结下了深厚的友谊。','','com全部 + plex重叠 + ion名词后缀 → 全部表情重叠于面部 → complexion面色',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (152,'trust','trust','/trʌst/','v. 信任；盼望，希望；  n. 委托','to have confidence in somebody; to believe that somebody is good, sincere, honest, etc.; to believe that something is true or correct or that you can rely on it','My boss trusts me so much. I can\'t let him down.','我的老板那么信任我，我不能让他失望。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (153,'classroom','classroom','/ˈklæsruːm/','n. 教室，课堂','a room where classes are taught in a school, college, or university','Students can have lessons in classrooms.','学生们可以在教室里上课。','','class班级 + room房间 → classroom教室',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (154,'strive','strive','/straɪv/','v. 努力，奋斗','to try very hard to achieve something','They are all striving for a good future and life.','他们都在为美好的未来和生活而奋斗。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (155,'maximize','maximize','/ˈmæksɪmaɪz/','vt. 取……最大值，最佳化','to increase sth as much as possible','Maximize the volume if you still can\'t hear the sound clearly.','如果你还听不清声音，就把音量最大化。','','maxi大 ＋ mize使 → maximize使最大化',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (156,'break_through','break through','/breɪk, θruː/','phr. 突破','If you break through a barrier, you succeed in forcing your way through it.','The man\'s punch managed to break through the wall.','这个男人的拳头成功打破了这面墙。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (157,'mute','mute','/mjuːt/','vt.把……静音；  n.弱音器；  adj.缄默的','to make the sound of something, especially a musical instrument, quieter or softer, sometimes using a mute','The man answered the phone after muting the TV.','这个男人给电视静音后，接听了电话。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (158,'by_hand','by hand','/baɪ hænd/','phr. 用手','without the use of a machine','She copied the story by hand.','她把这个故事用手抄了一遍。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (159,'dandelion','dandelion','/ˈdændɪlaɪən/','n. 蒲公英','a very common wild plant that has bright yellow flowers','She is holding many dandelions in her hands.','她手里拿着许多蒲公英。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (160,'superman','superman','/ˈsuːpərmæn/','n.超人','a man who is unusually strong or intelligent or who can do something extremely well','That boy dreams to become a superman one day.','那男孩梦想有一天能成为超人。','become a superman','Super超级 + man人 → superman超人，能力非凡的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (161,'notation','notation','/noʊˈteɪʃn/','n. 记号；标记法；记录','a system of signs or symbols used to represent information, especially in mathematics, science and music','Every composition is made up of a series of musical notations.','每一首乐曲都是由一系列的音乐符号组成的。','musical notations','not记号 + ation表示行为、情况、状态、过程、结果 → notation记号；标记法',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (162,'oppressive','oppressive','/əˈpresɪv/','adj. 压迫的','weighing heavily on the senses or spirit','Galileo faced an oppressive society which, at the time, considered his theories ridiculous.','伽利略所面对的是一个压迫性的社会，当时的人们认为他的理论是荒谬的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (163,'gale','gale','/ɡeɪl/','n. 狂风，一阵（笑声）','an extremely strong wind','A sudden gale almost knocked me down.','一阵狂风差点把我吹倒。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (164,'apology','apology','/əˈpɑːlədʒi/','n.道歉，歉意','a word or statement saying sorry for something that has been done wrong or that causes a problem; information that you cannot go to a meeting or must leave early','He is making an apology to his boss.','他在向老板道歉。','making an apology','apo离开 + logy说话 → 退后一步说 → apology道歉',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (165,'evidence','evidence','/ˈevɪdəns/','n.证据，证明；  v.证明','the facts, signs or objects that make you believe that something is true','He is collecting evidence at the crime scene.','他正在犯罪现场收集证据。','','e出 + vid看 + ence表名词 → 明显的证据 → evidence证据，证人',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (166,'librarian','librarian','/laɪˈbreriən/','n. 图书管理员，图书馆馆长','a person who is in charge of or works in a library','The helpful librarian helped me find the books I needed.','这个称职的图书管理员帮我找到了我需要的书。','','libr书 + arian表示人 → 图书馆馆长；图书管理员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (167,'impress_on','impress on','/ɪmˈprɛs ɑn/','phr. 给...深刻印象','','The woman\'s beauty had impressed itself on her memory.','那位女士的美丽给她留下了深刻的印象。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (168,'officer','officer','/ˈɑːfɪsər/','n. 警官；官员；干事','a person who has a position of authority or command in the military','He\'s a friendly police officer.','他是一个和善的警察。','police officer','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (169,'assumption','assumption','/əˈsʌmpʃn/','n. 假定，设想','a belief or feeling that something is true or that something will happen, although there is no proof','Having a baby is just their assumption.','有个宝宝只是他们的设想而已。','','assumpt假定 + ion表名词 → assumption假设；承担',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (170,'incredulous','incredulous','/ɪnˈkredʒələs/','adj. 怀疑的，不轻信的','not willing or not able to believe something; showing an inability to believe something','"You made it by yourself?" The lady said to her son in an incredulous tone.','“你自己做的?”那位女士用怀疑的语气对儿子说。','','in不 ＋ cred相信，信任 ＋ ulous轻信的 → incredulous不轻信的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (171,'substance','substance','/ˈsʌbstəns/','n.物质；实质，本质','a type of solid, liquid or gas that has particular qualities','A substance like water can exist in solid, liquid or gaseous form.','像水这样的物质可以以固态、液态或者气态的形式存在。','','sub下面 + st站立 + ance表名词 → 站在下面的东西 → substance物质；本质',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (172,'bring_down','bring down','/brɪŋ daʊn/','phr. 使倒下；减少','to cause to fall or collapse.','The strong wind last night brought down the telephone pole.','昨晚的强风把电线杆吹倒了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (173,'policeman','policeman','/pəˈliːsmən/','n. 警察','a male police officer','The policeman is chasing a thief.','警察正在抓小偷。','','police警察 + man人 → policeman警察',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (174,'elastic','elastic','/ɪˈlæstɪk/','adj.可伸缩的；（系统或计划）灵活的；  n.松紧带，橡皮圈','that can change or be changed','The spring is a very elastic thing that can stretch far.','弹簧是一种可伸缩的东西，可以拉伸得很远。','a very elastic thing','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (175,'connect_with','connect with','/kəˈnɛkt wɪð/','phr. 与……相连','to relate or associate','She felt she really connected with the speaker as they shared many similar views.','她觉得她跟那位演讲者似乎连接在了一起，因为他们有着许多相似的观点。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (176,'item','item','/ˈaɪtəm/','n.物品；一条，一则','one thing on a list of things to buy, do, talk about, etc.','He sells some of his unwanted items in the yard sale.','他在庭院大甩卖中卖一些不需要的物品。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (177,'go_through','go through','/ɡoʊ θruː/','phr.浏览，查阅；通过，完成','to look at or examine something carefully, especially in order to find something','He is going through his textbooks to find the right answer.','他正在翻阅课本寻找正确答案。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (178,'gay','gay','/ɡeɪ/','n. 同性恋者','a person who is homosexual, especially a man','Gay people also have the right to love.','同性恋也有权利相爱。','Gay people','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (179,'empirical','empirical','/ɪmˈpɪrɪkl/','adj.实证的，以观察或实验为根据的','based on experiments or experience rather than ideas or theories','Empirical studies focus more on observation rather than theory alone.','实证研究更强调观察而非理论本身。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (180,'detachment','detachment','/dɪˈtætʃmənt/','n.分离；超然；分遣队','a condition in which something has become separated from something else','This picture illustrates the healthy eye and the detachment of the retina.','这张图描绘了健康的眼睛和视网膜的脱离。','','de 否定，非，相反 + tach =nail 表示“钉子” + ment名词后缀 → detachment分离，拆开',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (181,'line','line','/laɪn/','n.线','a long narrow mark on a surface; a row of people or things next to each other or behind each other','There is a yellow line in the middle of the road.','道路中间有条黄线。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (182,'shady','shady','/ˈʃeɪdi/','adj. 成荫的，多荫的；可疑的，靠不住的','protected from direct light from the sun by trees, buildings, etc.; (of a tree, etc.) providing shade from the sun','It\'s nice to take a walk in the shady forest.','在成荫的森林里散步很惬意。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (183,'prevention','prevention','/prɪˈvenʃn/','n. 预防，防止','the act of stopping something bad from happening','Some people believe this cream will help in the prevention of wrinkles.','一些人认为这款面霜能够防止长皱纹。','','pre预先 + vent来 + ion名词后缀，表示行为 → prevention预防，防止，阻止',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (184,'tide','tide','/taɪd/','n.潮汐；  v.随潮漂流','the regular upward and downward movement of the level of the ocean that is caused by the pull of the Sun and the Moon on the Earth','The tide is going out, leaving the beach soft and clean.','潮水退去了，海滩变得柔软又干净。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (185,'doubt','doubt','/daʊt/','v.怀疑；  n.怀疑','a feeling of being uncertain about something or not believing something','I really doubt whether aliens exist.','我很怀疑外星人是否真的存在。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (186,'instrument','instrument','/ˈɪnstrəmənt/','n.乐器；工具','an object used for producing musical sounds, for example a piano or a drum','Guitar, violin, drum, and piano are all musical instruments.','吉他、小提琴、鼓和钢琴都是乐器。','musical instruments','in内 + stru=struct建立 + ment表名词 → 内部结构 → instrument仪器；工具',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (187,'keep_down','keep down','/kiːp daʊn/','phr. 抑制',' place a limit on the number of','They keep down their voice when their roommate falls asleep.','当室友睡着时，他们会压低说话的声音。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (188,'magazine','magazine','/ˈmæɡəziːn/','n. 杂志，期刊','a type of large thin book with a paper cover that you can buy every week or month, containing articles, photographs, etc., often on a particular topic; a radio or television programme that is about a particular topic','I like to read magazines about fashion and celebrities.','我喜欢阅读关于时尚和名人的杂志。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (189,'with_reference_to','with reference to','/wɪð ˈrefərəns tu/','phr. 关于，有关','used in a letter to introduce the subject that you are going to write about','"With reference to your job application, we\'ll write to you in a week."','"关于你申请工作一事，一周以后我们会写信回复你。"','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (190,'dramatic','dramatic','/drəˈmætɪk/','adj.戏剧性的；戏剧的','(of a change, an event, etc.) sudden, very great and often surprising; exciting and impressive','The dramatic decline of the stock value was a big blow for him.','这次股价的戏剧性下跌对他来说是一个沉重的打击。','','drama戏剧 + tic形容词后缀 → dramatic戏剧的，戏剧性的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (191,'outspoken','outspoken','/aʊtˈspoʊkən/','adj.直言的，坦率的','saying exactly what you think, even if this shocks or offends people','Her outspoken remarks always reveal facts.','她直言不讳的评论总是戳中现实。','outspoken remarks','out外，出 + spoken说 → 直接说出来 → outspoken坦率的，直言不讳的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (192,'politician','politician','/ˌpɑːləˈtɪʃn/','n. 政治家，政客','a person whose job is concerned with politics, especially as an elected member of parliament, etc.','The female politician is giving an election speech.','女政治家正为竞选做演讲。','','polit国家，城市 + ician人 → 爱国家之人 → politician政客',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (193,'mood','mood','/muːd/','n.情绪，心情','the way someone feels; a person\'s emotional state','"I\'m in a good mood today," she said with a smile.','“我今天心情很好。”她微笑着说。','in a good mood','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (194,'phobia','phobia','/ˈfoʊbiə/','n. 恐惧症','an extremely strong dislike or fear of someone or something','I have a phobia of heights, so my legs keep trembling from fear.','我恐高，所以我的腿一直在抖。','a phobia of heights','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (195,'abandon','abandon','/əˈbændən/','v.抛弃；放弃','to stop doing something, especially before it is finished; to stop having something','He abandoned his car in the desert.','他在沙漠中抛弃了车子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (196,'table_manners','table manners','/ˈteɪbl mænərz/','n.餐桌礼仪','the behaviour that is considered correct while you are having a meal at a table with other people','His grandma is teaching him good table manners.','奶奶在教他良好的餐桌礼仪。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (197,'compensation','compensation','/ˌkɑːmpenˈseɪʃn/','n. 赔偿金；补偿','something, especially money, that somebody gives you because they have hurt you, or damaged something that you own','The injured man received his compensation from the insurance agent.','那个受伤的人收到了保险代理人的赔偿金。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (198,'antagonist','antagonist','/ænˈtæɡənɪst/','n. 反派，反派角色','someone who offers opposition','In the astronaut cartoon, the robot is seen as the antagonist.','在这部有关宇航员的动画里，这个机器人被视为反派角色。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (199,'bait','bait','/beɪt/','n. 饵，诱惑物；  v. 辱骂，欺侮','food put on a hook to catch fish or in nets, traps, etc. to catch animals or birds; a person or thing that is used to catch somebody or to attract them, for example to make them do what you want','There\'s no better bait for a cat than fish.','对于猫而言，没有比鱼更好的诱饵了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (200,'magistrate','magistrate','/ˈmædʒɪstreɪt/','n. 法官','an official who acts as a judge in the lowest courts of law','"Case closed!" shouted the magistrate as she slammed down the gavel.','“结案!”法官敲下法槌喊道。','','magistr行政 + ate表示人 → magistrate地方行政官',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (201,'sole','sole','/soʊl/','n.脚底，鞋底，袜底；  adj.独有的；  v.给……装鞋底','the bottom surface of the foot','She is having the sole of her foot massaged.','她正在按摩足底。','','sol单独 ＋ e → sole单独的，唯一的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (202,'cheerful','cheerful','/ˈtʃɪrfl/','adj. 高兴的','happy, and showing it by the way that you behave','After tasting the cake, the little boy shows a cheerful expression.','在品尝蛋糕后，小男孩的脸上露出了开心的表情。','','cheer欢乐 + ful形容词后缀 → cheerful快乐的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (203,'awake','awake','/əˈweɪk/','adj.醒着的；  v.（使）醒来；唤起，被唤起','not asleep (especially immediately before or after sleeping)','It\'s already 3:22 a.m., but she is still awake.','现在已经是凌晨3点22分了，但她还醒着。','','a加强意义 + wake醒着 → awake唤醒，使醒',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (204,'belt','belt','/belt/','n.带，腰带；皮带；传送带','a long narrow piece of leather, cloth, etc. that you wear around the waist','My pants are so loose that I need to wear a belt.','我的裤子太宽松了所以我需要系一条腰带。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (205,'exchange','exchange','/ɪksˈtʃeɪndʒ/','vt.交流；交换，互换；交易；  n.交易所','to give something to somebody and at the same time receive the same type of thing from them','People can exchange their thoughts and ideas.','人们可以交换他们的思想和意见。','','ex出 + change交换 → exchange交换，交流',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (206,'burglar','burglar','/ˈbɜːrɡlər/','n.窃贼','a person who enters a building illegally in order to steal','The burglar is trying to break into the house.','盗贼正试图闯进这个家。','','burgl盗窃 + ar表示人 → 盗窃的人 → burglar窃贼',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (207,'in_need_of','in need of','/ɪn niːd əv/','phr. 需要','used to say that someone or something needs to have something','The man is in desperate need of a coffee.','这个男人特别需要一杯咖啡。','in desperate need of','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (208,'jury','jury','/ˈdʒʊri/','n.陪审团；裁判团，评委团','a group of members of the public who listen to the facts of a case in a court and decide whether or not somebody is guilty of a crime','The lawyer is showing the evidence to the jury.','律师正在向陪审团展示证据。','','jur发誓，法律 + y名词后缀 → 发誓的人 → jury陪审团',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (209,'firmly','firmly','/ˈfɜːrmli/','adv. 坚固地，稳固地；坚定地，坚决地','not easily moved or disturbed','He firmly squeezed the piece of paper.','他牢牢攥紧那张纸。','','firm坚固的 + ly...地 → 坚固地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (210,'lenient','lenient','/ˈliːniənt/','adj. 宽大的，宽容的，仁慈的','allowing a lot of freedom and not punishing bad behavior in a strong way :not harsh, severe, or strict','This time, my mom was lenient about me failing the exam.','对于我在这次考试中不及格一事，我妈表现得十分宽宏大量。','was lenient about','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (211,'navigation','navigation','/ˌnævɪˈɡeɪʃn/','n.导航','the skill or the process of planning a route for a ship or other vehicle and taking it there; the movement of ships or aircraft','This app will help you with your navigation.','这个软件会帮你导航。','','nav船 + ig走 + ation表名词 → navigation航行；航海术；导航',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (212,'breathe','breathe','/briːð/','v.呼吸','to move air into and out of your lungs: to inhale and exhale','She breathes deeply to relax herself when doing yoga.','她做瑜伽时用深呼吸的方式来放松自己。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (213,'hacker','hacker','/ˈhækər/','n. 电脑黑客，企图不法侵入他人电脑系统的人','a person who secretly finds a way of looking at and/or changing information on somebody else’s computer system without permission','It\'s undeniable that hackers are experts in computer.','不可否认黑客确实是电脑高手。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (214,'particle','particle','/ˈpɑːrtɪkl/','n. 粒子，微粒；【语】小品词','a very small piece of something','Atoms are very small particles.','原子是非常小的粒子。','small particles','part部分，分开 + icle小东西 → 一小部分 → particle少量',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (215,'orderly','orderly','/ˈɔːrdərli/','adj. 有秩序的，整齐的，有条不紊的','arranged or organized in a logical or regular way','Put the files in an orderly sequence.','把这些文件按一定的顺序放好。','','order顺序 + ly副词后缀 → orderly 依次的，有序的',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (216,'shilling','shilling','/ˈʃɪlɪŋ/','n.先令','a former British and Australian silver or cupronickel coin worth one twentieth of a pound: not minted in Britain since 1970','There used to be twenty shillings in a pound.','过去二十先令合一英磅。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (217,'detergent','detergent','/dɪˈtɜːrdʒənt/','n. 洗涤剂，清洁剂','a powder or liquid that is used to clean clothes, dishes, etc. :a chemical substance that is like soap','Detergent can remove dirt from clothes and make them clean.','洗涤剂可以去除衣物上的污渍，使其变干净。','','deterg=deterge擦净 + ent药剂 → detergent洗涤剂',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (218,'dormitory','dormitory','/ˈdɔːrmətɔːri/','n.宿舍；宿舍楼','a room for several people to sleep in, especially in a school or other institution','My dormitory is clean and tidy.','我的宿舍干净整洁。','','dorm睡眠 + itory表示场所 → 睡觉的地方 → dormitory寝室，宿舍',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (219,'haunt','haunt','/hɔːnt/','v. （鬼，魂）常出没于；  n. 常去的地方','if the ghost of a dead person haunts a place, people say that they have seen it there','Ghosts are believed to haunt old places.','人们相信鬼魂经常出没于古旧的场所。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (220,'obscenity','obscenity','/əbˈsenəti/','n.猥琐下流；猥亵的话(或行为)','the trait of behaving in an obscene manner','He sat screaming obscenities because of the heavy traffic jam.','由于严重的交通堵塞，他坐在那儿大喊大叫地骂着下流的话。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (221,'wander','wander','/ˈwɑːndər/','v. 漫游；迷路；  n. 闲逛','to move around or go to different places usually without having a particular purpose or direction','The young couple is wandering in the park.','这对年轻的夫妇正在公园里漫步。','wandering in the park','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (222,'in_favour_of','in favour of','/ɪn/ /ˈfeɪvər/ /ɑv/','prep. 赞成，以…为收款人','in support of','I\'m in favour of the new law.','我赞成新法律。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (223,'loop','loop','/luːp/','n.（用线、绳、带等打成的）环；  v.使成环，绕成圈；  vt.打成环状','a round shape made by something like string or rope','We made a loop out of rope for future use.','我们用绳子做了个环以供日后使用。','made a loop','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (224,'homesick','homesick','/ˈhoʊmsɪk/','adj.想家的，思乡的','sad because you are away from home and you miss your family and friends','Gazing at the bright moon, he became homesick for his hometown.','看着这轮明月，他很思念自己的家乡。','','home家 + sick病 → 思乡病',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (225,'would','would','/wʊd/','aux.会','used as the past form of will when reporting what somebody has said or thought','He said if he won a million dollars he would buy a house.','他说如果他挣了一百万美元，他就会买一栋房子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (226,'arrive','arrive','/əˈraɪv/','v. 到达；（时间等）来临','to get to a place, especially at the end of a journey','She arrived at the airport on time.','她准时抵达了机场。','','ar一再 + rive河 → 到达河边 → 达到目标 → arrive到达',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (227,'dump','dump','/dʌmp/','vt.倾倒，丢弃；  n.垃圾场，废物堆','to get rid of something you do not want, especially in a place which is not suitable','The big truck is dumping waste materials.','这辆大卡车正在倾倒废料。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (228,'significant','significant','/sɪɡˈnɪfɪkənt/','adj.有重大意义的','having a special or secret meaning that is not understood by everyone','This day is significant for me because it\'s my father\'s birthday.','这一天对我意义重大，因为这天是我爸爸的生日。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (229,'feminism','feminism','/ˈfemənɪzəm/','n.女权主义，男女平等主义','the belief that men and women should have equal rights and opportunities','Feminism is the belief that men and women are equal.','女权主义是一种相信男人和女人地位平等的理念。','','femin女人 ＋ ism...主义 → feminism女权主义；女权运动',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (230,'homosexual','homosexual','/ˌhoʊməˈsekʃuəl/','n. 同性恋；  adj. 同性恋的','a person, usually a man, who is sexually attracted to people of the same sex','Homosexuals only love members of the same sex.','同性恋者只爱同性。','','homo同类的 + sexual性别的 → homosexual同性恋的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (231,'supplant','supplant','/səˈplænt/','v. 代替；排挤掉','to take the place of somebody/something (especially somebody/something older or less modern)','The worker was supplanted by a robot.','这个工人被机器人取代了。','','sup在…下面 ＋ plant种植 → 种在下面，把上面的取代 → supplant取代，排挤',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (232,'sharpen','sharpen','/ˈʃɑːrpən/','v. 削尖；磨快；使敏捷；使提高','to make something sharper; if a sense or feeling sharpens or something sharpens it, it becomes stronger and/or clearer; to become or make something better, more skillful, more effective, etc. than before','You must sharpen your pencil if you want to use it.','如果你想用铅笔的话，要先削尖它。','sharpen your pencil','sharp尖 + en动词后缀  → sharpen削尖',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (233,'better','better','/ˈbetər/','adj.更好的；  adv.更好地；  v.改善；  n.更优者','of a higher standard or less poor quality; not as bad as something else','Her figure gets better and better through daily exercise.','通过每天运动，她的身材越来越好了。','better and better','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (234,'resolve','resolve','/rɪˈzɑːlv/','n.决心；  v.解决','strong determination to achieve something','Nothing shakes his resolve of being a fluent English speaker!','没有什么能动摇他想说一口流利的英语的决心！','','re再 + solve解决 → resolve决心',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (235,'assembly','assembly','/əˈsembli/','n. 集会；集合','a group of people who have been elected to meet together regularly and make decisions or laws for a particular region or country','Representatives from different countries attended the assembly of the UN.','来自不同国家的代表参加了联合国大会。','','as不断 + sembl =same一样 + y表名词 → 不断到一个地方→ assembly集合',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (236,'evasive','evasive','/ɪˈveɪsɪv/','adj.逃避的；托辞的，推托的','done to avoid harm, an accident, etc.','The famous singer was evasive when he was asked the sensitive question.','这位知名歌手对这个敏感的问题采取回避的态度。','','e出+vas走+ive形容词后缀→逃避的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (237,'request','request','/rɪˈkwest/','n.请求；  vt.请求','an act of politely or formally asking for something','His father agreed to his request for a Superman costume.','他父亲同意了他想要一套超人服装的请求。','','re再 + quest寻求，询问 → 再寻求 → request要求',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (238,'bucket','bucket','/ˈbʌkɪt/','n.水桶','an open container with a handle, used for carrying or holding liquids, sand, etc.; a large container that is part of a crane or digger and is used for lifting things; the amount contained in a bucket; a large amount','The cute cat is hiding in a bucket.','那只可爱的小猫躲在一个桶子里。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (239,'be_confident_in','be confident in','/biˈkɑnfədənt ɪn/','phr. 对…有信心；对……充满信心','full of conviction','Her smile shows that she is really confident in her upcoming interview.','她的微笑表明她对即将到来的面试充满自信。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (240,'anchor','anchor','/ˈæŋkər/','n.锚；（广播电视新闻节目的）主持人','a heavy metal object that is attached to a rope or chain and dropped over the side of a ship or boat to keep it in one place','The ship dropped the anchor and hit the shark on its head.','船抛出锚，打到了一只鲨鱼头上。','dropped the anchor','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (241,'get_tired_of_sth.','get tired of sth.','/ɡet ˈtaɪərd əv ˈsʌmθɪŋ/','phr. 厌倦了某事','exhausted of doing something','The housewife is getting tired of all the housework.','这位家庭主妇开始所有家务事感到厌倦。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (242,'bring_out','bring out','/brɪŋ aʊt/','phr. 出版，推出',' make visible','The famous singer brought out a new song.','这位著名的歌手推出了他的新歌。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (243,'correspond','correspond','/ˌkɔːrəˈspɑːnd/','vi.通信；相似','to be the same as or match something','Nowadays, people correspond to each other in many different ways.','现如今，人们有许多不同的方式进行通信。','','cor共同 + respond回应 → 相互回应 → correspond通信，符合',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (244,'own','own','/oʊn/','v.有，拥有','one or ones belonging to oneself','This boy once owned a black cat.','这个男孩曾经拥有一只黑色的猫。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (245,'chic','chic','/ʃiːk/','adj. 别致的；时髦的；  n. 时髦，款式别致','following the current fashion or style :fashionable and appealing','That dress is very chic—where\'d you buy it?','这件连衣裙非常别致——你在哪里买的？','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (246,'partnership','partnership','/ˈpɑːrtnərʃɪp/','n.合作伙伴','the state of being a partner in business','Their companies are working together in a partnership for the project.','他们的公司正在为这个项目合作。','','part部分 + ner人 + ship表关系或状态 → 部分合作人的状态 → partnership 合伙人关系',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (247,'decoration','decoration','/ˌdekəˈreɪʃn/','n. 装饰','a thing that makes something look more attractive on special occasions','They\'re putting decorations on the Christmas tree.','她们在往圣诞树上放装饰品。','','decor装饰 + ation表示行为、情况、状态、过程、结果 → 装饰，装潢；装饰品；奖章',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (248,'speeding','speeding','/ˈspiːdɪŋ/','n. 超速行驶','','The driver was stopped by the police for speeding.','这位司机因超速行驶被警察拦下。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (249,'carry_through','carry through','/ˈkeri θru/','v. 使渡过难关，坚持下去','to successfully finish or complete (something that you have begun or said you will do)','The group relied on their experienced leader to carry them through the tough expedition.','这个小组依靠他们经验丰富的领队带领他们渡过艰苦的探险。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (250,'be_dexterous_in','be dexterous in','/bi ˈdɛkstərəs ɪn/','phr. 灵敏于……','skilful with your hands; skilfully done','Monkeys are dexterous in swinging through trees on vines.','猴子善于在树林里灵巧地荡来荡去。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (251,'clown','clown','/klaʊn/','n.小丑','an entertainer who wears funny clothes and a large red nose and does silly things to make people laugh; a person that you disapprove of because they act in a stupid way','The clown has a red nose.','这个小丑有个红鼻子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (252,'stapler','stapler','/ˈsteɪplər/','n.订书机','a device that you use to put staples into something (such as paper)','There are three different-sized staplers.','这里有三个不同大小的订书机。','','stapl=staple钉书钉 ＋ er名词后缀 → stapler订书机',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (253,'wasteful','wasteful','/ˈweɪstfl/','adj.浪费的，挥霍的','using more of something than is necessary; not saving or keeping something that could be used','There was a wasteful amount of food from the dinner party.','宴会上剩下的食物太多，这样很浪费。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (254,'overwrought','overwrought','/ˌoʊvərˈrɔːt/','adj. 过分紧张的，过度兴奋的','very excited or upset','She gets overwrought every time she takes the elevator.','每次坐电梯她都会过度紧张。','gets overwrought','over过度 + wrought工作 → overwrought 过度劳累的，过分紧张',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (255,'censorship','censorship','/ˈsensərʃɪp/','n.审查制度；审查机构','the act or policy of censoring books, etc.','A part of this image is blurred because of censorship guidelines.','因为审查制度，这幅图像的一部分被模糊了。','','censor审查 + ship表名词 → censorship审查机构，审查制度',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (256,'path','path','/pæθ/','n.小路','a way or track that is built or is made by the action of people walking','Follow the path through the forest and you won\'t get lost.','沿着这条森林小径走，你就不会迷路。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (257,'exceedingly','exceedingly','/ɪkˈsiːdɪŋli/','adv. 过分地','extremely; very; very much','He was running exceedingly fast!','他跑的真是过分的快了！','','exceed超过 + ing...的 + ly表副词 → exceedingly过分地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (258,'offshore','offshore','/ˌɔːfˈʃɔːr/','adj. 近海的，海岸的','in the sea, not far from the land','Look, there is an island just offshore.','看，海边有个小岛。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (259,'billboard','billboard','/ˈbɪlbɔːrd/','n. 告示牌，广告牌','a large board on the outside of a building or at the side of the road, used for putting advertisements on','The billboard on this highway is blank.','这段高速公路上的广告牌是空白的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (260,'wear_out','wear out','/wer aʊt/','phr. 用坏，磨损','to become, or make something become, thin or no longer able to be used, usually because it has been used too much','Both of these shoes are totally worn out.','这双鞋被完全磨坏了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (261,'friction','friction','/ˈfrɪkʃn/','n. 摩擦，摩擦力','the force that causes a moving object to slow down when it is touching another object','Friction between the two hands generates some heat.','双手摩擦可以生热。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (262,'newspaper','newspaper','/ˈnuːzpeɪpər/','n.报纸','a set of large sheets of paper that have news stories, information about local events, advertisements, etc., and that are folded together and sold every day or every week','This clever little dog can read a newspaper!','这只聪明的小狗竟然在看报纸！','read a newspaper','news新闻 + paper纸 → newspaper报纸',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (263,'portrayal','portrayal','/pɔːrˈtreɪəl/','n. 画像，描画，描写','the act of showing or describing somebody/something in a picture, play, book, etc.; a particular way in which this is done','The cat was so satisfied with the portrayal of him.','猫咪对他的这幅画像非常满意。','','portray描绘 ＋ al构成名词，表示行为 → portrayal描画，描写',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (264,'pure','pure','/pjʊr/','adj.纯的，纯粹的','not mixed with anything else, with nothing added; clean and not containing any harmful substances','The water seems so pure and clean.','水看起来真纯净。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (265,'harmony','harmony','/ˈhɑːrməni/','n.和睦；和谐','a state of peaceful existence and agreement','They live together in perfect harmony.','他们和睦地住在一起。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (266,'somebody','somebody','/ˈsʌmbədi/','pron. 某人','a person who is not known or mentioned by name','Somebody sends me the flowers, but I don\'t know who he is.','某人给我送了花，可是我不知道他是谁。','','some有些 + body人 → somebody某人，有人',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (267,'fatuous','fatuous','/ˈfætʃuəs/','adj. 愚昧而不自知的','foolish or stupid','The fatuous monarch had been manipulated by others.','这个愚蠢的君主一直在被别人操纵。','The fatuous monarch','fatu笨 + ous...的 → fatuous昏庸的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (268,'whisky','whisky','/ˈwɪski/','n. 威士忌酒','a strong alcoholic drink made from malted grain. It is sometimes drunk with water and/or ice.','I prefer whisky over any other hard drink.','烈酒里面我最喜欢威士忌。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (269,'supersonic','supersonic','/ˌsuːpərˈsɑːnɪk/','adj. 超音速的','faster than the speed of sound','Supersonic jets can fly faster than sound.','超音速飞机的飞行速度比声音更快。','','super超过 + son声音 + ic……的 → supersonic超音速的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (270,'definite','definite','/ˈdefɪnət/','adj. 明确的，肯定的','sure or certain; unlikely to change','The police found definite proof that he committed the crime.','警方已经掌握明确证据，可以证明是他实施了犯罪。','','defin明确 + ite形容词后缀 → definite明确的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (271,'on_end','on end','/ɔn/ /end/','adv. 直立','on end or upright','The man\'s hair is on end.','那个男人的头发直立着。','on end','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (272,'leaflet','leaflet','/ˈliːflət/','n. 传单，散页的印刷品','a printed sheet of paper or a few printed pages that are given free to advertise or give information about something','She is reading the leaflet attentively.','她正认真地看传单。','','leaf树叶，一页纸 + let小东西 → leaflet小叶；传单',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (273,'slow_down','slow down','/sloʊ daʊn/','phr. 放慢速度',' lose velocity; move more slowly','The car slowed down as it approached the crosswalk.','汽车在接近人行横道时放慢了速度。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (274,'kin','kin','/kɪn/','n. 亲属','your family or your relatives','Of course I love them; they\'re my kin.','我当然爱他们，他们是我的亲人。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (275,'beehive','beehive','/ˈbiːhaɪv/','n. 蜂箱','a structure made for bees to live in','The beekeeper can collect the honey from these beehives.','养蜂人可以从这些蜂箱里收集蜂蜜。','','bee蜜蜂 + hive蜂巢 → beehive蜂窝；蜂箱',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (276,'burst_into_laughter','burst into laughter','/bɜːrst \'ɪntʊ \'læftər/','phr. 突然笑起来，放声大笑','to suddenly start laughing','The team burst into laughter during their meeting in the office.','这个团队在他们在办公室开会的时候放声大笑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (277,'stressful','stressful','/ˈstresfl/','adj.压力大的，令人紧张的','','Preparing for the college entrance exam is a very stressful time for most students.','对大多数学生来说，备战高考的时候压力很大。','','stress压力 ＋ ful形容词后缀 → stressful产生压力的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (278,'picky','picky','/ˈpɪki/','adj. 挑剔的','','The little boy is a bit picky about his food.','这个小男孩有一点挑食。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (279,'technically','technically','/ˈteknɪkli/','adv. 技术上，专门地，学术上，工艺上','','Smart phones are much more technically advanced than the first mobile phones.','智能手机在技术上比第一代手机先进得多。','','techn技术 ＋ ic...的 ＋ ally...地 → technically技术上；专门地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (280,'fitness','fitness','/ˈfɪtnəs/','n.健康，健壮；适合，恰当','the state of being physically healthy and strong; the state of being suitable or good enough for something','Fitness is important for a long life.','健康对长寿来说很重要。','','fit健康的 + ness名词后缀 → fitness健康',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (281,'zinc','zinc','/zɪŋk/','n. 锌；  vt. 镀锌于…','a chemical element. Zinc is a bluish-white metal that is mixed with copper to produce brass and is often used to cover other metals to prevent them from rusting.','Zinc is a very common metal.','锌是一种很常见的金属。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (282,'campaign','campaign','/kæmˈpeɪn/','n.（社会性、政治性）活动，运动；  v.从事活动','a series of planned activities that are intended to achieve a particular social, commercial or political aim','Many people launched a campaign to call for environmental protection.','许多人发起了一场呼吁环保的运动。','','camp营地 + aign名词后缀 → 营地 → 战役',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (283,'ascendance','ascendance','/ə\'sendəns/','n. 优势','the state that exists when one person or group has power over another','The lion\'s ascendance was owed largely to his sheer power and size.','狮子的优势主要在于他的力量和体型。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (284,'nullify','nullify','/ˈnʌlɪfaɪ/','v. 使无效，废弃，取消','to cause (something) to lose its value or to have no effect','The seller gave fake information, which nullifies the contract.','卖家提供了虚假信息，因此合同无效。','','null没有+ify使... → 取消，废除',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (285,'distinct','distinct','/dɪˈstɪŋkt/','adj.截然不同的；独特的','easily or clearly heard, seen, felt, etc.','The red umbrella is distinct among the black ones.','这把红色的伞在这些黑色的伞中显得与众不同。','','dis分开 + stinct（sting）刺，做标记 → 分开标记的，区分清楚的 → distinct独特的，清楚的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (286,'judiciary','judiciary','/dʒuˈdɪʃieri/','n.司法部；司法','persons who administer justice','Judiciary systems interpret and apply the laws in the name of a state.','司法系统以国家的名义解释和应用法律。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (287,'stack','stack','/stæk/','n. 堆，一大堆；  v. 堆积，堆放','a pile of something, usually neatly arranged; a large number or amount of something; a lot of something','I\'ve bought this entire stack of goods through e-shopping!','这一大堆东西都是我从网上买的！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (288,'stadium','stadium','/ˈsteɪdiəm/','n.体育场，露天大型运动场','a large sports ground surrounded by rows of seats and usually other buildings','This is one of the biggest football stadiums in the world.','这是世界上最大的足球场之一。','football stadiums','stadi=stand站，立 + um表场所 → stadium运动场',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (289,'sue','sue','/suː/','v. 控告，提起诉讼；起诉','to make a claim against somebody in court about something that they have said or done to harm you; to formally ask for something, especially in court','The worker is suing his boss for failing to pay his salary.','这名工人起诉老板拖欠工资。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (290,'freckle','freckle','/ˈfrekl/','n. 雀斑，斑点','a small, brownish spot on someone\'s skin','She has many freckles on her face.','她脸上有好多雀斑。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (291,'onion','onion','/ˈʌnjən/','n. 洋葱，洋葱头','a round vegetable with many layers inside each other and a brown, red or white skin. Onions have a strong smell and flavour.','She is slicing the onion with a knife.','她正在用刀切洋葱。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (292,'ask_for','ask for','/æsk fɔːr/','phr.询问',' increase the likelihood of','The tourist is asking the woman for directions.','游客正在向那位女士问路。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (293,'consistency','consistency','/kənˈsɪstənsi/','n. 一致性；连贯性','the quality of always behaving in the same way or of having the same opinions, standard, etc.; the quality of being consistent','His consistency is remarkable, scoring points in every single game!','他的表现特别稳定，每场比赛都得分！','','con共同 + sist站立 + ency名词后缀 → consistency一致性，连贯性',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (294,'content','content','/ˈkɑːntent/','n.目录；  adj.满足的；  v.使满意','the things that are contained in something','You can get a brief idea of a book from the table of contents.','你可以从目录页了解一本书的大致内容。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (295,'geographer','geographer','/dʒiˈɑːɡrəfər/','n. 地理学家；地理学者','a person who studies geography; an expert in geography','The geographer is drawing a map of this area.','这个地理学家正在绘制该地区的地图。','','geo地理 + graph写，图 + er表示人，行为的主动者，做某事的人 → geographer地理学者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (296,'willingness','willingness','/ˈwɪlɪŋnəs/','n.愿意，乐意','the quality of being happy and ready to do something','The student raised his hand to show his willingness to clean the blackboard.','这位学生举手表示自愿去擦黑板。','','will心愿 + ing名词后缀 + ness表名词，行为或状态 → willingness心甘情愿',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (297,'well-known','well-known','/ˌwel ˈnoʊn/','adj. 有名的，著名的','known about by a lot of people; (of a fact) generally known and accepted','This is a well-known painting.','这幅画世界闻名。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (298,'stuffy','stuffy','/ˈstʌfi/','adj. 闷热的；古板的；鼻子不通气的','(of a building, room, etc.) warm in an unpleasant way and without enough fresh air','A bus full of people can be really stuffy.','挤满人的公交车上很闷热。','','stuff填满 + y……的 → 一味填满 → stuffy乏味的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (299,'bewilderment','bewilderment','/bɪˈwɪldərmənt/','n. 困惑','confusion resulting from failure to understand','Her business issues have left her in a state of bewilderment.','她的业务问题使她陷入了困惑。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (300,'anxiety_for','anxiety for','/æŋˈzaɪəti fɔːr/','phr.焦虑，担忧','','Lying in the hospital, he has anxiety for himself.','躺在医院里，他为自己感到担忧。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (301,'procure','procure','/prəˈkjʊr/','vt. （努力）取得；  vi. 介绍娼妓','to get (something) by some action or effort','I finally procured a signed photo of my idol!','我终于得到偶像的签名照啦！','','pro向前，在前 + cure关心 → 关心在前 → procure想要获得',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (302,'laborer','laborer','/\'leɪbərə/','n. 工人；劳动者','a person who does hard physical work for money','The laborer looks very confident.','这位工人看起来很自信。','','labor劳动 + er 表示人 → laborer劳动者；工人',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (303,'surpass','surpass','/sərˈpæs/','v. 胜过；超出','to do or be better than somebody/something','The turtle surpassed the rabbit in the running race.','乌龟在跑步比赛中超过了兔子。','','sur超过，在上面 + pass通过 → 在上面通过 → surpass超过',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (304,'revengeful','revengeful','/rɪ\'vendʒfəl/','adj.怀恨在心的','disposed to seek revenge or intended for revenge','The revengeful peach thought up ways to get the other fruits back for tormenting him.','这个怀恨在心的桃子想出了办法来对那些戏弄他的其他水果进行报复。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (305,'have_a_go','have a go','/həv ə ɡoʊ/','phr. 企图，尝试','to try; attempt','Have a go and see if you can solve this puzzle.','你试试看能否解开这个难题。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (306,'guitar','guitar','/ɡɪˈtɑːr/','n.吉他','a musical instrument that is held against the front of your body and that has usually six strings which are played with your fingers or with a pick','I have always wanted to play music on the guitar.','我一直希望能用吉他弹奏歌曲。','play music on the guitar','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (307,'bewilder','bewilder','/bɪˈwɪldər/','v. 使不知所措；使迷惑','to confuse (someone) very much','She is bewildered; she does not know what to do.','她手足无措，不知道该怎么办。','','be使……成为 + wilder迷惑 → bewilder使迷惑',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (308,'employee','employee','/ɪmˈplɔɪiː/','n.雇员','a person who is paid to work for somebody','These six employees make a great team.','这六名雇员组成了一个很好的团队。','','employ雇用 + ee人 → employee雇员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (309,'find_one\'s_bearings','find one\'s bearings','/faɪnd wʌnz ˈberɪŋs/','v.指明方向','find out the right way','I could find my bearings using the app on my phone.','我可以用手机的这个应用程序找到自己的方向。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (310,'appeal_to_sb._for_sth.','appeal to sb. for sth.','/əˈpiːl tuː ˈsʌmbədi fɔːr ˈsʌmθɪŋ/','phr.呼吁，恳求','','She appeals to us for protecting forests.','她呼吁我们要保护森林。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (311,'slaughter','slaughter','/ˈslɔːtər/','v. 屠杀，屠宰；  n. 屠宰，屠杀','to kill an animal, usually for its meat','Thousands of cows are slaughtered every day during the meat production process.','在制肉过程中，每天有数以千计的牛被屠宰。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (312,'step_on','step on','/step ɑːn/','phr.踩',' place or press the foot on','He stepped back and forth on the control pad, matching the pattern on the screen.','他的脚在控制板上来回踩动，以对应屏幕上的图标。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (313,'dissatisfy','dissatisfy','/dɪsˈsætɪsˌfaɪ/','v. 使不满','to fail to satisfy; make discontented; displease','I am very dissatisfied with this phone and I\'m going to return it.','我对这个手机非常不满意，我要退货。','','dis不 + satis满足 + fy动词后缀 → 使不满，使不平',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (314,'relation','relation','/rɪˈleɪʃn/','n.关系，联系','the way in which two people, groups or countries behave towards each other or deal with each other; the way in which two or more things are connected','They have built a business relation; they\'re partners from now on.','他们建立了商业关系；从现在开始，他们就是合作伙伴了。','','relat=relate关联 + ion名词后缀 → relation关系；联系；家属',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (315,'criteria','criteria','/kraɪ\'tɪəriə/','n. 标准，条件','a standard or principle by which something is judged, or with the help of which a decision is made','The man with blonde hair satisfies the criteria of the job listing.','这个金发男人符合招聘标准。','the criteria of the job listing','criteri标准 + a复数形式 → criteria标准，条件',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (316,'beside_the_point','beside the point','/bɪˈsaɪd ðə pɔːɪnt/','phr.不重要','','Whether he had fun or not is beside the point—he promised to be home by 8pm!','他是否玩得开心并不重要——他承诺了晚上8点到家的！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (317,'French','French','/frentʃ/','adj.法国的；法国人的；  n.法语','of or connected with France, its people or its language','These icons are all closely related to French culture.','这些图标都与法国文化密切相关。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (318,'warm_up','warm up','/ˈwɔːrmˌʌp/','phr. 变暖',' run until the normal working temperature is reached','He breathed into his hands to warm them up.','他朝手哈气让其暖和起来。','','',4,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (319,'priority','priority','/praɪˈɔːrəti/','n.优先考虑的事','something that you think is more important than other things and should be dealt with first','My priority is to finish my homework then dinner.','我得先做完作业才能吃晚餐。','','prior优先 + ity名词后缀 → priority优先（权），重点',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (320,'spaghetti','spaghetti','/spəˈɡeti/','n.意大利细面条','pasta in the shape of long, thin strings','Spaghetti with tomato sauce and grated cheese is my favorite.','加了番茄酱和芝士粉的意大利细面是我的最爱。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (321,'gear','gear','/ɡɪr/','n.装备；齿轮；  v.使适合','machinery in a vehicle that turns engine power (or power on a bicycle) into movement forwards or backwards','I need my gear when I go climbing.','登山时，我需要我的装备。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (322,'machinery','machinery','/məˈʃiːnəri/','n. 机器，机关；机构，机制','machines as a group, especially large ones; the parts of a machine that make it work','The machinery in the factory is used to assemble automobiles.','这个工厂里的机器是用来装配汽车的。','','machin机器 + ery表示场所、地点、工作处 → machinery机器，机关，结构',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (323,'masculinity','masculinity','/ˌmæskjuˈlɪnəti/','n. 男性（气概）','the trait of behaving in ways considered typical for men','Strong muscles are one way to prove a man\'s masculinity.','发达的肌肉是展现男子气概的方式之一。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (324,'freezer','freezer','/ˈfriːzər/','n.冷藏室','a device or room for freezing food or keeping it frozen','Fresh food goes in the top; frozen foods go in the freezer.','新鲜食物放上面；冷冻食物放进冷藏室。','in the freezer','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (325,'for_the_most_part','for the most part','/fɔr ðə moʊst pɑrt/','phr. 在极大程度上；多半','in large part; mainly or chiefly','The product works, for the most part.','这个产品通常是有效的。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (326,'quarry','quarry','/ˈkwɔːri/','n. 采石场；  v. 努力挖掘','a place where large amounts of stone, etc. are dug out of the ground','The quarry supplies rock for making buildings.','采石场提供建房所需的石材。','quarry supplies rock','quar采石 + ry表名词 → quarry采石场',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (327,'tedium','tedium','/ˈtiːdiəm/','n. 单调乏味','the quality or state of being tedious or boring','The tedium of this job is starting to get to me.','这个工作的单调乏味开始烦恼我了。','The tedium of this job','ted枯燥 + ium表名词 → tedium单调乏味',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (328,'organisation','organisation','/ˌɔːrɡənəˈzeɪʃn/','n. 团体，机构；组织体制','a group of people who form a business, club, etc. together in order to achieve a particular aim','Our organisation has contacts all around the world.','我们的机构在全球都有联系。','','organis（e）组织 + ation表名词 → organisation组织，团体',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (329,'talk_over','talk over','/tɔːk ˈoʊvər/','phr.讨论，商议',' speak with others about (something); talk (something) over in detail; have a discussion','The couple usually sit and talk over their plans for the day over breakfast.','这对夫妻经常在吃早餐时讨论当天的计划。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (330,'peril','peril','/ˈperəl/','n. 危险','serious danger','The man faced the peril of falling off the cliff.','这个男人面临着掉下悬崖的危险。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (331,'dodge','dodge','/dɑːdʒ/','v. 躲避，避开；  n. 躲闪，躲避；  v. 回避，规避','to move quickly and suddenly to one side in order to avoid somebody/something','Wow, look at him dodge all those bullets!','哇！你看他躲过了所有的子弹！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (332,'division','division','/dɪˈvɪʒn/','n.分，分配','the process or result of dividing into separate parts; the process or result of dividing something or sharing it out','He finished the division of the cake.','他已把蛋糕分好了。','','di分开 + vis分开 + ion表名词 → division分，分配',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (333,'mutton','mutton','/ˈmʌtn/','n. 羊肉，羊','the meat of an adult sheep used as food','The man is selling the food that is made from mutton.','这男人正在卖羊肉串。','made from mutton','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (334,'during','during','/ˈdʊrɪŋ/','prep.在……过程中，在……期间','throughout the entire time of (an event, period, occurrence, etc.)','It\'s rude to talk on the phone during dinner.','在吃晚餐时讲电话很没礼貌。','','dur持久 ＋ ing构成介词 → during在…期间',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (335,'actuality','actuality','/ˌæktʃuˈæləti/','n. 实际；现状；现实；事实','the quality or state of being actual or real','The scenery on the bank note looked just the same in actuality.','纸币上印的风景和实际的看起来一模一样。','in actuality','actual实际的 + ity名词后缀 → actuality 现实',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (336,'portfolio','portfolio','/pɔːrtˈfoʊlioʊ/','n.公文包，文件夹；投资组合','a thin flat case used for carrying documents, drawings, etc.; (finance) a set of shares owned by a particular person or organization','He is checking his portfolio to find some documents.','他正在找公文包里的文件。','checking his portfolio','port拿，运 + folio树叶，页 → 拿树叶[书页]的东西 → 文件夹；投资组合',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (337,'make_a_move','make a move','/meɪk ə mʊv/','phr. 采取行动','to change position, or to move in a particular way or direction','He is waiting for his opponent to make a move.','他在等着他的对手走下一步。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (338,'buckle','buckle','/ˈbʌkl/','v. 扣紧，扣住；用扣子，把…扣紧（或扣住、扣上）；  n. 金属扣，皮带扣','to fasten something or be fastened with a buckle','Make sure that you\'ve buckled your seat belt before you start your car.','在发动汽车前，确保你系好了安全带哦！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (339,'funding','funding','/ˈfʌndɪŋ/','n.基金，资金','money for a particular purpose; the act of providing money for such a purpose','They plan to help children living in poverty through extra funding.','他们计划用额外的基金帮助贫困儿童。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (340,'worship','worship','/ˈwɜːrʃɪp/','v.崇拜，爱戴；做礼拜，拜神；  n.礼拜，礼拜仪式','to show respect for God or a god, especially by saying prayers, singing, etc. with other people in a religious building; to love and admire somebody very much, especially so much that you cannot see their faults','In ancient times, Chinese farmers used to worship the god of earth.','在古代，中国农民敬拜土地公公。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (341,'end','end','/end/','n. 结果，结局；末端，终点；  v. 结束','to finish; to make something finish','The end of the race was very close.','比赛结果很接近。','The end of the race','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (342,'blend','blend','/blend/','v.混合；把…混成一体；  n.混合物','to mix two or more substances together','Blend the flour and the water with a spoon.','用勺子把面粉和水混到一起。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (343,'encourage','encourage','/ɪnˈkɜːrɪdʒ/','v.鼓励，支持','to give somebody support, courage or hope','Her boyfriend encourages her when she exercises.','当她锻炼时，她的男朋友在一旁鼓励她。','','en加强 + courage内心的力量=勇气 → encourage鼓励',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (344,'feeble','feeble','/ˈfiːbl/','adj. 虚弱的','very weak; not effective; not showing determination or energy','The feeble old man found it difficult to climb the stairs.','这位虚弱的老人连爬楼梯都很困难。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (345,'paddler','paddler','/\'pædlɚ/','n. 轮船桨手，乒乓球运动员，涉水者',' someone paddling a canoe','I am a paddler on the rowing team.','我是划船队的一个船桨手。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (346,'achievement','achievement','/əˈtʃiːvmənt/','n. 成绩，成就；实现，完成','a thing that somebody has done successfully, especially using their own effort and skill','He is known for his great achievements in the sport of tennis.','他在网球运动上的成就令人瞩目。','','achieve达成 + ment表示行为、行为的过程或结果 → achievement成就；实现',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (347,'the_more...the_more...','the more...the more...','/ðə mɔːr ðə mɔːr/','phr. 越……就越……','More and more','The more books you read, the more knowledge you will get.','你读的书越多，学到的知识就越多。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (348,'shuttle','shuttle','/ˈʃʌtl/','n.短程穿梭运行的车辆；航天飞机；  vi.穿梭，移动','a plane, bus or train that travels regularly between two places','People can take the shuttle bus from the subway station to the panda base.','人们可以从地铁站搭乘穿梭巴士到大熊猫基地。','','shutt=shoot抛出 + le表示做某种动作时所使用的东西 → shuttle接驳车',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (349,'bus','bus','/bʌs/','n. 公共汽车','a large road vehicle that carries passengers, especially one that travels along a fixed route and stops regularly to let people get on and off','Let\'s take the bus to the next city.','让我们乘公交车去下一个城市吧。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (350,'grown-up','grown-up','/ˌɡroʊn ˈʌp/','n. 成年人；  adj. 成长的，成熟的，成人的','(used especially by and to children) an adult person','The boy is a grown-up now and no longer plays with the old toys.','这个男孩现在已是一个成年人，不再玩以前的旧玩具了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (351,'from_now_on','from now on','/frʌm naʊ ɑːn/','phr. 从今以后，今后','in future','They are husband and wife from now on.','从现在起他们就是夫妻了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (352,'premium','premium','/ˈpriːmiəm/','n.额外费用，溢价；  adj.高级的','very high (and higher than usual); of high quality','The concert tickets are being sold at a premium.','这些演唱会门票以高于面值的价格出售。','at a premium','pre…前的，预先 + mium拿，买到 → 在前面的人拿到 → premium奖品，奖金',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (353,'difficult','difficult','/ˈdɪfɪkəlt/','adj. 困难的，难做的；难对付的，不易相处的','not easy; needing effort or skill to do or to understand','It is difficult for her to carry such a huge stone.','让她搬起这么大的一块石头实在太难了！','','dif不 + fic做 + ult表名词 → 不好做 → difficult困难的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (354,'archaic','archaic','/ɑːrˈkeɪɪk/','adj. 已不通用的；陈旧的，过时的，老式的','old and no longer used','Radios are becoming archaic today.','收音机现在已经很少有人用了。','','archa太古 ＋ ic...的 → archaic古代的；陈旧的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (355,'consecutive','consecutive','/kənˈsekjətɪv/','adj. 连续的，连贯的','following one after another in a series, without interruption','She has been the top student in her class for three consecutive years.','她连续三年成为班级第一。','','con全部 + secut跟随 + ive……的 → 一个接一个跟随 → consecutive连贯的，连续的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (356,'wedge','wedge','/wedʒ/','n. 楔子；  v. 楔入','a piece of wood, rubber, metal, etc. with one thick end and one thin pointed end that you use to keep a door open, to keep two things apart, or to split wood or rock','I drove a wedge through a log to split it in two.','我把楔子插入木头，将它一分为二。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (357,'cursor','cursor','/ˈkɜːrsər/','n. 光标；（计算尺的）【计】游标，指针','a mark on a computer screen that shows the place where information is being entered or read','Move the cursor and click "OK", then you can log into the system.','移动光标并点击“确认”，你就可以登录进系统了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (358,'muscle','muscle','/ˈmʌsl/','n.肌肉；体力；  v.用强硬手段获得','a piece of body tissue that you contract and relax in order to move a particular part of the body; the tissue that forms the muscles of the body','I can see every muscle on the man\'s arm.','我可以看到这个男人手臂上的每块肌肉。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (359,'advertise','advertise','/ˈædvərtaɪz/','v. 为……做广告','to let people know that something is going to happen, or that a job is available by giving details about it in a newspaper, on a notice in a public place, on the Internet, etc.','The technology company advertises its latest phones on electronic billboards.','这家科技公司在电子广告牌上为他们最新款的手机做广告。','','ad再 + vert转变 + ise使…… → 转变客户想法 → advertise为……做广告',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (360,'population','population','/ˌpɑːpjuˈleɪʃn/','n.人口','all the people who live in a particular area, city or country; the total number of people who live there; a particular group of people or animals living in a particular area','The population of the world is over seven billion.','世界人口超过70亿。','','popul人民 + ation表示行为、状态 → population全体居民，人口',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (361,'pile','pile','/paɪl/','n.一堆；  v.堆积','a number of things that have been placed on top of each other','What a tall pile of books!','多么高的一摞书！','a tall pile','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (362,'unique','unique','/juˈniːk/','adj.独特的','being the only one of its kind','This square apple looks unique in a pile of round ones.','这个方苹果在一堆圆苹果中显得独一无二。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (363,'hall','hall','/hɔːl/','n.会堂，礼堂','a building or large room for public meetings, meals, concerts, etc.','The conference hall with red chairs is empty.','这个配有红色椅子的会堂空空荡荡的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (364,'conscious_of','conscious of','/ˈkɑːnʃəs əv/','phr. 意识到的，关注的','','Conscious of the show being about to start, he adjusted his tie and smiled.','意识到节目即将开始，他调整了领带并微笑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (365,'skip','skip','/skɪp/','v. 跳过；遗漏；  n. 跳跃','to move forwards lightly and quickly making a little jump with each step','The children are skipping rope during their break.','孩子们在课间跳绳。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (366,'western','western','/ˈwestərn/','adj.有西方特征的；  n.西部影片','located in the west or facing west; connected with the west part of the world, especially Europe and N America','I decided to wear a Western style wedding dress.','我决定穿西式婚礼裙。','','west西方 + ern……方向的 → western西方的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (367,'concept','concept','/ˈkɑːnsept/','n.概念；观念','an idea or a principle that is connected with something abstract','Copernicus presented a new concept regarding the solar system.','哥白尼提出了一个有关太阳系的新概念。','','con共同 + cept掌握 → 能共同掌握的 → 概念，设计',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (368,'preceding','preceding','/prɪˈsiːdɪŋ/','adj. 在前的，在先的','to happen before something or come before something/somebody in order; to go in front of somebody','Click this button to browse the preceding text.','点击这个按钮以浏览前文。','','pre预先 + ced走 + ing形容词后缀，…的 → preceding在前的，在先的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (369,'mirage','mirage','/məˈrɑːʒ/','n. 幻影，海市蜃楼','an effect caused by hot air in deserts or on roads, that makes you think you can see something, such as water, which is not there; a hope or wish that you cannot make happen because it is not realistic','I thought there was water in the distance, but it was only a mirage.','我原以为远处有水源，但它却只是海市蜃楼。','','mir惊奇，看 + age状态 → 惊奇状态 → 奇景',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (370,'misery','misery','/ˈmɪzəri/','n. 痛苦，悲惨，不幸','great suffering of the mind or body; something that causes great suffering of mind or body','Her misery is due to her mother\'s death.','她的痛苦来自于母亲的过世。','','miser可怜的 ＋ y表名词 → misery可怜，可悲',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (371,'prospective','prospective','/prəˈspektɪv/','adj. 未来的；预期的；  n. 预期','expected to do something or to become something; expected to happen soon','The prospective parents are discussing what they will buy for their baby.','这对准父母正在讨论给他们的孩子买些什么。','','prospect前景 ＋ ive形容词后缀 → prospective将来的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (372,'intent','intent','/ɪnˈtent/','adj. 全神贯注的；专心致志的；  n. 意图；意向；目的','showing strong interest and attention','He looked at the computer screen with an intent expression.','他全神贯注地盯着电脑屏幕。','intent expression','in内 + tent伸展 → intent意图',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (373,'warehouse','warehouse','/ˈwerhaʊs/','n. 仓库','a building where large quantities of goods are stored, especially before they are sent to shops/stores to be sold','The warehouse is full of boxes.','仓库里堆满了货箱。','','ware物件 + house房子 → 放货物的房子 → warehouse仓库',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (374,'furnish','furnish','/ˈfɜːrnɪʃ/','v. （用家具等）布置（房间、公寓等）','to put furniture in a house, room, etc.','We furnished our room with very expensive furniture.','我们用非常昂贵的家具来装饰我们的房间。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (375,'contour','contour','/ˈkɑːntʊr/','n.轮廓，等高线，概要；  vt.画轮廓，画等高线','the outer edges of something; the outline of its shape or form; (also contour line) a line on a map that joins points that are the same height above sea level','The contour lines join points of equal height.','等高线上的点距离地面的高度相等。','','con全部 + tour旋转，迂回 → 全部转一圈 → contour轮廓',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (376,'starve','starve','/stɑːrv/','v.（使）饿死，挨饿','to suffer or die because you do not have enough food to eat; to make somebody suffer or die in this way','The bear is starving; it doesn\'t have enough food to eat.','这只熊快饿死了；它没有食物吃。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (377,'switch','switch','/swɪtʃ/','n.开关；转向；转辙器','a small device that you press or move up and down in order to turn a light or piece of electrical equipment on and off','Jerry hit the switch to see what would happen.','杰瑞戳开开关想看看会发生什么。','hit the switch','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (378,'squad','squad','/skwɑːd/','n.（军队的）班，小队，小组；  v.编成班','a section of a police force that deals with a particular type of crime','Our squad moved out to find the enemy.','我们的小分队出去搜寻敌人了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (379,'severe','severe','/sɪˈvɪr/','adj.严酷的；剧烈的','extremely bad or serious','It\'s hard for people to walk in such severe weather conditions.','在如此严酷的天气下，人们行走得很艰难。','','sever诚恳 + e → severe严肃的，严厉的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (380,'workshop','workshop','/ˈwɜːrkʃɑːp/','n.车间，工场，工作室；研讨会','a room or building in which things are made or repaired using tools or machinery; a period of discussion and practical work on a particular subject, in which a group of people share their knowledge and experience','I left my car at the workshop for repair.','我把我的车留在车间修理。','at the workshop','work工作 + shop工厂 → workshop车间',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (381,'shine','shine','/ʃaɪn/','v. 照耀，发光；  n. 光泽，光','to give off light','The sun is shining in the sky.','太阳在天空中熠熠闪光。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (382,'be_suspicious_of','be suspicious of','/bi səˈspɪʃəs ʌv/','phr. 怀疑','having or showing a cautious distrust of someone or something','She is suspicious of the report from her business partner.','她对自己商务合伙人的报告很怀疑。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (383,'resistant_to','resistant to','/rɪˈzɪstənt tu/','phr. 对...有抵抗力的，（尤指对变化和新思想）抗拒的','','Gene editing has made the apple more resistant to the disease.','基因编辑增强了苹果对这种病害的抵抗力。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (384,'thermos','thermos','/ˈθɜːrməs/','n.热水瓶，保温瓶','a container that keeps liquids hot or cold for long periods of time','A thermos can keep water hot for a considerable period of time.','保温瓶可以使热水在长时间内保温。','','therm热 + os物品 → thermos热水瓶',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (385,'hardworking','hardworking','/ˌhɑːrd ˈwɜːrkɪŋ/','adj.勤勉的','putting a lot of effort into a job and doing it well','Although she is poor, she is a very hardworking student.','虽然她很穷，但她是一个勤勉的学生。','','hard刻苦 + work工作 + ing形容词后缀 → 努力工作的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (386,'lady','lady','/ˈleɪdi/','n.女士，夫人','a word used to mean ‘woman’ that some people, especially older people, consider is more polite','The young lady is smiling.','这位年轻女士在微笑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (387,'journalist','journalist','/ˈdʒɜːrnəlɪst/','n.新闻记者','a person whose job is to collect and write news stories for newspapers, magazines, radio or television','The journalist is carrying a microphone and a camera.','这位记者带着一个话筒和一台相机。','','journal报纸，刊物 + ist人 → 写新闻文章的人 → journalist新闻记者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (388,'mate','mate','/meɪt/','n. 配偶；  v. （使）成配偶，（使）成伙伴，交配','a person\'s husband, wife, or romantic or sexual partner','My mate and I can look at each other for a long time.','我的伴侣跟我可以互看彼此很久。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (389,'go_(very)_far','go (very) far','/ɡoʊ ˈveri fɑːr/','phr. 大有前途','attain success or reach a desired goal','This girl is so talented in music so they believe she will go very far.','这个女孩在音乐方面很有天赋，因此他们相信她将来会大有前途。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (390,'airport','airport','/ˈerpɔːrt/','n.机场','a place where planes land and take off','The plane landed at the airport.','飞机降落在机场。','at the airport','air空气，空中 + port港口 → airport机场，航空站',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (391,'scholarship','scholarship','/ˈskɑːlərʃɪp/','n.奖学金','an amount of money that is given by a school, an organization, etc., to a student to help pay for the student\'s education','She studied hard and got a scholarship.','她努力学习，并获得了奖学金。','got a scholarship','scholar学者 + ship表名词 → scholarship学问，学识',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (392,'be_susceptible_to','be susceptible to','/bi səˈsɛptəbəl tu/','vt. 易感染(对...敏感)','accessible or especially liable or subject to some influence, mood, agency, etc.','He is rather susceptible to illnesses.','他容易染上疾病。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (393,'playroom','playroom','/ˈpleɪruːm/','n. 游戏室','a room for children to play in','The playroom has all kinds of toys for all kinds of girls and boys.','游戏室为所有男孩和女孩们提供各式各样的玩具。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (394,'rise_to_fame','rise to fame','/raɪz tu fem/','phr. 成名，出名','become famous','His extraordinary skills led to his sudden rise to fame.','他非凡的技能让他忽然成名。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (395,'yield','yield','/jiːld/','v. 出产；弯曲；屈服；让行；  n. 收益','to produce or provide something, for example a profit, result or crop','The fields yielded many carrots for harvest this year.','这块田今年产出了很多胡萝卜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (396,'ignorance','ignorance','/ˈɪɡnərəns/','n.无知；愚昧','a lack of knowledge or information about something','I am embarrassed by my complete ignorance of history.','我对历史一无所知，这让我很难堪。','','i不 ＋ gnor知道 ＋ ance名词后缀 → ignorance无知，愚昧',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (397,'defendant','defendant','/dɪˈfendənt/','n. 被告','the person in a trial who is accused of committing a crime, or who is being sued by another person','The defendant is filled with regret in the court.','这个被告在法庭上充满了悔意。','','de使成… + fend打击 + ant表示人→ 成为被打击的人→ 被告',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (398,'as_if','as if','/æz ɪf/','phr. 好像，仿佛','used when you are giving a possible explanation for something or saying that something appears to be the case when it is not.','Wow! The little girl dressed up as if she was a fairy!','哇！这个小女孩打扮得像个小仙女！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (399,'exempt','exempt','/ɪɡˈzempt/','adj. 被免除的','','In this tourist spot children under 1.2 meters tall are exempt from paying entrance fee.','在这个旅游景点，身高在1.2米以下的儿童可以免票。','are exempt from','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (400,'music','music','/ˈmjuːzɪk/','n.音乐，乐曲；乐谱','sounds that are arranged in a way that is pleasant or exciting to listen to. People sing music or play it on instruments.','Let\'s put some music on!','让我们放点儿音乐吧！','','mus音乐 ＋ ic...学 → music音乐',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (401,'cliff','cliff','/klɪf/','n. 悬崖；峭壁','a high area of rock with a very steep side, often at the edge of the sea or ocean','The steep white cliffs surrounded the bay.','陡峭的白色悬崖包围着海湾。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (402,'bodyguard','bodyguard','/ˈbɑːdiɡɑːrd/','n. 保镖，护卫','a person or a group of people who are employed to protect somebody','This rich businessman hired a bodyguard to protect him.','这个有钱的商人雇了保镖来保护他。','bodyguard to protect him','body身体 + guard保卫→ 保镖，护卫',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (403,'contribute','contribute','/kənˈtrɪbjuːt/','v. 捐献，捐助','to give something, especially money or goods, to help somebody/something','Many people contribute money to help people in need.','很多人捐钱来帮助有需要的人们。','','con共同 + tribute给予 → 全部给出 → contribute捐献，贡献',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (404,'sensor','sensor','/ˈsensər/','n.传感器','a device that can react to light, heat, pressure, etc. in order to make a machine, etc. do something or show something','The pressure sensor will show you if the pressure in the pipe is too high.','当管道压力过大时，压力传感器会显示出来。','','sens=sense感觉 + or名词后缀表示物 → 传感器',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (405,'transparent','transparent','/trænsˈpærənt/','adj.透明的，清澈的','(of glass, plastic, etc.) allowing you to see through it','These glasses are transparent.','这些玻璃杯是透明的。','','trans横过，超过 + par出现 + ent形容词后缀 → 横穿某物能看见 → transparent透明的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (406,'tinge','tinge','/tɪndʒ/','v. 给…染色，轻微地影响；  n. 淡淡的（颜色、神色），轻微，少量','a slight color, flavor, or quality','The maple leaf was tinged red in autumn.','枫叶在秋天被染成红色。','was tinged red','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (407,'field_research','field research','/fild/ /ˈriˌsɜrtʃ/','phr. 野外实地考察','do some research in field','The scientist often traveled to different sites to conduct field research.','那个科学家经常到不同的地方去做野外实地考察。','conduct field research','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (408,'gardening','gardening','/ˈɡɑːrdnɪŋ/','n.园艺；园林工人的工作','the activity of working in a garden, especially for pleasure','The family is doing gardening work in the garden.','这家人正在花园里做园艺工作。','','garden花园 + ing表名词 → gardening园艺；园林工人的工作',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (409,'determination','determination','/dɪˌtɜːrmɪˈneɪʃn/','n.决心；确定','the act of finding out or calculating something','His determination helps him to lose weight through exercise.','他下决心要通过运动减肥。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (410,'habitat','habitat','/ˈhæbɪtæt/','n.栖息地，生活环境','the place where a particular type of animal or plant is normally found','Here are two deer in their natural habitat.','两只鹿在它们的自然栖息地里。','','habit居住 + at表示地方 → 住的地方 → habitat（动植物）居住地',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (411,'locomotive','locomotive','/ˌloʊkəˈmoʊtɪv/','n. 机车，火车头','a railway engine that pulls a train','Old locomotives ran on coal and steam.','老式火车靠煤和蒸汽提供动力。','','loco地方 + mot动 + ive名词后缀 → 从一地动到一地 → locomotive火车头',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (412,'headline','headline','/ˈhedlaɪn/','n. 大字标题','the title of a newspaper article printed in large letters, especially at the top of the front page','I didn\'t read the story; I only saw the headline.','我没看这个故事，我只看了眼标题。','','head头 + line字行 → 头一行字 → headline标题',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (413,'elite','elite','/ɪˈliːt/','n. 精英','a small group of people in a society, etc. who are powerful and have a lot of influence, because they are rich, intelligent, etc.','Only a few elites can make it to the top of the pyramid.','只有少数精英能到达金字塔顶端。','','e出 + lite选择，收集 → 选出的人物 → elite精英人物',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (414,'changeable','changeable','/ˈtʃeɪndʒəbl/','adj. 多变的','likely to change; often changing','The weather here is so changeable.','这里的天气变化多端。','','change变化 + able可…的 → changeable可变的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (415,'filter','filter','/ˈfɪltər/','n.过滤器；  v.过滤，渗透','a device containing paper, sand, chemicals, etc. that a liquid or gas is passed through in order to remove any materials that are not wanted; a device that allows only particular types of light or sound to pass through it','The water filter is used to purify the water.','净水器用以净化水。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (416,'tug','tug','/tʌɡ/','v. 用力拖（或拉）；  n. 猛拉；牵引','to pull something hard, often several times; to pull something hard in a particular direction','They are tugging the rope in the game.','他们在比赛中拉着绳子。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (417,'owing','owing','/ˈoʊɪŋ/','adj. 应付的，未付的，欠着的，受恩惠的，感激的，负有义务的','money that is owing has not been paid yet','The National Debt is the total amount of money borrowed by the government that is still owing.','国家债务是由政府举借的、尚未偿还的金钱总额。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (418,'exchange_for','exchange for','/ɪksˈtʃendʒ fɔr/','phr. 交换','','She wants to exchange the red dress for a white one.','她想把这件红色的连衣裙换成白色的。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (419,'on_condition_that','on condition that','/ɑːn kənˈdɪʃn ðət/','phr.如果','','He\'ll go to the party on the condition that his friend wears those funny trousers.','如果他的朋友穿上那条搞笑的裤子，他就会参加派对。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (420,'fabrication','fabrication','/ˌfæbrɪˈkeɪʃn/','n.制作；构成；捏造；伪造物；装配','the process of making or producing goods, equipment, etc. from various different materials','The car is undergoing the fabrication process.','这辆汽车正在制造过程中。','','fabric表示“制作” + ation名词后缀 → 制作，构成',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (421,'patient','patient','/ˈpeɪʃnt/','n.病人，患者；  adj.有耐心的，能忍耐的','a person who is receiving medical treatment, especially in a hospital','As a nurse, I love to work closely with my patients.','作为一名护士，我喜欢近距离接触我的病人们。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (422,'trolley_bus','trolley bus','/ˈtrɑli bʌs/','n. 无轨电车','a bus that is driven by electric power taken from cables above the street.','A trolley bus uses electricity instead of gas.','电车用电而不烧油。','A trolley bus','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (423,'write_down','write down','/ˈraɪt ˌdaʊn/','phr.写下，记下','to write something on paper, especially in order to remember or record it','Please write down this sentence in your notebook.','请把这句话写在笔记本里。','write down this sentence','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (424,'esthetic','esthetic','/esˈθetɪk/','adj. 美学的；悦目的；美的','concerned with beauty and art and the understanding of beautiful things','The color and structure of this classical architecture brought esthetic pleasure to him.','这座古典建筑的色彩和结构给他带来了美的享受。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (425,'be_acquainted_with','be acquainted with','/bi əˈkwentɪd wɪð/','phr. 熟悉','','He is already well acquainted with British culture.','他已经熟知英国文化。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (426,'mop','mop','/mɑːp/','n.拖把；  v.用拖把拖洗、擦抹','a tool for washing floors that has a long handle with a bunch of thick strings or soft material at the end','Use this mop to clean the floor.','用这个拖把来清洁地板。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (427,'at_all_costs','at all costs','/æt ɔːl kɔsts/','phr. 不管多大代价，无论如何','whatever is needed to achieve something','The player was determined to protect the ball at all costs.','这个球员不惜一切代价坚决护球。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (428,'mind','mind','/maɪnd/','n.头脑，思想；  v.注意；记住','the part of a person that makes them able to be aware of things, to think and to feel','Here\'s a hard question for you: Are your mind and your brain the same thing?','问你个难题：你的思想和头脑是一个东西吗？','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (429,'practitioner','practitioner','/prækˈtɪʃənər/','n.（医生或律师等）从业者，从事者','a person who works in a profession, especially medicine or law','The medical practitioners are preparing for whatever challenge they are faced with.','医疗工作者们做好了应对一切挑战的准备。','medical practitioners','pr预先 + act行动，做 + ition表示行为、行为的过程或结果 + er表示做某事的人 → 预先进行创业的人 → practitioner开业者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (430,'tranquility','tranquility','/træŋ\'kwɪlətɪ/','n. 安静，平静','the quality or state of being quiet and peaceful','I prefer the tranquility of countryside to city life.','比起城市生活，我更喜欢乡村的宁静。','','tranquil安静的 + ity名词后缀 → tranquility 宁静',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (431,'majestic','majestic','/məˈdʒestɪk/','adj. 雄伟的','large and impressively beautiful','The royal palace looks majestic under the blue sky, if only I could live here!','这座宫殿在蓝天下看上去十分雄伟，我要是能住在里面就好啦！','','majest=majesty 威严 + ic...的 → 雄伟的，壮丽的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (432,'Saturday','Saturday','/ˈsætərdeɪ/','n. 星期六','the day of the week after Friday and before Sunday','Saturday is the first day of weekend.','星期六是周末的第一天。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (433,'carve','carve','/kɑːrv/','v.雕刻；（把肉等）切成块','to cut a large piece of cooked meat into smaller pieces for eating','The girl is carving a pumpkin for Halloween.','小女孩正在为万圣节雕刻南瓜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (434,'passive','passive','/ˈpæsɪv/','adj.被动的；  n.被动语态','tending not to take an active or dominant part','Stop smoking! You are making your baby a passive smoker!','别抽烟啦！你正在让你的孩子成为被动吸烟者！','a passive smoker','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (435,'block_out','block out','/blɑk aʊt/','phr. 挡住（光线）','Something that blocks out light prevents it from reaching a place.','We gave our baby sunglasses to block out the sun\'s harmful rays.','我们给宝宝戴上墨镜，阻挡阳光里的有害射线。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (436,'tribal','tribal','/ˈtraɪbl/','adj. 部落的','connected with a tribe or tribes','These African tribal people wear traditional clothing.','这些非洲部落人民穿着传统服饰。','','trib=tribe部落 + al属于……的 → adj.部落的；种族的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (437,'mathematical','mathematical','/ˌmæθəˈmætɪkl/','adj.数学的；精确的','connected with or involving mathematics','She is good at solving mathematical puzzles.','她很擅长解答数学难题。','','mathemat数学 + ic……的 + al……的 → mathematical数学的，数学上的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (438,'hit_on_(upon)','hit on (upon)','/hɪt ɔːn əˈpɔːn/','v. 碰巧打到，偶然发现','come to one\'s mind; suggest itself','She finally hit on the correct combination after trying many times.','在试了很多次后，她最后突然想到了正确的密码。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (439,'mania','mania','/ˈmeɪniə/','n. 癫狂，狂热','extreme enthusiasm for something that is usually shared by many people','I have a mania for neatness. It\'s a problem inside my head.','我的有整洁的癖好，这算是我脑中的执念。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (440,'visible','visible','/ˈvɪzəbl/','adj.可见的','that can be seen','The cake in the right box is visible.','右边盒子里的蛋糕是可见的。','','vis看 + ible形容词后缀，可…的 → visible看得见的，可见的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (441,'pack','pack','/pæk/','v.收拾，打包；包装；塞满，挤满；  n.一伙，一群','to put clothes, etc. into a bag in preparation for a trip away from home; to put something into a container so that it can be stored, transported or sold','He is packing his clothes. ','他正在打包他的衣服。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (442,'latter','latter','/ˈlætər/','n.后者；  adj.后面的','the second of two things or people mentioned','When asked which he would prefer, an apple or a pizza, the boy chose the latter.','当被问到更喜欢苹果还是比萨时，男孩选择了后者。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (443,'existing','existing','/ɪɡˈzɪstɪŋ/','adj.现有的，现存的','existing＝found or used now.','These two Hawaiian Poo-uli birds could be the only existing ones left in the world.','夏威夷的这两只婆欧里鸟，可能是世界上仅存的两只婆欧里鸟了。','','ex出+ist站立+ing表状态→站出来的→existing现存的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (444,'confine','confine','/kənˈfaɪn/','v. 监禁；限制；  n. 范围，界限，约束，限制','to keep somebody/something inside the limits of a particular activity, subject, area, etc.','I am confined to my jail cell.','我被囚禁在监牢里了。','am confined to','con加强意义 + fine界限 → confine边界；限制',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (445,'proverb','proverb','/ˈprɑːvɜːrb/','n.谚语','a well-known phrase or sentence that gives advice or says something that is generally true, for example ‘Waste not, want not.’','The dog chasing the mouse reminded the old man of a Chinese proverb.','狗追老鼠的场景使这位老人想起了一句中国谚语。','','pro前面 + verb词语 → 古人的言语 → proverb谚语',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (446,'hurry_up','hurry up','/ˈhɜːri ʌp/','phr. 赶快，快点','to do something more quickly because there is not much time; to make somebody do something more quickly; to make something happen more quickly','He has to hurry up, or he will miss the bus.','他得快点，否则就赶不上公共汽车了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (447,'color','color','/ˈkʌlər/','n.颜色；  v.给……涂色','the appearance that things have that results from the way in which they reflect light. Red, orange and green are colours.','The kids painted their hands every color of the rainbow.','小孩子们把彩虹的几种颜色都画在手上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (448,'slippery','slippery','/ˈslɪpəri/','adj. 滑的；易滑脱的','difficult to hold or to stand or move on, because it is smooth, wet or polished','Watch out! The ground is slippery!','小心！地面很滑！','','slipp滑 + ery表名词 → slippery滑的，使人滑跤的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (449,'goat','goat','/ɡoʊt/','n. 山羊','an animal with horns and a coat of hair, that lives wild in mountain areas or is kept on farms for its milk or meat','I love my pet goat even though it eats everything.','我爱我的宠物山羊，尽管它什么都吃。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (450,'despair','despair','/dɪˈsper/','n.绝望；  v.绝望，感到无望','to no longer have any hope or belief that a situation will improve or change','"I just don\'t want to live anymore," he said with despair in his voice.','“我只是不想再活下去了，”他带着绝望的语气说。','despair in his voice','de去掉 + spair希望 → despair 绝望',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (451,'jog','jog','/dʒɑːɡ/','n.慢跑；  v.慢跑','to run slowly and steadily for a long time, especially for exercise','Every morning I go for a jog for my health.','每天早上，我都会为了健康去慢跑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (452,'yawn','yawn','/jɔːn/','v.打哈欠；打着哈欠说；  n.乏味或枯燥的事物','to open your mouth wide and breathe in deeply through it, usually because you are tired or bored','The cat yawned lying on the grass. So cute!','这只猫躺在草地上打哈欠，太可爱了！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (453,'incorporate','incorporate','/ɪnˈkɔːrpəreɪt/','v. 包含；使并入','to include something so that it forms a part of something','The app update incorporates many new features and improvements.','这款应用程序的更新加入了许多新功能和改进。','','in向内，进入 + corpor团体 + ate动词后缀 → 成为团体 → incorporate合并，并入',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (454,'routinely','routinely','/ruːˈtiːnli/','adv. 常规地，惯常地；例行公事地','','She routinely cheers herself up each morning.','每天清晨她都会为自己打打气。','','routine路线 ＋ ly...地 → routine走老路地=例行公事的 ＋ ly...地 → routinely例行公事地；老一套地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (455,'most_distinctive','most distinctive','/moʊst dɪˈstɪŋktɪv/','phr. 最杰出的','of a feature that helps to distinguish a person or thing','These are five of most distinctive people from the 20th century.','他们是20世纪最杰出人物中的其中五位。','the most distinctive actress','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (456,'beloved','beloved','/bɪˈlʌvɪd/','n. 爱人；  adj. 心爱的，所钟爱的','somebody you love very much','You are my beloved.','你是我的爱人。','my beloved','be是 + loved被爱，所爱 → beloved 心爱的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (457,'renewable','renewable','/rɪˈnuːəbl/','adj. 可再生的；可继续的；  n. 再生性能源','(of energy and natural resources) that is replaced naturally or controlled carefully and can therefore be used without the risk of finishing it all','Wind energy is renewable.','风能是可再生的。','','renew重生 + able可……的 → renewable可再生的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (458,'stir','stir','/stɜːr/','vt.搅拌','to mix something by making circular movements in it with a spoon or similar object','The lady is stirring the coffee.','这位女士正在搅拌咖啡。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (459,'take_out','take out','/teɪk aʊt/','phr. 取出；把…带出去','to remove from its packing；to obtain money by removing it from your bank account','He takes out some money from his wallet.','他从钱包里拿了一些钱出来。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (460,'beyond','beyond','/bɪˈjɑːnd/','prep.超出；  adv.在更远处','more than something','The equation is beyond me, and it won\'t come out.','这道方程题超出了我的理解范围，怎么也解不出来。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (461,'onset','onset','/ˈɑːnset/','n. 开始；攻击，袭击','the beginning of something, especially something unpleasant','The referee\'s whistle indicates the onset of the game.','裁判的哨声表示比赛开始。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (462,'in_vain','in vain','/ɪn veɪn/','phr.徒然，白费力气','to no avail','All his efforts to fetch water with a basket were in vain.','用竹篮子打水，他所有的努力都白费了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (463,'stove','stove','/stoʊv/','n.炉子，火炉，电炉','a large piece of equipment for cooking food, containing an oven and gas or electric rings on top','Turn off the stove, or the food will be overcooked.','快把炉子关掉，不然食物要烧焦了。','Turn off the stove','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (464,'up_and_down','up and down','/ʌp ænd daʊn/','phr.上上下下；来回，来来回回','in one direction and then in the opposite direction','The cat moves its head up and down when you play with it.','当你逗猫的时候，它的头上上下下。','moves its head up and down','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (465,'noteworthy','noteworthy','/ˈnoʊtwɜːrði/','adj.值得注意的；显著的','deserving to be noticed or to receive attention because it is unusual, important or interesting','This must be a noteworthy painting because so many people are crowded around it.','这一定是一幅值得注意的画，因为有这么多人都围着它。','','note注意 + worthy值得 → adj. 值得注意的；显著的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (466,'religion','religion','/rɪˈlɪdʒən/','n. 宗教信仰；虔诚的追求','the belief in the existence of a god or gods, and the activities that are connected with the worship of them, or in the teachings of a spiritual leader','His religion taught him to be kind.','他的宗教信仰教他要善良。','','relig=rely依赖 + ion名词后缀 → 用来依赖的 → religion宗教，宗教信仰',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (467,'avalanche','avalanche','/ˈævəlæntʃ/','n. 雪崩，大量拥至；  vi. 崩塌','a large amount of snow and ice or of dirt and rocks that slides suddenly down the side of a mountain','The avalanche buried the small cabin in the snow.','雪崩掩埋了那个小木屋。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (468,'athletics','athletics','/æθˈletɪks/','n.体育运动','sports, games, and exercises that require strength and skill :athletic activities','He is good at many kinds of athletics.','他擅长很多种运动。','','athlet运动 ＋ ics学科 → athletics运动学',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (469,'flap','flap','/flæp/','v. 拍打，挥动；  n. 拍打，挥动','if a bird flaps its wings, or if its wings flap, they move quickly up and down; to move or to make something move up and down or from side to side, often making a noise','The bird flaps its wings.','鸟拍打着翅膀。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (470,'impoverish','impoverish','/ɪmˈpɑːvərɪʃ/','v. 使成赤贫，使枯竭','to make somebody poor; to make something worse in quality','Underdeveloped living conditions impoverish African children.','艰苦的生活条件使得非洲孩子们很穷困。','','im进入 + pover=poverty贫困 + ish表动词，“造成…” → 使成赤贫',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (471,'tendency_to_sth.','tendency to sth.','/ˈtendənsi tuː ˈsʌmθɪŋ/','phr.做某事的倾向','','When he is sad, he has a tendency to smoking.','当他伤心时，他有想抽烟的倾向。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (472,'distribution','distribution','/ˌdɪstrɪˈbjuːʃn/','n.分布，分配','the act of delivering something to a store or business','This chart shows the approximate population distribution in Australia.','这张图显示了澳大利亚人口的大致分布。','population distribution','dis分开 + tribut给予 + ion表名词 → distribution分配',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (473,'miserable','miserable','/ˈmɪzrəbl/','adj.痛苦的，悲惨的	；令人难受的','very unhappy or uncomfortable','The man feels tired and miserable.','这个男人感到疲倦和痛苦。','','miser可怜 + able……的 → miserable可怜的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (474,'geometry','geometry','/dʒiˈɑːmətri/','n. 几何学；几何形状','the branch of mathematics that deals with the measurements and relationships of lines, angles, surfaces and solids','Geometry is the study dealing with different kinds of shapes.','几何学是研究各种不同图形的学科。','','geo地 + metry计量，测量 → 测量地面 → geometry几何学',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (475,'tell_from','tell from','/tel frʌm/','phr.看出','','She could tell from his expression that he was angry.','她从他的表情看出他生气了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (476,'discard','discard','/dɪsˈkɑːrd/','v.丢掉；抛弃；打出（无用的牌）','to get rid of something that you no longer want or need','I will discard this bottle into the garbage bin.','我要把这个瓶子丢进垃圾桶。','','dis离开 + card纸 → discard丢弃',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (477,'desperation','desperation','/ˌdespəˈreɪʃn/','n. 绝望（的境地）','the state of being desperate','I feel a sense of desperation by looking at the undone work.','他看了看还没做完的工作，感到一阵绝望。','','desperat绝望的 + ion名词后缀 → desperation绝望',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (478,'waken','waken','/ˈweɪkən/','v. 弄醒；唤醒','to wake, or make somebody wake, from sleep','The alarm clock wakens me at 6 o\'clock every day.','闹钟每天都在六点的时候把我叫醒。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (479,'quantify','quantify','/ˈkwɑːntɪfaɪ/','vt.确定数量','to describe or express something as an amount or a number','A measuring cup helps me quantify the ingredients that I need.','量杯帮我确定我需要的材料的用量。','','quant数量 + ify表动词 → 确定…的数量，量化',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (480,'archive','archive','/ˈɑːrkaɪv/','n. 档案室，档案；  vt. 把……收集归档','a place in which public records or historical materials (such as documents) are kept','The man is checking and counting files in the archive.','那位男生在档案室里面清点文件。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (481,'stand_in_line','stand in line','/stænd ɪn laɪn/','v. 排队','form a queue, form a line','These people are standing in line.','这些人正在排队。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (482,'hostility','hostility','/hɑːˈstɪləti/','n. 虐待，敌意；不友善','unfriendly or aggressive feelings or behaviour','The dog\'s fierce look shows its hostility.','狗狗一脸凶相，满是敌意。','','host敌人 + ility表名词 → hostility敌对',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (483,'vest','vest','/vest/','n.汗衫，背心，马甲；  v.给……穿衣服','a piece of underwear worn under a shirt, etc. next to the skin','I put on my white vest to get ready for exercise.','我穿上我的白色背心准备锻炼。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (484,'quota','quota','/ˈkwoʊtə/','n.限额；配额；定额','the limited number or amount of people or things that is officially allowed','He was told that the quota of liquor is two bottles per person.','他被告知酒的限额是每人两瓶。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (485,'have_one\'s_hands_full','have one\'s hands full','/hæv wʌnz hændz fʊl/','phr. 忙得不可开交；手头事情应接不暇','keep busy with sth.','The mother has her hands full with both her work and her children.','这位母亲因为工作和孩子，忙得不可开交。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (486,'reason_for','reason for','/ˈrizən fɔr/','n. ...的原因(理由等)','','Missing the bus is his reason for being late.','没赶上公共汽车是他迟到的原因。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (487,'show_respect_for','show respect for','/ʃo rɪˈspɛkt fɔr/','phr. 对...表示尊敬','regard highly; think much of','The little girl showed respect for her teacher.','小女孩对老师表示了尊重。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (488,'sex','sex','/seks/','n.性别；色情；  v.区分性别','physical activity between two people in which they touch each other’s sexual organs, and which may include sexual intercourse','The application form asks for your sex.','这张申请表需要填上您的性别。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (489,'total','total','/ˈtoʊtl/','adj.整个的，总体的；  n.总数','being the amount or number after everyone or everything is counted or added together','What\'s the total number of ducks in the pond?','池塘里一共有多少只鸭子呢？','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (490,'musical','musical','/ˈmjuːzɪkl/','adj.音乐的；有音乐才能的，喜欢音乐的；  n.音乐剧','connected with music; containing music','The guitar is a musical instrument which is hard to learn.','吉他是一种难学的乐器。','a musical instrument','mus娱乐，音乐 + ical…的 → musical音乐的；和谐的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (491,'sponsorship','sponsorship','/ˈspɑːnsərʃɪp/','n.赞助','','Any company who provided sponsorship is advertised on the show.','任何一家提供赞助的公司都能在这个节目中植入广告。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (492,'hesitation','hesitation','/ˌhezɪˈteɪʃn/','n.犹豫不决','a delay due to uncertainty of mind or fear','The girl showed hesitation in selecting a dress.','女孩在挑选裙子时犹豫不决。','','hesitat(e) 犹豫+ ion 名词后缀 → hesitation 犹豫不决',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (493,'excel','excel','/ɪkˈsel/','vi. 胜出；  vt. 优于','to be very good at doing something','The red man excels in running.','红色的小人在跑步中胜出了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (494,'groan','groan','/ɡroʊn/','v. 呻吟；抱怨；  n. 呻吟','to make a long deep sound because you are annoyed, upset or in pain, or with pleasure','The woman loudly groaned due to her splitting headache.','这个女人因剧烈的头痛而大声呻吟起来。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (495,'agricultural','agricultural','/ˌæɡrɪˈkʌltʃərəl/','adj. 农业的；农艺的','connected with the science or practice of farming','Agricultural land is important for growing crops.','农田（质量）对于种庄稼来说很重要。','','agri田地，农业 + cult培养 + ur=ure表名词 + al形容词后缀 → 农业的，农艺的，农学的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (496,'glad','glad','/ɡlæd/','adj. 高兴的','pleased; happy','I am glad to be sharing my speech with you today.','很高兴今天能给大家做演讲。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (497,'lavatory','lavatory','/ˈlævətɔːri/','n. 厕所，盥洗室','a toilet, or a room with a toilet in it; a public building or part of a building, with toilets in it','The lavatory in the middle is for the disabled.','中间的厕所是给残疾人用的。','','lav洗，冲洗 + atory场所 → 冲洗的地方 → lavatory洗手间',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (498,'latitude','latitude','/ˈlætɪtuːd/','n. 纬度；（言论，行动的）自由','the distance of a place north or south of the equator (= the line around the world dividing north and south), measured in degrees','The higher the latitude, the colder the temperature will be.','纬度越高，温度越低。','','lat宽 ＋ itude抽象名词 → latitude纬度；自由',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (499,'try','try','/traɪ/','v.试图，努力；  n.努力，尝试','to use, do or test something in order to see if it is good, suitable, etc.','The woman is trying on a pair of high heels.','这个女人正在试穿一双高跟鞋。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (500,'Buddhist','Buddhist','/ˈbʊdɪst/','adj. 佛教的；  n. 佛教徒','a person who follows the religion of Buddhism','The Buddhist monk is praying in the temple.','这个佛教僧侣正在寺庙里祈祷。','Buddhist monk','Buddh=Buddha佛教 + ist主义 → 佛教徒',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (501,'because_of','because of','/bɪˈkɔːz əv/','phr. 因为；由于','','I got sick because of the cold and the rain.','因为天冷和这场雨，我生病了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (502,'cohesive','cohesive','/koʊˈhiːsɪv/','adj. 团结的；紧密结合的','forming a united whole','We must work as a cohesive group and support each other.','我们必须组成一个团结的小队并互相支持。','','co共同 + hes粘附 + ive……的 → 粘着的，紧密结合在一起的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (503,'minimal','minimal','/ˈmɪnɪməl/','adj.最低限度的','very small in size or amount; as small as possible','The advertisement emphasizes that the risk involved in the surgery is minimal.','广告强调这个手术的风险微乎其微。','','minim小 + al形容词后缀 → minimal最小的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (504,'hostess','hostess','/ˈhoʊstəs/','n.女服务员；女主人；女主持人','a woman who invites guests to a meal, a party, etc.; a woman who has people staying at her home; a woman who is employed to welcome and entertain men at a nightclub; a woman who introduces and talks to guests on a television or radio show; a woman who welcomes the customers in a restaurant','The air hostess brought a cup of coffee to the passenger.','空姐给乘客端上来一杯咖啡。','','host主人 + ess女性，雌性 → 女主人',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (505,'in_common','in common','/ɪn ˈkɑmən/','phr. 相同的，共有，有共同之处','sharing equally with another or others','The girl and boy are thinking in common.','女孩和男孩有相同的想法。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (506,'fellow','fellow','/ˈfeloʊ/','n. 家伙，男人；  adj. 处于相同情况的，同类的；  vt. 使…与另一个对等，使…与另一个匹敌','a male person; a boy or man','Those two fellows are celebrating their success.','那两个家伙在庆祝他们的成功。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (507,'discussion','discussion','/dɪˈskʌʃn/','n.讨论，谈论','the process of discussing somebody/something; a conversation about somebody/something','The teacher and kids are in a discussion about the Earth.','老师和孩子们在进行一场关于地球的讨论。','','discuss讨论 + ion名词后缀 → discussion讨论',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (508,'recreate','recreate','/ˌriːkriˈeɪt/','v. 再创造，再现；娱乐，消遣','','Advanced technology makes it possible to recreate this damaged relic.','高科技能再现这件受损文物原有的面貌。','','re再 + cre增长，产生 + ate造成 → 再创造 → recreate再现，再创造',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (509,'cliche','cliche','/klɪˈʃeɪ/','n. 陈腐思想，陈词滥调','a phrase or expression that has been used so often that it is no longer original or interesting','It\'s such a cliche to say "If you are well, it is a sunny day."','“你若安好，便是晴天”已经是陈词滥调了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (510,'lightly','lightly','/ˈlaɪtli/','adv. 轻轻地，容易地，轻松地','gently; with very little force or effort','I didn\'t want to wake up the baby, so I put him down very lightly.','我不想叫醒宝贝，所以我把他轻轻地放下了。','','light轻轻的 ＋ ly...地 → lightly轻轻地；轻松地；容易地；不费力地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (511,'congressional','congressional','/kənˈɡreʃənl/','adj.国会的；议会的','of or relating to congress','Congressional representatives from each state attended the national meeting.','来自各州的国会代表们参加了此次全国会议。','','con共同+gress行走+ion名词后缀+al...的→ (代表)大会的，国会的，议会的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (512,'sprint','sprint','/sprɪnt/','v. 疾跑，冲刺；  n. 全速奔跑','to run or go very fast for a short distance','Both the athletes sprint to the finish line to try and win the race.','运动员们都向着终点线冲刺，想要赢得比赛。','sprint to the finish line','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (513,'summary','summary','/ˈsʌməri/','n.摘要，总结；  adj.简略的，概要的','a short statement that gives only the main points of something, not the details','I made a summary of this article.','我对这篇文章做了一下总结。','','summ总数 + ary表名词 → 内容总和 → summary摘要',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (514,'original','original','/əˈrɪdʒənl/','adj.最初的，原始的','existing at the beginning of a particular period, process or activity; new and interesting in a way that is different from anything that has existed before; able to produce new and interesting ideas; painted, written, etc. by the artist rather than copied','I gave her a copy and kept the original document myself.','我给了她一份复印件，并自己保存了原件。','','origin起源 + al形容词后缀 → original原始的，独创的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (515,'with_the_exception_of','with the exception of','/wɪð ðə ɪkˈsepʃən əv/','phr. 除...之外','','All of these fruit are orange, with the exception of the apple, which is green. ','除了苹果是绿色的，所有的水果都是橙色的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (516,'contented','contented','/kənˈtentɪd/','adj. 满足的；  v. 使…满足','showing or feeling happiness or satisfaction, especially because your life is good','The couple enjoyed a contented relaxing life after retiring.','退休后，这对夫妻过上了满足、惬意的生活。','a contented relaxing life','content满意 ＋ ed形容词后缀 → contented满足的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (517,'moral','moral','/ˈmɔːrəl/','adj. 道德（上）的，道义的；  n. 道德，品行','concerned with principles of right and wrong behaviour; following the standards of behaviour considered acceptable and right by most people','To return the money you found or not, it\'s a moral dilemma.','捡到的钱要不要还回去，这是一个道德难题。','','mor道德 + al…的 → moral道德的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (518,'degeneration','degeneration','/dɪˌdʒenəˈreɪʃn/','n. 退化','','Overgrazing has caused the degeneration of the grassland.','过度放牧导致了草地的退化。','','de 否定 + gener 出生，产生+ ation 表示情况、过程、结果→退化；[医] 变性；堕落；恶化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (519,'sin','sin','/sɪn/','n.罪孽，罪过；错误，过失；  v.违反戒律；犯过失','an offence against God or against a religious or moral law','There are seven deadly sins in early Catholic teachings.','天主教早期教义中有七宗罪。','seven deadly sins','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (520,'broadcast','broadcast','/ˈbrɔːdkæst/','n.广播或电视节目；  v.播放，广播','to tell a lot of people about something; to send out programmes on television or radio','A broadcast is a program, a performance, or a speech on the radio or on television.','广播电视节目是指在收音机里或在电视上播放的节目、表演或演说。','','broad宽广 + cast投射 → 广播, 播音',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (521,'commiserate','commiserate','/kəˈmɪzəreɪt/','v. 同情，怜悯','to show somebody sympathy when they are upset or disappointed about something','I commiserated with her when she didn\'t get the promotion.','当她没有得到提拔时，我很同情她。','commiserated with','com共同 + miser可怜的 + ate动词后缀 → 共同可怜 → 怜悯',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (522,'psychology','psychology','/saɪˈkɑːlədʒi/','n.心理学；心理特征，心理状态','the scientific study of the mind and how it influences behaviour','I study psychology to learn about how people think.','我学心理学是为了了解人们如何思考。','','psych灵魂 + ology……学 → psychology心理学，心理状态',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (523,'sympathy','sympathy','/ˈsɪmpəθi/','n.同情；同感','the feeling that you care about and are sorry about someone else\'s trouble, grief, misfortune, etc.','He felt a lot of sympathy for the dog and gave it a bone.','他很同情那条小狗并给了它一根骨头。','felt a lot of sympathy for','sym共同 + pathy感情 → sympathy同情',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (524,'impatient','impatient','/ɪmˈpeɪʃnt/','adj.不耐烦的，急躁的','','He had been waiting for twenty minutes and he was getting impatient.','他已经等了二十分钟，有点不耐烦了。','','im不 + patient有耐心的 → impatient不耐烦的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (525,'oak','oak','/oʊk/','n.栎树，橡树','a large tree that produces small nuts called acorns. Oaks are common in northern countries and can live to be hundreds of years old.; the hard wood of the oak tree','There is a bench under the grand oak tree.','巨大的橡树下有一条长凳。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (526,'acknowledge','acknowledge','/əkˈnɑːlɪdʒ/','v.告知收到；致意；答谢；承认','to tell somebody that you have received something that they sent to you','"Acknowledged. We will bake the bread soon."','“已收到。我们会马上烤面包。”','','ac使 + knowledge了解 → acknowledge承认，认知',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (527,'narrow','narrow','/ˈnæroʊ/','adj.狭窄的；  n.海峡；  v.变窄','measuring a short distance from one side to the other, especially in relation to length','The fat man is wondering how to pass through the narrow road.','那个胖子正在纠结如何才能走过那条窄巷。','the narrow road','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (528,'constitute','constitute','/ˈkɑːnstətuːt/','vt.构成，组成','(not used in the progressive tenses) to be the parts that together form something; to form a group legally or officially; (not used in the progressive tenses) to be considered to be something','Bread, beef, cheese and salad constitute the perfect burger.','面包、牛肉、芝士和沙拉组成了一个完美的汉堡。','','con共同 + stitute=set up放 → 放到一起 → constitute构成，组成',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (529,'pence','pence','/pens/','n. 便士','the plural form of penny, a British coin worth one hundredth of a pound','In the U.K., one hundred pence make one pound.','在英国，一百便士等于一英镑。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (530,'additional','additional','/əˈdɪʃənl/','adj. 增加的；附加的','more than was first mentioned or is usual','Each additional scoop made the ice cream taste even more delicious.','每多一个球都让这个冰激凌变得更好吃了。','additional scoop','add加上 + ition名词后缀 + al形容词后缀 → additional附加的，追加的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (531,'snail','snail','/sneɪl/','n.蜗牛；迟钝的人；  v.缓慢移动','a small soft creature with a hard round shell on its back, that moves very slowly and often eats garden plants. Some types of snail can be eaten.','A small snail is climbing a tree.','一只小蜗牛在爬树。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (532,'Christmas','Christmas','/ˈkrɪsməs/','n.圣诞节','25 December, the day when Christians celebrate the birth of Christ','Christmas is a traditional festival in Western countries.','圣诞节是西方国家的传统节日。','','Christ基督 + mas(s)圣餐 → 为纪念耶稣诞生吃圣餐 → Christmas圣诞节',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (533,'cloak','cloak','/kloʊk/','n. 斗篷，披风；覆盖物；  vt. 给……披斗篷；掩饰','a type of coat that has no sleeves, fastens at the neck and hangs loosely from the shoulders, worn especially in the past','The woman wears a red cloak.','这个女人穿着一件红色的斗篷。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (534,'cassette','cassette','/kəˈset/','n. 录像带，盒式磁带','a small flat plastic case containing tape for playing or recording music or sound','People used cassette tapes to play music in the past.','过去人们都用磁带来听音乐。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (535,'fluctuation','fluctuation','/ˌflʌktʃuˈeɪʃn/','n. 波动；起伏','one of several frequent changes in size, amount, quality, etc, especially from one extreme to another; the act of changing frequently like this','The fluctuation in our data shows that our production is not stable enough.','数据的波动说明了我们的产量还不够稳定。','','fluctu波浪 + ation表示行为、情况、状态、过程、结果 → fluctuation波动，起伏',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (536,'give_rise_to','give rise to','/ɡɪv raɪz tu/','phr. 引起，发生','cause to happen or occur, not always intentionally','Doing sports gives rise to a slim figure.','运动让身材苗条。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (537,'entry','entry','/ˈentri/','n. 进入','the act of recording information in a computer, book, etc.','He made his entry into the meeting room.','他走进了会议室。','made his entry into','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (538,'responsibility_for','responsibility for','/rɪˌspɑːnsəˈbɪləti fɔːr/','n. 责任, 负责','','He apologised and took full responsibility for the accident.','他道了歉并主动承担事故的全部责任。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (539,'fog','fog','/fɔːɡ/','n.雾，烟雾，尘雾','a thick cloud of very small drops of water in the air close to the land or sea, that is very difficult to see through','The heavy fog covers the whole city.','大雾弥漫了整座城市。','heavy fog','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (540,'perverse','perverse','/pərˈvɜːrs/','adj. 违反常情的；邪恶的','showing deliberate determination to behave in a way that most people think is wrong, unacceptable or unreasonable','The fish is being deliberately perverse to swim to an opposite direction.','这条鱼故意反常地游向相反的方向。','','per贯穿，自始自终 ＋ verse=vers转 → 和大家始终反着转 → perverse性情乖张的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (541,'legislate','legislate','/ˈledʒɪsleɪt/','v. 立法，制定法律','to make a law affecting something','The congress is responsible for legislating, or making laws.','国会负责立法或制定法律。','','legisl=legis法律 + ate使之成…… → 使之成法律 → legislate立法',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (542,'uncalled-for','uncalled-for','/ʌn\'kɔːldˌfɔː/','adj. 没有必要的，不合适的','not necessary or appropriate :not called for','The man\'s aggression towards the parking warden was uncalled-for.','这人对停车场管理员的挑衅是不应该的。','','un未 ＋ called叫道 ＋ -for为了 → uncalled-for不必要的；多余的；无理的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (543,'gold','gold','/ɡoʊld/','n.黄金，金币；  adj.金制的','a chemical element. Gold is a yellow precious metal used for making coins, jewellery, decorative objects, etc.; money, jewellery, etc. that is made of gold','Every pirate dreams of finding a chest of gold.','每个海盗都梦想找到一箱黄金。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (544,'layer','layer','/ˈleɪər/','n. 层；阶层','a level or part within a system or set of ideas','Wow, look at how many layers that sandwich has!','哇，看看那个三明治有多少层！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (545,'blood','blood','/blʌd/','n.血（液）；血统；  v.抽血','the red liquid that flows through the bodies of people and animals','The doctor took some blood from me during my checkup.','医生在给我检查时抽了点儿血。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (546,'tan','tan','/tæn/','n.晒成棕褐色或晒黑的皮肤；  v.硝制（皮革）','the brown colour that somebody with pale skin goes when they have been in the sun','I can get a tan while lying in the sun.','躺在阳光下，我就会晒黑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (547,'standpoint','standpoint','/ˈstændpɔɪnt/','n.观点，立场','an opinion or a way of thinking about ideas or situations','The two ministers held conflicting standpoints on war issue.','两位大臣在战争问题上持有相反的观点。','','stand立 + point点 → standpoint立场，观点',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (548,'stand_by_sb.','stand by sb.','/stænd baɪ ˈsʌmbədi/','v. 支持某人','be behind; approve of sb.','She always stands by her friends whenever they are in trouble.','每当朋友有困难时，她总是会支持她们。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (549,'substantial','substantial','/səbˈstænʃl/','adj.大量的','','The clothing store offered substantial discounts on all items to boost sales.','这家服装店对店内所有的商品进行大幅度打折以促进销售。','substantial discounts','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (550,'disorganize','disorganize','/dɪs\'ɔːgəˌnaɪz/','v. 破坏组织；搅乱秩序；使混乱；破坏组织','to disrupt or break up the order, arrangement, or system of; throw into confusion or disorder','It takes me weeks to organize my closet, but only minutes to disorganize it.','整理我的衣柜要花几周，但是打乱它只要几分钟。','','dis相反 + organize组织 → disorganize破坏组织',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (551,'be_used_to_sth.','be used to sth.','/biː ju:st tuː ˈsʌmθɪŋ/','quant. 习惯于','be accustomed to','Living in England, she is used to it raining every day.','住在英国，她习惯了每天下雨。','she is used to','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (552,'lot','lot','/lɑːt/','pron. 大量，许多','a large number or amount','I have a lot of pencils.','我有许多铅笔。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (553,'impatience','impatience','/ɪmˈpeɪʃns/','n.不耐烦，急躁','','Her impatience is growing as she\'s already waited for an hour.','她已经等了一个小时，所以变得越来越不耐烦了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (554,'overlook','overlook','/ˌoʊvərˈlʊk/','v. 忽视，未注意到；  n. 忽视，远眺','if a building, etc. overlooks a place, you can see that place from the building','She\'s so busy on her tablet that she\'s totally overlooking her daughter.','她忙着玩平板，全然忽视了她的女儿。','','over在上，在外 + look看 → 在上面看 → 俯视；疏忽',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (555,'flirt','flirt','/flɜːrt/','vi.卖弄风情，调情；戏弄，不认真地对待；  n.调情的人','to behave in a way that shows a sexual attraction for someone but is not meant to be taken seriously','Obviously they are flirting with each other.','很显然，他们在互相调情。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (556,'authorize','authorize','/ˈɔːθəraɪz/','v. 批准；授权','to give official permission for something, or for somebody to do something','The emperor authorized this document with a stamp.','皇帝加印批准了这个文件。','','auth授权 + or人 + ize动词后缀 → authorize授权，批准',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (557,'glamor','glamor','/ˈɡlæmər/','n.魅力，吸引力','the attractive and exciting quality that makes a person, a job or a place seem special.','This beautiful blonde girl has so much style and glamor!','这个金发美女很有风格，魅力十足！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (558,'have_(get)_the_upper_hand','have (get) the upper hand','/hæv ɡet ði ˈʌpər hænd/','v. 取得优势，占上风','win a victory over','The red team have gained the upper hand and look like they will win.','红队已经占了上风而且他们好像要赢了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (559,'redundant','redundant','/rɪˈdʌndənt/','adj. 多余的，过剩的','not needed or useful','The old steam train is redundant and has been replaced with newer trains.','旧的蒸汽火车被新式火车所取代，显得过时多余了。','','red=re反复 + und波动 + ant形容词后缀 → 反复波动 → redundant多余的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (560,'model','model','/ˈmɑːdl/','n. 模型；模特；  v. 模仿','a copy of something, usually smaller than the original object','The girl looks at her model house with a smile.','这个女孩微笑地看着她的房子模型。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (561,'chant','chant','/tʃænt/','v.反复地说；吟诵；  n.圣歌，赞美诗；吟诵声；重复的话语','to sing or shout the same words or phrases many times','The fans are chanting their favorite song with the singer on the stage.','粉丝们跟着台上的歌手一起吟唱他们最爱的歌。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (562,'plantation','plantation','/plænˈteɪʃn/','n. 农场；种植园','a large area of land, especially in a hot country, where crops such as coffee, sugar, rubber, etc. are grown','On our plantation, we grow carrots and potatoes.','在我们的种植园里，我们栽种胡萝卜和土豆。','','plant种植 + ation名词后缀 → plantation种植园',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (563,'purple','purple','/ˈpɜːrpl/','adj. 紫色的；  n. 紫色','having the colour of blue and red mixed together','The flower is purple.','这朵花是紫色的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (564,'prestige','prestige','/preˈstiːʒ/','n.威望，声望','the respect and admiration that somebody/something has because of their social position, or what they have done','He has considerable prestige owed to his educational achievements.','由于在教育方面的成就，他享有很高的威望。','','pre前 + stage讲台，舞台 → 有声望的人能站在舞台前 → prestige声望',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (565,'on_no_account','on no account','/ɔn noʊ əˈkaʊnt/','phr.决不','definitely not','On no account are visitors allowed to feed the animals in the zoo.','在动物园里，游客一律不得给动物喂食。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (566,'zone','zone','/zoʊn/','n.地带，空间，地区，区域，范围','one of the sections in a city or town that is used for a particular purpose','Our school is in this zone.','我们学校在这个区域。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (567,'dissipated','dissipated','/ˈdɪsɪpeɪtɪd/','adj. 沉迷于酒色的','enjoying activities that are harmful such as drinking too much alcohol','The emperor ignored state affairs but indulged in his luxurious and dissipated life everyday.','这位皇帝不理朝政，日日沉迷酒色，过着奢靡的生活。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (568,'dock','dock','/dɑːk/','n.码头；船坞；被告席；  v.进港；扣工资；剪短（动物的尾巴）','a part of a port where ships are repaired, or where goods are put onto or taken off them','The boat is berthed at the dock.','这艘船停靠在码头边。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (569,'violence','violence','/ˈvaɪələns/','n. 暴力','violent behaviour that is intended to hurt or kill somebody','The two boys used violence to end the quarrel.','这两个男孩动用武力结束了争吵。','used violence to','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (570,'emphasis_on','emphasis on','/ˈɛmfəsɪs ɑn/','n. 着重于，强调；重读，重音','','This housekeeping manager puts special emphasis on neatness.','这位家政经理特别强调整洁。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (571,'rule','rule','/ruːl/','v. 统治，控制；  n. 规则，规定，规章，条例','to control and have authority over a country, a group of people, etc.','Once upon a time, there was a king ruling the country.','很久以前，有一位国王统治着这个国家。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (572,'outrage','outrage','/ˈaʊtreɪdʒ/','n.愤怒；残暴，暴行；  v.使震怒，使愤慨','a strong feeling of shock and anger; an act or event that is violent, cruel or very wrong and that shocks people or makes them very angry','Three thousand yuan for a lobster? What an outrage!','三千块一只虾？真是令人愤慨！','','out外，出 + rage怒气 → 怒气外露 → outrage粗暴',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (573,'unbearable','unbearable','/ʌnˈberəbl/','adj. 不堪忍受的','too painful, annoying or unpleasant to deal with or accept','The smell of the garbage is unbearable. Take it out!','垃圾的味道简直受不了，快把它拿出去！','','un不 ＋ bear忍受 ＋ able能...的 → unbearable难以忍受的；承受不住的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (574,'counterpart','counterpart','/ˈkaʊntərpɑːrt/','n. 对手；对应的人（物）；副本','a person or thing that has the same position or function as somebody/something else in a different place or situation','The Democrat senator is shaking hands with his Republican counterpart.','这位民主党参议员和共和党同级握了握手。','','counter相对应 + part部分，分开 → 对应的一部分 → counterpart相对物；副本',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (575,'taxi','taxi','/ˈtæksi/','n. 出租汽车；  v. (飞机) 缓慢滑行','a car with a driver that you pay to take you somewhere. Taxis usually have meters which show how much money you have to pay.','The man is waiting for a taxi.','这位男士正等着出租车。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (576,'shape','shape','/ʃeɪp/','n.外形，形状，轮廓；  vt.使形成，塑造','the form or outline of an object','Put your hands together to make a heart shape.','把你的手放在一起比个心形。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (577,'married_to','married to','/ˈmærid tuː/','phr. 和 ... 结婚，致力于…的','','He\'s a teacher who is married to his job.','他是一位教师，一心扑在自己的工作上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (578,'knowhow','knowhow','/\'nəʊhaʊ/','n.专门技术','','He doesn\'t have the knowhow required to fix a car, but luckily his friend does.','他没有修车所需的专业技术，但幸运的是，他的朋友知道怎么做。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (579,'beard','beard','/bɪrd/','n. （下巴上的）胡须','hair that grows on the chin and cheeks of a man’s face; similar hair that grows on some animals','He likes to touch his beard when he thinks.','他思考的时候喜欢摸自己的胡子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (580,'hand_over','hand over','/ hand ˈəʊvə /','phr. 把…交给','act of relinquishing property or authority etc','She hands the key over to me.','她把钥匙递给我。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (581,'revival','revival','/rɪˈvaɪvl/','n.复苏，复兴','an improvement in the condition or strength of something','The tourist hotspot enjoyed a dramatic revival once the epidemic had faded away.','传染病消失后，这个旅游胜地又恢复了兴旺景象。','','re一再，重新 + viv生命 + al名词后缀，…的 → 复活',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (582,'layoff','layoff','/\'leɪˌɔːf/','n. 裁员；临时解雇；活动停止期间','the act of ending the employment of a worker or group of workers','The boss is warning there will be layoffs if their performance doesn\'t improve.','老板警告说，如果他们的业绩不提高，就会裁员。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (583,'trouble','trouble','/ˈtrʌbl/','n.烦恼；  vt.（使）烦恼，麻烦','something that is wrong with a machine, vehicle, etc.','My car has broken down; I\'m in big trouble now!','我的车坏了，我现在麻烦大啦！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (584,'distinguished','distinguished','/dɪˈstɪŋɡwɪʃt/','adj. 著名的，卓著的；高贵的','very successful and admired by other people','Einstein is a distinguished physicist and scientist.','爱因斯坦是一位杰出的物理学家和科学家。','','distinguish区别 + ed表形容词 → 与众不同 → distinguished著名的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (585,'graduate','graduate','/ˈɡrædʒuət/','v.毕业；渐渐变为；取得学位；授予学位；  n.毕业生；学位获得者；  adj.毕业的；研究生的','to get a degree, especially your first degree, from a university or college','She graduated from university after four years\' unforgettable life.','经过四年难忘的大学生活，她毕业了。','','grad步 + uate使 → 完成所有步骤 → graduate毕业',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (586,'contradict','contradict','/ˌkɑːntrəˈdɪkt/','v. 与……发生矛盾，与……抵触，与……对立','to say that something that somebody else has said is wrong, and that the opposite is true; (of statements or pieces of evidence) to be so different from each other that one of them must be wrong','The signs contradict each other. Which way should we go?','这些标志互相矛盾，我们应该走哪条路呢？','','contra反对，相反 + dict说 → 反着说 → contradict反驳',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (587,'commonsense','commonsense','/ˌkɑːmən ˈsens/','adj. 常识的','inspired by or displaying sound practical sense','This simple math equation is commonsense.','这个简单的数学方程式是常识。','','common普通，共同 + sense感觉 → commonsense具有常识的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (588,'economy','economy','/ɪˈkɑːnəmi/','n.经济','the relationship between production, trade and the supply of money in a particular country or region; a country, when you are thinking about its economic system','The economy is improving and people have more money.','经济正在改善，人们也有了更多的钱。','','eco环境，经济 + nomy学术领域 → economy经济（学）',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (589,'overload','overload','/ˌoʊvərˈloʊd/','v. 使超载，使过载；使负担（或负荷）过重；  n. 过重负担','to put too great a load on something','That bicycle is overloaded, and it\'s so dangerous.','这辆自行车超载了，这太危险了。','','over过度、太甚 + load负载，装载 → 使超载，超过负荷',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (590,'donate','donate','/ˈdoʊneɪt/','v.捐赠','to allow doctors to remove blood or a body organ in order to help somebody who needs it','We donated a sum of money to the charity.','我们向慈善机构捐了一笔钱。','','don给予 + ate使 → 给出去 → donate捐赠',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (591,'excursion','excursion','/ɪkˈskɜːrʒn/','n.远足','a short journey made for pleasure, especially one that has been organized for a group of people','We took an excursion into the forest.','我们去森林里远足了。','took an excursion','ex出+curs跑，发生+ion行为 → 远足；游览',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (592,'grab','grab','/ɡræb/','vt.抓住，抓取；  n.抓取','to take or hold somebody/something with your hand suddenly, firmly or roughly; to try to take hold of something','Babies love to grab your fingers.','婴儿喜欢抓住你的手指。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (593,'contagious','contagious','/kənˈteɪdʒəs/','adj. （病）有传染性的','a contagious disease spreads by people touching each other','The cold he has is contagious.','他患的感冒是有传染性的。','','con共同 + tag接触 + ious……的 → 传染的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (594,'relaxing','relaxing','/rɪˈlæksɪŋ/','adj. 令人放松的','','She finds lying on the sofa quite relaxing.','她觉得躺在沙发上很令人放松。','','relax放松 ＋ ing形容词后缀 → relaxing令人轻松的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (595,'break_away_from','break away from','/brek əˈwe frʌm/','phr. 脱离……','separate oneself from','He has decided to break away from the group.','他决定脱离这个团体。','break away from the group','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (596,'confession','confession','/kənˈfeʃn/','n. 坦白，供认','a statement that a person makes, admitting that they are guilty of a crime; the act of making such a statement','The criminal agreed to write a confession.','罪犯同意写一份供认书。','','confess坦白 + ion名词后缀 → confession坦白',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (597,'annihilate','annihilate','/əˈnaɪəleɪt/','v. 消灭','to destroy (something or someone) completely','Some people believe that aliens will annihilate the Earth.','一些人相信外星人会毁灭地球。','annihilate the Earth','an给予+nihil不存在+ate动词后缀→使东西不存在→消灭',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (598,'certainty','certainty','/ˈsɜːrtnti/','n.必然的事；确信','the state of being certain','It\'s almost a certainty that he\'ll win the race.','这场比赛他会赢，这几乎是必然的事。','','certain确实的 + ty表名词 → 肯定',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (599,'stupid','stupid','/ˈstuːpɪd/','adj.愚蠢的','not intelligent :having or showing a lack of ability to learn and understand things','The stupid donkey couldn’t even work out this easy math problem.','这只蠢驴连这么简单的数学问题都算不出来。','The stupid donkey','stup笨，麻木 ＋ id形容词，“如…的” → stupid笨的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (600,'circumference','circumference','/sərˈkʌmfərəns/','n.圆周长度，圆周；周围','the length of a line that goes around something or that makes a circle or other round shape; the external boundary or surface of a figure or object','The circumference of the island is 3.5km.','这个岛的周长是3.5千米。','','circum环绕，周围 + fer带来 + ence名词后缀 → 带来一圈 → circumference周长',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (601,'secretion','secretion','/sɪˈkriːʃn/','n. 分泌，分泌物，隐藏','the production of a liquid by part of a plant or animal','The snail produces a green secretion as it moves.','蜗牛移动时会流出绿色分泌物。','produces a green secretion','secret藏匿，分泌 + ion名词后缀 → secretion 藏匿，分泌',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (602,'simple','simple','/ˈsɪmpl/','adj.简单的；无经验的','not complicated; easy to understand or do','You can solve this problem—it\'s simple!','你可以解决这个问题的，它很简单！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (603,'beat_about_around_the_bush','beat about/around the bush','/biːt əˈbaʊt əˈraʊnd ðə bʊʃ/','v. 转弯抹角','to talk about something for a long time without coming to the main point','Should I beat around the bush, or should I just tell her there\'s food on her face?','我是该旁敲侧击呢，还是直接跟她说她脸上有一粒米饭？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (604,'besides','besides','/bɪˈsaɪdz/','prep.除……之外（还）；  adv.此外','in addition to somebody/something; apart from somebody/something','As the winner, I received lots of money besides the cup.','作为胜利者，我除了得到奖杯外，还获得了一大笔钱。','','be构成介词 + side边 + s表副词 → besides此外，而且',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (605,'translate','translate','/trænsˈleɪt/','v. 翻译；转化','to express the meaning of speech or writing in a different language; to be changed from one language to another','The girl used a phone app to translate this phrase into English.','女孩用手机应用把这个短语翻译成了英文。','','trans交换 + late拿出，带出 → 交换拿出 → translate翻译；转化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (606,'Medicare','Medicare','/ˈmedɪker/','n. 老年保健医疗制','health care for the aged; a federally administered system of health insurance available to persons aged 65 and over','Medicare is a national health insurance plan mainly for the elderly in the United States.','老年保健医疗制指的是一项主要针对美国老年人的国家健康保险计划。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (607,'mistaken','mistaken','/mɪˈsteɪkən/','adj. 弄错的；被误解的','','He was very mistaken about where the target was.','他对靶子在哪里的判断是错的。','','mis表示“错误，坏” ＋ taken表示“接受；取得” → mistaken错误的；弄错的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (608,'preparation','preparation','/ˌprepəˈreɪʃn/','n. 准备工作','the act or process of getting ready for something or making something ready','When cooking, cutting the vegetables is important preparation.','做饭的时候，切菜是重要的准备工作。','','prepar = prepare准备 ＋ ation名词后缀 → preparation准备',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (609,'season','season','/ˈsiːzn/','n.季（节）；  vt.给……调味','one of the four periods (spring, summer, autumn, and winter) into which the year is commonly divided','There are four seasons in a year.','一年有四个季节。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (610,'agree_on','agree on','/əˈɡriː ɑːn/','phr. 对…意见一致','share opinion on','We all agree on the solid fact that peace is the only way to prosperity.','我们都一致认为：和平是通往繁荣的唯一道路，这是一个不争的事实。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (611,'memorial','memorial','/məˈmɔːriəl/','n.纪念像，纪念物，纪念碑，纪念仪式；  adj.记忆的','a statue, stone, etc. that is built in order to remind people of an important past event or of a famous person who has died; a thing that will continue to remind people of somebody/something','The memorial of Confucius is built to remind us of his achievements.','修建孔子纪念像是为了让我们记住他的成就。','','memor记忆 + ial形容词后缀，…的 → memorial记忆的；纪念物，纪念日',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (612,'beset','beset','/bɪˈset/','v. 困扰；镶嵌','to cause problems or difficulties for (someone or something)','Various skin problems have beset her.','多种肌肤问题困扰着她。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (613,'voucher','voucher','/ˈvaʊtʃər/','n.代金券；教育补助金券；  vt.证实……的可靠性','a printed piece of paper that can be used instead of money to pay for something, or that allows you to pay less than the usual price of something','I won a voucher worth $5000, but only for purchasing the private jet.','我得了一张5000美元的代金券，但是只能用来买私人飞机。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (614,'metaphorical','metaphorical','/ˌmetəˈfɔːrɪkl/','adj. 隐喻的','a metaphorical use of a word is not concerned with real objects or physical events, but with ideas or events of a non-physical kind','The gap between men and women is a metaphorical representation of gender differences.','男女之间存在的鸿沟是性别差异的隐喻。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (615,'shake','shake','/ʃeɪk/','v.摇动；  n.摇；颤抖','to move or have parts of your body move in short, quick movements and in a way that you are not able to control','Shake the bottle well before drinking.','饮用前请摇晃瓶子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (616,'synthetic','synthetic','/sɪnˈθetɪk/','adj. 合成的，人造的；  n. 合成物','artificial; made by combining chemical substances rather than being produced naturally by plants or animals','These fibers are synthetic.','这些衣服是人造纤维布制成的。','','syn共同 + the=thesis放置 + tic形容词后缀 → 放一起 → synthetic合成的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (617,'latest','latest','/ˈleɪtɪst/','adj. 最近的，最新的','the most recent or newest','He is reading the latest news on the newspaper.','他正在阅读报纸上的最新消息。','','lat=late最近 + est表示最高级“最……” → latest最近的，最新的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (618,'hatred','hatred','/ˈheɪtrɪd/','n. 憎恨','a very strong feeling of dislike for somebody/something','He has a lot of hatred to this terrible phone.','他对这个糟糕的手机有极大的怨恨。','','hatr仇恨 + ed名词后缀 → hatred憎恶，憎恨，仇恨',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (619,'boss','boss','/bɔːs/','n.老板，上司；  v.发号施令','a person who has a lot of power in an organization','He\'s so nervous when his boss is watching him work.','老板看着他工作的时候他很紧张。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (620,'intimate','intimate','/ˈɪntɪmət/','adj.亲密的，密切的；详细的；  vt.宣布，通知；  n.密友，知己','(of people) having a close and friendly relationship; private and personal, often in a sexual way','Nothing is sweeter than being with intimate lovers.','没什么比和亲密的恋人在一起更幸福了。','intimate lovers','intim内心的 + ate……的 → 内心的 → 亲近的；不说出口的 → intimate亲密的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (621,'prospectus','prospectus','/prəˈspektəs/','n. 章程，内容简介','a printed statement that describes something (such as a new business or investment) and that is sent to people who may want to be involved in it or invest in it','He\'s reading the prospectuses of different universities so he can choose the best one.','他正在阅读不同大学的简介来选出最好的一所。','','pro向前 ＋ spect看 ＋ us用 → 用来向前看的东西 → prospectus计划书；大纲',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (622,'damp','damp','/dæmp/','adj. 潮湿的，有湿气的','somewhat or slightly wet','London is damp and wet.','伦敦很潮湿。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (623,'pronounce','pronounce','/prəˈnaʊns/','v. 发音；发表，宣布','to make the sound of a word or letter in a particular way','Open your mouth wide when you pronounce this sound.','发这个音时，嘴巴要张大。','pronounce this sound','pro在前 + nounce讲话，说出 → 在嘴前讲话 → pronounce发音',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (624,'curious','curious','/ˈkjʊriəs/','adj.好奇的；好管闲事的','having a strong desire to know about something','The cat is curious about the black mouse.','这只猫对这个黑色鼠标感到好奇。','','curi好奇 + ous形容词后缀 → curious好奇的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (625,'resistor','resistor','/rɪˈzɪstər/','n. 【电】电阻器','a device that has resistance to an electric current in a circuit','The colored rings around each resistor specify its electrical resistance.','电阻器上的彩环代表它的电阻。','','resist阻止 ＋ or名词后缀，表示物 → resistor电阻器',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (626,'feature','feature','/ˈfiːtʃər/','n.特征，特点，特色；面貌，相貌；  v.以……为特色；起重要作用，作为主要角色','(in newspapers, on television, etc.) a special article or programme about somebody/something','A unique feature of this plant is its birdlike flower.','这种植物的独特之处在于它的鸟状花朵。','','feat做，制作 + ure名词后缀 → 做事的状态 → 做事特征 → feature面貌；特征',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (627,'appal','appal','/əˈpɔːl/','v. 使惊骇，使胆寒，吓坏；惊诧，惊讶；胆战心惊；大吃一惊','','The woman was appalled by the state of her son\'s bedroom.','这位女士被她儿子房间的脏乱程度吓到了。','','ap一再 ＋ pal白色 → 脸变白 → appal受惊，使震惊',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (628,'chase_up','chase up','/tʃeɪs ʌp/','phr. 提醒某人快做某事','to contact or find (someone) usually in order to get something','His business partner had to chase him up for his payment.','他的生意伙伴不得不提醒他赶紧还钱。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (629,'novelty','novelty','/ˈnɑːvlti/','n.新奇；新颖小巧而廉价的物品','the quality of being new, different and interesting','That pair of glasses gets my attention for its novelty.','那副新颖的眼镜引起了我的注意。','','novel新奇 + ty表名词 → novelty新奇事情',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (630,'rose','rose','/roʊz/','n.玫瑰，蔷薇','a flower with a sweet smell that is usually white, yellow, red, or pink and that grows on a bush which has thorns on the stems','The rose is deep red.','这种玫瑰是深红色的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (631,'privacy','privacy','/ˈpraɪvəsi/','n. 隐私','the state of being alone and not watched or disturbed by other people','We can protect our personal privacy by enabling pin codes on our phones.','我们可以通过给手机加密来保护我们的个人隐私。','','priv单个 + acy名词后缀 → 个人的 → privacy隐私',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (632,'exit','exit','/ˈeksɪt/','n.出口；退场；  v.离开，出去','a way out of a public building or vehicle','You can find the exit by following the green light.','跟着绿灯走，你就能找到出口。','','ex出自…… + it走 → exit出口',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (633,'philosophical','philosophical','/ˌfɪləˈsɑːfɪkl/','adj.哲学的','connected with philosophy','This old man likes to think about philosophical questions.','这位长者喜欢思考哲学问题。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (634,'intonation','intonation','/ˌɪntəˈneɪʃn/','n. 声调；语调','the quality of playing or singing exactly in tune','The intonation of their singing harmonized beautifully with the music.','他们的声调与音乐融合非常优美和谐。','','in使 + ton音调 + ation名词后缀 → intonation声调，语调',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (635,'restrain_from','restrain from','/rɪˈstreɪn frəm/','phr. 阻止……去……','','His teammates restrained him from shouting at the referee.','他的队友竭力阻止他向裁判大吼大叫。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (636,'recorder','recorder','/rɪˈkɔːrdər/','n. 录音机；记录员','(in compounds) a machine for recording sound','The old man is making a voice memo with a recorder.','老人正在用录音机做语音备忘录。','','record记录，录音 + er表示人或物 → recorder记录者；录音机',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (637,'devoted','devoted','/dɪˈvoʊtɪd/','adj.热衷的，致力于…的','having strong love or loyalty for something or someone','The two men are devoted to performing well in their careers.','他们俩的表演都很投入。','are devoted to performing','de使成…、作成…、或仅作加强意义 ＋ vot=vow，表示”发誓“ ＋ ed形容词后缀 → devoted投入的，深爱的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (638,'gentle','gentle','/ˈdʒentl/','adj.温柔的，文雅的','calm and kind; doing things in a quiet and careful way; (of weather, temperature, etc.) not strong or extreme; having only a small effect; not strong or violent; not steep or sharp','He was very gentle and gave me his coat.','他很绅士，把他的外套给我了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (639,'keen_on','keen on','/kiːn ɑːn/','phr. 热爱','','He is keen on starting his new job, having been unemployed for so long.','他失业了很长时间，所以对新工作充满热情。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (640,'mend','mend','/mend/','v. 修理，缝补','to repair something that has been damaged or broken so that it can be used again; to repair a hole in a piece of clothing, etc.','The man is trying to mend the damaged roof.','这个男人正在修补被损坏的的屋顶。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (641,'weep','weep','/wiːp/','v.哭泣','to cry, usually because you are sad','I could feel his sadness when I saw him weeping.','看到他在哭泣，我能感受到他的悲伤。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (642,'really','really','/ˈriːəli/','adv.事实上，真正地','used to say what is actually the fact or the truth about something','He\'s not really good at shooting arrows.','其实他不太擅长射箭。','','real真实的 + ly表副词 → really真正地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (643,'foreign','foreign','/ˈfɔːrən/','adj.外国的，外来的','in or from a country that is not your own','Our English teacher is from a foreign country.','我们的英语老师来自外国。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (644,'slap','slap','/slæp/','v.掌掴，拍打；  n.掌掴，拍击声','to hit somebody/something with the flat part of your hand; to put something on a surface in a quick, careless and often noisy way, especially because you are angry; to hit against something with the noise of somebody being slapped','He was so angry that he slapped his friend.','他很生气，扇了他朋友一耳光。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (645,'physicist','physicist','/ˈfɪzɪsɪst/','n. 物理学者，物理学家','a scientist who studies physics','Einstein was a great physicist.','爱因斯坦是个伟大的物理学家。','a great physicist','physic物理 + ist做...的人 → physicist物理学家',4,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (646,'curriculum_vitae','curriculum vitae','/kəˌrɪkjələm ˈviːtaɪ/','phr. 简短的履历书','a short document that describes your education, work experience, etc.','Five candidates handed in their curricula vitae.','五位候选人递交了简历。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (647,'place_emphasis_on','place emphasis on','/pleɪsˈemfəsɪs ɑːn/','phr. 强调','to decide something is important','Dentists place much emphasis on the importance of brushing your teeth every day.','牙医非常强调每天刷牙的重要性。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (648,'sterilize','sterilize','/ˈsterəlaɪz/','vt. 消毒，使不孕，使（土地）不毛','to clean (something) by destroying germs or bacteria','Doctors must sterilize their hands before performing an operation.','医生在做手术之前必须要给双手消毒。','sterilize their hands','steril无菌的 + ize动词后缀 → sterilize 杀菌',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (649,'intimidation','intimidation','/ɪnˌtɪmɪˈdeɪʃn/','n.恐吓','the act of intimidating a weaker person to make them do something','The man was scared by his boss\'s intimidation.','这个男人被他老板的恐吓吓住了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (650,'be_equipped_with','be equipped with','/bi ɪˈkwɪpt wɪð/','phr. 装备着','be provided with','Our workers are all equipped with health and safety clothing.','我们的工人都配备了这样的健康和安全保护装备。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (651,'cover_up','cover up','/ˈkʌvər ʌp/','phr.掩盖','','The two brothers tried to cover up the accident from their mother.','这俩兄弟试着从妈妈那里掩盖这件事。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (652,'incumbent','incumbent','/ɪnˈkʌmbənt/','adj. 现任的；负有职责的','a person who holds a particular office or position','The incumbent king is passing the crown to his successor.','现任国王正将王冠传给他的继任者。','','in上 + cumb躺 + ent → incumbent 压在上面的，现任的，现任者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (653,'differentiation','differentiation','/ˌdɪfəˌrenʃiˈeɪʃn/','n.区别','a discrimination between things as different and distinct','The differentiation between different colors is a very important ability for children.','对儿童来说，区分颜色是一种很重要的能力。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (654,'servant','servant','/ˈsɜːrvənt/','n.仆人','a person who is hired to do household or personal duties such as cleaning and cooking','Their family is very rich, they have their own servant to serve them food and drinks.','他们家非常有钱，有自己的仆人为他们提供饮食。','','serv服务，保持 ＋ ant表示人 → servant仆人；公务员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (655,'cut_off','cut off','/kʌt ɔːf/','phr. 切断','to remove something from something larger by cutting','I think \'impossible\' looks better if we cut off the \'im-\'.','我觉得把“impossible”这个单词的“im-”去掉更好。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (656,'width','width','/wɪdθ/','n. 宽度，广度，宽阔','the measurement from one side of something to the other; how wide something is; the distance between the two long sides of a swimming pool','The man\'s width is smaller than his height.','这人的宽度小于他的高度。','','wid=wide宽的 + th抽象名词 → width宽度',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (657,'ring_up','ring up','/rɪŋ ʌp/','phr. 打电话给','to perform and record a sale on a cash register','He rang up his friend on his cellphone.','他用手机给朋友打了个电话。','rang up his friend','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (658,'amass','amass','/əˈmæs/','vi. 聚集；  vt. 积累，积聚','to gather or collect (something, such as a large amount of money) especially for yourself','He has amassed a lot of money over the years.','这些年他攒了不少钱。','amassed a lot of money','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (659,'say','say','/seɪ/','v.说；  n.发言权','to speak or tell somebody something, using words','Why do you have to say it so loudly?','你为什么要说这么大声？','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (660,'scale','scale','/skeɪl/','n. 天平，磅秤；  v. 攀登','the size or extent of something, especially when compared with something else','Stand on the weighing scales to get your weight.','站在体重秤上来测自己的体重吧。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (661,'manuscript','manuscript','/ˈmænjuskrɪpt/','n. 手稿；底稿；手抄本','a copy of a book, piece of music, etc. before it has been printed','This is the manuscript of a famous writer.','这是一位著名作家的手稿。','','manu手 + script写 → 手写 → 手稿',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (662,'balance_between','balance between','/ˈbæləns bɪˈtwiːn/','phr.……之间的平衡','','We should find a balance between work and health.','我们应该找到工作和健康之间的平衡。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (663,'birthplace','birthplace','/ˈbɜːrθpleɪs/','n. 诞生地','the place where someone was born or where something began','My birthplace is a small village.','我的出生地是一个小村庄。','','birth出生 ＋ place放，地方 → birthplace诞生地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (664,'lawn','lawn','/lɔːn/','n. 草坪；草地；（衣服用）细麻','an area of ground covered in short grass in a garden/yard or park, or used for playing a game on','I take care of my lawn to keep it nice and green.','我精心打理我的草坪，让它看起来美观而又葱郁。','take care of my lawn','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (665,'enjoy_oneself','enjoy oneself','/enˈdʒɔːɪ wʌnˈself/','phr. 过得愉快','have a happy time','They are all enjoying themselves at the beach.','他们在海边都过得很愉快。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (666,'adopt','adopt','/əˈdɑːpt/','v. 收养','to take somebody else’s child into your family and become its legal parent(s)','The couple adopted a child from the orphanage.','这对夫妻从孤儿院收养了一个孩子。','','ad做…，加强… + opt选择 → 选出来 → adopt采纳，收养',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (667,'indemnity','indemnity','/ɪnˈdemnəti/','n.补偿，赔偿；赔偿物','a payment made to someone because of damage, loss, or injury','The judge asked the accused man to pay an indemnity to the plaintiff.','法官要求此人对原告进行赔偿。','','in不+demn伤害+ity表名词→使不受损害→赔偿',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (668,'breach','breach','/briːtʃ/','n. 裂痕；  v. 使有裂口','a break in a relationship between people or countries','The situation became very dangerous because of the breach in the dam.','由于大坝出现裂口，形势变得非常危险。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (669,'cub','cub','/kʌb/','n.幼兽；年轻无经验的人','a young animal that eats meat','The lion cubs played with their mother on the grassland.','狮子宝宝们和母狮在草地上玩耍。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (670,'informative','informative','/ɪnˈfɔːrmətɪv/','adj. 给予知识的，提供有用信息的；见闻广博的','providing information','History books can be very informative.','历史书能带给人丰富的知识。','','in进+form形状+ative形容词后缀→有信息的 →见多识广的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (671,'boom','boom','/buːm/','n.轰鸣声；  vi.发出低沉有力、有回响的声音','a loud deep sound','The bombs went off with a loud boom.','炸弹爆炸的时候发出隆隆的一声巨响。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (672,'seclude','seclude','/sɪˈkluːd/','v. 与世隔绝，使隔绝','to keep (someone) away from other people','She secluded herself from the outside world, both alone and lonely.','她过着与世隔绝的生活，孤单又孤独。','secluded herself from','se分离的 + clude关闭 → seclude 使隔离',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (673,'regulation','regulation','/ˌreɡjuˈleɪʃn/','n.规章，法规，条例','an official rule made by a government or some other authority','The traffic police is introducing traffic rules and regulations to us.','交警在向我们介绍交通法规。','traffic rules and regulations','regul规则、统治 + ation表名词 → 有规则的 → regulation规则，规章',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (674,'have_an_eye_for','have an eye for','/hæv æn aɪ fɔːr/','phr. 有眼光，对…有鉴赏力','be able to recognize, appreciate, and make good judgments about','The stylist has an eye for detail, so each outfit is beautifully coordinated.','这个时装博主在穿衣服上很有眼光。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (675,'prohibit','prohibit','/prəˈhɪbɪt/','v.禁止','to stop something from being done or used especially by law','The law prohibits spitting in public.','该法令禁止在公共区域内随地吐痰。','prohibits spitting','pro向前，提前 + hibit拿住，握住 → 在前面拿住 → prohibit阻止，禁止',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (676,'ideal','ideal','/aɪˈdiːəl/','adj. 理想的；  n. 理想','existing only in your imagination or as an idea; not likely to be real','A couch potato\'s ideal weekend is to lay on the sofa, watching TV and eating snacks.','一个电视迷的理想周末是躺在沙发上看电视、吃零食。','','ide思想，观点 + al名词后缀 → 对未来的想法 → ideal理想的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (677,'come_in_sight','come in sight','/kʌm ɪn saɪt/','phr. 看见，出现，表示看见','to become visible','The sunrise came in sight as I neared the top of the mountain.','爬到山顶时，我看到了最美的日出。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (678,'Asia','Asia','/ˈeɪʒə/','n.亚洲','the largest continent','Asia is the largest of all the continents.','亚洲是面积最大的洲。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (679,'smuggling','smuggling','/ˈsmʌɡlɪŋ/','n. 走私；  v. 走私','secretly importing prohibited goods or goods on which duty is due','Cell phone smuggling is against the law.','走私手机是犯法的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (680,'policy','policy','/ˈpɑːləsi/','n. 政策，方针；保险单','a plan of action agreed or chosen by a political party, a business, etc.','Some company policy forbids employees to have relationships with each other.','一些公司政策规定员工之间不准谈恋爱。','','polic国家，城市 + y名词后缀 → 用以管理国家的依据 → policy政策',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (681,'communicate','communicate','/kəˈmjuːnɪkeɪt/','v. 沟通，交流；传达，传递','to exchange information, news, ideas, etc. with somebody','The police communicate with each other by radio.','警察通过无线电进行沟通。','','com共同 + muni交流 + cate表动词 → 共同交流 → 传播',4,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (682,'drum','drum','/drʌm/','n. 鼓；圆桶；  v. 击鼓','a musical instrument that is made with a thin layer of skin or plastic stretched over the end of a round frame and that is played by hitting the skin or plastic with sticks or with your hands','The little guy shows his talent at playing the drum.','小家伙展示了他打鼓的才能。','playing the drum','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (683,'sturdy','sturdy','/ˈstɜːrdi/','adj.结实的，坚固的；强壮的，健壮的','(of an object) strong and not easily damaged','This sturdy box can easily hold the weight of many books.','这个结实的箱子能轻松承受许多书的重量。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (684,'lab','lab','/læb/','n. 实验室，研究室','a laboratory; a room or building equipped for scientific experimentation or research','This lab has lots of equipment for experiments.','这间实验室有许多实验仪器。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (685,'share','share','/ʃer/','v.分享；分配，均分；  n.一份，份额','to have or use something at the same time as somebody else','Would you like to share some ice cream with me?','你想和我一起分享冰激凌吗？','share some ice cream with','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (686,'careful','careful','/ˈkerfl/','adj.仔细的，细心的；小心的','giving attention or thought to what you are doing so that you avoid hurting yourself, damaging something or doing something wrong','Pay careful attention to each piece so you don\'t choose the wrong one.','每一块拼图都要仔细观察，这样你就不会选错。','','care照料 + ful有…的 → careful小心的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (687,'taste','taste','/teɪst/','v.品尝，尝起来；品鉴；  n.味道；鉴赏力','to test the flavour of something by eating or drinking a small amount of it','She always tastes the soup before serving it to others.','她上汤之前总要先尝一尝。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (688,'convert','convert','/kənˈvɜːrt/','v. 可转变为，可变换成；改变，转变，转化；使改变信仰','to be able to be changed from one form, purpose, or system to another','Cool! The sofa can be easily converted into a bed.','真棒！这张沙发轻轻松松就能变成一张床。','','con共同 + vert转变 → 共同转 → 转化；改造',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (689,'satirical','satirical','/səˈtɪrɪkl/','adj. 讽刺性的，讥讽的，爱挖苦人的','exposing human folly to ridicule','This satirical drawing highlights how addicted we all are to our phones nowadays.','这幅讽刺画突显出我们都对手机上瘾的现状。','','satir=satire讽刺 ＋ ical...的 → satirical讽刺性的；讥讽的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (690,'November','November','/noʊˈvembər/','n. 十一月','the 11th month of the year','November is the eleventh month of the year.','十一月是一年的第十一个月。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (691,'shovel','shovel','/ˈʃʌvl/','n. 铁锨，铲；  v. 铲起','a tool with a long handle and a broad blade with curved edges, used for moving earth, snow, sand, etc.','The shovel stands at an inclined angle in a pile of soil.','那个铲子斜立在一堆泥土上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (692,'reserve','reserve','/rɪˈzɜːrv/','n.储备；保护区；  v.预订','to ask for a seat, table, room, etc. to be available for you or somebody else at a future time','He has an emergency reserve of food stored at home.','他在家里有一个存放食物的紧急储备库。','','re再 + serve服务，保持 → 再留住 → reserve预定',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (693,'in_place_of','in place of','/ɪn pleɪs əv/','phr. 代替','','She used milk in place of cream, which she had none of.','她没有奶油，就用牛奶来代替。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (694,'mucous','mucous','/ˈmjuːkəs/','adj. 黏液的，似黏液的','of or secreting or covered with or resembling mucus','The slippery fish is covered with a mucous layer.','这只滑溜溜的鱼身上覆盖着黏液似的外膜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (695,'susceptible','susceptible','/səˈseptəbl/','adj. 易受感染的；易受影响的；多情的','very likely to be influenced, harmed or affected by somebody/something','Young children are susceptible to disease.','小朋友容易感染疾病。','','sus在…下面 + cept拿 + ible能…的 → 能被拿下 → 易受影响，易受感染的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (696,'on_the_way_out','on the way out','/ɑːn ðə weɪ aʊt/','phr. 渐渐过时，正在离开','If something or someone is on the way out or on their way out, they are likely to disappear or to be replaced very soon.','This outdated phone is on the way out.','这种样式的手机慢慢过时了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (697,'bad-tempered','bad-tempered','/ˌbæd ˈtempərd/','adj. 脾气不好的，易怒的','often angry','The bad-tempered man shouted at a stranger who rubbed his sleeve by accident.','这个坏脾气男子对一个不小心擦到他袖子的陌生人大喊大叫。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (698,'playground','playground','/ˈpleɪɡraʊnd/','n. 操场，游乐区','an outdoor area where children can play, especially at a school or in a park','The students are having fun on the playground after class.','下课后，学生们在操场上玩耍。','','play比赛 + ground场地 → playground操场，运动场',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (699,'speak_well_of','speak well of','/spik wɛl ʌv/','v. 称赞','to compliment, to say good things about someone','That boss speaks well of the employee of the month.','那位老板称赞了这个月的最佳员工。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (700,'on_the_road','on the road','/ɑn ði rəʊd/','phr. 在旅途中',' travelling about','He just wanted a new car so he could get back on the road.','他只想要一辆新车以便重新上路。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (701,'rash','rash','/ræʃ/','n.疹，皮疹；（短时期内）爆发的一连串；  adj.轻率的，鲁莽的','','Whenever I eat seafood, I get red rashes on my face.','每次吃海鲜，我的脸上就会冒红疹子。','get red rashes','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (702,'regarding','regarding','/rɪˈɡɑːrdɪŋ/','prep. 关于','concerning somebody/something; about somebody/something','His speech would address important issues regarding environmental pollution.','他的演讲将涉及关于环境污染的重要问题。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (703,'clear_up','clear up','/klɪr ʌp/','v. 放晴，清除，整理','(of the weather) to become fine or bright; (of an illness, infection, etc.) to disappear; to make something clean and neat; to solve or explain something;','The sky clears up after the rain has fallen.','雨后的天空放晴了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (704,'take_over_one\'s_business','take over one\'s business','/teɪk ˈoʊvər wʌnz ˈbɪznəs/','phr. 接管某人的生意','to assume control or possession for one\'s business','He will take over the family\'s business after his grandfather retires.','他会在爷爷退休的时候接管家里的生意。','take over the family\'s business','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (705,'ambassador','ambassador','/æmˈbæsədər/','n. （特命全权）大使','an official who lives in a foreign country as the senior representative there of his or her own country','Each cellphone company sent an ambassador to the conference.','每个手机厂商都派了代表来参加这个会议。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (706,'look_ahead','look ahead','/lʊk əˈhed/','phr. 向前看，展望未来','If you look ahead, you think about what is going to happen in the future and perhaps make plans for the future.','Look ahead into your future instead of dwelling on your past.','着眼你的未来，而不是停留在过去。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (707,'ravage','ravage','/ˈrævɪdʒ/','v. 摧残，破坏；  n. 毁坏，荒废，破坏的残迹','to damage or harm (something) very badly','The ravages of the earthquake were devastating.','地震带来的破坏是毁灭性的。','','rav捕，夺 + age状态 → 掠夺过的状态 → ravage破坏',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (708,'takeaway','takeaway','/ˈteɪkəweɪ/','n.外带食物；外卖餐馆','takeout','I had no time to go out for lunch, so I ordered a takeaway.','我没有时间出去吃午饭，所以我点了一份外卖。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (709,'plunge','plunge','/plʌndʒ/','v.跳进，（使）投入；使陷入；暴跌；  n.卷入，参与；暴跌，骤减','to move or make somebody/something move suddenly forwards and/or downwards; to move up and down suddenly and violently','The sportswoman plunged into the water. Splash!','女运动员跳入水中，水花四溅。','plunged into the water','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (710,'empty','empty','/ˈempti/','adj.空的；  vt.倒空','with no people or things inside; (of something that somebody says or does) with no meaning; not meaning what is said','The meeting room had many seats, but they were all empty.','会议室有很多座位，但是都是空的。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (711,'beneficial_to','beneficial to','/ˌbenɪˈfɪʃl tuː/','phr. 对…有益，对…有利','','A healthy balanced diet is beneficial to health. ','平衡的膳食对身体健康有益。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (712,'embassy','embassy','/ˈembəsi/','n.大使馆；大使馆全体人员','the building in which an embassy works','The US embassy in the UK is located in London.','美国驻英大使馆位于伦敦。','US embassy','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (713,'deprivation','deprivation','/ˌdeprɪˈveɪʃn/','n. 剥夺；免职；损失','the fact of not having something that you need, like enough food, money or a home; the process that causes this','The criminal suffered the deprivation of political rights.','这个罪犯被剥夺了政治权利。','','de去掉 + priv单个 + ation名词后缀 → 从个人身边拿走 → 剥夺；丧失',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (714,'wag','wag','/wæɡ/','v. 摇动；  n. 爱说笑的人','if a dog wags its tail, or its tail wags, its tail moves from side to side several times; to shake your finger or your head from side to side or up and down, often as a sign of disapproval; to stay away from school without permission','My dog will wag his tail happily when he sees me.','我的狗会在看到我时开心地摇尾巴。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (715,'clockwise','clockwise','/ˈklɑːkwaɪz/','adj. 顺时针方向的；  adv. 顺时针方向地','moving around in the same direction as the hands of a clock','The man is walking around the garden in a clockwise direction.','那个男人以顺时针方向在花园里散步。','','clock时钟 + wise方向，状态 → clockwise顺时针的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (716,'tour_guide','tour guide','/tʊr ɡaɪd/','phr. 导游','someone whose job it is to show tourists around a place and explain its history, architecture etc','Our tour guide told us a story about the Great Wall.','导游给我们讲了一个关于长城的故事。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (717,'prerequisite','prerequisite','/ˌpriːˈrekwəzɪt/','n.先决条件，必要条件；  adj.必须先具备的，必要的','something that must exist or happen before something else can happen or be done','A prerequisite for being an air force pilot is having perfect eyesight.','拥有绝佳的视力是成为空军飞行员的先决条件。','','pre预先 + requisite必需品 → prerequisite先决条件',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (718,'accomplished','accomplished','/əˈkɑːmplɪʃt/','adj. 完成了的，达到了的，有技能的，有学问的，有造诣的，多社交才艺的，涵养好的','very successful :having done or achieved many good or important things','The accomplished student won several awards for his achievements.','这个有学问的学生因其成就而获得了多个奖项。','The accomplished student','accomplish完成 + ed形容词后缀 → accomplished 完成的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (719,'accusation','accusation','/ˌækjuˈzeɪʃn/','n. 谴责；【律】指控','a statement saying that you think a person is guilty of doing something wrong, especially of committing a crime; the fact of accusing somebody','The accusations from different people make him lower his head in guilt.','来自不同人的谴责让他羞愧地低下了头。','','accus(e) 指责 + ation名词后缀 → accusation指责',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (720,'flicker','flicker','/ˈflɪkər/','v. 闪烁，摇曳；  n. 闪烁，闪光','to burn or glow in an unsteady way :to produce an unsteady light','Candles are flickering at night.','烛光在夜色中摇曳着。','Candles are flickering','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (721,'gamer','gamer','/ˈɡeɪmər/','n. 电脑游戏玩家','','These gamers are playing games together online.','这些玩家正在网上一起玩游戏。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (722,'movie','movie','/ˈmuːvi/','n.电影；电影业','a showing of a movie in a theater','We are going to see an open-air movie.','我们准备看一场露天电影。','','mov移动 + ie表名词，小东西或人 → movie电影',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (723,'gain','gain','/ɡeɪn/','v.获得；  n.（财富、重量的）增加；利益','to obtain or win something, especially something that you need or want; to gradually get more of something; to obtain an advantage or benefit from something or from doing something; to increase in value','We can gain valuable knowledge by reading books.','我们能通过阅读获得宝贵的知识。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (724,'luck','luck','/lʌk/','n.好运，幸运','good fortune; good luck','He is in luck! He just won the prize.','他运气真好！他中奖了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (725,'haze','haze','/heɪz/','n.薄雾，雾气；烟雾；  vt.（使）变糊涂','air that is difficult to see through because it contains very small drops of water, especially caused by hot weather','A few rays of sunshine shone through the forest haze.','几缕阳光穿过林间薄雾。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (726,'expanse','expanse','/ɪkˈspæns/','n. 广阔的区域','a wide and open area of something, especially land or water','The great expanse of desert makes me calm.','广阔的沙漠让我感到平静。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (727,'without_question','without question','/wɪðˈaʊt ˈkwestʃən/','phr. 毫无疑问','','Water always flows downhill, without question.','毫无疑问，水总是往低处流。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (728,'new','new','/nuː/','adj.新的；新发现的','recently bought; different from the previous one','The man loves his new motorbike!','这个男人超爱他的新摩托车！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (729,'look_round','look round','/lʊk/ /raʊnd/','phr. 四处看，寻找','look about oneself','The meerkats look round to be aware of predators.','猫鼬四处张望来警惕他们的天敌。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (730,'philosophy','philosophy','/fəˈlɑːsəfi/','n.哲学，哲学体系','the study of the nature and meaning of the universe and of human life; a particular set or system of beliefs resulting from the search for knowledge about life and the universe','I often think about the meaning of life and other questions of philosophy.','我常常思考生命的意义以及其他哲学问题。','','philo爱 + sophy智慧 → 爱与智慧 → philosophy哲学',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (731,'sheet','sheet','/ʃiːt/','n.纸张；被单','a piece of paper for writing or printing on, etc. usually in a standard size','Please write your name on this sheet of paper.','请在这张纸上写下你的名字。','sheet of paper','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (732,'occupy','occupy','/ˈɑːkjupaɪ/','vt.占领，侵占；任职，执政','to fill or use a space, an area or an amount of time','These desks were occupied in different kinds of ways.','这些桌子被以各种方式占据。','','oc再次 + cupy抓 → 抓住地盘 → occupy占领',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (733,'quart','quart','/kwɔːrt/','n. 夸脱','a unit for measuring liquids, equal to 2 pints or about 1.14 litres in the UK and Canada, and 0.95 of a litre in the US','There was about a quart of milk left in the bucket.','桶里还剩大约一夸脱牛奶。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (734,'earnest','earnest','/ˈɜːrnɪst/','adj.真诚的，诚挚的，认真的','very serious and sincere','"Thank you very much!" said the granny with an earnest expression on her face.','“非常感谢你！”这位老奶奶真诚地说道。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (735,'outwards','outwards','/ˈaʊtwərdz/','adv. 向外地','toward the outside','The water flows outwards from the pipe.','水从管道中向外流。','flows outwards from','out外 + wards表方向 → 向外地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (736,'naked','naked','/ˈneɪkɪd/','adj. 裸体的，无遮蔽的','not wearing any clothes; without the usual covering','The naked baby is crawling and smiling on the floor.','那个光着身子的婴儿正在地上边爬边笑。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (737,'vice','vice','/vaɪs/','n. 恶习；罪行','evil or immoral behaviour; an evil or immoral quality in somebody’s character','Sleeping late is a vice.','睡懒觉是一种恶习。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (738,'get','get','/ɡet/','v.得到，获得，赢得；  link-v.成为，变成，变得','to reach a particular state or condition; to make somebody/something/yourself reach a particular state or condition','They all get what they want.','他们都得到了他们想要的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (739,'skeptical','skeptical','/ˈskeptɪkl/','adj.表示怀疑的','having doubts that a claim or statement is true or that something will happen','I\'m skeptical that the weasel did not come here merely to extend his greetings.','我怀疑那只黄鼠狼不仅仅是来这里表达问候的。','','skept怀疑 + ical表形容词 → skeptical怀疑的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (740,'upwards','upwards','/ˈʌpwərdz/','adv. 向上；在上部','in a direction from lower to higher','The roller coaster was going upwards along the track very fast.','过山车正沿着轨道向上飞驰。','','up向上 + wards表副词，向... → 向下，朝上',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (741,'toward','toward','/tɔːrd/','prep. 向；朝；对于','in the direction of somebody/something','The little girl is walking toward her father.','这个小女孩正向爸爸走去。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (742,'take_the_place_of','take the place of','/teɪk ðə pleɪs əv/','phr. 取代，代替','to replace (someone or something)','Gradually, robots have taken the place of manual workers.','机器人逐渐取代了手工工人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (743,'humidity','humidity','/hjuːˈmɪdəti/','n.湿气；潮湿；湿度','the amount of water in the air','The humidity in the bathroom is high after taking a bath.','洗完澡后，浴室里的湿度很高。','','humid=wet潮湿 + ity表名词 → humidity潮湿',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (744,'inertia','inertia','/ɪˈnɜːrʃə/','n.惯性；惰性','','The inertia caused by the driver hitting the brakes made them all lean forward.','司机刹车造成的惯性让大家都往前扑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (745,'root_for','root for','/rut fɔr/','phr. 全力支持，为…加油喝彩，赞助','take sides with; give support to','It\'s great to see so many people rooting for our basketball team!','有这么多人支持我们篮球队，真是太好了！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (746,'stiffen','stiffen','/ˈstɪfn/','v.（使）变硬，（使）难以弯曲','to become more severe or strong or to make (something) more severe or strong','The man stiffened his hair by applying some gel to it.','这个男人涂了些发胶，让头发更坚硬。','stiffened his hair','stiff僵硬的+en动词后缀 →  变硬',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (747,'recline','recline','/rɪˈklaɪn/','vi. 躺，斜倚（常与on，upon或against连用）；  vt. 使后靠，使斜倚','to lean backward','The passenger reclined in her seat.','这位乘客正靠在她的座位上。','reclined in','re 回、向后 + clin 倾斜 + e → v.放置',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (748,'spot','spot','/spɑːt/','n.斑点；污点；  vt.发现，认出','a small area of a surface that is different from other areas','This type of dog has many black spots.','这种狗的身上有很多黑色的斑点。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (749,'particular','particular','/pərˈtɪkjələr/','adj.特别的，不寻常的；格外的；  n.细节','used to emphasize that you are referring to one individual person, thing or type of thing and not others','You should pay particular attention to spelling.','你需要特别注意你的拼写。','','partic少量 + ular形容词后缀 → particular特别的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (750,'acknowledgement','acknowledgement','/əkˈnɑːlɪdʒmənt/','n.承认，确认；感谢','the state or quality of being recognized or acknowledged; a statement acknowledging something or someone','The little boy gave his tutor a nod of acknowledgement.','小男孩向家教老师点头表示听明白了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (751,'adolescent','adolescent','/ˌædəˈlesnt/','n.青少年；  adj.青春期的','a young person who is developing from a child into an adult','Acne is common among adolescents.','青少年长粉刺很普遍。','','adolesc进入青春期 + ent表示具有……性质的，关于……的 → 青春期的,青少年的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (752,'clergy','clergy','/ˈklɜːrdʒi/','n.牧师，神职人员','the priests or ministers of a religion, especially of the Christian Church','The clergy is crossing his fingers to pray.','牧师手指交叉祈祷。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (753,'complex','complex','/ˈkɑːmpleks/','adj. 复杂的，难解的；  n. 建筑群；情结','made of many different things or parts that are connected; difficult to understand','He has no clue about how to solve this complex case.','他对如何解决这个复杂的案件毫无头绪。','','com共同 + plex重叠 → 全部重叠 → complex复杂的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (754,'alternative','alternative','/ɔːlˈtɜːrnətɪv/','n.可供选择的事物；  adj.可供选择的','a thing that you can choose to do or have out of two or more possibilities','He has the alternative of either riding or driving.','他可以在骑车或开车中选择一种。','','altern另外的 + ative形容词/名词后缀 → alternative替换的，替换物',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (755,'block','block','/blɑːk/','v.阻挡，妨碍，阻塞；  n.块状物；街区；阻碍；大厦','to stop somebody from going somewhere or seeing something by standing in front of them or in their way','The fallen tree blocks the way.','这棵倒地的树阻挡了去路。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (756,'conceive','conceive','/kənˈsiːv/','v. 怀孕；设想，想出','when a woman conceives or conceives a child, she becomes pregnant','The pregnancy test proved that she had conceived a baby.','验孕测试显示她怀了一个宝宝。','','con共同 + ceive拿，抓，握住 → conceive想象；构想',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (757,'oar','oar','/ɔːr/','n. 桨，橹','a long pole with a flat blade at one end that is used for rowing a boat','They pulled on the oars to make the boat go faster.','他们（用力）划桨，加速前进。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (758,'endorse','endorse','/ɪnˈdɔːrs/','v. 代言','to say in an advertisement that you use and like a particular product so that other people will want to buy it','The celebrity is endorsing the brand\'s lipstick.','这位名人正在为这个品牌的口红代言。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (759,'clock','clock','/klɑːk/','n.钟；仪表','a device that shows what time it is and that is usually placed in a room or attached to a wall','The clock showed it was just past ten o\'clock.','这个钟显示刚过十点。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (760,'saline','saline','/ˈseɪliːn/','adj. 咸的，含盐的','containing salt','Salt often washes up on the shore of saline lakes.','盐湖里的盐经常会被冲到岸边。','','sal盐 + ine形容词后缀 → 含盐的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (761,'backward','backward','/ˈbækwərd/','adv.向后地；  adj.落后的；向后的，倒行的','towards a place or position that is behind','The little boy went backward on the beach.','那个小男孩在沙滩上倒着走。','went backward','back后边 + ward向 → backward 向后的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (762,'cafe','cafe','/kæˈfeɪ/','n.咖啡馆，餐馆','a place where you can buy drinks and simple meals. Alcohol is not usually served in British or American cafes.; a small shop/store that sells sweets, newspapers, food, etc. and usually stays open later than other shops/stores','I went for coffee with my friend in a cafe.','我和我朋友在咖啡馆喝了咖啡。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (763,'vaccinate','vaccinate','/ˈvæksɪneɪt/','v. 进行预防接种；  n. 被接种牛痘者','to give a person or an animal a vaccine, especially by injecting it, in order to protect them against a disease','The doctor is vaccinating the little baby.','医生正在给小宝宝接种疫苗。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (764,'period','period','/ˈpɪriəd/','n.时期','a length of time during which a series of events or an action takes place or is completed','He became a math teacher over a period of four years.','他花了四年的时间成了一名数学老师。','period of four years','peri周围，靠近 ＋ od道路 → period周期',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (765,'delete','delete','/dɪˈliːt/','v.删除','to remove something that has been written or printed, or that has been stored on a computer','Are you sure you want to delete this message?','你确定要删除这条信息么？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (766,'expensive','expensive','/ɪkˈspensɪv/','adj.昂贵的','costing a lot of money','These are so expensive! You shouldn\'t have bought them for me! (Actually, yes, you should have.)','这太贵重了！你不该买给我的。（好吧，其实我想要。）','','ex出 + pens花费 + ive形容词后缀 → 要花钱的 → expensive昂贵的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (767,'touch','touch','/tʌtʃ/','v.触摸；  n.触觉','to put your hand, fingers, etc., on someone or something','He wanted to touch her belly to feel the baby moving.','他想摸摸她的肚子来感受宝宝的移动。','touch her belly','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (768,'overt','overt','/oʊˈvɜːrt/','adj. 明显的；公开的；公然的','done in an open way and not secretly','It is overt that the dog wanted to eat that spaghetti.','很明显，这只狗想吃那盘意大利面。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (769,'something','something','/ˈsʌmθɪŋ/','pron.某事物；有价值或重要的人或事物；  adv.有点，稍微','a thing that is not known or mentioned by name','Here, there is something in the box for you.','给，盒子里有给你的一些东西。','','some有些 + thing事 → 一些事情 → something某事，某物',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (770,'disciplinary','disciplinary','/ˈdɪsəpləneri/','adj. 纪律的，纪律严明的','connected with the punishment of people who break rules','The teacher is taking disciplinary actions against the naughty boy.','老师给了这个淘气的男孩违纪处分。','','dis不 + cip拿 + lin直线 + ary...的 → disciplinary纪律的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (771,'boot','boot','/buːt/','n.靴子；  v.启动','a covering usually of leather or rubber for the entire foot and the lower part of the leg','The person wore a pair of brown boots to hike.','这个人穿了一双棕色靴子去爬山。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (772,'nonconformist','nonconformist','/ˌnɑːnkənˈfɔːrmɪst/','n. 不符合惯例的人；  adj. 不遵照准则的，不墨守成规的','a person who does not behave the way most people behave :someone who does not conform','She dresses like a nonconformist but she\'s actually very conventional.','她打扮得很出格，但是她实际上是很传统的。','dresses like a nonconformist','non不 + conformist遵奉者 → nonconformist 不遵循传统的人',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (773,'publisher','publisher','/ˈpʌblɪʃər/','n. 出版商；发行人','a person or company that produces books, magazines, etc.','The book was available in shops after months of efforts by the publisher.','经过出版商几个月的努力，这本书得以在书店里出售。','','publish出版 + er做某事的人 → publisher出版者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (774,'roam','roam','/roʊm/','v. 闲逛，漫步，徘徊；眼睛或手（缓慢地）扫遍','to walk or travel around an area without any definite aim or direction','I don\'t know where we\'re going; I\'d just like to roam the city for a while.','我不知道我们要去哪里，我就是想在城里闲逛。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (775,'noon','noon','/nuːn/','n. 正午，中午','the middle of the day :12 o\'clock in the daytime','It\'s noon, and the sun is at its highest point.','现在是中午，太阳正处于最高点。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (776,'difference_between','difference between','/ˈdɪfrəns bɪˈtwiːn/','phr.……之间的差别','','The difference between these two apples is color.','这两个苹果之间的差别在于颜色。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (777,'ministry','ministry','/ˈmɪnɪstri/','n.（政府的）部，内阁','a government department or the building in which it is located','Governments have many different ministries, such as the Ministry of Health.','政府设有许多不同的部门，比如卫生部。','','ministr=minister部长 + y表名词 → minister部长 + y表名词 → ministry（政府的）部',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (778,'add...to...','add...to...','/æd tu/','phr. 往……加入……','','Add some sugar to your coffee to make it sweeter.','给你的咖啡加点糖让它更甜。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (779,'orthodox','orthodox','/ˈɔːrθədɑːks/','adj. 正统的','(especially of beliefs or behaviour) generally accepted or approved of; following generally accepted beliefs','The Greek orthodox church with blue domes is so beautiful.','希腊正教的蓝顶教堂真是太美了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (780,'brazen','brazen','/ˈbreɪzn/','adj. 厚脸皮的，厚颜无耻的；黄铜(制)的；  v. 厚着脸皮干，使变得无耻','open and without shame, usually about something that people find shocking','He was brazen about taking off his shoes on the subway.','这个厚颜无耻的男人毫无顾忌地在地铁上脱鞋。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (781,'spending','spending','/ˈspendɪŋ/','n. 经费(开销)','the act of spending or disbursing money','Public spending refers to the amount spent by the government on education, healthcare and transport.','公共支出是指政府在教育、医疗和交通等方面的支出。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (782,'be_at_odds_(with_sb.)(over_sth.)','be at odds (with sb.)(over sth.)','/biː æt ɑːdz wɪθ ˈsʌmbədi ˈoʊvər ˈsʌmθɪŋ/','adj. 与…有争执','have a disagreement over something with sb.','I was at odds with my friend over this particular issue.','我和朋友在这个问题上有所争执。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (783,'arrive_at_a_place','arrive at a place','/əˈraɪv æt eɪ pleɪs/','phr. 到达某地','arrive; get to; reach','I arrived at Tiananmen Square for the first time.','我到天安门了，这是我第一次来。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (784,'flight','flight','/flaɪt/','n.航班；空中航行','a journey made by air, especially in a plane','The flight information is shown on the big screen.','航班信息显示在大屏幕上。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (785,'penetrate','penetrate','/ˈpenətreɪt/','v. 刺穿，穿透；进入','to go into or through something; to succeed in entering or joining an organization, a group, etc. especially when this is difficult to do','The apple was penetrated with an arrow.','这个苹果被一支箭射穿了。','penetrated with an arrow','pen 几乎 + etr穿过 + ate 动词后缀 → penetrate刺穿；渗入',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (786,'stern','stern','/stɜːrn/','adj. 严厉的；严峻的；苛刻的；坚决的；  n. 船尾','serious and often disapproving; expecting somebody to obey you; serious and difficult','The businessman wears a stern expression.','这个商人露出很严肃的表情。','a stern expression','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (787,'dropout','dropout','/ˈdrɑːpaʊt/','n.辍学生','someone who quits school before graduation','He left school as a dropout because he had to help his family with farming.','为了帮家里种地，他不得不离开学校，成了一名辍学生。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (788,'posture','posture','/ˈpɑːstʃər/','n. 姿势；  v. 装模作样；  n. 看法；态度','the position in which you hold your body when standing or sitting','My mom always told me to keep a straight posture.','我妈妈总提醒我保持挺直的姿势。','','pos放置，摆放 + ture名词后缀 → 摆出的姿势 → posture姿势，姿态',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (789,'maid','maid','/meɪd/','n.女仆','(often in compounds) a female servant in a house or hotel','The maid is using a hoover to clean the room.','这名女佣正用吸尘器打扫房间。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (790,'extrinsic','extrinsic','/eksˈtrɪnzɪk/','adj. 外在的，外部的','not belonging naturally to somebody/something; coming from or existing outside somebody/something rather than within them','Love is an intrinsic motivation; money, an extrinsic one.','爱是内在的动力，而钱是外在的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (791,'animated','animated','/ˈænɪmeɪtɪd/','adj. 活泼的，充满生气的','full of interest and energy','My grandpa is very animated although he is aged.','虽然我爷爷已经上了年纪，但他仍充满活力。','','animat=animate活的 + ed 形容词后缀 → animated活生生的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (792,'revelation','revelation','/ˌrevəˈleɪʃn/','n.揭露；（出乎意料的）被揭示的真相','the act of making people aware of something that has been secret','The revelation that he stole from his company was exposed.','他盗窃公司财物的事情被揭露了。','','re相反 + vel=veil盖上 + ation表名词 → revelation揭示，揭露',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (793,'stir-fry','stir-fry','/ˈstɜːr fraɪ/','v.用旺火炒（或煎、煸）','','The chef is stir-frying the noodles.','这位厨师正在炒面条。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (794,'sentiment','sentiment','/ˈsentɪmənt/','n. 感情；情绪','a feeling or an opinion, especially one based on emotions','The couple shares a lot of deep sentiment.','这对夫妇有着深厚的感情。','','senti感觉 + ment名词后缀 → 感情',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (795,'clamp','clamp','/klæmp/','n. 夹具','fasten or fix with a clamp','A clamp is used to hold two or more things together.','夹子可以用来把两个或者更多东西夹在一起。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (796,'insure','insure','/ɪnˈʃʊr/','v.为……投保','to buy insurance so that you will receive money if your property, car, etc. gets damaged or stolen, or if you get ill/sick or die','He insures the cars against traffic accidents.','他为车投了交通事故险。','','in进入 + sure肯定 → 进入肯定 → 保险',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (797,'helicopter','helicopter','/ˈhelɪkɑːptər/','n. 直升机','an aircraft without wings that has large blades on top that go round. It can fly straight up from the ground and can also stay in one position in the air','The helicopter is flying over the sea.','这架直升机正在海面上方飞行。','','helic螺旋 + opt适应，能力 + er表名词 → 能够螺旋上升的事物 → helicopter直升飞机',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (798,'responsible_for','responsible for','/rɪˈspɑːnsəbl fɔːr/','phr.对……负责',' being the agent or cause','I am responsible for the safety of this plane.','我对这架飞机的安全负责。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (799,'let_oneself_go','let oneself go','/let wʌnˈself ɡoʊ/','v. 尽情，情不自禁','become less tense, rest, or take one\'s ease','She loves to dance, so she lets herself go at parties.','她喜欢跳舞，所以她在聚会中尽情释放自己。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (800,'the_United_Nations(UN)','the United Nations(UN)','/ði juˈnaɪtɪd ˈneɪʃnz/','n. 联合国【（U.N./UN（缩）】','an organization of independent states formed in 1945 to promote international peace and security','The United Nations play a positive role in guarding world peace.','联合国在守护世界和平方面发挥着积极作用。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (801,'logical','logical','/ˈlɑːdʒɪkl/','adj. 有逻辑的；推理正确的','following or able to follow the rules of logic in which ideas or facts are based on other true ideas or facts','Logical thinking requires a step-by-step thought process.','逻辑思维需要循序渐进的思维过程。','','log说话 + ic表名词 + al形容词后缀 → logical符合逻辑的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (802,'lemonade','lemonade','/ˌleməˈneɪd/','n. 柠檬水','a drink made from lemon juice, sugar and water','I used lemons, sugar and ice to make a glass of lemonade.','我用柠檬、糖和冰块做了一杯柠檬水。','','lemon柠檬 + ade东西，状态 → lemonade柠檬水',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (803,'marriage','marriage','/ˈmærɪdʒ/','n.婚姻；结婚','the ceremony in which two people become husband and wife; the state of being married','After they exchanged rings, the couple entered into marriage.','交换戒指之后，这对新人迈入了婚姻生活。','','marri=marry结婚 + age状态，总称 → marriage结婚',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (804,'postbox','postbox','/ˈpoʊstbɑːks/','n. 邮箱','a public box, for example in the street, that you put letters into when you send them','I take letters out from the postbox every day.','我每天把信从邮箱里取出来。','','post邮件，邮政 + box盒子 → postbox邮箱',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (805,'metal','metal','/ˈmetl/','n.金属，合金，金属制品；  vt.（以金属）覆盖，装配','a substance (such as gold, tin, or copper) that usually has a shiny appearance, is a good conductor of electricity and heat, can be melted, and is usually capable of being shaped','Wow, these roses are made of metal.','哇，这些玫瑰花是金属做的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (806,'near','near','/nɪr/','prep. 靠近；  adv. 近，接近；  adj. 近的','at a short distance away from somebody/something','The little boy sits near the fire.','这个小男孩坐在靠近火堆的位置。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (807,'clause','clause','/klɔːz/','n. 条款；从句','an item in a legal document that says that a particular thing must or must not be done','The tenant will sign the tenancy agreement after checking every clause.','房客核对完每条条款后才会签署租房合同。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (808,'barkeeper','barkeeper','/\'bɑːˌkiːpər/','n. 酒保','an employee who mixes and serves alcoholic drinks at a bar','The barkeeper is responsible for serving drinks behind the bar.','这个酒保负责在吧台后为客人提供饮料。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (809,'unanimous','unanimous','/juˈnænɪməs/','adj. 一致同意的；全体一致的','if a decision or an opinion is unanimous, it is agreed or shared by everyone in a group','There was unanimous agreement that we should do the business deal.','全体一致同意我们应该做这笔生意。','','un单一，一个 + anim生命，精神 + ous……的 → unanimous全体一致的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (810,'AD','AD','/ˌeɪ ˈdiː/','abbr.(Anno Domini)<拉>公元','a public promotion of some product or service','AD indicates any year after the supposed birth year of Jesus Christ.','“公元”表示耶稣基督公认诞生之年以后的年份。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (811,'sublime','sublime','/səˈblaɪm/','adj. 雄伟的，崇高的，极端的，超群的；  n. 顶峰，崇高；  v. 使…纯化，使…升华，变高尚','of very high quality and causing great admiration','The sublime view brought him a magical feeling of awe.','壮丽的景色给他一种奇妙的敬畏感。','sublime view','sub达到 + lime阈值 → sublime 顶点，崇高的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (812,'addiction','addiction','/əˈdɪkʃn/','n.上瘾，沉溺','a strong and harmful need to regularly have something (such as a drug) or do something (such as gamble)','His addiction to alcohol gradually deepened.','他的酒瘾越来越大了。','','addict上瘾 + ion名词后缀 → addiction 沉溺，上瘾',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (813,'fluent','fluent','/ˈfluːənt/','adj.（语言）讲得流利的；（文字）流畅熟练的','able to speak, read or write a language, especially a foreign language, easily and well; (of a language, especially a foreign language) expressed easily and well','The rapper used his fluent English to complete the freestyle.','这个说唱歌手用他流利的英文完成了这段即兴说唱。','','flu流动 + ent…的 → 流动的 → fluent流利的，流畅的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (814,'liaison','liaison','/ˈliːəzɑːn/','n. 联系，暧昧关系','a relationship between two organizations or different departments in an organization, involving the exchange of information or ideas','We will need to maintain close liaison so our companies keep in contact.','我们需要保持紧密联络，以使我们的公司保持联系。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (815,'leave_sb._(sth.)_behind','leave sb. (sth.) behind','/liːv ˈsʌmbədi ˈsʌmθɪŋ bɪˈhaɪnd/','phr. 忘带，留下','leave unchanged or undisturbed or refrain from taking','She left her phone behind when leaving for work.','她出门上班的时候忘了带手机。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (816,'polish','polish','/ˈpɑːlɪʃ/','vt.磨光，擦亮；润饰，使优美；  n.优美；  adj.（Polish）波兰语的','to make something smooth and shiny by rubbing it','The car needs to be polished regularly.','这车需要定期抛光。','','pol光滑 + ish动词词尾 → polish抛光，擦亮',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (817,'Antarctic','Antarctic','/ænˈtɑːrktɪk/','n.南极地区；  adj.南极的','the area around the South Pole','This kind of animal lives in the Antarctic.','这种动物生活在南极。','','ant相反 + arctic北极的 → Antarctic南极的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (818,'condolence','condolence','/kənˈdoʊləns/','n.哀悼；吊唁','sympathy that you feel for somebody when a person in their family or that they know well has died; an expression of this sympathy','People lit candles to show their condolence for the earthquake victims.','人们点燃蜡烛，来向地震中的受害者表示哀悼。','','condol=condole悲伤 + ence名词后缀 → 哀悼；慰问',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (819,'show_up','show up','/ʃoʊ ʌp/','phr. 露面，出现',' appear or become visible; make a showing','When the singer\'s fiancee showed up on stage, the audience was surprised.','当这这名歌手的未婚妻出现在舞台上时，观众感到很惊讶。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (820,'dressing','dressing','/ˈdresɪŋ/','n. 沙拉酱，调味汁','savory dressings for salads; basically of two kinds: either the thin French or vinaigrette type or the creamy mayonnaise type','Here are different dressings you can choose.','这里有不同的沙拉酱供你选择。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (821,'fabric','fabric','/ˈfæbrɪk/','n.布料，织物','woven or knitted material','There are many colorful fabric samples.','这里有好多五颜六色的布料样品。','','fabric=make制作 → 线制作的 → fabric织物',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (822,'quiescent','quiescent','/kwaɪˈesnt/','adj. 静止的，沉寂的，不活动的','(formal) quiet; not active','This volcano exploded a few years ago: fortunately, it\'s quiescent now.','这个火山几年前喷发过，幸运的是，它现在已经沉寂了。','','qui静 ＋ escent...的 → quiescent静止的；不活动的；沉寂的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (823,'inland','inland','/ˈɪnlænd/','adj.内陆的，国内的；  adv.在内陆，往内陆','located in or near the middle of a country, not near the edge or on the coast','Switzerland is an inland country.','瑞士是一个内陆国家。','','in向内，进入 + land土地 → inland内地的，国内的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (824,'captain','captain','/ˈkæptɪn/','n.船长，机长；  vt.做……的首领','the person in charge of a ship or commercial aircraft','The captain is standing at the helm of the ship.','船长正在船上掌舵。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (825,'creator','creator','/kriˈeɪtər/','n. 创造者','a person who has made or invented a particular thing','This sculpture\'s creator is trying to present what she envisioned in her mind.','这座雕塑的创造者正试图呈现出她脑海中想象的画面。','','creat=create创造 ＋ or名词后缀，表示做…工作的人或物 → creator创造者；创建者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (826,'thirsty_for','thirsty for','/ˈθɜːrsti fɔːr/','phr. 渴望 ...','','Despite already having a PhD, he\'s still thirsty for more knowledge.','尽管已经有了博士学位，他仍然渴望学习更多的知识。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (827,'neck','neck','/nek/','n.脖子；  v.（与……）搂着脖子亲吻；  vi.搂脖子亲嘴','the part of the body between the head and the shoulders','Duck neck is so spicy and yummy.','鸭脖又辣又好吃。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (828,'version','version','/ˈvɜːrʒn/','n.版本；说法','a form of something that is slightly different from an earlier form or from other forms of the same thing','This book has many different versions.','这本书有很多不同的版本。','','vers转 + ion表名词 → 把原文转换成另一版本 → version翻译，译文',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (829,'propeller','propeller','/prəˈpelər/','n. 螺旋桨','a device with two or more blades that turn quickly and cause a ship or an aircraft to move forward','I\'ve been trained to fly single propeller planes.','我接受过训练，学习驾驶单螺旋桨飞机。','single propeller planes','pro向前 ＋ pell=pel推进 ＋ er表名称，物 → propeller推进器',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (830,'calcium','calcium','/ˈkælsiəm/','n. 钙','a chemical element. Calcium is a soft silver-white metal that is found in bones, teeth and chalk.','Milk and cheese are high in calcium.','牛奶和芝士都富含钙。','high in calcium','calc石头 + ium表名词，常指化学元素 → calcium钙',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (831,'drown','drown','/draʊn/','v. 淹死；淹没','to die because you have been underwater too long and you cannot breathe; to kill somebody in this way','The apple drowned in the water because it couldn\'t swim.','苹果因为不会游泳而淹死在了水里。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (832,'predatory','predatory','/ˈpredətɔːri/','adj. 捕食生物的','living by killing and eating other animals','We little fish can do nothing when faced with the predatory hawk.','我们这些小鱼面对捕食的老鹰真的无能为力。','','pred抢掠+ator物+y...的→predatory掠夺的；食肉的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (833,'incline','incline','/ɪnˈklaɪn/','n. 倾斜，斜坡，斜面；  v. （使）倾斜，（使）倾向于','a slope','The small ball is on an incline and would hit the big ball.','小球在斜面的一端，可能会撞向大球。','on an incline','in使 + clin倾斜 + e → incline 倾斜，斜坡',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (834,'smooth','smooth','/smuːð/','adj.光滑的；平稳的；  vt.使光滑；使平稳','completely flat and even, without any lumps, holes or rough areas','She said the taste of the chocolate is as smooth as silk. Give me some!','她说这种巧克力的口感如丝绸般柔滑，给我一点儿尝尝！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (835,'a_multitude_of','a multitude of','/e ˈmʌltɪˌtud ʌv/','phr. 许多，众多','A multitude of things or people is a very large number of them.','A multitude of cars are parked side by side.','许多车紧挨着停在一起。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (836,'aside','aside','/əˈsaɪd/','adv.留存；  n.离题的话','to one side; out of the way','I pushed the hamburger aside because I\'m on a diet.','我把汉堡推到了一边，因为我正在节食。','','a在…的 + side旁边 → 在旁边 → aside在边上',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (837,'space','space','/speɪs/','n.（可利用的）空间，空地；（两物或某物两部分之间的）空当，空隙，间隔，距离；  v.留间隔，隔开','the amount of an area, room, surface, etc., that is empty or available for use','I cleared a space for you to sit.','我给你腾出了一个坐的地方。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (838,'accountability','accountability','/əˌkaʊntəˈbɪləti/','n.有责任','responsibility to someone or for some activity','Everybody thinks that he has accountability for his mistake.','所有人都认为他要对自己的过失负责。','has accountability for','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (839,'connect','connect','/kəˈnekt/','v.连接；与……有同感；把……联系起来','to join together two or more things; to be joined together','My phone is connected to the computer.','我的手机正连接着电脑。','is connected to','con共同 + nect连结 → connect连结',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (840,'pressure','pressure','/ˈpreʃər/','n.压力；  vt.对……施加压力','the force or weight with which something presses against something else','The pressure of the giant pear is unbearable!','这个大鸭梨的压力实在是难以承受！','The pressure of','press挤压 + ure名词后缀，表行为、状态 → pressure压力',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (841,'lord','lord','/lɔːrd/','n. 有爵位的贵族；  v. 逞威风；  vt. 称…为勋爵','a powerful man in medieval Europe, who owned a lot of land and property','He\'s an English lord honored by the King.','他是一个被国王册封的英国贵族。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (842,'conditional','conditional','/kənˈdɪʃənl/','adj. 有条件的，假定的；  n. 条件句，条件语','expressing something that must happen or be true if another thing is to happen or be true; depending on something','Cats\' love for humans seems to be conditional.','看来，猫对人类的爱是有条件的。','','condition条件 + al形容词后缀 → conditional条件的，有条件的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (843,'envisage','envisage','/ɪnˈvɪzɪdʒ/','v.想象，设想','to imagine what will happen in the future','He envisages a future where he owns a home.','他设想一个拥有自己的家的未来。','','en致使 + vis=see表示“看” + age名词后缀 → 使能在脑海中看见 → 想象，设想',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (844,'momentum','momentum','/moʊˈmentəm/','n. （物理）动量；势头；动力','a force that is gained by movement','His momentum caused him to go up into the air.','动量让他高高跃起。','','moment重要 + um表示场所、实物及抽象名词 → momentum动力',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (845,'allure','allure','/əˈlʊr/','n. 诱惑力；  v. 诱使','power to attract :a quality that attracts people','The mouse is allured by the smell of the cheese.','老鼠被芝士的香味吸引了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (846,'direction','direction','/dəˈrekʃn/','n.方向，方位；（复数）指令，说明','the general position a person or thing moves or points towards','There are two different directions, left and right.','这里有左和右两个不同的方向。','','di通过 + rect正，直 + ion名词后缀 → 通过正确的道路 → direction指示，指引，说明，指导',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (847,'renovation','renovation','/ˌrenəˈveɪʃn/','n.翻修，修理；恢复','the act of improving by renewing and restoring','The couple are planning a renovation of the entire property.','夫妇俩正计划对整栋房子进行翻修。','','re重新+nov新的+ation名词后缀 → 翻新，修理',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (848,'responsive','responsive','/rɪˈspɑːnsɪv/','adj. 反应积极的，反应敏捷的','reacting quickly and in a positive way','Children are always the most responsive members of the audience.','孩子总是观众席里反应最积极的人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (849,'odyssey','odyssey','/ˈɑːdəsi/','n. 奥德赛','a Greek epic poem (attributed to Homer) describing the journey of Odysseus after the fall of Troy','An odyssey is a long exciting journey where lots of things can happen.','奥德赛是指一段漫长而激动人心的旅程，期间可以发生很多事情。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (850,'assistant','assistant','/əˈsɪstənt/','n.助理，助手；  adj.助理的，辅助的','a person who helps or supports somebody, usually in their job','The businessman has an assistant to help him with his work every day.','这个商人有一名每天协助他工作的助理。','','assist援助 + ant名词后缀 → 帮助之人 → assistant助手，助理',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (851,'liquor','liquor','/ˈlɪkər/','n. 烈性酒','strong alcoholic drink','This bar sells a wide variety of liquor.','这个酒吧出售各式各样的酒。','','liqu=liquid液体 + or表名词 → liquor酒；酒精饮料',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (852,'civilisation','civilisation','/ˌsɪvələˈzeɪʃn/','n.文明','a society, its culture and its way of life during a particular period of time or in a particular part of the world; a state of human society that is very developed and organized','Many relics from the ancient Egyptian civilisation have been discovered.','很多古埃及文明的遗迹都被发现了。','Egyptian civilisation','civil公民的 +isation=ization表名词→ [英]文明',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (853,'set_off','set off','/set ɔːf/','phr.出发，动身，启程','to begin a journey','The pirates set off from the island.','这些海盗从小岛出发了。','set off from the island','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (854,'passenger','passenger','/ˈpæsɪndʒər/','n.乘客，旅客','a person who is traveling from one place to another in a car, bus, train, ship, airplane, etc., and who is not driving or working on it','All the passengers are seated and ready for the trip.','乘客们已经坐好了，准备开始旅程。','','pass通过 + enger人 → 通过的人 → passenger乘客',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (855,'large','large','/lɑːrdʒ/','adj. 大的；大量的','great in size or amount','She has a very large cup.','她有一个非常大的杯子。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (856,'hopeless','hopeless','/ˈhoʊpləs/','adj.绝望的','feeling or showing no hope','He felt hopeless as the plane flew away, failing to notice his sign.','飞机没有注意到他的信号就飞走了，他感到很绝望。','','hope希望 + less表形容词，无……的 → hopeless无希望的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (857,'adversary','adversary','/ˈædvərseri/','n. 对手，敌手','an enemy or opponent','These two adversaries are locked in a heated public debate.','这两名对手正陷于激烈的公开辩论中。','','advers(e)相反的 + ary名词后缀：人 → 逆反之人 → adversary 对手',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (858,'on_the_air','on the air','/ɑːn ði er/','phr.直播中','of a radio or television station, program','His radio show is on the air from 7am daily.','他的广播节目每天早上7点开始播出。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (859,'confident_of','confident of','/ˈkɑnfɪdənt ʌv/','phr. 确信的，有把握的','','He is confident of his future success.','他对将来成功充满信心。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (860,'quilt','quilt','/kwɪlt/','n.被子；  v.摘录，编辑','a decorative cover for a bed, made of two layers with soft material between them','When the weather gets cold, I sleep with a heavy quilt to stay warm.','当天气变冷时，我会盖一床厚被子保暖。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (861,'hand_on','hand on','/hænd ɑːn/','phr. 依次传递','','The teacher asked them to sign their names and hand the form on.','老师让他们签名并把表格传下去。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (862,'relax','relax','/rɪˈlæks/','v. 放松','to rest while you are doing something enjoyable, especially after work or effort','Taking a bath is a good way to relax yourself.','泡澡是很好的放松方式。','','re重新 + lax松 → 重新松开 → relax放松，宽心',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (863,'keeper','keeper','/ˈkiːpər/','n. 饲养员','a person whose job is to take care of animals, especially in a zoo','The hungry animals were glad to see the zoo keeper bringing them lunch.','看到饲养员拿来了午餐，这些饥饿的动物非常高兴。','','keep监守 + er名词后缀 → keeper看守人',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (864,'mild','mild','/maɪld/','adj.清淡的；温暖的；轻微的','(of a flavour) not strong, spicy or bitter','I would love a bowl of mild chicken soup right now.','我现在真想要一碗清淡的鸡汤。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (865,'celebration','celebration','/ˌselɪˈbreɪʃn/','n.庆祝；庆典','a special event that people organize in order to celebrate something; the act of celebrating something','Many people gathered together for the New Year celebration.','很多人聚在一起欢庆新年。','','celebr庆祝 + ation表示行为、状态、过程 → celebration庆典，庆祝会',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (866,'rigidity','rigidity','/rɪˈdʒɪdəti/','n. 僵硬','the physical property of being stiff and resisting bending','Many people suffer from muscle rigidity.','许多人承受着肌肉僵硬之苦。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (867,'above','above','/əˈbʌv/','prep.在……之上；过于，超出；  adj.上面的，上述的；  adv.在……上面，上文中','at or to a higher place or position than something/somebody','The bird is flying above the water.','鸟儿在水面上飞行。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (868,'painstaking','painstaking','/ˈpeɪnzteɪkɪŋ/','adj. （不辞）劳苦的，辛勤的；  n. 辛劳，煞费苦心','needing a lot of care, effort and attention to detail','After years of painstaking research, he finally invented the electric bulb.','经过多年的辛勤试验，他终于发明了电灯泡。','','pains疼痛+tak=take拿，接 + ing……的 → 痛也要拿着 → 艰苦的；辛苦',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (869,'trace','trace','/treɪs/','vt.追踪；  n.痕迹','to find or discover somebody/something by looking carefully for them/it','The police dog traced the scent and located the stolen money.','这只警犬循着气味找到了被偷走的钱款。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (870,'industry','industry','/ˈɪndəstri/','n. 工业，产业；勤劳','the production of goods from raw materials, especially in factories; the quality of working hard','Heavy industry is important for our economy. Build more factories!','重工业对于我们的经济很重要，建造更多的工厂吧！','Heavy industry','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (871,'meat','meat','/miːt/','n. 肉','the flesh of an animal used as food','Vegetables are OK, but I prefer eating meats.','蔬菜是不错，但是我还是更喜欢吃肉。','prefer eating meat','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (872,'junk','junk','/dʒʌŋk/','n.垃圾，废旧物品；  v.把……（当废物）丢弃','things that are considered useless or of little value','What a mess! Must get rid of all this smelly junk.','真是一团糟！必须把这些发臭的垃圾清扫出去。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (873,'encouragement','encouragement','/ɪnˈkɜːrɪdʒmənt/','n.鼓励','the act of encouraging somebody to do something; something that encourages somebody','His encouragement made her run even faster.','在他的鼓励之下，她跑得更快了。','','encourage鼓励 + ment表名词 → encouragement鼓励',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (874,'vital','vital','/ˈvaɪtl/','adj.必不可少的，至关重要的；有活力的','connected with or necessary for staying alive','Water is vital to living beings.','水对生物来说是必不可少的。','','vit生命 + al形容词后缀 → vital有活力的；重要的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (875,'auction','auction','/ˈɔːkʃn/','n. 拍卖；  v. 拍卖','a public event at which things are sold to the person who offers the most money for them','Although about five of us were bidding on the house at the auction, I finally won.','在拍卖会上，虽然我们五个都为这栋房子竞价，但最终还是我赢了。','','auct=aug抬高，增加 + ion表名词 → auction拍卖',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (876,'disruptive','disruptive','/dɪsˈrʌptɪv/','adj.制造混乱的，破坏性的，分裂的','involving, causing, or tending to cause disruption','Those four disruptive students totally ruined my class.','那四个捣蛋鬼学生完全毁了我的课堂。','','dis分开+rupt断裂+ive表形容词 → disruptive 破坏性的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (877,'regard_for','regard for','/rɪˈɡɑːrd fɔːr/','phr.对……的尊重','','Carving a watermelon needs regard for details.','雕刻西瓜需要对细节的尊重。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (878,'spark','spark','/spɑːrk/','n.火花，火星；  v.发出火花','a very small burning piece of material that is produced by something that is burning or by hitting two hard substances together; a small flash of light produced by an electric current','A single spark can start a fire.','微小的火花就可能引起火灾。','A single spark','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (879,'conceited','conceited','/kənˈsiːtɪd/','adj. 自负的，自高自大的','having or showing too much pride in your own worth or goodness','In fact, the man was just conceited and couldn\'t fix the car.','事实上，这个人只是自负，其实根本修不好车。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (880,'decipher','decipher','/dɪˈsaɪfər/','vt. 破译；解释；  n. 密电译文','to find the meaning of (something that is difficult to read or understand)','In World War II, he invented a machine to decipher the enemy\'s code.','二战时，图灵发明了一种机器来破译敌人（纳粹）的密码。','decipher the enemy\'s code','de作成…+cipher密码→ n. 密电译文vt. 解释；破译（密码）；辨认；解读；',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (881,'veggie','veggie','/ˈvedʒi/','n. 蔬菜(=vegetable)','edible seeds or roots or stems or leaves or bulbs or tubers or nonsweet fruits of any of numerous herbaceous plant','There are different types of veggies on the table.','桌子上有不同种类的蔬菜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (882,'realize','realize','/ˈriːəlaɪz/','v.认识到，体会到','(not used in the progressive tenses) to understand or become aware of a particular fact or situation','"So that\'s how the word is spelled!" the little boy finally realized.','“原来这个单词是这样拼的！”小男孩终于意识到了这一点。','','real真实的 + ize表动词 → realize实现',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (883,'relate_to','relate to','/rɪˈleɪt tuː/','phr.与……有关','','A lot of people\'s favorite summer activities seem to relate to water. ','许多人最喜欢的夏日活动似乎都和水有关。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (884,'relationship','relationship','/rɪˈleɪʃnʃɪp/','n.关系','the way in which two people, groups or countries behave towards each other or deal with each other','These five people have different relationships with each other.','这五个人之间有不同的关系。','','relation关系 + ship表名词 →（亲属）关系',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (885,'cell','cell','/sel/','n.细胞；小隔间','the smallest part of an animal or plant that is able to function independently','White blood cells help protect the body against viruses.','白细胞可以保护身体，消灭病毒。','White blood cells','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (886,'proton','proton','/ˈproʊtɑːn/','n. 质子','a very small piece of matter (= a substance) with a positive electric charge that forms part of the nucleus (= central part) of an atom','Protons are positively charged particles in the center of an atom.','质子是原子核中带正电的粒子。','','prot第一 + on表名词 → proton质子',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (887,'get_along_with','get along with','/ɡet əˈlɔːŋ wɪð/','phr. 与……相处','to have a friendly relationship with somebody','The cute animals get along with each other.','可爱的小动物们相处得很愉快。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (888,'hazard_to','hazard to','/ˈhæzərd tuː/','phr.对于……的危险','','Electricity may be a hazard to children.','电对于儿童或许是一种危险。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (889,'liberty','liberty','/ˈlɪbərti/','n.自由','freedom to live as you choose without too many restrictions from government or authority; the state of not being a prisoner or a slave; the legal right and freedom to do something','The bird flew from the cage and got liberty.','这只鸟飞出了鸟笼，得到了自由。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (890,'horizon','horizon','/həˈraɪzn/','n.地平线；眼界，见识','the furthest that you can see, where the sky seems to meet the land or the sea','I can see the horizon behind the hills.','我可以看到小山后面的地平线。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (891,'standby','standby','/ˈstændbaɪ/','n.备用，待命者','a person or thing that can always be used if needed','I always bring an umbrella whenever I go out as a standby.','不管什么时候出门，我总是会带一把雨伞备用。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (892,'angry','angry','/ˈæŋɡri/','adj.愤怒的','having strong feelings about something that you dislike very much or about an unfair situation','The phone call makes him very angry.','这通电话让他非常生气。','makes him very angry','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (893,'spur','spur','/spɜːr/','v.策马，用踢马刺的方式驱马前进；  n.刺激，鞭策，鼓励','to encourage a horse to go faster, especially by pushing the spurs on your boots into its side','The cowboy spurred his horse to run faster.','牛仔用踢马刺的方式来使他的马跑得更快一些。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (894,'up-to-date','up-to-date','/ˌʌp tə ˈdeɪt/','adj. 时新的，新式的；跟上时代的','modern; fashionable; having or including the most recent information','A smart phone is the most up-to-date way to get important information.','智能手机是获取重要信息的最新方式。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (895,'displace','displace','/dɪsˈpleɪs/','v.取代，替代，迫使（某人）离开家园，使离开原位','to take the place of somebody/something; to move something from its usual position','The man feels depressed after being displaced in his job by a machine.','在他的工作被机器取代后，这个男人感到十分难过。','','dis否定 + place位置 → displace移位',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (896,'begin','begin','/bɪˈɡɪn/','v. 开始','to start doing something; to do the first part of something','The bell rings and class begins.','上课铃响就开始上课。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (897,'rotund','rotund','/roʊˈtʌnd/','adj. （人）圆胖的','having a fat round body','The rotund man is sleeping on the chair.','这个胖乎乎的男子正在椅子上睡觉。','rotund man','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (898,'pull_at','pull at','/pʊl æt/','phr.拉扯',' pluck or pull at with the fingers','She\'s pulling at her face.','她正在扯自己的脸。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (899,'journalism','journalism','/ˈdʒɜːrnəlɪzəm/','n.新闻业','the work of collecting and writing news stories for newspapers, magazines, radio, television or online news sites; the news stories that are written','They work in journalism and broadcast news as anchors.','他们从事新闻行业，作为主播播报新闻。','','journal日报 ＋ ism名词后缀 → journalism新闻业',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (900,'occasion','occasion','/əˈkeɪʒn/','n. 场合，时候；活动；时机，机会','a particular time when something happens; a special event, ceremony or celebration','In China, New Year\'s Eve is a great family occasion.','在中国，除夕夜是重要的家庭团聚时刻。','family occasion','oc加强 + cas降临 + ion 表名词 → 突然落下的瞬间 → occasion时机；场合',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (901,'truly','truly','/ˈtruːli/','adv.真心地','used to emphasize that a particular statement, feeling, etc. is sincere or genuine','The undefeated boxer is truly one of the greatest of all time.','这位不败的拳击手真的是有史以来最伟大的拳击手之一。','','tru=true真实 + ly表副词 → truly真正地，确实地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (902,'serious','serious','/ˈsɪriəs/','adj. 认真的，严肃的','needing to be thought about carefully; not only for pleasure; sincere about something; not joking or meant as a joke','He is always very serious while working.','他工作时总是很认真。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (903,'rain','rain','/reɪn/','n. 雨，雨水；  v. 下雨','water that falls from the sky in separate drops','The girl walked alone in the rain.','女孩独自一人漫步在雨中。','in the rain','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (904,'co-worker','co-worker','/ˈkoʊ wɜːrkər/','n. 同事；合作者','a person that somebody works with, doing the same kind of job','They watch their co-worker presenting his plan.','他们看着同事陈述计划。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (905,'maltreat','maltreat','/ˌmælˈtriːt/','v. 虐待','to be very cruel to a person or an animal','The man with a belt in his hand maltreated his son.','手里拿着皮带的那个男人虐待了他的儿子。','','mal坏，恶 + treat对待 → maltreat虐待',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (906,'temple','temple','/ˈtempl/','n.庙宇，神殿；太阳穴','a building used for the worship of a god or gods, especially in religions other than Christianity','The old temple was beautiful at night.','这个古老的庙宇在晚上十分漂亮。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (907,'function','function','/ˈfʌŋkʃn/','n.功能，作用，机能；  v.正常工作，运转','the special purpose or activity for which a thing exists or is used','This kind of bottle with holes has many useful functions.','这种带孔的瓶子有许多实用的功能。','','funct活动 + ion表名词 → function功能',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (908,'percussion','percussion','/pərˈkʌʃn/','n. 敲打乐器','musical instruments that you play by hitting them with your hand or with a stick, for example drums','These students are playing percussion instruments in music class.','这些学生在音乐课上演奏打击乐器。','','per贯穿，自始至终 + cuss震 + ion名词后缀 → 震动 → 敲打',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (909,'put_off','put off','/pʊt ɔːf/','phr. 推迟','to change something to a later time or date','The sports meeting will be put off because of the rain.','因为下雨，运动会将会推迟。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (910,'buzz','buzz','/bʌz/','v. 发出嗡嗡声；  n. 低沉嘈杂的谈话声','(of a bee) to make a continuous low sound; to make a sound like a bee buzzing','The bees buzz as they work.','蜜蜂采蜜时发出嗡嗡声。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (911,'fact','fact','/fækt/','n.事实','something that truly exists or happens: something that has actual existence','My photo proved the fact that the ghosts weren\'t real.','我的照片证明了一个事实：这些鬼都是假的。','proved the fact','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (912,'recital','recital','/rɪˈsaɪtl/','n. 独奏，吟诵，演奏会','a public performance of music or poetry, usually given by one person or a small group; a spoken description of a series of events, etc. that is often long and boring','I went to watch a famous pianist\'s recital last night.','昨晚我去看了一个著名音乐家的钢琴独奏会。','','re一再，重新 + cit引用，唤起 + al名词后缀 → recital背诵；独奏',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (913,'casualty','casualty','/ˈkæʒuəlti/','n. 伤亡人员，死伤者，受害人','a person who is killed or injured in war or in an accident','We suffered one casualty at work today.','在今天的工作中，有一人不幸遇难。','','casual待命士兵的 + ty表名词 → casualty（事故）伤亡人员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (914,'actress','actress','/ˈæktrəs/','n. 女演员','a woman who performs on the stage, on television or in films/movies, especially as a profession','The princess in the film was played by a famous actress.','这部电影里的公主由一个著名的女演员扮演。','','act表演 + ress女性 → actress女演员',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (915,'elevation','elevation','/ˌelɪˈveɪʃn/','n. 高度','the height of a place, especially its height above sea level','The mountain is at an elevation of 3000 meters above sea level.','这座山的海拔高度是3000米。','','elevat升高 + ion名词后缀 → elevation提升，高度',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (916,'attend_to','attend to','/əˈtend tu/','phr.照料',' get down to; pay attention to; take seriously','The nurse attends to her patients carefully.','护士认真且温柔地照顾着病人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (917,'apart','apart','/əˈpɑːrt/','adv.分离地，分开地；  adj.分隔的，拆开的，撇开的','separated by a distance, of space or time; not together; separate or separately','They set one man apart from the rest.','他们把一个人从人群里分离出来了。','apart from the rest','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (918,'sanction','sanction','/ˈsæŋkʃn/','n.批准；  v.批准；支持；对……实施制裁','official permission or approval for an action or a change','The installation of air conditioners received sanction from the boss.','老板批准了空调的安装。','','sanct神圣 + ion表名词 → 给予神圣的权利 → sanction批准，授权',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (919,'teller','teller','/ˈtelər/','n. 出纳员',' an official appointed to count the votes (especially in legislative assembly)','Tellers deal with customers face-to-face in the bank, including giving and receiving cash.','银行出纳员与客户面对面打交道，包括给出和收取现金。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (920,'unsafe','unsafe','/ʌnˈseɪf/','adj. 不安全的，危险的','not safe','It\'s unsafe to touch the switch with wet hands.','湿手触碰开关是很不安全的。','','un不 + safe安全的 → 不安全的；危险的；不安稳的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (921,'pay_attention_to','pay attention to','/peɪ əˈtenʃən tu/','phr. 注意','take notice of','While walking, we should pay careful attention to warning signs!','走路时，我们应该多注意路上的警告牌！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (922,'prove','prove','/pruːv/','v.证明，证实','to use facts, evidence, etc. to show that something is true','It takes one second to say "I do," but a lifetime to prove it.','说一句“我愿意”只用一秒，可证明它却需要一辈子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (923,'apple','apple','/ˈæpl/','n.苹果','a round fruit with shiny red or green skin and firm white flesh','I had an apple for breakfast today.','我今天早餐吃了一个苹果。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (924,'pine','pine','/paɪn/','n.松树；  v.（因死亡、离别等）难过','an evergreen forest tree with leaves like needles; the pale soft wood of the pine tree, used in making furniture, etc.','The pine tree is a symbol of Mount Huangshan.','迎客松是黄山的标志之一。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (925,'as_a_result','as a result','/əz ə rɪˈzʌlt/','phr.所以，结果','because','As a result of eating too much fast food, I got really fat.','由于吃了太多快餐食品，结果我变得非常胖。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (926,'eastern','eastern','/ˈiːstərn/','adj. 东方的，东部的，朝东的','located in the east or facing east; connected with the part of the world that is to the east of Europe','I saw the sunrise in the eastern sky.','我看到太阳从东方升起。','','east东方 + ern形容词后缀 → eastern东方的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (927,'inquisitive','inquisitive','/ɪnˈkwɪzətɪv/','adj. 好奇的，好打听的','very interested in learning about many different things; (disapproving) asking too many questions and trying to find out about what other people are doing, etc.','The inquisitive boy with the magnifying glass is eager for knowledge.','这个手拿放大镜的好奇男孩非常渴望知识。','inquisitive boy','in进入 ＋ quis问，寻求 ＋ itive表形容词 → inquisitive过分好问的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (928,'absorbed','absorbed','/əbˈzɔːrbd/','adj.全神贯注的，专心致志的','very interested in something/somebody so that you are not paying attention to anything else','My daughter is absorbed in her story book.','我女儿被她的故事书吸引住了。','is absorbed in','ab一再 + sorb吸收 + ed…的 → absorbed全神贯注的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (929,'outfit','outfit','/ˈaʊtfɪt/','n.装备，装束，全套服装；组织，团队；  v.提供装备','a set of clothes that you wear together, especially for a particular occasion or purpose; a group of people working together as an organization, business, team, etc.; a set of equipment that you need for a particular purpose','When it comes to their outfits, they have totally different taste.','她们对于穿搭有着完全不同的品位。','','out外 + fit装备 → outfit全套装备，套装',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (930,'concert','concert','/ˈkɑːnsərt/','n. 音乐会','a public performance of music','The animals are holding a concert in the forest!','动物们正在森林里开演唱会呢！','holding a concert','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (931,'forerunner','forerunner','/ˈfɔːrʌnər/','n. 先驱；祖先；前兆；预兆','a person or thing that came before and influenced somebody/something else that is similar; a sign of what is going to happen','Do you agree that he is the forerunner of Chinese rock music?','你同意他是中国摇滚乐先驱这种说法吗？','','fore前 + run跑步 + ner人 → 先跑出去的人 → forerunner先驱，先导',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (932,'appraise','appraise','/əˈpreɪz/','v. 评价，鉴定','to consider or examine somebody/something and form an opinion about them or it','The manager has appraised the two employees.','经理对这两个员工做出了评价。','','ap一再 ＋ praise价值 → 给以价值 → appraise评估',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (933,'general','general','/ˈdʒenrəl/','adj.普遍的，总的；一般的，普通的；大致的，笼统的；  n.将军','affecting all or most people, places or things;  normal; usual; including the most important aspects of something; not exact or detailed; approximately, but not exactly, the direction/area mentioned; not limited to a particular subject, use or activity; not limited to one part or aspect of a person or thing; highest in rank; chief','In general, the chart shows an increase.','总的来说，这张图呈现了一个上升趋势。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (934,'retrieve','retrieve','/rɪˈtriːv/','v.取回，重新得到，挽回','to bring or get something back, especially from a place where it should not be;  to find and get back data or information that has been stored in the memory of a computer; to make a bad situation better; to get back something that was lost','The dog retrieves a ball.','小狗找回了一个球。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (935,'dismay','dismay','/dɪsˈmeɪ/','n.失望，沮丧；  v.使惊恐','a worried, sad feeling after you have received an unpleasant surprise','The student could not hide his dismay after failing the exam.','得知考试不及格后，这位同学无法掩饰自己的沮丧。','','dis分开，分离 + may能够 → 不能做事 → dismay沮丧',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (936,'hide','hide','/haɪd/','v.躲藏；隐瞒；把……藏起来','to go to or stay at a place where you cannot be seen or found','The boy is hiding inside the big box.','男孩藏在这个大箱子里。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (937,'allurement','allurement','/ə\'lʊəmənt/','n.诱惑','attractiveness','The carrot is an irresistible allurement for the donkey.','胡萝卜对驴来说是一种难以抗拒的诱惑。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (938,'magnetism','magnetism','/ˈmæɡnətɪzəm/','n. 吸引力；磁性','the qualities of something, especially a person’s character, that people find powerful and attractive','Money has a powerful magnetism and is very attractive.','钱有一种神奇的吸引力。','','magnet磁铁 + ism学术流派 → magnetism磁学，磁性',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (939,'diligence','diligence','/ˈdɪlɪdʒəns/','n.勤奋','careful hard work :continued effort','She showed great diligence in her completing schoolwork.','她在完成学业的过程中表现出了极其勤奋的精神。','','dilig勤奋 + ence表示性质、状态、行为 → diligence 勤奋',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (940,'conception','conception','/kənˈsepʃn/','n.怀孕；构想，设想；思想，观念','the process of forming an idea or a plan; an understanding or a belief of what something is or what something should be; the process of an egg being fertilized inside a woman’s body so that she becomes pregnant','This baby will come into the world nine months after conception.','怀孕九个月后，宝宝会来到这个世上。','','con共同 + cept拿，抓，握住 + ion名词后缀 → conception概念，观念',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (941,'imposition','imposition','/ˌɪmpəˈzɪʃn/','n. 征收','the act of introducing something such as a new law or rule, or a new tax','The government is responsible for the imposition of taxes.','政府负责征收税款。','','impos强加 + i + tion名词后缀 → imposition 强加，征税',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (942,'Westerner','Westerner','/ˈwestərnər/','n. 西方人','an inhabitant of a western area; especially of the U.S','Westerners have different eating habits to people from Asia.','西方人和亚洲人有不同的饮食习惯。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (943,'try_sth._out','try sth. out','/traɪ ˈsʌmθɪŋ aʊt/','phr. 试验','to test or use somebody/something in order to see how good or effective they are','I\'m going to try out my new experiment on some mice.','我将在小白鼠身上试验我的新实验。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (944,'work_out','work out','/wɜrk aʊt/','phr. 计算出；锻炼；计划；解决','to calculate something','He worked out the math problem on the blackboard.','他做出了黑板上的那道数学题。','worked out the math problem','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (945,'Monday','Monday','/ˈmʌndeɪ/','n. 星期一','the day of the week after Sunday and before Tuesday, the first day of the working week','Today is Monday.','今天是星期一。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (946,'thief','thief','/θiːf/','n.小偷','a person who steals something','A thief is stealing the girl\'s phone.','一个小偷正在偷这个女孩的手机。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (947,'tonic','tonic','/ˈtɑːnɪk/','n. 补药；主调音或基音；  adj. 使精神振作的','a medicine that brings you back to a normal physical or mental condition','Ginseng is a well-known tonic which is good for health.','人参是一种非常出名的补药，它对身体非常好。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (948,'conceit','conceit','/kənˈsiːt/','n. 自负；想法，观点；构想，幻想；狂妄','too much pride in yourself and what you do','The cat\'s conceit deluded him into believing he is as strong as a lion.','这只猫的自负使他误以为自己像狮子一样强壮。','','con全部 + ceit拿出 → 拿出架子 → conceit自负，狂妄',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (949,'yelp','yelp','/jelp/','v. 狗吠，（因痛而）叫喊，叫喊着说','to make a quick, high cry or bark','The white dog yelped and tried to protect himself from two dogs.','这只白狗叫了一声，试图保护自己免受其他两只狗的伤害。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (950,'under','under','/ˈʌndər/','prep.在……之下；在……的领导下；  adj.下面的；  adv.在下方','in, to or through a position that is below something; below the surface of something; covered by something','There\'s a cute little girl playing under the table.','一个可爱的小女孩正在桌下玩呢。','under the table','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (951,'boil','boil','/bɔɪl/','v.烧开，沸腾','when a liquid boils or when you boil it, it is heated to the point where it forms bubbles and turns to steam or vapour','The water in the small pot is boiling.','小锅里的水正在沸腾。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (952,'furthermore','furthermore','/ˌfɜːrðərˈmɔːr/','adv.而且，此外','in addition to what has just been stated','He broke his leg in the forest; furthermore, some strange creatures were watching him.','他在森林中摔断了腿，此外，他还被某些奇怪的生物盯上了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (953,'automatic','automatic','/ˌɔːtəˈmætɪk/','adj. 自动的；无意识的；  n. 自动手枪','done or happening without thinking','The automatic door opens by itself when someone walks towards it.','当有人走过来时，自动门会自行打开。','','autom=auto，autom自动 + atic有…性质的 → automatic自动的，机械的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (954,'sector','sector','/ˈsektər/','n.（经济等的）部门','a part of an area of activity, especially of a country’s economy','This country\'s economy has three different sectors: manufacturing, agriculture, and services.','这个国家的经济有三个不同的部分：制造业、农业和服务业。','','sect切 + or名词后缀 → sector部门',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (955,'honeymoon','honeymoon','/ˈhʌnimuːn/','n.蜜月；  v.度蜜月','a holiday/vacation taken by a couple who have just got married','The newly-weds are on their honeymoon.','这对新婚夫妇正在蜜月旅行中。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (956,'be_bent_on','be bent on','/bi bent ɔn/','v. 专心致志于','having a strong desire to do (something)','She is bent on her online assignments and thinks about the answers.','她正专注于线上作业，并思考着答案。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (957,'soup','soup','/suːp/','n. 汤','a food made by cooking vegetables, meat, or fish in a large amount of liquid','This is a bowl of chicken soup.','这是一碗鸡汤。','chicken soup','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (958,'solar','solar','/ˈsoʊlər/','adj.太阳能的；太阳系的','of or connected with the sun; produced by or using the sun\'s light or heat','Solar energy is from the sun.','太阳能来自太阳。','Solar energy','sol太阳 + ar与...有关 → 太阳的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (959,'preposition','preposition','/ˌprepəˈzɪʃn/','n. 前置词，介词','a word or group of words, such as in, from, to, out of and on behalf of, used before a noun or pronoun to show place, position, time or method','Prepositions are usually used before nouns to give additional information.','介词通常用在名词前来给出额外的信息。','','pre…前的，预先 + position位置 → 位置放在前面 → 前置词，介词',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (960,'nutritional','nutritional','/nuˈtrɪʃənl/','adj. 营养的','of or relating to or providing nutrition','We can learn its nutritional content from the label.','我们可以从标签上了解它的营养成分。','','nutrit营养+ion表名词+al…的 → 有营养的，滋养的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (961,'sand','sand','/sænd/','n.沙堆；  v.用砂纸打磨','a substance that consists of very small fine grains of rock; a large area of sand on a beach','The kids are playing in the sand.','孩子们在沙地里玩。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (962,'Buddhism','Buddhism','/ˈbʊdɪzəm/','n. 佛教','an Asian religion based on the teaching of Siddhartha Gautama (or Buddha)','The man sitting there believes in Buddhism.','坐在那里的人信奉佛教。','believes in Buddhism','Buddh=Buddha佛 + ism主义 → 佛教',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (963,'ion','ion','/ˈaɪɑːn/','n. ［物］离子','an atom or a molecule with a positive or negative electric charge caused by its losing or gaining one or more electrons','Na+ is an ion because it does not have the same number of protons and electrons.','Na+是离子，因为它质子数和电子数不相同。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (964,'accessory','accessory','/əkˈsesəri/','n.配饰；附件；配件；同谋；  adj.附属的；辅助的；同谋的','a thing that you can wear or carry that matches your clothes, for example a belt or a bag','Some girls like various accessories, such as sunglasses, hats and lipsticks.','有些女孩喜欢各种各样的配饰，比如太阳眼镜、帽子和口红。','','access接近通道 + ory表名词 → access接近 + ory表名词 → accessory接近的物=附件',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (965,'resemblance','resemblance','/rɪˈzembləns/','n.相似','the fact of being or looking similar to somebody/something','There is a remarkable resemblance between him and his brother, Pete.','他和他的弟弟皮特之间有着惊人的相似之处。','','re一再，重新 + sembl相像 + ance名词后缀，表性质 → resemblance相像',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (966,'month','month','/mʌnθ/','n.月','a period of time that lasts about four weeks or 30 days','There are twelve months in a year.','一年有12个月。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (967,'spread','spread','/spred/','v.抹，敷；伸开，伸展；散布，传播；摊开；  n.伸开，伸展；散布，传播；活动范围','to open something that has been folded so that it covers a larger area than before; to arrange objects so that they cover a large area and can be seen easily','I like to spread butter on the bread before making a sandwich.','做三明治之前，我喜欢在面包上涂点黄油。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (968,'sooner_or_later','sooner or later','/ˈsʊnər ɔːr ˈleɪtər/','adv. 迟早；早晚有一天','within an indefinite time or at an unspecified future time','“I swear I will succeed sooner or later!" thought the businessman standing by the window.','“我发誓我一定会成功的！”那个站在窗边的商人这样想。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (969,'motion','motion','/ˈmoʊʃn/','n.运动，移动','the act or process of moving or the way something moves','The slow motion clearly shows how he dodges the bullets.','慢动作清楚地展现了他躲过子弹的全过程。','','mot=move移动 + ion名词后缀 → motion运动',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (970,'haul','haul','/hɔːl/','v. 拖，拉，拽；  n. 一次获得；  v. 硬拖，硬拉，用力拖','to pull something/somebody with a lot of effort','It is pointless for him to attempt to haul the truck barehanded.','对他而言，赤手空拳地拉卡车是徒劳的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (971,'separation','separation','/ˌsepəˈreɪʃn/','n.分离','the act of separating people or things; the state of being separate','Their separation made them both extremely sad.','与对方分离让他们伤心欲绝。','','separ分居 + ation名词后缀 → separation分离；间隔',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (972,'medicine','medicine','/ˈmedɪsn/','n.药；医学','a substance, especially a liquid that you drink or swallow in order to cure an illness; the study and treatment of diseases and injuries','He was given medicine from the doctor to help him cure his disease.','医生给了他一些药来治病。','','medic医师＋ ine名词后缀 → 跟医师有关的 → medicine医学，内科学',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (973,'cooker','cooker','/ˈkʊkər/','n. 炉灶','a large piece of equipment for cooking food, containing an oven and gas or electric rings on top','A cooker is a large device that uses gas or electricity to cook food.','炉灶是一种用天然气或电烹饪食物的大型设备。','','cook烹饪 + er表示物 → 炊具',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (974,'apron','apron','/ˈeɪprən/','n.围裙','a piece of clothing worn over the front of the body, from the chest or the waist down, and tied around the waist. Aprons are worn over other clothes to keep them clean, for example when cooking.','I wear an apron while I cook, so my clothes don\'t get dirty.','做饭时我穿着围裙，这样就不会把我的衣服弄脏了。','wear an apron','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (975,'interdependence','interdependence','/ˌɪntərdɪˈpendəns/','n. 互相依赖','the fact of depending on each other; the fact of consisting of parts that depend on each other','The disabled couple rely on interdependence to ride the bike.','这对残疾夫妇需要互相依赖才能骑走自行车。','','inter互相 + depend依靠 + ence名词后缀 → interdependence互相依靠',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (976,'ore','ore','/ɔːr/','n. 矿，矿石；矿砂','rock, earth, etc. from which metal can be obtained','These beautiful ores are the materials for the production of iron.','这些漂亮的矿石是炼铁的材料。','beautiful ores','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (977,'sea','sea','/siː/','n.海洋，海域；大量','the salt water that covers much of the Earth\'s surface','The sea looks so calm today.','今天，这片海看起来很平静。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (978,'superiority','superiority','/suːˌpɪriˈɔːrəti/','n. 优越（性），优等','the state or quality of being better, more skilful, more powerful, greater, etc. than others; behaviour that shows that you think you are better than other people','He wins the competition with obvious superiority.','他以明显的优势赢得了这次竞争的胜利。','','super超级 + ior较…… + ity名词后缀 → 超过一般人的 → superiority优越（性）',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (979,'seek','seek','/siːk/','v.寻找；争取','to search for (someone or something)','Let\'s play hide-and-seek!','让我们来玩捉迷藏吧！','hide-and-seek','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (980,'enable','enable','/ɪˈneɪbl/','v.使能够，使可能','to cause (a feature or capability of a computer) to be active or available for use','Standing on the box enables him to look out the window.','站在箱子上让他能够看到窗外。','enables him to look','en使…进入状态 + able能够 → enable使能够',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (981,'for_good_(and_all)','for good (and all)','/fɔːr ɡʊd ənd ɔːl/','adv. 永久地，一劳永逸地','for a long time without essential change','She is determined to stop smoking for good and all.','她决定再也不抽烟了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (982,'ascent','ascent','/əˈsent/','n. 登高；上坡路；上升','the act of climbing or moving up; an upward journey','His ascent of the mountain was very difficult due to the snow.','他的攀登很艰难，因为积雪很厚。','','a加强意义 + scent爬，攀 → ascent上升，升高，登高',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (983,'crowded','crowded','/ˈkraʊdɪd/','adj.拥挤的','filled with too many people or things','The subway is too crowded to get on.','这趟地铁挤得上不去。','','crowd拥挤 + ed形容词后缀 → crowded 拥挤的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (984,'useless','useless','/ˈjuːsləs/','adj. 无用的，无价值的，无效的','not useful; not doing or achieving what is needed or wanted','It\'s useless trying to use this bicycle.','这辆自行车已经没法用了。','','use用 + less无…的 → useless无用的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (985,'moth','moth','/mɔːθ/','n. 蛾','a flying insect with a long thin body and four large wings, like a butterfly, but less brightly coloured. Moths fly mainly at night and are attracted to bright lights.','The moth is flying directly towards the flame.','飞蛾正径直扑向火焰。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (986,'genius','genius','/ˈdʒiːniəs/','n. 天才；天资，天赋','unusually great intelligence, skill or artistic ability','The kid is a genius! He can work out any complicated formula.','这孩子是个天才！任何复杂的公式他都算得出来。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (987,'dazzle','dazzle','/ˈdæzl/','v.使眼花；使赞叹不已；  n.光辉；令人赞叹的东西','if a strong light dazzles you, it is so bright that you cannot see for a short time','He was dazzled by the car\'s headlights.','他被车前灯照花了眼。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (988,'wreck','wreck','/rek/','n. （事故中）遭严重损坏的汽车（飞机等）；沉船，失事船；  v. 破坏，使毁灭','a car, plane, etc. that has been very badly damaged in an accident','The wreck of the plane was left here.','飞机残骸被遗留在这里。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (989,'cut_back','cut back','/kʌt bæk/','phr. 削减',' return in time','She has cut back her studying hours recently. ','她最近减少了学习时间。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (990,'observer','observer','/əbˈzɜːrvər/','n.观察者','a person who watches somebody/something; a person who watches and studies particular events, situations, etc. and is therefore considered to be an expert on them; a person who attends a meeting, lesson, etc. to listen and watch but not to take part','The little boy wants to become a star observer in the future.','这个小男孩以后想成为一名观星者。','','ob加强意义 + serv保持 + er表示人,行为的主动者，做某事的人 → 观察员，观测者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (991,'reject','reject','/rɪˈdʒekt/','v.拒绝','to refuse to accept or consider something; to refuse to love, care for, or give attention to (someone)','She directly rejected marrying him.','她直接拒绝嫁给他。','','re回 + ject投掷，扔 → 扔回来 → reject拒绝',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (992,'erect','erect','/ɪˈrekt/','v.搭建，竖起；建造，建立；  adj.直立的，垂直的','to build something; to put something in position and make it stand vertical','It took him a long time to erect the tent.','搭建这个帐篷用了他很长时间。','','e向外，向上 + rect指领 → erect建立',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (993,'specially','specially','/ˈspeʃəli/','adv. 专门地；特别地','for a particular purpose, person,etc; more than usual or more than other things','The door was specially made for the giraffe.','这个门是专门为长颈鹿做的。','specially made for','special特别的 + ly副词后缀 → specially特别地，专门地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (994,'car','car','/kɑːr/','n. 汽车，小汽车，轿车','a road vehicle with an engine and four wheels that can carry a small number of passengers','There is a green car parked at the side of the road.','路边停着一辆绿色的车。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (995,'dream','dream','/driːm/','n.梦；  v.做梦','to experience a series of images, events and feelings in your mind while you are asleep; to imagine and think about something that you would like to happen','In my dream, I was on a beach in Hawaii.','我在梦里去了夏威夷海滩。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (996,'belief','belief','/bɪˈliːf/','n.信仰；被信仰之物','a feeling of being sure that someone or something exists or that something is true','The rights and wrongs of eating meat are subject to personal beliefs.','吃肉的做法正确与否，取决于个人的信仰。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (997,'supplementary','supplementary','/ˌsʌplɪˈmentri/','adj. 补充的；附加的；  n. 补充者','provided in addition to something else in order to improve or complete it','The milk powder provides the baby with supplementary nutrients.','这种奶粉为婴儿补充营养。','','sup在…下面 + ple满，填满 + ment表示行为结果 + ary表示有...性质的，属于...的，关于...的 → supplementary增补的，补充的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (998,'camper','camper','/ˈkæmpər/','n. 野营者，露营者','','The camper is looking at the lake in front of her.','这个露营者正看着面前的湖泊。','','camp 田野 + er 表示人 → n.露营者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (999,'outer','outer','/ˈaʊtər/','adj.外面的，外层的','on the outside of something; furthest from the inside or centre of something','The outer part of this ball is green.','这个球的外部是绿色的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1000,'policymaker','policymaker','/\'pɒləsɪˌmeɪkə/','n. 决策者，政策制定者','a member of a government department, legislature, or other organization who is responsible for making new rules, laws, etc.','Policymakers have issued a new policy to reduce carbon emissions.','决策者们出台了一项新政策以减少碳排放。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1001,'absent','absent','/ˈæbsənt/','adj.缺席的，不在场的','not in a place because of illness, etc.; not present in something; showing that you are not really looking at or thinking about what is happening around you','What a surprise! The best student is absent from school!','震惊！学霸今天没来学校！','','ab远离的 + sent出现 → 没有出现 → absent缺席的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1002,'refusal','refusal','/rɪˈfjuːzl/','n.拒绝','an act of saying or showing that you will not do, give or accept something','The boy crossed his arms and persisted in his refusal to eat.','小男孩抱紧了双臂，坚决拒绝吃饭。','','re向后，相反 + fus流，泻 + al名词后缀 → 流向相反 → 拒绝',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1003,'mockingbird','mockingbird','/ˈmɑːkɪŋbɜːrd/','n. 嘲鸫属鸣禽','a North American bird that sings loudly and copies the songs of other birds','I woke up to the mockingbird\'s song every morning.','我每天早上都被蓝嘲鸫的歌声叫醒。','the mockingbird\'s song','mock模仿 + ing 表示行为、状态 + bird鸟 → n. 模仿鸟；嘲鸫属鸣禽；蓝嘲鸫（等于mocking thrush）',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1004,'sophomore','sophomore','/ˈsɑːfəmɔːr/','n. 大二年级学生','a student in the second year of a course of study at a college or university','I will be a sophomore this year.','今年我就大二了。','','sopho=soph聪明 ＋ more愚蠢 → 自以为有智慧的愚者 → sophomore大学二年级学生',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1005,'site','site','/saɪt/','n.场所；网站；  vt.给……选址','a place where a building, town, etc. was, is or will be located','Take measurements at the construction site.','去施工现场测量。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1006,'cruel','cruel','/ˈkruːəl/','adj. 残忍的，残酷的','causing pain or suffering','Don\'t be so cruel to me! I\'m just a watermelon!','不要对我这么残忍，我只是一个西瓜！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1007,'plain','plain','/pleɪn/','adj.朴素的，不做修饰的','not decorated or complicated; simple; without marks or a pattern on it','I like plain T-shirts as they are simple and cheap.','我喜欢朴素的T恤，因为它们简单又便宜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1008,'teacher','teacher','/ˈtiːtʃər/','n. 教师，老师，教员','a person whose job is teaching, especially in a school','Our teacher showed us where America and China were in the world.','老师指给我们看了美国和中国在地球上的位置。','','teach教 + er人 → teacher教师',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1009,'champagne','champagne','/ʃæmˈpeɪn/','n. 香槟酒','a French sparkling white wine (= one with bubbles) that is drunk on special occasions','To celebrate, let\'s pop open a bottle of champagne!','我们开一瓶香槟酒来庆祝吧！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1010,'appease','appease','/əˈpiːz/','v.抚慰，安抚；平息','to make somebody calmer or less angry by giving them what they want','The little dog often appeases the big one by offering up his bones.','这只小狗常常献上骨头来防止大狗动怒。','','ap加强 + pease=peace平静 → 平息',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1011,'draft','draft','/dræft/','n.草稿；  v.起草','a rough written version of something that is not yet in its final form','This is just the draft design of a building.','这只是建筑的设计草图。','the draft design','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1012,'pass_sb._(sth.)_by','pass sb. (sth.) by','/pæs ˈsʌmbədi ˈsʌmθɪŋ baɪ/','phr. 错过','pass (time) in a specific way','He didn\'t train hard, and the chance to play in the final passed him by.','他没有刻苦训练，错过了参加决赛的机会。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1013,'analogue','analogue','/ˈænəlɔːɡ/','adj. 有长短针的','something having the property of being analogous to something else','An analogue clock shows the time with hands on a dial rather than digitized numbers.','指针式时钟通过钟面上的指针而非数字形式来显示时间。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1014,'attributable','attributable','/əˈtrɪbjətəbl/','adj.可归因于……的','capable of being attributed','The homelessness of squirrels is attributable to the reduction of forest.','小松鼠之所以无家可归，是因为森林面积的减少。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1015,'exhaustion','exhaustion','/ɪɡˈzɔːstʃən/','n. 筋疲力尽；耗尽，枯竭','the state of being very tired','She suffered from exhaustion.','她感到筋疲力尽。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1016,'species','species','/ˈspiːʃiːz/','n.种类；物种；人类；  adj.物种上的','a class of things of the same kind and with the same name','There are tens of thousands of different species of birds.','世界上有成千上万种各不相同的鸟。','different species of birds','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1017,'radiate','radiate','/ˈreɪdieɪt/','v. 辐射，发出（光或热）','if something radiates heat, light or energy or heat, etc. radiates from it, the heat is sent out in all directions','The sun radiates light and heat towards the earth.','太阳向地球发出光和热。','','radi光线 + ate造成、使之成…… → radiate辐射，（使）从中心发散',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1018,'hang_on_to','hang on to','/hæŋ ɑːn tu/','phr. 紧紧抓住','','The climber hung on to the rock.','攀岩者紧紧抓住了岩石。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1019,'venerable','venerable','/ˈvenərəbl/','adj. 令人尊敬的','people or things deserve respect because they are old, important, wise, etc. a venerable old man','Most teachers are highly venerable, you should show them respect!','很多老师都是令人尊敬的，你们都应该尊敬他们。','','vener=venerate庄严的 ＋ able具有某种性质的 → venerable庄严的，值得尊敬的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1020,'hair','hair','/her/','n.头发，毛发','the substance that looks like a mass of fine threads growing especially on the head; one of these threads growing on the body of people and some animals','The lady has such long smooth hair.','这位女士有一头长而柔顺的秀发。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1021,'traveler','traveler','/ˈtrævələr/','n.旅行者，旅客','someone who is traveling or who travels often','The tour guide led a group of travelers.','导游带领了一群游客。','','travel旅行 + er名词后缀 → traveler旅行者，旅客',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1022,'embody','embody','/ɪmˈbɑːdi/','v. 体现，象征','to express or represent an idea or a quality','The lotus flower embodies purity and integrity.','莲花象征着清白和正直。','','em使…进入状态 + body身体 → 精神进入身体 → embody体现',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1023,'laundry','laundry','/ˈlɔːndri/','n.洗衣；要洗的衣物','clothes, sheets, etc. that need washing, that are being washed, or that have been washed recently','Doing laundry is part of my housework.','我的家务之一是洗衣服。','','laund=launder洗衣 + ry场地 → 洗衣房',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1024,'love','love','/lʌv/','n.爱；  v.爱，喜欢','(not used in the progressive tenses) to have very strong feelings of affection for somebody','You can\'t define the love between two people; you can only feel it.','你无法定义两人之间的爱，你只能去感受。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1025,'pig','pig','/pɪɡ/','n.猪；小猪，野猪；  vt.贪婪地吃','an animal with pink, black or brown skin, short legs, a broad nose and a short tail which curls round itself. Pigs are kept on farms for their meat (called pork) or live in the wild.','What a cute little pig!','多可爱的小猪！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1026,'doggy','doggy','/ˈdɔːɡi/','n. 小狗（=doggie）','informal terms for dogs','These two cute doggies are running together.','这两只可爱的小狗在一起奔跑。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1027,'lure','lure','/lʊr/','v. 以诱饵吸引；  n. 诱惑物','to persuade or trick somebody to go somewhere or to do something by promising them a reward','I lure fish by putting worms on my fishing pole.','我把蠕虫放到鱼钩上做诱饵来钓鱼。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1028,'judicial','judicial','/dʒuˈdɪʃl/','adj.司法的，审判（上）的','connected with a court, a judge or legal judgement','The judge, jury and witnesses are important participants in the judicial system.','法官、陪审团和证人在司法系统中很重要。','','judic判断 + ial形容词后缀 → 法官 → judicial司法的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1029,'wisdom','wisdom','/ˈwɪzdəm/','n.智慧，学问；明智，正确判断','the ability to make sensible decisions and give good advice because of the experience and knowledge that you have; the knowledge that a society or culture has gained over a long period of time','Zhuge Liang is an example of wisdom.','诸葛亮是智慧的榜样。','','wis=wise智慧的 + dom状态或领域 → wisdom智慧',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1030,'aspect','aspect','/ˈæspekt/','n.（问题等的）方面','a particular part or feature of a situation, an idea, a problem, etc.; a way in which it may be considered','This passage is written from three aspects.','这篇文章是从三个方面来写的。','from three aspects','a来，临近 + spect看 → 看的东西 → aspect外表，容貌，形势，方面',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1031,'maternal','maternal','/məˈtɜːrnl/','adj.母亲的，母性的；母方的，母系的','of or relating to a woman who is having a baby','The crazy fans were showing their maternal love for the three boys.','狂热的粉丝们对三个男孩表达了母性般的爱。','','matern母 + al…的 → maternal母亲的，母性的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1032,'prospect','prospect','/ˈprɑːspekt/','n. 前景，展望；  v. 有前途；对……进行仔细调查','the chances of being successful','My job prospects are great.','我的就业前景非常好。','','pro向前，在前 + spect看 → 向前看 → prospect前景',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1033,'mobile_phone','mobile phone','/ˌmoʊbl ˈfoʊn/','n.手机','','I just downloaded the BaiCiZhan app on my mobile phone.','我刚在手机上下载了百词斩App。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1034,'overture','overture','/ˈoʊvərtʃər/','n. 主动表示，姿态，前奏曲，序言，事件的开端，提出问题；  vt. 作为一种主动姿态提出，向…提出建议','a piece of music played at the start of an opera, a musical play, etc.','The curtain was opened as the orchestra played the overture.','随着乐队演奏的前奏曲，帷幕被拉开。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1035,'persuade','persuade','/pərˈsweɪd/','vt.说服，劝说；使相信','to make somebody do something by giving them good reasons for doing it','He is trying to persuade his friend to go on a roller coaster with him.','他正试图说服他的朋友和他一起坐过山车。','','per贯穿，自始至终 + suade劝 → 一直劝 → persuade劝说',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1036,'feverish','feverish','/ˈfiːvərɪʃ/','adj.发烧的；狂热的，极其兴奋的','suffering from a fever; caused by a fever','I touched his forehead; he felt hot and feverish.','我摸了摸他的前额，感到很烫，他应该发烧了。','','fever发烧 + ish...的 → feverish发烧的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1037,'loaf','loaf','/loʊf/','n. 一条（面包）；  v. 虚度光阴','an amount of bread that has been shaped and baked in one piece','I will just eat a loaf of bread for lunch.','午餐我只会吃一个面包。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1038,'refundable','refundable','/rɪˈfʌndəbl/','adj.可退费的','','The locker key deposit is refundable. ','储物柜钥匙的押金是可以退还的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1039,'chronic','chronic','/ˈkrɑːnɪk/','adj.（疾病）慢性的；积习难改的；（问题）顽固的','(especially of a disease) lasting for a long time','He\'s suffering from chronic neck and back pain.','他有慢性脖子痛和背痛。','','chron时间 + ic…的 → 拖长时间的 → 长期的；(疾病)慢性的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1040,'stoop','stoop','/stuːp/','v. 弯腰，俯身；  n. 弯腰','to walk or stand with your head and shoulders bent forward','It is amazing that they could stoop so low.','他们竟然可以把背压得这么低，太惊人了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1041,'see_through','see through','/ˈsiːˌθrʊ/','phr. 看穿，识破','to recognize the truth about an excuse, false statement, etc; not be fooled','He has already seen through the magician\'s trick.','他早已看穿魔术师的把戏。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1042,'obligation','obligation','/ˌɑːblɪˈɡeɪʃn/','n. 义务，责任','the state of being forced to do something because it is your duty, or because of a law, etc.; something which you must do because you have promised, because of a law, etc.','If you want to own a pet, you must fulfill all the associated obligations.','如果你想拥有一只宠物，你就必须履行所有的相关义务。','','obligat使负义务 + ion名词后缀 → 有义务 → obligation责任',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1043,'commuter','commuter','/kəˈmjuːtər/','n.通勤者','a person who travels into a city to work each day, usually from quite far away','The commuter takes a bus and the subway to work and come back every day.','这个通勤者每天搭乘公交和地铁上下班。','','com共同 + mut 改变 + er[名词后缀]做某事的人 → commuter通勤者，经常乘公共车辆往返者；[交] 月季票乘客',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1044,'generous','generous','/ˈdʒenərəs/','adj.慷慨大方的；丰富的','giving or willing to give freely; given freely','The generous man distributes lucky money to us during each Spring Festival.','这个大方的男人每年春节都给我们发红包。','','gener出生，产生 + ous形容词后缀 → [不断]产生 → generous丰富的，慷慨的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1045,'agony','agony','/ˈæɡəni/','n.极大的痛苦','extreme physical or mental pain','The man is in agony when hearing the bad news.','当听到这个坏消息时，这个人陷入了极大的痛苦中。','','agon挣扎 + y表名词 → agony痛苦',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1046,'supply','supply','/səˈplaɪ/','vt.供应，供给；  n.供应（量）；（复数）补给品','an amount of something that is provided or available to be used','The water tower is supplying water for local families.','这座水塔为当地的家庭供水。','','sup在下面 + ply填充，充满 → 填充下去 → 供应[下去]，补给',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1047,'appetite_for','appetite for','/ˈæpɪtaɪt fɔːr/','phr. 对……的欲望','','The little boy has a strong appetite for acquiring knowledge. ','这个小男孩有强烈的求知欲。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1048,'statue','statue','/ˈstætʃuː/','n.雕像','a figure of a person or an animal in stone, metal, etc., usually the same size as in real life or larger','There stands a huge statue in New York city.','一座巨大的雕像坐落在纽约市。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1049,'inclusive','inclusive','/ɪnˈkluːsɪv/','adj.包含……在内的','having the total cost, or the cost of something that is mentioned, contained in the price; including all the days, months, numbers, etc. mentioned; including a wide range of people, things, ideas, etc.','The money he is paying the waiter is inclusive of tips.','他付给服务员的钱里包含了小费。','','in进入 + clus关闭 + ive形容词后缀 → 包括在内的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1050,'marvelous','marvelous','/ˈmɑːrvələs/','adj. 叹为观止的，令人惊奇的；非凡的','extremely good; wonderful','"It is the most marvelous fireworks show!" the girl exclaimed.','“这是最叹为观止的烟花表演！”这个女孩惊叹道。','','marvel奇迹 + ous……的 → marvelous奇迹般的；了不起的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1051,'centigrade','centigrade','/ˈsentɪɡreɪd/','n.摄氏度；  adj.摄氏度的','a scale of temperature in which water freezes at 0° and boils at 100°','The flower grows well at 25 degrees centigrade.','花在25摄氏度的环境下生长得很好。','at 25 degrees centigrade','centi百 + grade级，度 → 百分度的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1052,'adhere','adhere','/ədˈhɪr/','v.黏附；遵守；坚持；附着，粘在……上','to stick firmly to something','I used glue to adhere the poster to the wall.','我用胶水把海报贴在墙上。','','ad做…，加强… + here粘 → 粘在一起 → 坚持',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1053,'Japan','Japan','/dʒəˈpæn/','n. 日本','a country consisting of a group of islands in eastern Asia','In Japan, we can see the beautiful Fuji Mountain.','在日本，我们可以看到美丽的富士山。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1054,'slight','slight','/slaɪt/','adj. 轻微的，微小的；纤细的，瘦弱的；少量的；  n. 轻视，蔑视','very small in degree or amount','There\'s a slight imperfection on this antique teapot.','这个古董茶壶上面有一个小瑕疵。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1055,'reliability','reliability','/rɪˌlaɪəˈbɪləti/','n.可靠性','the quality of being able to be trusted to do what somebody wants or needs','The reliability of the safe is very high.','这个保险箱的可靠性很高。','','reli=rely依靠 + ability 名词后缀，可...性 → reliability可靠性',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1056,'divorce','divorce','/dɪˈvɔːrs/','n. 离婚，离异；  v. 离婚','the legal ending of a marriage; a separation; the ending of a relationship between two things','The couple have agreed to get a divorce.','这对夫妻已经同意离婚了。','','di使…变成、分开 + vorce=vert转 → 从丈夫身边转开 → 离婚',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1057,'uneasy','uneasy','/ʌnˈiːzi/','adj.心神不宁','feeling worried or unhappy about a particular situation, especially because you think that something bad or unpleasant may happen or because you are not sure that what you are doing is right; not certain to last; not safe or settled; that does not enable you to relax or feel comfortable','The man playing Mahjong felt uneasy when he got a phone call from his wife.','这个正在打麻将的男人接到老婆的电话，感到心神不宁。','','un不 + eas放松 + y形容词后缀 → uneasy心神不安的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1058,'go_back_on','go back on','/ɡoʊ bæk ɑːn/','phr. 违背',' fail to fulfill a promise or obligation','He went back on his promise to his son.','他违背了对自己儿子的承诺。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1059,'get_in','get in','/ɡet ɪn/','phr. 进入','to arrive at a place; to win an election','Shut the door! Smoke is getting in.','快把门关上！烟进来了！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1060,'tape_recorder','tape recorder','/ˈteɪp rɪkɔːrdər/','phr. 磁带录音机','a machine used to record and play sound on magnetic tape','Have you ever used a tape recorder?','你用过盒式录音机吗？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1061,'condom','condom','/ˈkɑːndəm/','n. 安全套，避孕套','a thin rubber covering that a man wears over his penis during sex to stop a woman from becoming pregnant or to protect against disease','Don\'t forget to wear condoms before having sex.','进行性行为之前，请记得戴上安全套。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1062,'pull_on','pull on','/pʊl ɑːn/','phr.穿','','He pulled on his jeans and ran downstairs to answer the door.','他穿上牛仔裤跑下楼去开门。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1063,'wound','wound','/wuːnd/','n.伤口；  vt.伤害','an injury that is caused when a knife, bullet, etc., cuts or breaks the skin','She has a small wound on her knee.','她膝盖上有一个小伤口。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1064,'acceleration','acceleration','/əkˌseləˈreɪʃn/','n. 加速；促进；加速度','an increase in how fast something happens; the rate at which a vehicle increases speed; the rate at which the velocity (= speed in a particular direction) of an object changes','The car has great acceleration out of corners.','这辆车弯道加速很快。','','ac再 + celer加速 + ation名词后缀 → 再次加速 → acceleration加速',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1065,'be_similar_to','be similar to','/bi ˈsɪmɪlər tu/','phr. 和……相似','almost the same','The two girls are so similar to each other.','这两个女孩看起来很相似。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1066,'hygiene','hygiene','/ˈhaɪdʒiːn/','n. 卫生；卫生学；保健学','the practice of keeping yourself and your living and working areas clean in order to prevent illness and disease','Hands should be washed with soap to improve hygiene.','为了更卫生，洗手的时候应该用肥皂。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1067,'trousers','trousers','/ˈtraʊzərz/','n. 裤子','a piece of clothing that covers the body from the waist down and is divided into two parts to cover each leg separately','She wears a pair of yellow trousers.','她穿了一条黄色的裤子。','a pair of yellow trousers','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1068,'focus','focus','/ˈfoʊkəs/','n.焦点；  v.集中','a point or distance at which the outline of an object is clearly seen by the eye or through a lens','Make sure your subject is in focus before taking the photo.','拍照前你要确保拍摄对象已对焦。','in focus','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1069,'clinical','clinical','/ˈklɪnɪkl/','adj.临床的；冷漠的','relating to the examination and treatment of patients and their illnesses','The new drug is undergoing clinical trials.','这种新药正在进行临床试验。','clinical trials','clinic诊所 + al……的 → 临床的；诊所的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1070,'feminist','feminist','/ˈfemənɪst/','n.男女平等主义者，女权扩张论者；  adj.主张男女平等的，女权主义的','a person who supports the belief that women should have the same rights and opportunities as men','Feminists call for equal rights for women and girls.','女权主义者呼吁女性应当享有平等的权利。','','femin=femine女性的 ＋ ist信仰者，专家 → feminist女权主义者',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1071,'drawer','drawer','/drɔːr/','n.抽屉','a box that slides into and out of a piece of furniture (such as a desk) and that is used to store things','Remember to keep all your files in the drawer.','记得把你的所有文件都放在抽屉里。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1072,'take_priority_over','take priority over','/teɪk praɪˈɔːrəti ˈoʊvər/','phr. 优先','deal with the most important thing first','For a foodie, eating gourmet food takes priority over anything else.','对一个吃货来说，美食高于一切。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1073,'fund','fund','/fʌnd/','n.资金，基金；  v.拨款，提供资金','an amount of money that is used for a special purpose; money on deposit on which checks or drafts can be drawn','These coins are my holiday fund.','这些零花钱是我的假日基金。','','fund基础，创办事业的基础 → 底子，本钱 → fund基金',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1074,'nibble','nibble','/ˈnɪbl/','v. 一点点地咬，慢慢啃，吹毛求疵；  n. 细咬，轻咬，啃','to eat slowly or with small bites','The bulldog puppy is nibbling on the toy.','那只小斗牛犬在咬玩具，多可爱啊！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1075,'badminton','badminton','/ˈbædmɪntən/','n. 羽毛球；羽毛球运动','a game like tennis played by two or four people, usually indoors. Players hit a small light kind of ball, originally with feathers around it (= a shuttlecock) across a high net using a racket.','These kids are playing badminton in the park.','小孩子们在公园打羽毛球。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1076,'violinist','violinist','/ˌvaɪəˈlɪnɪst/','n.小提琴演奏者，小提琴家','a person who plays the violin','The young violinist impressed us with his great talent.','这位年轻的小提琴家以其极高的天赋给我们留下了深刻的印象。','','violin小提琴 + ist从事某种职业的人 → violinist小提琴手',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1077,'lately','lately','/ˈleɪtli/','adv.最近','recently; in the recent past','Lately, the temperature keeps going above 40°C.','最近的气温一直超过40摄氏度。','','late最近的 + ly……地 → lately最近，不久前',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1078,'basically','basically','/ˈbeɪsɪkli/','adv. 基本上；主要地','used when you are giving your opinion or stating what is important about a situation','Basically, all the students are depressed during a hard English examination.','在这场困难的英语考试中，基本上所有学生都很郁闷。','','basic基础的 + ally……地 → basically基本上',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1079,'as_a_rule','as a rule','/æz ə rʊl/','phr.通常','','As a rule, he tries to call his mom at 8 pm every day.','通常情况下，他每天晚上8点给妈妈打电话。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1080,'bedside','bedside','/ˈbedsaɪd/','n. 床边','space by the side of a bed (especially the bed of a sick or dying person)','There are two books on the bedside table.','床头柜上有两本书。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1081,'positive','positive','/ˈpɑːzətɪv/','adj.积极的；  n.正极','thinking about what is good in a situation: feeling confident and sure that something good will happen; completely sure that something is correct or true; directed at dealing with something or producing a successful result; showing clear evidence that a particular substance or medical condition is present','You\'d better be positive rather than negative about things.','你最好积极地看待事物，不要消极。','','posit肯定 + ive形容词后缀 → positive肯定的；积极的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1082,'alarm','alarm','/əˈlɑːrm/','n.警报器，警报；  v.使惊恐，使忧虑','a device that warns people of a particular danger; a loud noise or a signal that warns people of danger or of a problem','The police car turned on the alarm as it passed by here.','警车路过时，打开了警报器。','turned on the alarm','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1083,'equal','equal','/ˈiːkwəl/','adj.平等的；相等的；  v.比得上；  n.同等的人','having the same rights or being treated the same as other people, without differences such as race, religion or sex being considered','Today, men and women are equal in the eyes of the law.','如今，男女在法律面前是平等的。','','equ相等，平均 + al形容词后缀 → 相等的，平等的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1084,'subscription','subscription','/səbˈskrɪpʃn/','n.订阅；捐款；签署；同意；会费','an amount of money you pay, usually once a year, to receive regular copies of a newspaper or magazine, etc.; the act of paying this money','He paid for an annual subscription to his favorite magazine.','他为自己最喜欢的杂志付了一年期的订阅费。','subscription to','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1085,'nothing_to_do_with','nothing to do with','/ˈnʌθɪŋ tu doʊ wɪθ/','v. 与…无关','be unconcerned about','The little boy told his mother that he had nothing to do with the broken vase.','小男孩告诉妈妈，花瓶碎了与他与关。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1086,'whirl','whirl','/wɜːrl/','v. 回旋；  n. 一个接一个的活动','to move, or make somebody/something move, around quickly in a circle or in a particular direction','The water whirled in the river.','河里的水在不停地打转儿。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1087,'mock','mock','/mɑːk/','v.嘲笑；轻蔑，蔑视；  adj.不真诚的；伪造的；  n.模拟考试','to laugh at somebody/something in an unkind way, especially by copying what they say or do','The big dog crawled on its belly, mocking the Corgi\'s short legs.','那条大狗在地上爬着走，嘲笑柯基的短腿。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1088,'fee','fee','/fiː/','n.费用；服务费，报酬','an amount of money that you pay for professional advice or services','He was shocked by the huge amount of hidden fees behind such a haircut.','他被这个发型背后巨额的隐形费用惊呆了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1089,'make_light_of','make light of','/meɪk laɪt ɑv/','v. 轻视','regard with contempt','The swimmer made light of the hazardous situation that had happened in the water.','游泳者对刚才水中所发生的危急情况轻描淡写。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1090,'bent','bent','/bent/','adj.弯曲的；  v.弯腰，弯曲（bend过去式）','having a shape that is changed by bending :not straight','The man is picking out the bent nails from the straight ones.','那个男人正在从一堆钉子中挑出弯曲的钉子。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1091,'numerical','numerical','/nuːˈmerɪkl/','adj. 数字的，用数字表示的','relating to numbers; expressed in numbers','The black keyboard keys are in numerical order.','这些黑色的键盘按键按照数字顺序排列。','','numer数 + ical形容词后缀，…的 → numerical数字的，用数词表示的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1092,'under_the_heel_of','under the heel of','/ˈʌndər ðə hiːl əv/','phr. 被…践踏(支配)','dominated or controlled by','I would never submit to working under the heel of my female boss!','我不会屈服于女上司的践踏！','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1093,'battleground','battleground','/ˈbætlɡraʊnd/','n. 战场','a place where a battle is fought','A soldier stands alone on the smoky battleground.','一个士兵孤零零地站在硝烟弥漫的战场上。','','battle战斗 + ground场地 → battleground战场',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1094,'lounge','lounge','/laʊndʒ/','n. 候机室，休息室，酒吧间；懒散的步子；  v. （懒散地）倚，躺','to stand, sit or lie in a lazy way','People sit in the lounge waiting for boarding.','人们坐在候机室里等待登机。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1095,'festive','festive','/ˈfestɪv/','adj. 庆祝的，喜庆的，欢乐的，节日似的','cheerful and exciting :suited to a celebration or holiday','The festive atmosphere was enhanced by the brilliant firework display.','绚丽烟花的绽放增强了节日的喜庆气氛。','The festive atmosphere','fest节目+ive...的 → 表演节目的日子 → 节日 → 节日的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1096,'slide','slide','/slaɪd/','v.滑落；使滑动；  n.幻灯片','to move easily over a smooth or wet surface; to make something move in this way','The little girl is having fun sliding down quickly into the water.','小女孩快速滑落到水中，玩得很开心。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1097,'brow','brow','/braʊ/','n. 眉，眉毛','the arch of hair above each eye','She is painting her eye brows.','她正在画眉毛。','eye brows','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1098,'the_day_after_tomorrow','the day after tomorrow','/ðə deɪ ˈæftər təˈmɔːroʊ/','phr. 后天','the third day from today','Today is December 23rd; the day after tomorrow will be Christmas.','今天是12月23日，后天就是圣诞节了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1099,'get_up','get up','/ɡet ʌp/','phr. 起床','to get out of bed; to make somebody get out of bed','I usually get up at 7 o\'clock in the morning.','我通常早上7点钟起床。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1100,'rocky','rocky','/ˈrɑːki/','adj.岩石的，多岩石的；磐石般的','made of rock; full of rocks; difficult and not certain to continue or to be successful','The lighthouse sits on a very rocky shore.','灯塔坐落在岩石海岸上。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1101,'down','down','/daʊn/','adv. 向下，在下面；  n. 绒毛，汗毛','to or at a lower place or position','The mother is walking down the stairs with her daughter.','这位母亲正和女儿一起走下楼梯。','walking down','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1102,'somewhere','somewhere','/ˈsʌmwer/','pron.某个地方；  adv.到某处，在某处','in, at or to a place that you do not know or do not mention by name','He is searching for somewhere to take a holiday.','他正在寻找度假的地方。','','some某个 + where哪里 → somewhere在某处',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1103,'curiosity','curiosity','/ˌkjʊriˈɑːsəti/','n.好奇心','a strong desire to know about something','Curiosity drives the cat to see what it is in the box.','好奇心驱使这只猫去看盒子里是什么。','','curi关心 + osity多的状态 → 关心多 → 好奇心',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1104,'illicit','illicit','/ɪˈlɪsɪt/','adj. 违法的，违禁的','not allowed by law :unlawful or illegal','The police found and seized the illicit drugs.','警察查获并收缴了违禁药品。','','il不 ＋ lic法律，允许 ＋ it抽象名词 → 不允许 → illicit不合法',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1105,'antagonism','antagonism','/ænˈtæɡənɪzəm/','n.对抗，敌对','a strong feeling of dislike or hatred :a desire to oppose something you dislike or disagree with','There was a lot of antagonism between the competitors before the boxing match.','拳击比赛开始前，双方的敌对情绪已经很明显了。','antagonism between','antagon反抗+ism表示“具备某种牲质” →对抗性',4,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1106,'steal','steal','/stiːl/','v.偷盗；  n.便宜货','to take (something that does not belong to you) in a way that is wrong or illegal; to move secretly and quietly so that other people do not notice you','The thief is trying to steal his wallet.','小偷正试图偷他的钱包。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1107,'skipping_rope','skipping rope','/ˈskɪpɪŋ roʊp/','n. （跳绳用）绳','a piece of rope, usually with a handle at each end, that you hold, turn over your head and then jump over, for fun or to keep fit','My skipping rope keeps me fit!','跳绳帮助我保持身材。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1108,'aquarium','aquarium','/əˈkweriəm/','n. 水族馆，水族箱，鱼缸','a glass or plastic container in which fish and other water animals and plants can live','People go to the aquarium to see sea animals.','人们去水族馆看海洋动物。','','aqu=aqua水 + arium表场所 → aquarium水族馆',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1109,'parade','parade','/pəˈreɪd/','n.游行；检阅；  v.游行，（使）列队行进；炫耀','a public celebration of a special day or event, usually with bands in the streets and decorated vehicles; a formal occasion when soldiers march or stand in lines so that they can be examined by their officers or other important people','The New Year parade in Chinatown is always a popular event.','在唐人街举办的新年大游行总是受人欢迎。','','par看见 + ade集体 → 集体出现 → parade游行',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1110,'willpower','willpower','/ˈwɪlpaʊər/','n. 意志力，自我克制力','the ability to control your thoughts and actions in order to achieve what you want to do','This time I have the willpower to stick to my diet!','这次我下定决心要坚持节食。','','will意愿 + power力量 → 意志力',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1111,'rebound','rebound','/rɪˈbaʊnd/','v. 弹回，恢复，振作；  n. 弹回，重新振作，回应','to bounce back after hitting something','The ball rebounded from the tree and hit me.','球从树上回弹后打到了我。','rebounded from the tree','re回，向后 ＋ bound弹跳 → rebound弹回，跳回',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1112,'bureaucrat','bureaucrat','/ˈbjʊrəkræt/','n.官僚，官僚主义者','an official working in an organization or a government department, especially one who follows the rules of the department too strictly','The cat\'s request had to go through so much red tape designed by the bureaucrats.','这只猫的请求不得不经过官僚们规定的烦琐手续。','','bureau局 + crat统治 → bureaucrat官僚',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1113,'gold_medal','gold medal','/ˌɡoʊld ˈmedl/','phr. 金牌','a medal made of gold that is awarded as the prize for first place in a sports competition','I won the race, and I have a gold medal to prove it!','我赢得了这场比赛，我有金牌作证！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1114,'dragon','dragon','/ˈdræɡən/','n.龙；凶恶的女人','(in stories) a large aggressive animal with wings and a long tail, that can breathe out fire; a woman who behaves in an aggressive and frightening way','Look! This dragon can breathe fire!','看，这条龙会喷火！','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1115,'audit','audit','/ˈɔːdɪt/','v. 审计，查账；旁听；  n. 审计；查帐','to officially examine the financial accounts of a company','My main job is to audit the account every day.','我每天的主要工作就是审计账目。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1116,'morbid','morbid','/ˈmɔːrbɪd/','adj. （精神等）病态的','relating to unpleasant subjects (such as death)','The man with a morbid curiosity about ghosts planned to buy the "haunted" house.','那个人对鬼魂有着病态的好奇心，他计划买下这座“闹鬼”的房子。','','morb死 ＋ id形容词后缀 → 像死一样 → morbid疾病的，不健康的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1117,'tall','tall','/tɔːl/','adj. 身材高的，高大的','(of a person, building, tree, etc.) having a greater than average height','How did you grow so tall?','你是怎么长到这么高的？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1118,'compromise_between','compromise between','/ˈkɑːmprəmaɪz bɪˈtwiːn/','n. ... 之间的折衷办法','','The child made a compromise between what he wanted and what his mother wanted.','这个孩子在自己的意愿和他妈妈的要求之间找到了一个折中点。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1119,'spout','spout','/spaʊt/','v. 滔滔不绝地讲；  n. 水龙卷','to speak a lot about something; to repeat something in a boring or annoying way','My teacher spouted nonsense during the lesson.','我老师上课时滔滔不绝地讲废话。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1120,'shopper','shopper','/ˈʃɑːpər/','n. 购物者','someone who visits stores in search of articles to buy','This shopper has a cart full of vegetables.','这位购物者的购物车里满是蔬菜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1121,'arbitration','arbitration','/ˌɑːrbɪˈtreɪʃn/','n. 仲裁，公断','the official process of settling an argument or a disagreement by somebody who is not involved','If you can\'t reach an agreement, you can go to arbitration to solve the dispute.','如果你们双方就这件事不能达成一致，你们可以通过仲裁来解决这个纠纷。','','arbitr判断+ation行为 →arbitration仲裁',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1122,'plane','plane','/pleɪn/','n.飞机；平面；  v.刨平','a vehicle that has wings and an engine and can carry people or things in the air','The plane is taking off at sunset.','飞机在日落时分起飞。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1123,'volume','volume','/ˈvɑːljuːm/','n. 音量','the amount of sound that is produced by a television, radio, etc.','I turned the volume up to hear the radio.','我把收音机音量调大来听广播。','turned the volume up','vol旋转，卷 + ume表物 → 卷起来的东西 → volume卷，册',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1124,'candle','candle','/ˈkændl/','n. 蜡烛','a round stick of wax with a piece of string (called a wick ) through the middle which is lit to give light as it burns','The candles are lit to give light in the dark.','这些蜡烛被点燃了，在黑暗中散发着光芒。','','cand发光 + le表物体 → 发光的物体 → 蜡烛',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1125,'hardship','hardship','/ˈhɑːrdʃɪp/','n.艰难，困苦','a situation that is difficult and unpleasant because you do not have enough money, food, clothes, etc.','He\'s currently suffering severe financial hardship.','他当下正面临着严重的经济困难。','','hard艰难的 + ship表情况 → 苦难',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1126,'immediate','immediate','/ɪˈmiːdiət/','adj.立即的','happening or done without delay','This letter demands my immediate response.','这封信需要我立即回复。','','im不 + mediate间接的 → immediate直接的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1127,'glitter','glitter','/ˈɡlɪtər/','v.闪闪发光，闪耀；  n.灿烂的光辉，闪光','to shine brightly with little flashes of light, like a diamond; (of the eyes) to shine brightly with a particular emotion, usually a strong one','Look at the crystal chandelier glittering. It\'s so beautiful!','看那闪闪发光的水晶吊灯，真是太美了！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1128,'connection_between','connection between','/kəˈnekʃn bɪˈtwiːn/','phr.……之间的联系','','There\'s a strong connection between food and health.','食物和健康之间有着强烈的联系。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1129,'aid','aid','/eɪd/','n.救护；  v.援助，帮助','help that is given to a person','The blind man walks with the aid of a guide dog.','那个盲人在导盲犬的帮助下走路。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1130,'virgin','virgin','/ˈvɜːrdʒɪn/','n. 处女；贞女；  adj. 处女的','a person who has never had sex','This tropical forest is a virgin land.','这个热带森林是一片处女地。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1131,'set','set','/set/','n.一套，一副，一批；  v.（小心地）放置；建立，设立，树立；调整好；（故事等）以……为背景','a group of similar things that belong together in some way','Many girls own a set of makeup.','很多女孩子有成套的化妆品。','a set of','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1132,'anyhow','anyhow','/ˈenihaʊ/','adv.不论用何种方法，无论如何；尽管如此','despite something; even so','Someone has to wash the dishes anyhow, so I\'ll do it.','反正得有人洗碗，那就我洗吧。','','any无论 + how怎么 → 无论如何 → anyhow无论如何',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1133,'fruit','fruit','/fruːt/','n.水果；成果，产物；  v.结果实','(of a tree or plant) to produce fruit','A basket of fresh fruits is on the wooden table.','木桌上放了一篮新鲜水果。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1134,'overrun','overrun','/ˈoʊvərʌn/','n. 泛滥成灾；超出限度；  v. （侵略军）横行','too much production or more than expected','There was a lot of overrun from the heavy rain.','大雨造成了水灾泛滥。','overrun from the heavy rain','over过度+run扩散→泛滥成灾；超出限度',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1135,'mainland','mainland','/ˈmeɪnlænd/','n.大陆；  adj.大陆的','the main area of land of a country, not including any islands near to it','This map of Africa shows both the mainland and an island.','这张非洲地图展示了非洲大陆和一个岛屿。','','main主要的 + land陆地 → mainland大陆',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1136,'fuel','fuel','/ˈfjuːəl/','n. 燃料；  v. 给……加燃料','a thing that is said or done that makes something, especially an argument, continue or get worse','We use many different types of fuel in everyday life.','日常生活中，我们会使用到多种不同类型的燃料。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1137,'lantern','lantern','/ˈlæntərn/','n. 灯笼','a light that has usually a glass covering and that can be carried by a handle','We put up many yellow lanterns.','我们挂起了很多黄色的灯笼。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1138,'wither','wither','/ˈwɪðər/','v. 枯萎，凋谢；使畏缩','if a plant withers or something withers it, it dries up and dies','The sunflowers in the field have withered in the sun.','地里的向日葵在太阳下枯萎了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1139,'riding','riding','/ˈraɪdɪŋ/','n.骑马','riding a horse as a sport','The two women are going riding through the forest.','那两位女士正在森林里骑马。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1140,'surge','surge','/sɜːrdʒ/','vi.汹涌；激增；  n.波涛汹涌','to move very quickly and suddenly in a particular direction','The water surges over the road.','水汹涌着淹没了路面。','surges over','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1141,'dizziness','dizziness','/ˈdɪzinəs/','n. 头晕；头昏眼花','the feeling that everything is spinning around you and that you are not able to balance','My dizziness is so bad, I want to lie down, or maybe vomit.','我头晕很严重，我想躺下，或者呕吐。','','dizzi=dizzy头晕的 + ness表名词，性质，状态 → dizziness头晕；头昏眼花',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1142,'symmetry','symmetry','/ˈsɪmətri/','n. 对称；均衡','the exact match in size and shape between two halves, parts or sides of something','The building has perfect symmetry.','这座建筑具有完美的对称性。','','sym共同，相同 + metry测量 → 两边测量一样 → symmetry对称',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1143,'help...out','help...out','/help aʊt/','phr. 帮助某人解决困难','help; aid; assist; assistance','He couldn\'t lift the bucket, so his friend helped him out.','他提不起这个桶，所以他的朋友帮了他。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1144,'humankind','humankind','/ˌhjuːmənˈkaɪnd/','n.(总称)人类','all of the inhabitants of the earth','Protecting the Earth is the responsibility of all humankind.','保护地球是全人类的责任。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1145,'sustain','sustain','/səˈsteɪn/','v. 维持；支撑，承受','to support a weight without breaking or falling','These four columns sustain the entire building.','这四根柱子支撑着整座建筑物。','','sus在…下面 + tain握住 → 在下面握住 → 支撑，承受',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1146,'desirability','desirability','/dɪˌzaɪərəˈbɪləti/','n. 合意性','the quality of being worthy of desiring','As the number of charge stations for electric cars increases, so does their desirability.','随着电动汽车充电站数量的增加，电动汽车也更受欢迎了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1147,'orbit','orbit','/ˈɔːrbɪt/','vt.沿轨道运行，环绕……运行；  n.轨道','to move in an orbit (= a curved path) around a much larger object, especially a planet, star, etc.','All of our planets orbit the sun.','（在太阳系里）所有行星都环绕太阳运行。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1148,'democracy','democracy','/dɪˈmɑːkrəsi/','n. 民主制度；民主国家；民主主义；民众','a system of government in which all the people of a country can vote to elect their representatives','Under the policy of democracy, everyone has the right to vote.','在民主制度的体制下，每个人都有投票的权利。','','demo人民 + cracy统治 → democracy民主政治',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1149,'live_on','live on','/liːv ɑːn/','phr. 以…为主食','continue to live; endure or last','Many Chinese people live on a diet of rice.','许多中国人以米饭为主食。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1150,'teahouse','teahouse','/\'tiːˌhaʊs/','n. 茶室，茶馆','a restaurant where tea and light meals are available','There are many teahouses in Chengdu.','成都有很多茶馆。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1151,'reside','reside','/rɪˈzaɪd/','v. 居住','to live in a particular place','This type of crab resides inside shells.','寄居蟹住在贝壳里面。','','re再 + side坐 → 再坐之地 → reside居住',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1152,'applaud','applaud','/əˈplɔːd/','v.鼓掌；向…鼓掌表示赞赏','to strike the hands together over and over to show approval or praise','We start to applaud when she stands up to speak.','当她站起来准备说话的时候，我们开始鼓掌。','start to applaud','ap使 + plaud鼓掌 → applaud鼓掌；喝彩',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1153,'gorgeous','gorgeous','/ˈɡɔːrdʒəs/','adj.非常漂亮的；（衣服或色彩）华丽的；令人愉快的，引人入胜的','(of colours, clothes, etc.) with very deep colours; impressive','A gorgeous woman is lying in the flowers.','一位美丽的女子躺在群花之中。','','gorge峡谷 + ous……的 → 峡谷显得绚丽 → gorgeous绚丽的；极好的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1154,'for_the_moment','for the moment','/fər ðə ˈmoʊmənt/','n. 暂时',' temporarily','He doesn\'t want any tea for the moment.','他现在暂时不想喝茶。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1155,'anticipate','anticipate','/ænˈtɪsɪpeɪt/','v.期待；提早（做）','to expect something','I anticipate him winning the first prize as he is really great!','我期待他能得第一！因为他真的很棒！','','anti前面 + cip抓 + ate动词后缀 → 开始抓 → anticipate预料；预期的',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1156,'frequency','frequency','/ˈfriːkwənsi/','n.频率；频繁','the rate at which a sound or electromagnetic wave vibrates (= moves up and down)','The sounds had a high frequency.','这声音的频率很高。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1157,'departure','departure','/dɪˈpɑːrtʃər/','n.离开','the act of leaving a place; an example of this; a plane, train, etc. leaving a place at a particular time','His departure from home made his family sad.','他离开了家，这使其家人感到悲伤。','','depart出发 + ure名词后缀 → departure离开，出发',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1158,'climb','climb','/klaɪm/','v.攀登，爬；  n.攀爬，土坡','to go up something towards the top; to move somewhere, especially with difficulty or effort; to go up mountains or climb rocks as a hobby or sport; to go higher in the sky','I don\'t think I could climb that mountain.','我觉得我攀不上这座山。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1159,'swift','swift','/swɪft/','adj.敏捷的；  n.雨燕','happening or done quickly and immediately; doing something quickly','This is the swiftest land animal by far.','这是目前陆地上最敏捷的动物。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1160,'henceforth','henceforth','/ˌhensˈfɔːrθ/','adv.今后，此后','from this time forth; from now on','Sadly, the man was henceforth terrified of ropes.','令人遗憾的是，这个男人从此非常害怕绳子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1161,'aware','aware','/əˈwer/','adj.意识到的，察觉到的','interested in and knowing about something, and thinking it is important','He suddenly became aware of how to figure out the problem.','他突然知道该怎么解决这道难题了。','became aware of','a使 + ware注视 → aware意识到的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1162,'ground','ground','/ɡraʊnd/','n.地面','the surface of the earth','The man is lying on the ground.','这个男人正躺在地上。','on the ground','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1163,'technician','technician','/tekˈnɪʃn/','n. 技术员，技师','a person whose job is keeping a particular type of equipment or machinery in good condition','We brought the technician in to repair our computers.','我们把技术员叫来修电脑。','','techn技术 + ician表专家，从事某职业的人 → technician技术员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1164,'along','along','/əˈlɔːŋ/','prep.沿着；  adv.一起','in a line matching the length or direction of (something)','She walked along the road for a long time.','她沿着马路走了很久。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1165,'regenerate','regenerate','/rɪˈdʒenəreɪt/','v. 新生，再生，使革新；  adj. 改过自新的，新生的','(biology) to grow again; to make something grow again','Under the right conditions, even a plant that seems dead may regenerate itself.','在合适的条件下，即使是看起来快要死亡的植物也能重新生长。','regenerate itself','re一再，重新+gener产生+ate形容词后缀→重新产生生命→改过自新的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1166,'voltage','voltage','/ˈvoʊltɪdʒ/','n. 电压','electrical force measured in volts','“Be careful, this machine has a high voltage.”','“小心，这台机器带高压电。”','','volt电压 + age表示集合名词、总称 → voltage电压',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1167,'if','if','/ɪf/','conj. 如果，假使','used to say that one thing can, will or might happen or be true, depending on another thing happening or being true','If it is a sunny day, I will go out.','如果这是一个晴天，我就出去玩。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1168,'abolish','abolish','/əˈbɑːlɪʃ/','v. 废除，废止','to officially end a law, a system or an institution','In the mid 1800s, slavery was abolished in America.','19世纪中期，美国废除了奴隶制。','','abol消除 + ish动词后缀 → abolish废除',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1169,'discourage','discourage','/dɪsˈkɜːrɪdʒ/','vt.阻止；使...泄气，失去信心','to try to prevent something or to prevent somebody from doing something, especially by making it difficult to do or by showing that you do not approve of it','The bad weather discouraged her from having a picnic.','这糟糕的天气使她不能外出野餐。','','dis除去，取消 + courage勇气 → discourage使失去勇气',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1170,'shove','shove','/ʃʌv/','v. 推；猛推；  n. 推搡','to push somebody/something in a rough way','I don\'t think you\'ll move that brick wall no matter how hard you shove it.','无论你用多大力气去推那堵墙，我都觉得你推不动它。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1171,'notoriously','notoriously','/noʊˈtɔːriəsli/','adv. 众所周知地，恶名昭彰地，声名狼藉地','in a way that is well known for being bad','The celebrity is notoriously known for tax evasion.','这位名人因逃税而臭名昭著。','','notorious臭名昭著的 ＋ ly表示如...的、有...特征的、属于...的 → notoriously众所周知地；声名狼藉地；恶名昭彰地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1172,'Jewish','Jewish','/ˈdʒuːɪʃ/','adj. 犹太人的','connected with Jews or Judaism; believing in and practising Judaism','Both Marx and Einstein were Jewish.','马克思和爱因斯坦都是犹太人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1173,'turbulence','turbulence','/ˈtɜːrbjələns/','n.（空气或水的）乱流；骚乱，动荡','a series of sudden and violent changes in the direction that air or water is moving in','The plane is experiencing severe turbulence during the flight.','飞机在飞行时遇到了强烈的气流。','experiencing severe turbulence','turbu骚乱 + l + ence状态 → turbulence骚乱',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1174,'measurable','measurable','/ˈmeʒərəbl/','adj. 可测量的；重要的，重大的','that can be measured; [usually before noun] large enough to be noticed or to have a clear and noticeable effect','Her annual change in height is measurable.','她每年的身高变化都是可测量的。','','measur=measure测量 + able...的 → measurable可测量的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1175,'attract','attract','/əˈtrækt/','v.吸引','if you are attracted by something, it interests you and makes you want it; if you are attracted by somebody, you like or admire them; to make somebody/something come somewhere or take part in something; to make people have a particular reaction','This dog attracts many people to the fruit stall.','这只狗吸引了很多人来这个水果摊。','','at一再 + tract拉 → 拉过来 → attract吸引',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1176,'moist','moist','/mɔɪst/','adj. （表面）潮湿的，湿润的','slightly wet','The grass is moist due to last night\'s heavy rain.','因为昨晚的大雨，草地湿漉漉的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1177,'heroic','heroic','/həˈroʊɪk/','adj. 英勇的；英雄的','showing extreme courage and admired by many people; of or relating to heroes','An ordinary man may also make a heroic move.','一个普通人也能做出英勇的举动。','a heroic move','hero英雄 + ic形容词后缀 → heroic英雄的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1178,'exterminate','exterminate','/ɪkˈstɜːrmɪneɪt/','v. 消灭，灭绝，根除','to destroy or kill (a group of animals, people, etc.) completely','This spray will exterminate all your cockroaches.','这喷雾可以消灭所有的蟑螂。','exterminate all your cockroaches','ex 出去+ termin 界限+ ate 表示做、造成→exterminate消除',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1179,'awful','awful','/ˈɔːfl/','adj.糟糕的，讨厌的；可怕的，极坏的','extremely unpleasant, shocking, or bad','This fish smells awful. Take it away!','这条鱼的气味太糟糕了，快把它拿走！','smells awful','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1180,'networking','networking','/ˈnetwɜːrkɪŋ/','n.人际网，联网','forming business connections and contacts through informal social meetings; computing the interconnection of two or more networks in different places meetings.','Having skills in networking will help you find jobs or clients.','拥有建立人际网的技巧可以帮助你找到工作或是寻找客户。','','net网+work 操作+ing → networking人际网',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1181,'comet','comet','/ˈkɑːmət/','n. 彗星','a mass of ice and dust that moves around the sun and looks like a bright star with a tail','The comet is approaching the sun.','彗星正在向太阳靠近。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1182,'break_into','break into','/breɪk ˈɪntʊ/','phr. 闯入，碰到，发现','','The thief was arrested for breaking into a car.','这个小偷因橇车而被捕。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1183,'phoenix','phoenix','/ˈfiːnɪks/','n. 凤凰；死而复生的人','a magical bird in ancient stories that lives for 500 years before it burns itself to death and then is born again from its ashes','The phoenix is reborn out of the fire from its own egg.','凤凰伴随着火焰从自己的蛋里重生。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1184,'glorify','glorify','/ˈɡlɔːrɪfaɪ/','v. 赞美，赞扬，崇拜（神）','(formal) to praise and worship God','He spread his arms and glorified his god.','他张开双臂，赞美他的神。','','glori=glory光荣 + fy变成，做…… → glorify颂扬，夸赞',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1185,'pertain','pertain','/pərˈteɪn/','vi. 有关；适合','to relate','Pots, stoves and chopping knives all pertain to cooking.','锅、炉子和菜刀都与烹饪有关。','pertain to','per始终 ＋ tain握住 → 始终拿着 → pertain两者从属，相关',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1186,'depot','depot','/ˈdiːpoʊ/','n. 仓库；航空站；  v. 把……存放在储藏处；  adj. 药性持久的','a place where large amounts of food, goods or equipment are stored','This depot is used for the storage of wooden materials used for building houses.','这个仓库被用来存放修建房屋用的木质材料。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1187,'shred','shred','/ʃred/','v.切成细条，撕成碎片；  n.碎片；少量；毁灭','a long, thin piece cut or torn off of something','She is using the shredder to shred the document.','她正在用碎纸机粉碎文件。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1188,'tender','tender','/ˈtendər/','adj.温柔的；嫩的；柔弱的，脆弱的；  n.煤水车；  vt.提出（希望对方接受的意见等）','kind, gentle and loving','You have to be soft and tender with the baby.','你得对婴儿温柔呵护。','','tend伸，伸出 + er形容词后缀 → 刚伸出的嫩芽 → tender嫩的，柔软的，温柔的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1189,'let_out','let out','/ˈletˌaʊt/','phr. 放出；泄露','to allow to go or run free; release','She opened the door and let out the dogs.','她打开了门，把狗放了出去。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1190,'lack','lack','/læk/','n.缺乏，短缺；  v.缺乏','the state of not having something or not having enough of something','Because of a lack of water, few plants can grow here.','因为缺乏水，植物很难在这儿存活下来。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1191,'gross','gross','/ɡroʊs/','adj.总的，毛重的；  n.总量，总额；  adv.总共地','being the total amount of something before anything is taken away; very unpleasant; very rude','The gross cost for all these things is very high.','这些东西的总成本很高。','gross cost','gross=great大 → gross总共的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1192,'rush','rush','/rʌʃ/','v.冲，奔；匆忙做；  n.冲，急速行进；（交通）繁忙时段','to move or do something very quickly or in a way that shows you are in a hurry','I\'ll have to rush to the canteen; otherwise there\'ll be nothing left.','我得冲向食堂，不然什么吃的都没有了。','rush to the canteen','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1193,'forest','forest','/ˈfɔːrɪst/','n.森林','a large area of land that is thickly covered with trees','The forest looked beautiful when the sun shone through the trees.','当阳光穿过树木时，整个森林看起来美极了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1194,'sign_a_contract_with','sign a contract with','/saɪn ə ˈkɑːntrækt wɪð/','phr. 和……签合同','make an official agreement with','If you think it\'s ok, you can sign a contract with the owner.','如果你觉得可以的话，你可以和户主签合同。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1195,'penny','penny','/ˈpeni/','n.美分','a small British coin and unit of money. There are 100 pence in one pound (£1).','His parents give the little boy a penny a day.','小男孩的父母每天给他一美分。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1196,'jeans','jeans','/dʒiːnz/','n. 牛仔裤','trousers/pants made of strong cotton, especially denim','I bought a pair of short jeans.','我买了一条牛仔短裤。','short jeans','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1197,'despair_of','despair of','/dɪˈspɛr ʌv/','phr. 对……失去希望','','The man lost in the desert despaired of finding water.','在沙漠中迷路的男人对找到水已经不抱希望了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1198,'formulate','formulate','/ˈfɔːrmjuleɪt/','vt.制定，规划（计划、方法等）；系统地阐述','to create or prepare something carefully, giving particular attention to the details','He is formulating a detailed plan for his trip.','他正在为自己的旅行制订一个详尽的计划。','','formul公式，准则 + ate表示做、造成 → formulate构想出（计划、方法等）',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1199,'bit','bit','/bɪt/','n.少量，小片','a small amount or piece of something','He broke the loaf into bits to feed the ducks.','他把面包掰成小块喂鸭子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1200,'entertaining','entertaining','/ˌentərˈteɪnɪŋ/','adj. 令人愉快的','','She found the book very entertaining.','她觉得这本书很有趣。','','entertain愉快 ＋ ing形容词后缀 → entertaining令人愉快的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1201,'convert_to','convert to','/kənˈvɚt tu/','phr. 兑换为','','She converted her euro to American dollars.','她把欧元兑换成了美元。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1202,'informal','informal','/ɪnˈfɔːrml/','adj. 非正式的','casual；without formality or ceremony;','The man on the right is wearing more informal clothing.','右边的男人穿得更随便一点。','informal clothing','in不 + formal正式的 → informal 非正式的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1203,'concentrate_on','concentrate on','/\'kɑːnsənˌtreɪt ɑːn/','phr.聚精会神，集中思想','','Although it\'s noisy, he still manages to concentrate on his work. ','尽管很吵，他仍然可以聚精会神地工作。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1204,'neutralize','neutralize','/ˈnuːtrəlaɪz/','v. 消灭；宣布中立，使中立化','to make ineffective; destroy or counteract the effectiveness, force, disposition, etc. of','The cat\'s advanced weapon neutralized his opponents.','猫的先进武器消灭了他的对手。','','neutr中间，中和 + al……的 + ize动词后缀，……化 → 使中和',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1205,'versatile','versatile','/ˈvɜːrsətl/','adj.多才多艺的','(of a person) able to do many different things; (of food, a building, etc.) having many different uses','He\'s a versatile musician who can play many different instruments.','他是一位多才多艺的音乐家，会演奏多种乐器。','','versat转 + ile…的 → 玩的转 → versatile有才能的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1206,'embed','embed','/ɪmˈbed/','v.把……嵌入','to fix something firmly into a substance or solid object','The craftsman is embedding some precious jewels in the headdress.','这个工匠正在把一些珍贵的宝石镶嵌在这个头饰上。','','em置于…之内 + bed范围；床 → 进入范围 → 安置，嵌于',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1207,'disappointing','disappointing','/ˌdɪsəˈpɔɪntɪŋ/','adj.令人失望的；令人扫兴的','not as good, successful, etc. as you had hoped; making you feel disappointed','I found the contents of my gift to be very disappointing.','当我看到礼物是什么的时候，我感到非常失望。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1208,'betray','betray','/bɪˈtreɪ/','v.背叛；（非故意地）流露','to give information about somebody/something to an enemy','He betrayed his partner by selling the secret documents to others.','他背叛了合作伙伴，把这些秘密文件卖给了其他人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1209,'ownership','ownership','/ˈoʊnərʃɪp/','n.所有权','the fact of owning something','The couple have the certificate to prove their ownership of this house.','房产证可以证明这对夫妻拥有这栋房子的所有权。','','owner所有者 + ship表名词 → ownership所有(权)，所有制',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1210,'be_better_off','be better off','/bi ˈbetər ɑf/','phr. 较富裕','be comfortable','This man is better off now than he used to be.','这个男人现在比他过去要富裕。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1211,'overcoat','overcoat','/ˈoʊvərkoʊt/','n.长大衣','a long coat that is worn to keep a person warm during cold weather','This brown overcoat seems warm.','这件棕色大衣看起来很暖和。','brown overcoat','over在上，在外 + coat衣服 → 在衣服上的衣服 → overcoat外套',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1212,'flatter','flatter','/ˈflætər/','v. 阿谀，使高兴；（肖像等）胜过（真人真物）','to say nice things about somebody, often in a way that is not sincere, because you want them to do something for you or you want to please them','"Thank you for your kind words. I\'m flattered."','“谢谢你的赞美之词。我感到很荣幸。”','','flat吹 + t + er表反复动作→ 不断吹捧 → flatter使满意，奉承',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1213,'edge','edge','/edʒ/','n.（悬崖、峭壁的）边缘；  v.徐徐移动；给……开刃，使锐利','the outside limit of an object, a surface or an area; the part furthest from the centre','The chicken is so afraid when standing on the edge.','站在悬崖边的小鸡感到非常害怕。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1214,'via','via','/ˈvaɪə/','prep.经过，通过','by means of a particular person, system, etc.; through a place','They keep in touch with each other via the internet.','他们通过互联网来保持联系。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1215,'doorway','doorway','/ˈdɔːrweɪ/','n. 门口','an opening into a building or a room, where the door is','That French cafe has a beautiful doorway.','那个法国咖啡馆的门口很漂亮。','','door门 + way路 → doorway门口',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1216,'underlie','underlie','/ˌʌndərˈlaɪ/','v. 成为……的基础；位于……之下','to be the basis or cause of something','What underlay his success today was diligence and hard work.','他今日的成功源于勤奋和努力。','','under下 + lie躺着 → 成为……的基础；位于……之下',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1217,'misgiving','misgiving','/ˌmɪsˈɡɪvɪŋ/','n. 疑虑','a feeling of doubt about something :a feeling that something might not be right or might not work as planned','Many employees expressed misgivings about the method of assessment.','许多员工对考核方式很是担忧。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1218,'fluently','fluently','/ˈfluːəntli/','adv.流利地，流畅地','','The girl has a good memory and can recite the ancient poem fluently.','女孩的记忆力很好，能流利地背诵这首古诗。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1219,'take...into_account','take...into account','/teɪk ˈɪntu əˈkaʊnt/','phr. 把…考虑在内','allow or plan for a certain possibility; concede the truth or validity of something','You should take everything into account when you plan to travel.','计划旅行的时候你应该把所有事情都考虑到。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1220,'out_of_practice','out of practice','/aʊt əv ˈpræktɪs/','phr. 久不练习',' impaired in skill by neglect','He has not played the piano for years, so he\'s really out of practice. ','因为多年不弹钢琴，他的技艺已经生疏了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1221,'curl','curl','/kɜːrl/','n. 卷毛，卷发；  v. 使卷曲','a small bunch of hair that forms a curved or round shape; the tendency of hair to form curls','Her blonde curls are very beautiful.','她金色的卷发十分好看。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1222,'carry_off','carry off','/ˈkæri ɔːf/','phr. 夺走；获得(奖项，奖杯)；成功应对','to remove forcefully','He\'s gonna carry off her bag! Stop him!','他要把她的包夺走了！阻止他！','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1223,'pointed','pointed','/ˈpɔɪntɪd/','adj. 尖锐的；率直的','ending in a point','A pencil has a pointed shape.','铅笔有一个尖头。','a pointed shape','point点，变尖 ＋ ed形容词后缀 → pointed尖的，成尖状的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1224,'quite_a_number_of','quite a number of','/kwaɪt ə ˈnʌmbər ʌv/','phr. 相当多的(许多)','many, great amount','There are quite a number of cars in the parking lot; I can\'t find mine!','停车场上有相当多的车，我都找不到我的了！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1225,'endless','endless','/ˈendləs/','adj.没完没了的','continuing for a long time and seeming to have no end','The princess is tired of the endless social activities and banquets.','公主厌倦了无休止的社交活动和宴会。','','end结束 + less无…的 → endless无止境的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1226,'practicality','practicality','/ˌpræktɪˈkæləti/','n.实用性，实际性','the quality of being likely to succeed and reasonable to do or use','She paid more attention to the practicality of shoes on a rainy day.','她更注重鞋子在下雨天的实用性。','','practic实用的 ＋ ality表示状态、情况、性质 → practicality实用性，实际性',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1227,'situation','situation','/ˌsɪtʃuˈeɪʃn/','n.形势，处境','all the circumstances and things that are happening at a particular time and in a particular place','The general is analyzing the current situation of the war.','将军正在分析当前战争的形势。','','situat位于 + ion名词后缀 → situation地理位置',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1228,'pocketbook','pocketbook','/ˈpɑːkɪtbʊk/','n. 钱包；经济来源','a bag usually with handles and pockets that is used by women to carry money and personal belongings','I thought I put my money in my pocketbook, but I can\'t find it!','我想我把我的钱放在了钱包里，但是我找不到了！','','pocket口袋 ＋ book书 → 放书的口袋 → pocketbook小笔记本',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1229,'sunscreen','sunscreen','/ˈsʌnskriːn/','n. 防晒霜','a cream spread on the skin; contains a chemical (as PABA) to filter out ultraviolet light and so protect from sunburn','The sunscreen will protect her skin from the sun\'s rays.','防晒霜会使她的皮肤免受太阳光的伤害。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1230,'war','war','/wɔːr/','n.战争；对抗','a situation in which two or more countries or groups of people fight against each other over a period of time','These two countries are having a war.','这两个国家在打仗。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1231,'weightlessly','weightlessly','/\'weɪtləsli/','adv. 失重地','','We floated weightlessly around in our simulated spaceship cabin.','由于失重，我们在模拟太空舱里飘来飘去。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1232,'from_that_moment_on','from that moment on','/frəm ðæt ˈmoʊmənt ɔːn/','phr.那时起，从那一刻起','since that moment','From that moment on, I knew I wanted to be a pilot.','从那时起，我就知道我想成为一名飞行员。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1233,'printer','printer','/ˈprɪntər/','n. 打印机；印刷机，印刷工','a machine for printing text on paper, especially one connected to a computer','Can you please fix my printer?','你可以帮我修理打印机吗？','fix my printer','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1234,'apprehend','apprehend','/ˌæprɪˈhend/','vt. 逮捕；把…视作；理解，领会','(of the police) to catch somebody and arrest them','The driver was finally apprehended by the police for speeding.','那名驾驶员最终因超速而被警察逮捕。','apprehended by','ap一再 ＋ prehend抓住 → 一再抓住人或某个要点 → apprehend理解；忧虑',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1235,'constituency','constituency','/kənˈstɪtʃuənsi/','n. 选区','the body of voters who elect a representative for their area','A constituency is a district that elects its own spokesperson to the House of Representatives.','选区是指选举自己的发言人进入众议院的地区。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1236,'seriously','seriously','/ˈsɪriəsli/','adv. 认真地；严肃地','in a serious way','He took training very seriously.','他对待训练非常认真。','','serious严肃的 + ly……地 → seriously认真地；严重地，严肃地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1237,'supportive','supportive','/səˈpɔːrtɪv/','adj.支持的','giving help, encouragement or sympathy to sb','My family was supportive of my dream to be a singer.','对于我想要成为歌唱家的梦想，我的家人持肯定态度。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1238,'evil','evil','/ˈiːvl/','adj.邪恶的；  n.邪恶，罪恶，恶行','(of people) enjoying harming others; morally bad and cruel','This devilish monster has an evil stare.','魔鬼的眼中闪过一丝邪恶的光。','','e加强或引申意义、使… + vil=base（卑劣的）→ evil邪恶；罪恶的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1239,'defense','defense','/dɪ\'fens/','n.防御，防护','the act of defending someone or something from attack','The iron fence built by the shepherd is a great defense against the wolf.','牧羊人建造的铁栅栏可以有效地防狼。','','de去掉 + fens打击 + e → 去掉打击 → 打退敌人 → defense保卫',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1240,'disapprove','disapprove','/ˌdɪsəˈpruːv/','vi.不同意','to think that somebody/something is not good or suitable; to not approve of somebody/something','The girl disapproved of having pizza for dinner.','那个女孩不赞成晚餐吃比萨。','','dis不 + ap一再 + prove测试，证明 → 不一再证明 → disapprove不赞成',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1241,'second','second','/ˈsekənd/','n.秒；第二名；  adv.第二，其次','happening or coming next after the first in a series of similar things or people; 2nd','This digital clock is able to tell the time to the exact second.','这个数字时钟能精确到秒。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1242,'plus','plus','/plʌs/','prep.加，加上；  n.加号；有利因素；  adj.正的','used to indicate that one number or amount is being added to another','One plus one equals two. Hopefully you knew that.','一加一等于二，希望你知道这个。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1243,'mediate','mediate','/ˈmiːdieɪt/','v. 调解，调停，斡旋','to try to end a disagreement between two or more people or groups by talking to them and trying to find things that everyone can agree on; to succeed in finding a solution to a disagreement between people or groups','I tried to mediate their argument, but they never listen to me.','我试图调解他们的矛盾，但是他们不听我的。','','medi中间 + ate表示做…… → 在中间[走] → 调停',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1244,'innate','innate','/ɪˈneɪt/','adj. 与生俱来的，天生的','(of a quality, feeling, etc.) that you have when you are born','Cats have an innate drive to hunt mice.','猫天生有抓老鼠的欲望。','','in进 + nate出生的 → innate生来的；天然的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1245,'dig','dig','/dɪɡ/','v.挖掘，翻土；  n.挖苦','to make a hole in the ground or to move soil from one place to another using your hands, a tool or a machine','The dog is digging a hole.','这只狗正在挖洞。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1246,'law','law','/lɔː/','n.法律','the whole system or set of rules made by the government of a town, state, country, etc.','Nobody is above the law.','没有人能凌驾于法律之上。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1247,'vocal','vocal','/ˈvoʊkl/','adj. 声音的；畅言无忌的','connected with the voice','The singer is good at both vocal and facial expressions!','这位歌手擅长声乐和面部表情的表现！','vocal and facial expressions','voc呼喊，声，召集 + al具有…性质的 → vocal有声的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1248,'sharp','sharp','/ʃɑːrp/','adj.锋利的；  adv.锐利地','having a fine edge or point, especially of something that can cut or make a hole in something','This knife is so sharp that it can easily slice the apple.','这把刀好锋利啊，切苹果超级容易。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1249,'degree','degree','/dɪˈɡriː/','n. 学位；度；程度，等级','the qualification obtained by students who successfully complete a university or college course; a unit for measuring temperature','I finally got my degree after four years of studying!','经过四年的学习，我终于拿到了学位！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1250,'tuberculosis','tuberculosis','/tuːˌbɜːrkjəˈloʊsɪs/','n. 肺结核','a serious infectious disease in which swellings appear on the lungs and other parts of the body','Tuberculosis is a serious infectious disease that affects someone\'s lungs.','肺结核是一种严重感染人肺部的传染性疾病。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1251,'hook','hook','/hʊk/','n. 钓钩','a curved piece of metal, plastic or wire for hanging things on, catching fish with, etc.','We put a worm on the hook to catch a fish.','为了捕鱼，我们钩子上挂了一条虫。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1252,'median','median','/ˈmiːdiən/','adj. 中值的；中央的；  n. 中值，中位数','having a value in the middle of a series of values','The median value is the middle number in a sequence, or the average of middle two.','中间值是按顺序排列的一组数值中间的那个值，或者中间两个数值的平均数。','','medi中间 + an形容词后缀 → median中央的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1253,'bible','bible','/ˈbaɪbl/','n.(the Bible)《圣经》；权威书籍','the holy book of the Christian religion, consisting of the Old Testament and the New Testament','The Bible is the holy book of the Christian religion.','《圣经》是基督教的圣书。','The Bible','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1254,'narcotic','narcotic','/nɑːrˈkɑːtɪk/','n. 麻醉药；镇静剂；毒品；  adj. 麻醉的；催眠的','substance that relaxes you, reduces pain or makes you sleep; a powerful illegal drug that affects the mind in a harmful way. Heroin and cocaine are narcotics.','The bear fell asleep after being injected with narcotics.','被注射了麻醉剂后，那只熊昏昏欲睡。','','narco麻醉 + tic形容词后缀 → 麻醉的；有麻醉作用的；催眠的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1255,'oppress','oppress','/əˈpres/','vt.压迫；使（心情等）沉重','to treat somebody in a cruel and unfair way, especially by not giving them the same freedom, rights, etc. as other people','The poor employees are oppressed by their cruel boss.','这些可怜的员工受到了他们冷酷的老板的压迫。','','op对 + press挤压 → oppress压迫',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1256,'date','date','/deɪt/','n.日期；  v.给……注明日期','a particular day of the month, sometimes in a particular year, given in numbers and words','What\'s the date today?','今天多少号？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1257,'follow','follow','/ˈfɑːloʊ/','v.遵循','to come or go after or behind somebody/something','He followed the doctor\'s advice about when to take the medicine.','他听从了医生关于何时服药的建议。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1258,'crunch','crunch','/krʌntʃ/','n.嘎吱嘎吱的声音；  adj.关键的（时刻）','the quality of a food that produces a loud sound when it is chewed :a crunchy quality','She was awoken by the loud crunch of her daughter\'s crisps.','她被女儿吃薯片的嘎吱声吵醒了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1259,'square','square','/skwer/','n.正方形；广场；  adj.正方形的','an open area in a town, usually with four sides, surrounded by buildings','This square is a nice, quiet place to take a walk.','这个广场安静宜人，是个散步的好地方。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1260,'pacify','pacify','/ˈpæsɪfaɪ/','v. 使平静，安慰，抚慰','to make somebody who is angry or upset become calm and quiet','When my baby cries, I pacify him with hugs and kisses.','当宝宝哭的时候，我会用拥抱和亲吻让他平静下来。','','paci和平 ＋ fy动词后缀，使…的 → pacify使和平，使平静',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1261,'divide_up','divide up','/dɪˈvaɪd ʌp/','phr. 分配','If you divide something up, you separate it into smaller or more useful groups.','The people are divided up into four groups.','人们被分成了四组。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1262,'eat','eat','/iːt/','v.吃，吃饭','to put food in your mouth, chew it and swallow it; to have a meal','The boy is eating watermelon.','那个男孩正在吃西瓜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1263,'in_case_of','in case of','/ɪn keɪs əv/','phr. 假使','if sth happens','I brought an umbrella in case of rain.','我带了一把伞，以防下雨。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1264,'curl_up','curl up','/kɜːrl ʌp/','phr. 卷起，蜷曲，撅起','shape one\'s body into a curl','The paper started to curl up around the edge.','这张纸的边缘开始卷起了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1265,'bridegroom','bridegroom','/ˈbraɪdɡruːm/','n. 新郎','a man on his wedding day, or just before or just after it','The bridegroom is dressed in a suit with a white rose.','新郎穿着一件西装，胸口别着一朵玫瑰。','','bride新娘 + groom马夫 → bridegroom新郎',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1266,'be_concerned_with','be concerned with','/bi kənˈsənd wɪð/','phr. 与...有关','','The second chapter is concerned with the health of the elderly.','第二章所涉及的是老年人的健康问题。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1267,'shot','shot','/ʃɑːt/','n.击球；影片，镜头；  v.射击；  adj.杂色的','the action of hitting, kicking or throwing the ball in order to score a point or goal in a game','"Nice shot!" I said as he hit the ball.','“好球！”我在他击球时说道。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1268,'minefield','minefield','/ˈmaɪnfiːld/','n.布雷区','an area of land or water that contains mines (sense 2)','There\'s no way I will take this boat through that minefield!','我绝不会坐船经过那片雷区！','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1269,'downpour','downpour','/ˈdaʊnpɔːr/','n. 倾盆大雨','a sudden heavy rain','The man is caught in a sudden downpour, with no umbrella.','那个男人没带雨伞，又突然遇上倾盆大雨。','','down向下+pour倾倒 → 倾盆大雨；注下',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1270,'baggage','baggage','/ˈbæɡɪdʒ/','n. 行李','bags, cases, etc. that contain somebody’s clothes and things when they are travelling','We put our baggage in the back of the car.','我们把行李放在车的后备箱里。','','bagg=bag包 + age表示集合名词、总称 → baggage行李',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1271,'surgery','surgery','/ˈsɜːrdʒəri/','n. 外科手术','medical treatment of injuries or diseases that involves cutting open a person’s body and often removing or replacing some parts; the branch of medicine connected with this treatment','The surgeons are performing surgery on a patient.','外科医生们正在给病人做手术。','','surger=surgeon外科医生 + y名词后缀 → surgery外科，外科手术',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1272,'revise','revise','/rɪˈvaɪz/','v. 修改；温习（功课）','to change your opinions or plans, for example because of something you have learned; to change something, such as a book or an estimate, in order to correct or improve it','She is revising her paper according to the advice given by her teacher.','她正在根据老师给的意见修改论文。','','re一再，重新 + vise看 → 再看一遍 → revise修正',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1273,'birth','birth','/bɜːrθ/','n. 分娩，出生','the time when a baby comes out from the body of its mother','With the doctor\'s help, the mother gave birth to a baby.','在医生的帮助下，这位母亲顺利产下一个婴儿。','gave birth to','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1274,'travel','travel','/ˈtrævl/','v.旅行；走过，驶过；  n.旅行，旅游','to go on a trip or journey :to go to a place and especially one that is far away','Where should I travel next?','我接下来应该去哪儿旅行呢？','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1275,'sober','sober','/ˈsoʊbər/','adj. 未饮醉的，清醒的；  v. 使清醒','not drunk (= not affected by alcohol)','Tonight I\'m the designated driver, so must unfortunately remain sober!','今晚我是指定的司机，所以一定要保持清醒!','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1276,'specify','specify','/ˈspesɪfaɪ/','v.详细说明','to state something, especially by giving an exact measurement, time, exact instructions, etc.','If you want to achieve your goals, it\'s important to specify them clearly.','如果你想达到目标，清晰详细地说明这些目标很重要。','','speci外观，种类+ fy表动词 → 归类 →  指定，详细说明',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1277,'span','span','/spæn/','n. 跨度；时间段；  v. 横跨','the width of something from one side to the other','The bridge\'s span is about half a kilometer.','这座大桥的跨距大约是500米。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1278,'error','error','/ˈerər/','n. 错误，过失','a mistake, especially one that causes problems or affects the result of something','He is marking the errors on the document.','他正在标出文件上有错误的地方。','','err错误 + or行为，状况 → error错误',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1279,'oriental','oriental','/ˌɔːriˈentl/','adj. 东方的；  n. 东方人','connected with or typical of the eastern part of the world, especially China and Japan, and the people who live there','Oriental countries each have ancient traditions and their own unique culture.','东方各国都有古老的传统和自己独特的文化。','','orient东方的 + al形容词后缀 → oriental东方人；东方的；亚洲的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1280,'shrink','shrink','/ʃrɪŋk/','v. 缩小；退缩','to become or to make something smaller in size or amount','My sweater shrank in the wash.','我的毛衣在洗涤后缩水了。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1281,'hurdle','hurdle','/ˈhɜːrdl/','n.跨栏用栏，障碍；  v.跨栏，跨过','one of a series of barriers to be jumped over in a race','The athletes are jumping over the hurdles.','运动员们正跨过栏架。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1282,'be_strict_about','be strict about','/biː strɪkt əˈbaʊt/','phr. 对某事很严格，对某事严格要求','demanding that rules, especially rules about behaviour, should be obeyed','Our boss is strict about the quality of our work.','我们的领导严格要求我们的工作质量。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1283,'major','major','/ˈmeɪdʒər/','adj.主要的；  n.主修（科目）','[usually before noun] very large or important','A major cause of lung cancer is smoking.','导致肺癌的一个主要原因是吸烟。','A major cause','maj大 + or...的 → major较大的，主要的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1284,'cookery','cookery','/ˈkʊkəri/','n. 烹调术','the art or activity of preparing and cooking food','I learned cookery from cooking school, now I have my own restaurant.','我去了烹饪学校学习烹调术，现在我自己开了个餐馆。','','cook烹饪 + ery表行为方法 → cookery烹调法',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1285,'interview','interview','/ˈɪntərvjuː/','n.面试；  v.面试','a formal meeting at which somebody is asked questions to see if they are suitable for a particular job, or for a course of study at a college, university, etc.; a meeting (often a public one) at which a journalist asks somebody questions in order to find out their opinions','During the job interview, the man seemed nervous.','在求职面试过程中，这位应聘者似乎很紧张。','job interview','inter互相 + view看见 → interview会见',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1286,'airborne','airborne','/ˈerbɔːrn/','adj.在空中的','(of a plane or passengers) in the air;','He is looking at the airplane that is airborne.','他正看着空中的那架飞机。','','air航空的 + borne负荷 → adj.[航] 空运的；空气传播的；风媒的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1287,'toddle','toddle','/ˈtɑːdl/','v. （如小孩）蹒跚学步；  n. 刚学走步的小孩','to walk with short, unsteady steps','The baby has just learnt to toddle, so he walks unsteadily.','孩子才刚蹒跚学步，走得还不稳。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1288,'passer-by','passer-by','/ˌpæsər ˈbaɪ/','n. 过客，过路人','a person who is going past somebody/something by chance, especially when something unexpected happens','Some passers-by had seen the car accident.','一些路人目睹了这场车祸。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1289,'palace','palace','/ˈpæləs/','n.宫殿','the official home of a king, queen, president, etc.; any large impressive house','The first snow this winter covered the palace in a blanket of white.','今冬的初雪给这座宫殿盖上了一层雪白的毯子。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1290,'conference','conference','/ˈkɑːnfərəns/','n.会议；讨论会','a large official meeting, usually lasting for a few days, at which people with the same work or interests come together to discuss their views; a meeting at which people have formal discussions','He is delivering his speech at the pet owners\' conference.','他正在宠物主人会议上发表演讲。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1291,'retaliate','retaliate','/rɪˈtælieɪt/','v. 报复，反击','to do something bad to someone who has hurt you or treated you badly :to get revenge against someone','She retaliated against her brother with a kick.','她报复性地踢了她哥一脚。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1292,'pardon','pardon','/ˈpɑːrdn/','vt.赦免，原谅；  n.赦免，原谅；  int.请再说一遍','to officially allow somebody who has been found guilty of a crime to leave prison and/or avoid punishment','The king pardoned the prisoner.','君主赦免了那名囚犯。','pardoned the prisoner','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1293,'on_the_point_of','on the point of','/ɑːn ðə pɔːɪnt əv/','phr. 正要……的时候','','She was on the point of saying something to him when the phone rang. ','她正要对他说些什么的时候，电话响了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1294,'novelist','novelist','/ˈnɑːvəlɪst/','n. 小说家','a person who writes novels','This novelist wrote a series of famous books.','这个小说家写了一系列著名的小说。','','novel小说 + ist从事某种职业的人 → novelist小说家',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1295,'ammunition','ammunition','/ˌæmjuˈnɪʃn/','n. 弹药','a supply of bullets, etc. to be fired from guns','The soldier is well equipped with ammunition.','这个士兵装备好了弹药。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1296,'yeast','yeast','/jiːst/','n. 酵母，发酵物','a fungus used in making beer and wine, or to make bread rise','Yeast is what makes bread rise.','酵母就是让面包膨胀起来的东西。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1297,'weight','weight','/weɪt/','n.重量，分量；  vt.使变重','how heavy somebody/something is, which can be measured in, for example, kilograms or pounds; the fact of being heavy','The weight of the apples you chose is 2 kilos.','你所选的苹果的重量是2千克。','The weight of','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1298,'convenient_for','convenient for','/kənˈvinjənt fɔr/','phr. 方便的，近便的','','His house is convenient for the subway station.','他的房子到地铁站很方便。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1299,'conqueror','conqueror','/ˈkɑːŋkərər/','n. 征服者，胜利者','a person who conquers','He is the great conqueror of several empires.','他是好几个帝国的征服者。','','con共同 + quer询问 + or表示人 → 不停询问以证明胜利 → conqueror征服者,胜利者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1300,'usage','usage','/ˈjuːsɪdʒ/','n.使用，用法','the way in which words are used in a language; the fact of something being used; how much something is used','The teacher wrote out the correct usage of the word on the board.','老师在黑板上写了这个单词的正确用法。','','us用 + age状态 → 用的状态 → usage用法；惯例',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1301,'classic','classic','/ˈklæsɪk/','adj. 经典的；古典的；  n. 经典著作','a book, film/movie or song which is well known and considered to be of very high quality, setting standards for other books, etc.','"War and Peace" is regarded as a classic piece of literature.','《战争与和平》被认为是一部文学杰作。','classic piece of literature','class阶级 + ic表示人 → 高等阶级之人 → classic古典作家',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1302,'pickpocket','pickpocket','/ˈpɪkpɑːkɪt/','n.扒手','a person who steals money, etc. from other people’s pockets, especially in crowded places','Put your wallet away, and be careful of pickpockets.','收好你的钱包，小心小偷。','','pick捡 ＋ pocket口袋 → 从别人口袋里捡东西 → pickpocket扒手',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1303,'blame_for','blame for','/blem fɔr/','phr. 归咎于','','The mother blamed her son and the dog for the messy room.','母亲因为房间太过杂乱而责备了儿子和狗。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1304,'look_over','look over','/lʊk ˈoʊvər/','phr. 检查','a swift cursory examination or inspection','He looked over the contract before he signed it.','他在签合同前仔细检查了一番。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1305,'mediator','mediator','/ˈmiːdieɪtər/','n. 调停者','a person or an organization that tries to get agreement between people or groups who disagree with each other','When the two brothers have a quarrel, their good friend has to be a mediator.','当这两兄弟发生争执时，他们的好朋友就得担当调停者。','','medi中间 + ator人 → mediator调解人',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1306,'choir','choir','/ˈkwaɪər/','n. （教会的）歌唱队，唱诗班','a group of people who sing together, for example in church services or public performances','A penguin choir sings Christmas songs.','一个企鹅唱诗班唱着圣诞歌。','A penguin choir','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1307,'all_the_best','all the best','/ɔːl ðə best/','phr. 一切顺利','used when you are saying goodbye to somebody or ending a letter, to give somebody your good wishes','We wish you all the best in the new year.','祝你们在新的一年里一切顺利。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1308,'vindicate','vindicate','/ˈvɪndɪkeɪt/','vt. 证明…无辜','to show that (someone) should not be blamed for a crime, mistake, etc. :to show that (someone) is not guilty','Snowfall in June vindicated this innocent woman.','六月飞雪证明了窦娥的无辜。','','vin力量 ＋ dic说 ＋ ate使 → 用力量说 → vindicate拥护',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1309,'subsidiary','subsidiary','/səbˈsɪdieri/','n.子公司，附属机构；  adj.辅助的，次要的，附属的','a business company that is owned or controlled by another larger company','This parent company has six subsidiaries.','这家母公司有六家子公司。','','sub下 + sid坐 + iary形容词后缀 → 坐在下面帮助别人 → subsidiary补助的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1310,'pay_sb._back_for_sth.','pay sb. back for sth.','/peɪ ˈsʌmbədi bæk fɔːr ˈsʌmθɪŋ/','phr. 向…报复，报答','do or give something to somebody in return','Children will pay mother back for what mother did to them.','孩子们会报答妈妈为他们做的一切。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1311,'represent','represent','/ˌreprɪˈzent/','v.象征；阐明','to be a symbol of something','This hand gesture represents love.','这个手势象征着爱。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1312,'anonymity','anonymity','/ˌænəˈnɪməti/','n. 匿名，作者不明（或不详），无名之辈','the state of remaining unknown to most other people; the state of not having any unusual or interesting features','He agreed to be interviewed, so long as his anonymity was assured.','只要能保证匿名，他就同意接受采访。','','anonym无名氏 + ity名词后缀 → anonymity无名，匿名',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1313,'Mrs.','Mrs.','/ˈmɪsɪz/','n. 夫人，太太','a title that comes before a married woman’s family name or before her first and family names together','After we got married, I became "Mrs. Smith".','我们结婚后，我变成了“史密斯夫人”。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1314,'personally','personally','/ˈpɜːrsənəli/','adv. 亲自地','as yourself','I gave the book to him personally.','我亲自把书给了他。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1315,'gush','gush','/ɡʌʃ/','v. 涌出，滔滔不绝地说，洋洋洒洒地写；  n. 迸发','to flow out very quickly and in large amounts','The water is gushing out of the broken fire hydrant.','水正从坏掉的消防栓中喷涌而出。','gushing out of','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1316,'villager','villager','/ˈvɪlɪdʒər/','n.村民','a person who lives in a village','The villagers are working on the fields.','村民们在地里干活。','','villag=village村庄 + er人 → villager村民',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1317,'blame','blame','/bleɪm/','n.责备，过失；  v.责备，把……归咎于','responsibility for doing something badly or wrongly; saying that somebody is responsible for something','I always get all the blame, but I never do anything wrong.','我总是受到所有的责备，但我从没做错过任何事。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1318,'vary','vary','/ˈveri/','v. 相异；改变，变化；使多样化','(of a group of similar things) to be different from each other in size, shape, etc.','Each cup made by these kids varies slightly.','孩子们做的每一个杯子都有些许不同。','','vary=vari变化 → vary改变，变化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1319,'more','more','/mɔːr/','det.更多的；  adv.（程度上）更强','to a greater degree than something else; to a greater degree than usual','There are more and more coins in the jar.','罐子里的硬币越来越多了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1320,'tablet','tablet','/ˈtæblət/','n.碑，匾；药片；便笺簿','a flat piece of stone that has words written on it, especially one that has been fixed to a wall in memory of an important person or event','This ancient tablet is from Roman times.','这块古老的石碑源自罗马时代。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1321,'neurotic','neurotic','/nʊˈrɑːtɪk/','adj. 神经质的；神经官能病的；  n. 神经病患者','often or always fearful or worried about something :tending to worry in a way that is not healthy or reasonable','He is a very neurotic person and he worries too much about his safety.','他过于神经质，老是担心自己的人身安全。','','neuro神经+tic...的→神经过敏的；神经病的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1322,'cloth','cloth','/klɔːθ/','n. 布；衣料','material made by weaving or knitting cotton, wool, silk, etc.','The shop sells different kinds of cloth.','这家商店出售各式各样的布料。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1323,'propaganda','propaganda','/ˌprɑːpəˈɡændə/','n.宣传；宣传方法','ideas or statements that may be false or exaggerated and that are used in order to gain support for a political leader, party, etc.','The political propaganda is posted onto the lampposts around the city.','政治宣传内容被张贴在了城里各处的灯柱上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1324,'adapt_to','adapt to','/əˈdæpt tu/','phr.（使）适应','to become adjusted to new conditions','It takes time for children to adapt to school life.','孩子们需要一段时间来适应学校生活。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1325,'niece','niece','/niːs/','n.侄女，外甥女','the daughter of your brother or sister; the daughter of your husband’s or wife’s brother or sister','My niece is my sibling\'s daughter.','我的侄女或外甥女就是我兄弟姐妹的女儿。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1326,'fall_back_on','fall back on','/fɔl bæk ɔn/','phr. 求助于','depend on','If your first plan fails you will have to fall back on plan B.','如果你的第一计划失败了，你需要求助于第二计划。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1327,'developer','developer','/dɪˈveləpər/','n.开发商，开发者','someone who develops real estate (especially someone who prepares a site for residential or commercial use)','The developer bought the land with plans to build a shopping mall on it.','开发商买下了这块地，打算在上面修建购物商场。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1328,'ruin','ruin','/ˈruːɪn/','v.毁灭，毁坏；（使）破产；  n.废墟','to damage (something) so badly that it is no longer useful, valuable, enjoyable, etc.; to spoil or destroy (something)','These buildings were ruined by a powerful earthquake.','一场大地震摧毁了这些建筑。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1329,'deceit','deceit','/dɪˈsiːt/','n. 欺骗，欺诈','dishonest behavior that is meant to fool or trick someone','There seems to be some deceits happening under the sea.','海底似乎正发生着一些欺诈事件。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1330,'occupy_one\'s_time','occupy one\'s time','/ˈɑːkjupaɪ wʌnz taɪm/','phr. 占用某人的时间','to make someone spend time on and not able to do other things','My job occupies almost all of my time; I need some rest!','工作几乎占据了我所有时间，我需要休息！','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1331,'wholesale','wholesale','/ˈhoʊlseɪl/','n. 批发；  adj. 大规模的；批发的','in large quantities, especially so they can be sold again to make a profit','Retailers buy things in wholesale.','零售商通过批发方式采购东西。','','whole完整的 + sale销售 → wholesale批发',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1332,'certify','certify','/ˈsɜːrtɪfaɪ/','v.证实，证明；发证书给……','to state officially, especially in writing, that something is true','He was certified dead by the doctor.','医生证明他已经去世。','','certi=cret区别 + fy动词后缀 → 证明；保证',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1333,'restore','restore','/rɪˈstɔːr/','v.恢复','to bring somebody/something back to a former condition, place or position; to bring back a situation or feeling that existed before','We hope to restore the garden to its former beauty.','我们希望把花园恢复到它原来的美丽模样。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1334,'proper','proper','/ˈprɑːpər/','adj.得体的；适合的，适用的；独特的；真正的；完全的','right, appropriate or correct; according to the rules','You should wear something proper when having an interview.','面试时，你应当穿着得体。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1335,'zip_code','zip code','/ˈzɪp koʊd/','n. 邮政编码','a group of numbers that are used as part of an address so that post/mail can be separated into groups and delivered more quickly','You must write a zip code on the envelope before mailing a letter.','寄信前，你必须在信封上写上邮政编码。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1336,'study','study','/ˈstʌdi/','v.研究','to spend time learning about a subject by reading, going to college, etc.','Her studies are all about genetic engineering.','她的研究都与基因工程相关。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1337,'conscience','conscience','/ˈkɑːnʃəns/','n.良心，良知','the part of the mind that makes you aware of your actions as being either morally right or wrong','My conscience always tells me to do something right.','我的良心经常告诉我要做对的事情。','','con全部 + sci知道 + ence名词后缀 → 全部知道 → 有良知 → conscience良心',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1338,'keep','keep','/kiːp/','v.保持','to continue having or holding (something) :to not return, lose, sell, give away, or throw away (something)','It\'s so strange that she has kept young all these years.','真奇怪，这么多年来她一直都保持着年轻的状态。','kept young','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1339,'ripe','ripe','/raɪp/','adj. 熟的，成熟的','(of fruit or crops) fully grown and ready to be eaten','When bananas become ripe, they turn yellow.','香蕉成熟的时候，颜色就会变黄。','become ripe','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1340,'heave','heave','/hiːv/','v.用力举起；  n.举起；起伏','to lift, pull or throw somebody/something very heavy with one great effort','These people heave the big green ball together.','这些人一同举起了这个巨大的绿球。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1341,'sway','sway','/sweɪ/','v. 摇摆，摇曳；动摇（某人）；  n. 摇摆','to move slowly from side to side; to move something in this way','The willow tree swayed gently in the breeze.','柳树在微风中轻轻摆动。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1342,'full_refund','full refund','/fʊl ˈriːfʌnd/','phr. 全额退款，全额偿还','a full return of payment','The store gave me a full refund even though I had opened the package.','即使我打开了这个包裹，这家店还是把钱全部退给了我。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1343,'evident','evident','/ˈevɪdənt/','adj. 显然的，明显的，明白的','clear; easily seen','It\'s evident that the salesman is lying.','很明显这个推销员在说谎。','','e易于的 + vident看 → evident明显的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1344,'clutch','clutch','/klʌtʃ/','v. 紧握；抓住；  n. 抓住；离合器','to hold somebody/something tightly','He clutches his red packet and stays alert.','他紧紧抓住他的红包，保持警惕。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1345,'debut','debut','/deɪˈbjuː/','n. 初次登台，在社交场合的初次露脸；  v. 初次露面，初次表演','the first public appearance of a performer or sports player','The young player made his debut after signing a contract with the club.','这位年轻的运动员跟俱乐部签订合同后，首次亮相赛场。','made his debut','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1346,'earn_one\'s_living','earn one\'s living','/ɜː(r)n wʌnz ˈlɪvɪŋ/','phr. 谋生','make a living','She earns her living by selling flowers.','她靠卖花来挣钱谋生。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1347,'invert','invert','/ɪnˈvɜːrt/','v.倒置；倒转；颠倒','to change the normal position of something, especially by turning it upside down or by arranging it in the opposite order','Tea cups are inverted on the table before they\'re used.','在使用之前，茶杯都是倒置在桌子上的。','','in进 + vert转向 → 转进去 → 倒转，倒置',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1348,'level','level','/ˈlevl/','n.水平，标准，等级；  v.瞄准；对准目标；  adj.等高的','having the same height as something else','Players are separated into three levels in this game.','玩家们在这个游戏中被分为三个等级。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1349,'tactic','tactic','/ˈtæktɪk/','n.（为达到目的采取的）手段，战术，策略','an action or method that is planned and used to achieve a particular goal','The coach is explaining tactics for the following soccer game.','教练正在讲解接下来的足球赛中要用的战术。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1350,'eyewitness','eyewitness','/ˈaɪwɪtnəs/','n. 目击者','a person who has seen a crime, accident, etc. and can describe it afterwards','He was the only eyewitness of this robbery.','他是这次抢劫的唯一目击者。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1351,'imagine','imagine','/ɪˈmædʒɪn/','v.想象，幻想；设想，猜想；认为','to form a picture in your mind of what something might be like','She is imagining herself wearing a pretty dress.','她在想象自己穿上漂亮裙子的样子。','','imag=image图像 + ine……的 → 有关图像的 → imagine想象',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1352,'rental','rental','/ˈrentl/','adj.租借的；  n.租金收入，租金','the amount of money paid or collected as rent','The rental fee of this shell is too high for me.','对我而言，这贝壳的租金真是太贵了。','rental fee','rent租金 ＋ al构成名词 → rental租金收入，租金',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1353,'sophisticated','sophisticated','/səˈfɪstɪkeɪtɪd/','adj.（仪器）精密的，复杂的；老于世故的，精明老练的；高雅时髦的，很有品位的','having a lot of experience of the world and knowing about fashion, culture and other things that people think are socially important','This machine is quite sophisticated.','这台机器是非常精密复杂的。','','soph智慧 + istic……的 + at＝ate做，造成 + ed……的 → 有智慧的 → sophisticated老于世故的，精致复杂的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1354,'offense','offense','/əˈfens/','n. 犯罪，冒犯，过错，触怒，犯规，进攻','an illegal act; the act of upsetting or insulting somebody; the members of a team whose main aim is to score points against the other team; a method of attack','The dog gets an offense from its host and looks angry.','狗狗被主人惹恼了，看起来十分生气。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1355,'thick','thick','/θɪk/','adj.厚的；稠的，浓的','having a larger distance between opposite sides or surfaces than other similar objects or than normal','This book is very thick.','这本书非常厚。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1356,'explanation','explanation','/ˌekspləˈneɪʃn/','n.解释，说明','a statement, fact, or situation that tells you why something happened; a reason given for something; a statement or piece of writing that tells you how something works or makes something easier to understand','The boy is giving his explanation for why he arrived late for school.','男孩正在解释他上学迟到的原因。','','explan=explain解释 + ation名词后缀，表行为 → explanation说明，解释',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1357,'withstand','withstand','/wɪðˈstænd/','vt.忍受；抵挡','to be strong enough not to be hurt or damaged by extreme conditions, the use of force, etc.','We all have to withstand our own pressures in life.','我们都不得不承受各自的生活压力。','','with向后，相反 + stand站 → 向相反的方向站 → withstand抵抗，反抗',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1358,'brand','brand','/brænd/','n.品牌；  v.加污名于','a type of product made by a particular company','This famous brand makes many different products.','这个著名品牌制造各式各样的产品。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1359,'prosecution','prosecution','/ˌprɑːsɪˈkjuːʃn/','n.起诉；起诉方，原告','a person or an organization that prosecutes somebody in court, together with the lawyers, etc.','The cat is facing prosecution over his attack on the poor rabbit.','这只猫因为攻击那只可怜的兔子而面临起诉。','','pro向前 ＋ secut跟随 ＋ ion名词后缀 → 继续前进 → prosecution进行；起诉',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1360,'clever','clever','/ˈklevər/','adj. 聪明的','quick at learning and understanding things','The clever boy can figure out any difficult math problem.','这个男孩聪明极了，可以解出很难的数学题。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1361,'legislation','legislation','/ˌledʒɪsˈleɪʃn/','n.法律，法规','a law or a set of laws passed by a parliament; the process of making and passing laws','The Congress voted in favor of the new legislation.','国会投票赞成新的立法。','','legis法律+lat=late使之成…… + ion名词后缀 → 使之成法律 → legislation立法',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1362,'dispose_of','dispose of','/dɪˈspoʊz ɑv/','phr. 处理，安排','to deal with a problem, question or threat successfully','You\'d better dispose of these used tissues in the garbage.','你最好将这些用过的纸扔到垃圾桶里。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1363,'allocate','allocate','/ˈæləkeɪt/','v. 分配，配给','to give something officially to somebody/something for a particular purpose','Allocate one piece of cake to each person.','给每个人都分一块蛋糕。','','al一再 + loc地方 + ate表动词 → 不断送给地方 → 分配；分派',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1364,'fallen','fallen','/ˈfɔːlən/','adj.倒下的，落下的','lying on the ground, after falling','This fallen tree is lying on the lawn.','这棵倒下的树压在了草坪上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1365,'strand','strand','/strænd/','n.（绳子、线等的）股，缕；海滨，河岸，海滩，湖滨','a single thin piece of thread, wire, hair, etc.','Only one strand of the rope remained unbroken.','绳子上只剩一股线没有断了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1366,'appliance','appliance','/əˈplaɪəns/','n.家用电器，器具；装置；应用','a machine that is designed to do a particular thing in the home, such as preparing food, heating or cleaning','I spend all my money on domestic appliances, like TVs and refrigerators.','我把所有钱都花在像电视和冰箱这种家用电器上了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1367,'decay','decay','/dɪˈkeɪ/','v.腐烂；衰退；腐朽；  n.腐烂；衰退；腐败','to be destroyed gradually by natural processes; to destroy something in this way','These oranges have decayed on top.','这些橘子从顶部开始腐烂了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1368,'at_first_sight','at first sight','/æt fɜːrst saɪt/','n. 乍一看',' immediately','This math problem looks easy at first sight, but it\'s actually very difficult.','这道数学题乍一看很容易，但实际上很难。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1369,'at_this_rate','at this rate','/æt ðɪs reɪt/','n. 照这样下去','','This traffic\'s terrible. At this rate he\'ll never get to the airport on time.','交通太糟糕了。照这样下去，他根本不可能准时到达机场。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1370,'nose','nose','/noʊz/','n. 鼻子；前部；嗅觉','the part of the face that sticks out above the mouth, used for breathing and smelling things','Look! The elephant is drinking water with its long nose.','看！大象正在用它的长鼻子喝水。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1371,'romance','romance','/ˈroʊmæns/','n.浪漫','love or the feeling of being in love','He\'ll find time for romance by having dinner with his girlfriend.','他会找时间和女友共进晚餐，制造浪漫。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1372,'sociable','sociable','/ˈsoʊʃəbl/','adj.好交际的','(of people) enjoying spending time with other people','Humans are sociable creatures; we love to spend time with our friends.','人类是喜好交际的生物，我们喜欢和朋友待在一起。','','soci社会的 + able形容词后缀 → sociable爱社交的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1373,'modernize','modernize','/ˈmɑːdərnaɪz/','v. （使）现代化','to make a system, methods, etc. more modern and more suitable for use at the present time; to start using modern equipment, ideas, etc.','Repairing old houses is an important step to modernize our city.','修缮老旧房屋是城市现代化进程中的重要一步。','','modern现代的 + ize动词后缀 → modernize（使）现代化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1374,'backache','backache','/ˈbækeɪk/','n. 背痛','a continuous pain in the back','Since I got an office job, my backache has gotten much worse.','自从我得到一份办公室工作，我的背痛越来越严重。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1375,'handicap','handicap','/ˈhændikæp/','n.残疾，生理缺陷；障碍；  vt.使不利，妨碍','a permanent physical or mental condition that makes it difficult or impossible to use a particular part of your body or mind','The soldier who has a handicap proudly stands with the others.','这位残疾士兵骄傲地和其他士兵站在一起。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1376,'seductive','seductive','/sɪˈdʌktɪv/','adj. 性感的；引人注意的','sexually attractive','The dog looks so seductive in those black silky stockings.','这只狗穿着黑丝袜，看上去真性感。','','seduct吸引 + ive形容词后缀  → seductive 引人注意的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1377,'warm','warm','/wɔːrm/','adj.温暖的；  v.使温暖','at a fairly high temperature in a way that is pleasant, rather than being hot or cold','The weather cooled off, so we made a fire to keep warm.','天气变凉了，所以我们生火取暖。','keep warm','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1378,'diligent','diligent','/ˈdɪlɪdʒənt/','adj. 勤奋的；用功的','showing care and effort in your work or duties','Compared with her deskmate, she is a very diligent student.','与她的同桌相比，她是一名非常勤奋的学生。','','dilig勤奋 + ent具有...性质的 → diligent勤奋的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1379,'canvas','canvas','/ˈkænvəs/','n.（帆布做的）画布；帆布','a piece of canvas used for painting on; a painting done on a piece of canvas, using oil paints; a strong heavy rough material used for making tents, sails, etc. and by artists for painting on','The artist is painting on the canvas.','艺术家正在油画布上作画。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1380,'allusion','allusion','/əˈluːʒn/','n.暗示','a statement that refers to something without mentioning it directly','The \'Romeo\' who the girl refers to is used as an allusion to the famous story.','女孩所说的“罗密欧”源于对名著的暗指。','an allusion to','allu(de)暗指 + sion 名词后缀 → allusion 暗示',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1381,'introvert','introvert','/ˈɪntrəvɜːrt/','n. 内向的人，内弯（内翻）的东西；  v. 使内翻，使内向，使内省','a shy person :a quiet person who does not find it easy to talk to other people','The introvert is covered with invisible walls and struggles to communicate with others.','内向的人被无形的墙包裹起来，并且和他人交流有困难。','','intro向内，入内 + vert转 → 向内转 → introvert内向',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1382,'envoy','envoy','/ˈenvɔɪ/','n.使者，全权公使','a person who is sent by one government to represent it in dealing with another government','The envoy was sent to the Western Regions to seek military cooperation.','这名使者被派往西域寻求军事合作。','','en在...里 + voy路 → envoy 信使',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1383,'profound','profound','/prəˈfaʊnd/','adj. 深刻的；  n. 深海','very great; felt or experienced very strongly','The relationship between parents has a profound impact on a child\'s behavior.','父母的关系对于孩子的行为有着深刻的影响。','','pro前面 + found基础 → 有基础在前面 → profound有根基的，深刻的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1384,'majority','majority','/məˈdʒɔːrəti/','n.大多数，大部分','(law) the age at which you are legally considered to be an adult','The majority thinks it\'s a good plan, but I don\'t think so.','大多数人认为这是个好主意，但我不觉得。','','major主要的 + ity表名词 → majority大多数',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1385,'lengthen','lengthen','/ˈleŋθən/','v. 变长；延长','to become longer; to make something longer','Do you believe that your nose will lengthen if you tell a lie?','你相信吗，你如果说谎的话鼻子会变长。','','length长度 + en变成 → lengthen使延长，伸长',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1386,'self-service','self-service','/ˌself ˈsɜːrvɪs/','adj. 自助的，自我服务的','allowing or requiring customers to serve themselves without help from workers','Self-service afternoon tea party is very common in company.','自助下午茶派对是公司的常见福利。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1387,'unconscious','unconscious','/ʌnˈkɑːnʃəs/','adj. 不省人事的；未察觉的','in a state like sleep because of an injury or illness, and not able to use your senses','We found him unconscious on the floor.','我们发现他倒在地上，不省人事。','found him unconscious','un表否定 + con共同 + sci知道 + ous…的 → 什么都不知道 → unconscious无意识的，不知不觉的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1388,'stake','stake','/steɪk/','vt.下注；以桩来支撑；  n.木桩；赌注；利害关系','something (such as money) that you could win or lose in a game, contest, etc.','He stakes lots of money on the card game.','他在纸牌游戏中押了很多钱。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1389,'packer','packer','/ˈpækər/','n. 包装工人；从事包装业务的企业','a person, machine or company that puts food, goods, etc. into containers to be sold or sent to somebody','I work as a packer in an electronics factory.','我在一个电子厂做包装工。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1390,'nicety','nicety','/ˈnaɪsəti/','n. 细节，讲究','a small detail and especially one that is a part of polite or proper behavior','At dinner parties, you should observe all the niceties and be polite.','在晚餐聚会中，你应该观察每一个细节并礼貌行事。','niceties','nice美好的 + ty 表名词→精密；美好；细节',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1391,'inaccuracy','inaccuracy','/ɪnˈækjərəsi/','n. 不精确，错误','the fact of not being exact or accurate or of having mistakes','My inaccuracy embarrassed me in a dart game.','玩飞镖时，不能准确射中使我很尴尬。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1392,'the_United_Kingdom(UK)','the United Kingdom(UK)','/ðə juˈnaɪtəd ˈkɪŋdəm ˌjuː\'keɪ/','phr. 英国','a monarchy in northwestern Europe occupying most of the British Isles; divided into England and Scotland and Wales and Northern Ireland','The United Kingdom means England, Wales, Scotland, and Northern Ireland.','英国包括英格兰、威尔士、苏格兰和北爱尔兰四个地区。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1393,'mailbox','mailbox','/ˈmeɪlbɑːks/','n.邮箱','a small box near the main door of a building or by the road, which mail is delivered to','Hey! You’ve got a letter in your mailbox!','嘿！你的信箱里有一封信！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1394,'defile','defile','/dɪˈfaɪl/','v. 污损，弄脏；以纵队前进；  n. 隘路','to make (something) dirty','The factory defiled the river with sewage and waste.','工厂的污水和废物污染了河流。','','de加强意义+fil弄脏 → 使变脏 → 污损',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1395,'pollinate','pollinate','/ˈpɑːləneɪt/','vt. 传花粉给…','to give (a plant) pollen from another plant of the same kind so that seeds will be produced','Bees pollinate many of the flowers in the garden.','蜜蜂为许多花园里的花朵传粉。','','pollin授粉 ＋ ate表示做，造成 → pollinate对...授粉',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1396,'purse','purse','/pɜːrs/','n. 钱包（尤指女用的），小钱袋，手袋','a small bag made of leather, plastic, etc. for carrying coins and often also paper money, cards, etc., used especially by women; the amount of money that is available to a person, an organization or a government to spend','This purse holds some coins.','这个钱包装了一些硬币。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1397,'automobile','automobile','/ˈɔːtəməbiːl/','n. 汽车，机动车','a vehicle used for carrying passengers on streets and roads; a car','Would you like to go for a ride in my new automobile?','你想搭我的新车去兜风吗？','','auto汽车 + mobile移动的 → automobile汽车',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1398,'December','December','/dɪˈsembər/','n. 十二月','the 12th and last month of the year','Christmas is celebrated in December.','人们在十二月庆祝圣诞节。','in December','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1399,'introduction','introduction','/ˌɪntrəˈdʌkʃn/','n. 介绍；引进','the act of making one person formally known to another, in which you tell each the other’s name','The girl is making an introduction of her boyfriend to her parents.','这个女孩正在向父母介绍她的男朋友。','','intro向内，入内 + duc引导 + tion名词后缀，表状态 → 引进的行为 → introduction介绍；引进',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1400,'outside','outside','/ˌaʊtˈsaɪd/','adv. 在户外，在外面，向外面；  n. 外部；  adj. 外部的；  prep. 在……外面，不在……范围内','not in a room, building or container but on or to the outside of it; not inside a building','I like my kids to play outside on the grass.','我喜欢孩子们到外面的草地上玩耍。','play outside','out外，出 + side旁边 → outside在外边',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1401,'nation','nation','/ˈneɪʃn/','n. 民族，国家','a country considered as a group of people with the same language, culture and history, who live in a particular area under one government','These flags represent different nations.','这些国旗代表着不同的国家。','different nations','nat出生的 + ion名词后缀 → 出生之处 → nation国家',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1402,'possibility','possibility','/ˌpɑːsəˈbɪləti/','n.概率；可能的事','one of the different things that you can do in a particular situation','The possibility that I pick the black ball is fifty percent.','我摸到黑球的概率是50%。','','poss可能 + ibility表名词 → possibility可能；可能的事',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1403,'skyscraper','skyscraper','/ˈskaɪskreɪpər/','n. 摩天大楼','a very tall building in a city','Look up, and you will see several skyscrapers towering into the clouds.','抬头看去，你会看到几座高耸入云的摩天大楼。','','sky天空 + scrap擦 + er表物 → 擦到天空的楼 → skyscraper摩天楼',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1404,'cherry','cherry','/ˈtʃeri/','n. 樱桃（树）','a small soft round fruit with shiny red or black skin and a large seed inside; a tree on which cherries grow, or a similar tree, grown for its flowers','Cherry juice is good for your skin.','樱桃汁对你的皮肤有好处。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1405,'sustenance','sustenance','/ˈsʌstənəns/','n. 生计','the food and drink that people, animals and plants need to live and stay healthy','Picking up rubbish is a vital source of sustenance for those poor tramps.','对于这些贫穷的流浪汉来说，捡垃圾是他们重要的生计来源。','','sus在…下面 + ten支撑 + ance名词后缀 → 支撑下去的东西 → sustenance生活资料，粮食',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1406,'nominate_sb._for','nominate sb. for','/ˈnɑːmɪneɪt ˈsʌmbədi fɔːr/','v.提名，推荐','','The boy nominated his deskmate for the position of class monitor.','这个男孩提名他的同桌担任班长一职。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1407,'denounce','denounce','/dɪˈnaʊns/','v. 谴责，斥责','to strongly criticize somebody/something that you think is wrong, illegal, etc.','They all denounced me, even though I hadn\'t done anything wrong.','他们都在谴责我，即使我没有做错什么。','','de坏 + nounce讲话，说出 → 讲坏话 → denounce抨击',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1408,'galaxy','galaxy','/ˈɡæləksi/','n. 星系','any of the large systems of stars, etc. in outer space; the system of stars that contains our sun and its planets, seen as a bright band in the night sky; a group of famous people, or people with a particular skill','There are countless stars and planets in this beautiful galaxy.','在这个美丽的星系里有数不清的恒星和行星。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1409,'picnic','picnic','/ˈpɪknɪk/','n.野餐','an occasion when people pack a meal and take it to eat outdoors, especially in the countryside','The family enjoyed a nice picnic outside.','这一家人在室外享用了一顿很好的野餐。','a nice picnic','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1410,'flower','flower','/ˈflaʊər/','n.花，花卉；  v.开花','part of a plant from which the seed or fruit develops, often brightly coloured and lasting only a short time','There are colorful flowers in that place.','那里有五颜六色的花。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1411,'report_to','report to','/rɪˈpɔːrt tuː/','phr.向 ... 报到','','During this particular time, travelers are required to report to certain hotels.','在这个特殊时期，旅客需要到特定酒店报到。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1412,'shore','shore','/ʃɔːr/','n.岸','the land along the edge of an area of water (such as an ocean, lake, etc.)','There is a big "2017" on the shore.','在海岸上有一个大大的“2017”。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1413,'screen','screen','/skriːn/','n.屏幕；  v.遮蔽','the flat surface at the front of a television, computer, or other electronic device, on which you see pictures or information; the large flat surface that films/movies or pictures are shown on','The movie theater\'s screen is so large!','这个电影院的银幕好大！','movie theater\'s screen','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1414,'paragraph','paragraph','/ˈpærəɡræf/','n. （文章的）段，节','a section of a piece of writing, usually consisting of several sentences dealing with a single subject. The first sentence of a paragraph starts on a new line.','Please summarize the main point of this paragraph.','请总结这一段的大意。','','para旁、靠近、外 + graph=write，表示写，图 → 靠近图表旁边的文字 → (文章的)段，节',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1415,'entity','entity','/ˈentəti/','n. 实体，存在','something that exists separately from other things and has its own identity','There\'re six factories in this industrial park, but each is a separate entity.','这个工业园区里有六个工厂，但它们每一个都是独立的存在。','','ent表示存在 + ity表名词→entity实体，存在',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1416,'openly','openly','/ˈoʊpənli/','adv. 公开地','in an open way','He held a press conference to openly express his opposition to the new chemical plant.','他召开新闻发布会，公开反对新建化工厂。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1417,'side_road','side road','/ˈsaɪd roʊd/','n. 岔道','a smaller road that is connected to a main road','This white car is driving on the side road.','这辆白色的汽车正在岔道上行驶。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1418,'step_up','step up','/step ʌp/','phr.加快',' increase in extent or intensity','She stepped up her training as the race came closer.','比赛临近时，她加快了训练。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1419,'revolutionary','revolutionary','/ˌrevəˈluːʃəneri/','n. 革命者；  adj. 革命性的','a person who starts or supports a revolution, especially a political one','Revolutionaries fought against the dictatorship.','革命者反抗独裁。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1420,'distract','distract','/dɪˈstrækt/','v. 使分心，转移（注意力），分散（思想）','to take somebody’s attention away from what they are trying to do','The cat tried to distract his friend\'s attention and took his fish.','小猫试图转移他朋友的注意力，伺机拿走他的小鱼干。','','dis分开，分离 + tract拉 → 把心拉开 → 分心',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1421,'bill','bill','/bɪl/','n.账单','a document that says how much money you owe for something you have bought or used','The waiter said, “Here is your bill, sir.”','服务员说：”这是您的账单，先生。“','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1422,'pistol','pistol','/ˈpɪstl/','n. 手枪，信号，发令枪；  v. 用手枪杀死，用手枪伤害','','The heroine in this comic book hides a pistol in her handbag.','这本漫画书的女主角把手枪藏在手提包里。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1423,'renewal','renewal','/rɪˈnuːəl/','n.更新；翻新','the act of extending the period of time when something is effective or valid :the act of renewing something','Her passport was due for renewal as its expiration date approached.','她的护照在临近到期日时进行了更新。','','re一再，重新 ＋ new新的 ＋ al名词后缀 → renewal更新',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1424,'spokesperson','spokesperson','/ˈspoʊkspɜːrsn/','n.发言人','an advocate who represents someone else\'s policy or purpose','The workers\' spokesperson gave a speech speaking against compulsory unpaid overtime.','工人们的发言人做了发言，反对强制性的无偿加班。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1425,'middle','middle','/ˈmɪdl/','n.中部，中间；  adj.中部的，中间的','in a position in the middle of an object, group of objects, people, etc.; between the beginning and the end of something','This is my mom and my daughter, and that\'s me, in the middle.','这是我妈妈和我女儿，在中间的就是我。','in the middle','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1426,'granary','granary','/ˈɡreɪnəri/','n. 谷仓，粮仓；主要来源','a building in which grain is stored','A granary is a building which is used for storing grain.','粮仓是用来储存粮食的建筑物。','','gran颗粒 ＋ ary表场所 → granary放粮食颗粒的地方',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1427,'limb','limb','/lɪm/','n. 肢体；臂；枝干；树枝；  v. 肢解','an arm or a leg; a similar part of an animal, such as a wing','She lost a limb from an illness, but she can still run!','她因为疾病失去了一条腿，但她还可以跑步。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1428,'pad','pad','/pæd/','n.便笺簿；（动物的）脚；  v.填塞','a number of pieces of paper for writing or drawing on, that are fastened together at one edge','You can use an iPad to write notes instead of a pad of paper.','你可以不用纸质的便签簿，而用iPad来记笔记。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1429,'sonar','sonar','/ˈsəʊnɑːr/','n.声呐','a measuring instrument that sends out an acoustic pulse in water and measures distances in terms of the time for the echo of the pulse to return; sonar is an acronym for sound navigation ranging; asdic is an acronym for anti-submarine detection investig','The ship is sending and receiving sonar signals.','这艘船正在发送和接收声呐信号。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1430,'assimilation','assimilation','/əˌsɪməˈleɪʃn/','n.同化，同化作用；消化','people of different backgrounds come to see themselves as part of a larger national family.','Assimilation is the process when a group\'s culture comes to resemble those of another.','同化作用就是一个群体的文化变得和另一个群体一样的过程。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1431,'married','married','/ˈmærid/','adj. 已婚的，夫妇的','having a husband or wife; connected with marriage;','We\'re getting married today! We\'re so happy!','我们今天结婚，幸福极了！','','marri=marry结婚 + ed已……的 → married已婚的',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1432,'disadvantage','disadvantage','/ˌdɪsədˈvæntɪdʒ/','n.不利，不利地位；弱点','something that causes problems and tends to stop somebody/something from succeeding or making progress; a bad or undesirable quality or feature','Compared with the short boy, the tall boy was at a disadvantage when the books fell.','与矮个子男孩相比，高个子男孩在书掉下来时处于不利地位。','at a disadvantage','dis不，非 + advantage优点 → disadvantage缺点',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1433,'Pope','Pope','/poʊp/','n. 教皇','the leader of the Roman Catholic Church, who is also the Bishop of Rome','The Pope is the head of the Catholic church.','教皇是天主教教会的领袖。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1434,'take_sth._into_account','take sth. into account','/teɪk ˈsʌmθɪŋ ˈɪntu əˈkaʊnt/','phr. 考虑到某事','take into consideration for exemplifying purposes','The designers have to take into account the family have a child on the way.','设计师必须考虑到这家人将要生小孩的情况。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1435,'unless','unless','/ənˈles/','conj. 除非，如果不；除……外','used to say that something can only happen or be true in a particular situation','I won\'t buy you that toy unless you get a full mark.','我不会给你买玩具的，除非你得了一百分。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1436,'come_to_an_end','come to an end','/kʌm tu: æn end/','phr. 完结','be over','The relationship came to an end and the couple went their separate ways.','这对情侣的关系走向了尽头，他们自此分道扬镳。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1437,'teapot','teapot','/ˈtiːpɑːt/','n.茶壶','a pot that is used for making and serving tea and that has a spout and handle','Don\'t touch the teapot—it\'s very hot.','不要碰那个茶壶，它非常烫。','touch the teapot','tea茶 + pot壶 → teapot茶壶',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1438,'in_a_hurry','in a hurry','/ɪn ə ˈhɜːri/','phr.匆忙，很快地','rapid; swift; speedy; prompt','He is in a hurry to go to work!','他急着赶去上班。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1439,'defeat','defeat','/dɪˈfiːt/','vt.打败；  n.挫败','to win against somebody in a war, competition, sports game, etc.','He defeated his opponent and won the badminton match.','他打败了对手，赢得了这场羽毛球比赛。','','de向下 + feat做，制作 → 做下去 → 打下去 → defeat打败，摧毁',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1440,'liberation','liberation','/ˌlɪbəˈreɪʃn/','n.解脱，解放','the act or process of freeing a country or a person from the control of somebody else','The slave got his liberation at last.','这个奴隶最终得到了解放。','got his liberation','liber自由 + ation名词后缀 → 使自由 → liberation解放；释放',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1441,'ordinary','ordinary','/ˈɔːrdneri/','adj.普通的，平常的','not unusual or different in any way','I\'m just an ordinary man.','我只是一个再平常不过的男人。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1442,'faultless','faultless','/ˈfɔːltləs/','adj. 无错误的，没缺点的，无瑕疵的，无可挑剔的','having no mistakes','An excellent student, her schoolwork was always faultless.','学霸的作业总是无可挑剔。','','fault错误 + less无……的 → faultless无错误的，完美的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1443,'back_and_forth','back and forth','/bæk ənd fɔrθ/','phr. 来回地','toward the back and then toward the front: backward and forward','He paced back and forth outside the ward where his wife was giving birth.','他在妻子的产房外来回踱步。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1444,'embarrassment','embarrassment','/ɪmˈbærəsmənt/','n.尴尬；令人难堪的人或事','','Much to his embarrassment, everyone saw his open zip.','被别人看到自己的拉链没拉，他觉得十分尴尬。','to his embarrassment','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1445,'timidity','timidity','/tɪˈmɪdəti/','n. 胆怯','the quality of being shy and nervous','His timidity gives him nerves before performing onstage.','在上台表演前，他因为胆怯而紧张。','','timid胆怯的 ＋ ity性质 → timidity胆怯；胆小',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1446,'sort_sth._out','sort sth. out','/sɔːrt ˈsʌmθɪŋ aʊt/','phr. 分类，拣选，整理','arrange or order by classes or categories','I sorted the food out according to their varieties.','我根据食物的种类把食物分类了。','sorted the food out','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1447,'merely','merely','/ˈmɪrli/','adv.仅仅，只不过','used meaning ‘only’ or ‘simply’ to emphasize a fact or something that you are saying','At first he was scared of it, but later he found it was merely a cat.','起初他很害怕，但后来他发现那只是一只猫。','','mere仅仅 + ly……的 → adv.仅仅，只不过',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1448,'topple','topple','/ˈtɑːpl/','v. 摇摇欲坠，推翻，颠覆','to cause (something) to become unsteady and fall','The boy lost balance and the great pile of books toppled over.','那个男孩失去了平衡，一大堆书倒了下来。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1449,'installation','installation','/ˌɪnstəˈleɪʃn/','n. 安装，装置','the act of fixing equipment or furniture in position so that it can be used;  a piece of equipment or machinery that has been fixed in position so that it can be used','The installation of the new air conditioner is almost complete.','这台新空调基本安装好了。','','install安装 + ation名词后缀 → installation安装',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1450,'revolver','revolver','/rɪˈvɑːlvər/','n. 左轮手枪；旋转式装置','a small gun that has a container for bullets that turns around so that shots can be fired quickly without having to stop to put more bullets in','The cowboy is holding two revolvers in his hands; you better stay clear!','这个牛仔手中拿着两把左轮手枪，你最好离他远点！','','re再 ＋ volv旋转，卷 ＋ er表名词 → 子弹旋转打出 → revolver连发左轮手枪，旋转式装置',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1451,'inauguration','inauguration','/ɪˌnɔːɡjəˈreɪʃn/','n.就职典礼','the act of starting a new operation or practice','The new king is taking an oath at his inauguration.','新任国王正在他的就职典礼上宣誓。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1452,'rig','rig','/rɪɡ/','n. 钻井架；装备；帆具；成套器械；  v. 操纵；装配；欺骗','(especially in compounds) a large piece of equipment that is used for taking oil or gas from the ground or the bottom of the sea','The oil rig extracts oil from the ocean.','石油钻井架从海洋中提取石油。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1453,'decide','decide','/dɪˈsaɪd/','v.决定','to think carefully about the different possibilities that are available and choose one of them; to make an official or legal judgement; to affect the result of something; to be the reason why somebody does something','It\'s time to decide which way to go.','是时候决定走哪条路了。','','de使…成为 + cide切 → 切下去 → 下决心 → 决定，决心',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1454,'gift','gift','/ɡɪft/','n.天赋','a thing that you give to somebody, especially on a special occasion or to say thank you','She has a gift for math.','她有数学天赋。','a gift for','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1455,'plough','plough','/plaʊ/','vt. 犁，耕；  vi. 艰难地前进；  n. 犁；  vt. 乘风破浪前进','to dig and turn over a field or other area of land with a plough','We plough the fields so we can grow crops.','我们耕地，这样我们就能种植庄稼了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1456,'get_out_of','get out of','/ɡet aʊt ɑv/','phr. 下（车）；摆脱；逃避','','He pretends to be sick to get out of going to work.','他装病逃工。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1457,'dig_out','dig out','/dɪɡ aʊt/','phr. 掘出，发现','to remove somebody/something from somewhere by digging the ground around them or it','The dog is trying to dig out something on the beach.','这只狗正在沙滩上试图挖出什么东西。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1458,'culminate','culminate','/ˈkʌlmɪneɪt/','v. 使达高潮，使结束','to end with a particular result, or at a particular point','The marathon culminates in a winner.','在冠军产生时，马拉松比赛气氛达到了高潮。','','culmin顶 + ate动词后缀：使到达…… → culminate使达高潮',5,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1459,'by_mistake','by mistake','/baɪ mɪˈsteɪk/','phr. 错误地','','He took someone else\'s umbrella by mistake.','他错拿了别人的伞。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1460,'catching','catching','/ˈkætʃɪŋ/','adj. 传染的；迷人的，有魅力的','(of a disease) easily caught by one person from another','His flu was catching, and soon the whole office was ill.','他得的流感会传染，然后很快整个办公室都生病了。','','catch抓 + ing形容词后缀 → catching有魅力的，传染的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1461,'brush','brush','/brʌʃ/','n.画笔，笔刷；小冲突','an object made of short stiff hairs (called bristles ) or wires set in a block of wood or plastic, usually attached to a handle. Brushes are used for many different jobs, such as cleaning, painting, writing and tidying your hair.','Brushes of different sizes may be applied in different situations.','不同尺寸的画笔用于不同的情况。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1462,'crayon','crayon','/ˈkreɪən/','n.蜡笔，彩色粉笔','a coloured pencil or stick of soft coloured chalk or wax, used for drawing','The child colored many pictures with crayons.','小孩子用蜡笔给许多图画上色。','','cray拉丁文粉笔之意 + on表示物 → crayon彩色粉笔',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1463,'sadly','sadly','/ˈsædli/','adv.悲哀地；悲痛地','','"I didn\'t do very well in the exam," she said sadly.','“我没有考好。”她悲伤地说道。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1464,'fortunate','fortunate','/ˈfɔːrtʃənət/','adj.幸运的','having or bringing an advantage, an opportunity, a piece of good luck, etc.','It\'s fortunate to find a four-leaf clover.','能找到一片四叶草是件非常幸运的事。','','fortun=fort运气 + ate…的 → fortunate幸运的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1465,'crane','crane','/kreɪn/','n.起重机；  v.伸长（脖子）以便看得更清楚','a tall machine with a long arm, used to lift and move building materials and other heavy objects; a large bird with long legs and a long neck','The crane is lifting the girders to construct the building.','为了修房子，起重机正吊起大梁。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1466,'socialist','socialist','/ˈsoʊʃəlɪst/','adj.社会主义的；  n.社会主义者','connected with socialism; governed by or belonging to a party that believes in socialism','Do you know the core socialist values?','你知道社会主义核心价值观吗？','','social社会的 + ist信仰者，专家 → socialist社会主义者（的）',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1467,'sinister','sinister','/ˈsɪnɪstər/','adj.不吉祥的，险恶的','having an evil appearance :looking likely to cause something bad, harmful, or dangerous to happen','I can\'t stand the clown, because he always looks so creepy and sinister.','我无法忍受这个小丑，因为他看上去既恐怖又凶险。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1468,'expectancy','expectancy','/ɪkˈspektənsi/','n.预期；期待','','Human\'s life expectancy is higher now than in the past.','现在人类的平均预期寿命比过去长了。','','expect期望 + ancy名词后缀 → expectancy 预期',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1469,'entitle','entitle','/ɪnˈtaɪtl/','v. 给（书）题名；给予…权利','to give a title to a book, play, etc.','The book is entitled: The Journey Westward.','这本书被题名为《西游记》。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1470,'obliged','obliged','/əˈblaɪdʒd/','adj.感激的','under a moral obligation to do something','They were much obliged to the vet who saved the kitten.','他们非常感激兽医救了小猫。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1471,'waltz','waltz','/wɔːls/','n.华尔兹舞；  v.大摇大摆地走','','They are learning how to dance the waltz.','他们正在学怎么跳华尔兹。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1472,'hound','hound','/haʊnd/','n. 猎犬；  v. 追逼；烦扰；纠缠','a dog that can run fast and has a good sense of smell, used for hunting','My little hound has a great sense of smell.','我的小猎犬鼻子很灵。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1473,'crush','crush','/krʌʃ/','v.压扁，压坏；镇压；  n.拥挤的人群','to press or squeeze something so hard that it is damaged or injured, or loses its shape; to push or press somebody/something into a small space','The can was crushed and put into the recycling bin.','易拉罐被压扁并扔进了可回收垃圾桶中。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1474,'walk','walk','/wɔːk/','v.行走；  n.散步','to spend time walking for pleasure','Many people are walking on the road.','许多人行走在路上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1475,'hundred','hundred','/ˈhʌndrəd/','num.百，百个；  n.许多','the number 100','Whose face is on the hundred-dollar bill?','一百元美钞上是谁的脸？','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1476,'absolute','absolute','/ˈæbsəluːt/','adj.绝对的；完全的','total and complete','Motion is absolute, while stillness is relative.','运动是绝对的，静止是相对的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1477,'deplete','deplete','/dɪˈpliːt/','v. 耗尽，用尽；使大大减少','[usually passive] to reduce something by a large amount so that there is not enough left','His energy level was depleted, because he didn\'t eat breakfast.','他的精力被耗尽了，因为他没吃早饭。','','de否定，非，相反 + plete=fill表示“满，填满” → vt.耗尽，用尽；使衰竭，使空虚',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1478,'stem_from','stem from','/stem frʌm/','phr. 源于','','His fear of dogs stems from an incident when he was a child.','他对狗的恐惧源自于他小时候的一个意外。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1479,'hit_it_off_(with_sb._together)','hit it off (with sb./together)','/hɪt ɪt ɑːf wɪθ ˈsʌmbədi təˈɡeðər/','v. 一见如故，合得来','get along well (with)','When he compared my music to high mountains and flowing water, we hit it off.','他将我的音乐比作高山流水，这令我们一见如故。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1480,'navigable','navigable','/ˈnævɪɡəbl/','adj.（江河、海洋）可航行的，可通航的','deep and wide enough for boats and ships to travel on or through :capable of being navigated','The river is wide enough to be a navigable route for ships.','这条河很宽，足以成为船只的通航路线。','','nav船+ig走+able可…的 → 可航行的，可通航的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1481,'black','black','/blæk/','adj.黑色的；  n.黑人；黑色','having the very darkest colour, like coal or the sky at night','Her shiny black hair is beautiful.','她的闪亮黑发很美。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1482,'founder','founder','/ˈfaʊndər/','n. 奠基者','a person who starts an organization, institution, etc. or causes something to be built','He is widely regarded as the founder of modern physics.','他被广泛认为是现代物理学的奠基者。','','found基础 + er人 → founder奠基者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1483,'warfare','warfare','/ˈwɔːrfer/','n. 战争；斗争，冲突','the activity of fighting a war, especially using particular weapons or methods','Violent warfare is taking place in this area.','这个地区正爆发着一场激烈的战争。','','war战争 + fare经过 → 战争(状态)；斗争，冲突',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1484,'turkey','turkey','/ˈtɜːrki/','n.火鸡','large gallinaceous bird with fan-shaped tail; widely domesticated for food','The man is holding a big roast turkey.','这个男人手里拿着一只大的烤火鸡。','roast turkey','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1485,'intrigue','intrigue','/ɪnˈtriːɡ/','n. 阴谋；诡计；  v. 密谋；欺骗；引起极大兴趣','the activity of making secret plans in order to achieve an aim, often by tricking people','An evil intrigue suddenly comes to his mind.','他的脑中突然浮现出一个邪恶的阴谋。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1486,'eggplant','eggplant','/ˈeɡplænt/','n.茄子','a vegetable with shiny dark purple skin and soft white flesh','The eggplant was cut into slices.','茄子被切成了片状。','','egg鸡蛋 + plant植物 → 像蛋一样的植物 → eggplant茄子',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1487,'universe','universe','/ˈjuːnɪvɜːrs/','n.宇宙，天地万物','the whole of space and everything in it, including the earth, the planets and the stars; a system of stars, planets, etc. in space outside our own; a particular area of experience or activity','There are a lot of stars in the universe.','宇宙中有很多星星。','','uni一个 + vers转向 + e → 统一旋转 → universe宇宙',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1488,'prejudice','prejudice','/ˈpredʒudɪs/','n.偏见，成见；损害，侵害；  vt.使抱有偏见','an unfair feeling of dislike for a person or group because of race, sex, religion, etc.','The other elephants held a prejudice against him because of his giant ears.','其他大象因他的大耳朵而对其抱有偏见。','','pre预先 + judice判断 → 预先判断 → 偏见',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1489,'at_fault','at fault','/ət fɔlt/','phr. ⋯⋯过错，⋯⋯责任','deserving blame','Since he was texting while driving, he was at fault for the accident.','因为他在开车时发短信，所以他对这场事故负有责任。','at fault in the accident','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1490,'everyday','everyday','/ˈevrideɪ/','adj.日常的，每天的','used or happening every day or regularly; ordinary','Doing exercise and keeping a healthy diet have become my everyday life.','做运动和坚持健康的饮食已经成了我的日常生活。','','every每个的 + day天 → everyday每天的，日常的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1491,'be_stressed_out','be stressed out','/bi strest aʊt/','phr. 紧张，有压力的','If someone is stressed out, they are very tense and anxious because of difficulties in their lives.','Being stressed out all the time is not good for your health.','一直紧张对你的健康不利。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1492,'interviewee','interviewee','/ˌɪntərvjuːˈiː/','n. 被接见者，被访问者','a person who is interviewed','The interviewee is trying to land a job in that company.','被接见者试图在那家公司谋得一份工作。','','inter在…之间，相互 ＋ view观察 ＋ ee被动者 → interview面试 ＋ ee被动者 → interviewee被接见者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1493,'microfilm','microfilm','/ˈmaɪkroʊfɪlm/','n. 微缩胶片；  v. 缩微拍摄','film on which very small photographs of the printed pages of a newspaper, magazine, etc., are stored','Microfilms can store many photos.','微缩胶片能储存许多照片。','','micro微，小 ＋ film胶片 → microfilm微缩胶卷',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1494,'inaccessible','inaccessible','/ˌɪnækˈsesəbl/','adj. 难达到的','difficult or impossible to reach or to get','This remote area is inaccessible to all but the most adventurous.','只有最勇敢的人才能接近这片边远地带。','','in不 + ac一再 + cess行走 + ible……的 → 走得太快跟不上 → inaccessible难以接近的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1495,'confront','confront','/kənˈfrʌnt/','vt.与某人对峙；与……对抗；正视','to make somebody face or deal with an unpleasant or difficult person or situation; to have something in front of you that you have to deal with or react to','The two men confront each other with anger.','两个男人面带怒火，相互对峙。','confront each other','con共同 + front前额 → 互相面对 → confront对抗，面临',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1496,'propriety','propriety','/prəˈpraɪəti/','n. 礼节；适当','the rules of correct behaviour','He has a high sense of propriety and believes in being a gentleman.','他非常注重礼节，坚信自己要当一个绅士。','','propri恰当的 + ety表名词，状态 → 拥有[风度] → propriety适当',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1497,'proficient','proficient','/prəˈfɪʃnt/','adj. 精通的，熟练的','able to do something well because of training and practice','She\'s proficient in several languages.','她精通几门语言。','','pro向前，在前 + fici做 + ent形容词后缀 → 做在别人前面 → proficient精通的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1498,'host','host','/hoʊst/','n.主人，东道主；  v.主持，主办','a person who invites guests to a meal, a party, etc. or who has people staying at their house','The hosts had cooked food for us, so we brought some wine for them.','主人们为我们做了饭菜，所以我们给他们带了一些红酒。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1499,'silent','silent','/ˈsaɪlənt/','adj.沉默的，安静的；  n.无声电影','not speaking or making noise','We should keep silent in the library.','在图书馆里我们应当保持安静。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1500,'jargon','jargon','/ˈdʒɑːrɡən/','n. 行话，术语','words or expressions that are used by a particular profession or group of people, and are difficult for others to understand','I didn\'t understand all the horse and riding jargon he was using.','我不懂他所说的关于马和骑马的行话。','horse and riding jargon','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1501,'amazement','amazement','/əˈmeɪzmənt/','n.惊愕，惊异','a feeling of great surprise','The cute cat stares at the mirror in amazement.','这只可爱的猫一脸惊愕地盯着镜子。','','amaze使惊讶 ＋ ment表示行为、行为的过程或结果 → amazement惊异；惊愕',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1502,'cube','cube','/kjuːb/','n. 立方体，立方','the number that you get when you multiply a number by itself twice','A cube is a three dimensional square.','立方体是个三维正方体。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1503,'out_of_breath','out of breath','/aʊt əv breθ/','phr.上气不接下气','having difficulty breathing after exercise','I’m out of breath after a long run.','长跑以后我上气不接下气。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1504,'demonstrate','demonstrate','/ˈdemənstreɪt/','vt.演示，展示；（用实例、实验）论证；示范','to show (a quality, feeling, etc.) clearly to other people','The salesman demonstrates how the device works on a watermelon.','推销员在演示怎么操作切瓜神器。','','de加强 + monstr指出 + ate动词后缀 → 特别指出 → demonstrate证明',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1505,'at_one\'s_disposal','at one\'s disposal','/æt wʌnz dɪˈspoʊzl/','phr.任由某人使用','','The car in the garage is at my disposal.','车库里的车任由我使用。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1506,'denial','denial','/dɪˈnaɪəl/','n. 否认；拒绝给予','a statement that says something is not true or does not exist','She was in denial and wouldn\'t believe the bad news.','她坚决否认，就是不肯相信这个坏消息。','','den否认 + ial名词后缀 → denial否认',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1507,'collide','collide','/kəˈlaɪd/','vi. 互撞；碰撞；抵触','if two people, vehicles, etc. collide, they crash into each other; if a person, vehicle, etc. collides with another, or with something that is not moving, they crash into it','The cars collided because the road was slippery.','因为路面湿滑，这两辆汽车相撞了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1508,'engaged_to_sb.','engaged to sb.','/ɪnˈɡeɪdʒd tuː ˈsʌmbədi/','phr. 和…订婚','pledged to be married','She got engaged to her boyfriend, look at the engagement ring.','她跟男朋友订婚啦，看那订婚戒指。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1509,'guard','guard','/ɡɑːrd/','n.哨兵，警卫员；  vi.警惕；  vt.保卫，守护','a person, such as a soldier, a police officer or a prison officer, who protects a place or people, or prevents prisoners from escaping','The guard stood outside and defended the palace gates.','哨兵站在外面看守宫殿的大门。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1510,'excellent','excellent','/ˈeksələnt/','adj. 优秀的；极好的','extremely good','He\'s an excellent student who always gets excellent scores.','他是个优秀的学生，总是得高分。','','ex离开 + cell监狱 + ent…的 → 品德优秀的人离监狱很远 → excellent杰出的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1511,'moderately','moderately','/ˈmɑːdərətli/','adv. 适度地，有节制地','within reasonable limits; to an average extent; fairly but not very','I bought a moderately priced car: it is not too expensive nor too cheap.','我买了一辆价格适中的车：既不太贵也不太便宜。','','mod方式、模式、风度 + er表示反复动作 + ate具有..的性质 + ly表示如...的 → moderately适度地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1512,'steel','steel','/stiːl/','n.钢，钢铁，钢制品；  v.下决心应对（不愉快的事）；  adj.钢的，与钢有关的','a strong hard metal that is made of a mixture of iron and carbon; the industry that produces steel; a long thin straight piece of steel with a rough surface, used for rubbing knives on to make them sharp','Steel can be used to reinforce concrete in the construction of buildings.','在建造房屋时，钢铁可以用于加固混凝土。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1513,'bury','bury','/ˈberi/','v. 隐藏，埋藏；埋葬','to place a dead body in a grave','The boy buried his body in a pile of fall leaves.','这个男孩把自己的身体埋在一堆秋叶之中。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1514,'segregate','segregate','/ˈseɡrɪɡeɪt/','v. 分开，隔离，进行种族隔离','to separate people of different races, religions or sexes and treat them in a different way; to keep one thing separate from another','The police segregated the two rival camps of protesters.','警察把两个对立的抗议者阵营隔离开来。','','se分开，离开，区别开 + greg群 + ate动词后缀 → 和人群分开 → 隔离',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1515,'be_eager_to_do_sth.','be eager to do sth.','/bi ˈiːɡər tu duː ˈsʌmθɪŋ/','phr. 急欲，渴望做','wanting very much to do something, especially something interesting or enjoyable','He hasn\'t had food for days, and is eager to eat the steak.','他几天没吃东西了，非常渴望能吃掉这块牛排。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1516,'fling','fling','/flɪŋ/','v. 掷，抛；猛烈地移动；  n. 尽情欢乐的一阵，一时的放纵','to throw somebody/something somewhere with force, especially because you are angry','He flung a handful of brown dirt.','他把一捧黄土抛了出去。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1517,'stigma','stigma','/ˈstɪɡmə/','n.耻辱，污名；【植】柱头','a set of negative and often unfair beliefs that a society or group of people have about something','He attracts unwanted attention from the crowd due to the stigma of being a prisoner.','坐牢的耻辱让他被人指指点点。','','stigm标志，斑点 + a表名词 → stigma污点；不名誉的事',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1518,'transmission','transmission','/trænsˈmɪʃn/','n.传输，发射','the act or process of passing something from one person, place or thing to another; the act or process of sending out an electronic signal or message or of broadcasting a radio or television programme; a radio or television message or broadcast; the system in a vehicle by which power is passed from the engine to the wheels','This tower was built for mobile phone signal transmission.','这座塔是用来传输手机信号的。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1519,'landing','landing','/ˈlændɪŋ/','n.登陆，着陆；码头；降落；楼梯平台','an act of bringing an aircraft or a spacecraft down to the ground after a journey; the area at the top of a set of stairs where you arrive before you go into an upstairs room or move onto another set of stairs; an act of bringing soldiers to land in an area that is controlled by the enemy; a flat wooden platform on the water where boats let people get on and off, and load and unload goods','Air traffic controllers\' instructions are crucial for the safe landing of aircrafts.','空中交通管制员的指挥对飞机的安全着陆至关重要。','','land陆地 + ing名词后缀 → landing登陆，着陆，码头',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1520,'dine','dine','/daɪn/','v.用正餐（或晚餐）；招待……吃饭','to eat dinner','The happy family are dining together at a restaurant.','幸福的一家人正在餐馆里吃饭。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1521,'courtesy','courtesy','/ˈkɜːrtəsi/','n. 礼貌','a polite thing that you say or do when you meet people in formal situations','He helped her out of the car out of courtesy.','他出于礼貌扶她下了车。','out of courtesy','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1522,'go_without_(sth.)','go without (sth.)','/ɡoʊ wɪˈðaʊt ˈsʌmθɪŋ/','v. 在缺少…的情况下勉强对付','manage with an effort to do sth.','The man is so busy and goes without lunch, only bringing a sandwich.','他很忙并且没吃午饭就出门了，只带了一个三明治勉强对付。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1523,'handle','handle','/ˈhændl/','n. 柄，把手；  v. 处理，解决','the part of a door, drawer, window, etc. that you use to open it; the part of an object, such as a cup, a bag or a tool, that you use to hold it or carry it','Turn the handle to open the door.','转动把手来开门。','Turn the handle','hand手 + le表示做某种动作时所使用的东西 → handle柄，把手',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1524,'deal','deal','/diːl/','n.协议；大量；  vi.处理','an agreement, especially in business, on particular conditions for buying or doing something','So we agree, you\'ll buy my house? Do we have a deal? Good!','那么你确定要买我的房子？我们说好了吧？很好！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1525,'heavily','heavily','/ˈhevɪli/','adv.重重地，沉重地，沉闷地，猛烈地','to a great degree; in large amounts','Her addiction to cigarettes weighed heavily on her.','沉迷于香烟使她不堪重负。','weighed heavily on','heav沉重的 + i + ly副词后缀 → heavily沉重地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1526,'rectification','rectification','/ˌrektɪfɪˈkeɪʃn/','n. 改正','(chemistry) the process of refinement or purification of a substance by distillation','The cat using the litter tray was evidence that its rectification training had been successful.','猫在使用猫砂盆，这证明了对它的矫正训练是成功的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1527,'wait_on','wait on','/weɪt ɑːn/','phr. 服侍',' work for or be a servant to','He waited on tables in a restaurant.','他在一家饭店招待顾客。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1528,'office','office','/ˈɔːfɪs/','n. 办公室；处，局，社','a building or room in which people work at desks doing business or professional activities','I like office work—I can wear smart clothes and stay indoors.','我喜欢在办公室工作——可以穿得漂亮而且不用外出。','office work','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1529,'origin','origin','/ˈɔːrɪdʒɪn/','n.起源','the point from which something starts; the cause of something','The origin of humankind is still mysterious, but we think our ancestors lived in the trees.','虽然人类的起源仍然是谜，但是我们认为我们的祖先生活在树上。','','origin=orig升起，开始 → [生命]开始 → origin起源',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1530,'doughnut','doughnut','/ˈdoʊnʌt/','n. 甜甜圈；油炸圈饼；多纳滋','','There are some delicious doughnuts in the box.','盒子里有些美味的甜甜圈。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1531,'take_to_sth._sb.','take to sth./sb.','/teɪk tu ˈsʌmθɪŋ ˈsʌmbədi/','phr. 喜欢；养成…习惯','be fond of','The little boy really took to the girl, and now they play together every day.','小男孩真的喜欢这女孩，如今他们每天都一起玩。','took to the girl','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1532,'election','election','/ɪˈlekʃn/','n.选举','the process of choosing a person or a group of people for a position, especially a political position, by voting','In an election, we decide who our leaders will be.','在选举中，我们决定谁来当我们的领导人。','','e出 + lect选择，收集 + ion名词后缀 → election选举',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1533,'reckon','reckon','/ˈrekən/','vt.估算；认为','to calculate an amount, a number, etc.','The agent reckoned the house was worth about 500,000 yuan.','房屋中介估算这房子价值50万元。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1534,'forbid','forbid','/fərˈbɪd/','v.禁止','to order somebody not to do something; to order that something must not be done','We forbid smoking in the restaurant.','餐厅内禁止吸烟。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1535,'poke','poke','/poʊk/','n. 戳，捅；  v. 探（出），露出','the action of quickly pushing your fingers or another object into somebody/something','She poked him in the shoulder to get his attention.','她戳了戳他的肩膀以引起他的注意。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1536,'corporation','corporation','/ˌkɔːrpəˈreɪʃn/','n. 企业，公司','a large business or organization that under the law has the rights and duties of an individual and follows a specific purpose','In our corporation, we listen to everyone\'s opinion.','在我们公司，我们会听取所有人的意见。','','corporat(e)公司的 + ion名词后缀 → corporation公司',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1537,'by_and_by','by and by','/baɪ ənd baɪ/','phr. 逐渐地，不久以后','a future time or occasion','By and by, the tree will lose its leaves.','渐渐地，这棵树的叶子会落光。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1538,'balance_between...and...','balance between...and...','/ˈbæləns bɪˈtwiːn ənd/','phr. 平衡…和…','two(group of) things that are equal in importance','This woman creates a balance between work and family.','这位女士在工作和生活间找到了一种平衡。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1539,'agreement','agreement','/əˈɡriːmənt/','n. 协议，协定','an arrangement, a promise or a contract made with somebody','The two businessmen signed a long-term agreement to cooperate.','这两名商人签署了长期合作协议。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1540,'absolutely','absolutely','/ˈæbsəluːtli/','adv. 绝对地','used to emphasize that something is completely true','The ad said the product was absolutely guaranteed to work.','广告说这个产品是保证绝对有效的。','','ab不 ＋ solute松开 ＋ ly...地 → 不松开地 → absolutely绝对地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1541,'thread','thread','/θred/','n.线','a thin string of cotton, wool, silk, etc. used for sewing or making cloth','I can use these colorful threads to make knitted scarves.','我能用这些五颜六色的线织成漂亮的围巾。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1542,'stipend','stipend','/ˈstaɪpend/','n. 奖学金；定期津贴','an amount of money that is paid regularly to somebody, especially a priest, as wages or money to live on','My company gives me a stipend to cover my expenses while I go to business school.','公司给我发了奖学金，用来支付上商学院的费用。','a stipend to cover my expenses','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1543,'irrespective','irrespective','/ˌɪrɪˈspektɪv/','adj. 不考虑的，不顾的','without considering something or being influenced by it','Bookstores should be open to everyone, irrespective of whether they are rich or poor.','书店应该对每个人开放，不管他们是富裕还是贫穷。','','ir不 + re相反 + spect看 + ive……的 → 分别的（各顾各的）→ irrespective不考虑的，不顾及的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1544,'daily','daily','/ˈdeɪli/','adj. 每日的，日常的；  n. 日报','happening, done or produced every day; connected with one day’s work','I like to read the daily paper every morning.','我喜欢在每天早上读日报。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1545,'irrigate','irrigate','/ˈɪrɪɡeɪt/','v. 灌溉，冲洗','to supply water to an area of land through pipes or channels so that crops will grow','This machine can irrigate the field.','这台机器可以灌溉田地。','irrigate the field','ir使…成为，进入 + rig船桅装置 + ate动词后缀 → 水进船 → irrigate灌入水，灌溉',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1546,'diversity','diversity','/daɪˈvɜːrsəti/','n.多样性，差异，不同','a range of many people or things that are very different from each other; the quality or fact of including a range of many people or things','We can see a great ethnic diversity from these kids.','从这些孩子身上，我们可以看到种族多样性。','ethnic diversity','di分开 ＋ vers转变 ＋ ity表名词 → 分开转变 → diversity多样性',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1547,'forefinger','forefinger','/ˈfɔːrfɪŋɡər/','n. 食指','the finger that is next to the thumb','Raising his forefinger, he began to give instructions to the team.','伸出食指，他开始指导团队工作。','Raising his forefinger','fore前 ＋ finger手指 → forefinger食指',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1548,'oasis','oasis','/oʊˈeɪsɪs/','n.绿洲；令人欣慰的事物','an area in a desert where there is water and plants','It is the only oasis in this desert.','这是这片沙漠里的唯一绿洲。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1549,'in_the_end','in the end','/ɪn ðə end/','phr.最后，终于','as the end result of a succession or process','He got off to a bad start, but in the end he won the race.','他出发时不很顺利，但是最终赢得了比赛。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1550,'agriculture','agriculture','/ˈæɡrɪkʌltʃər/','n.农业','the science or occupation of farming','We depend on agriculture to give us food.','我们依靠农业给我们提供食物。','','agri田地 + cult耕种 + ure表名词 → 在田地里耕作 → agriculture农业',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1551,'well','well','/wel/','adj.健康的','in a good state or position; in good health','Both my parents are very well.','我的父母都很健康。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1552,'lump','lump','/lʌmp/','n. 肿块；粗笨的人；  v. 成团，成堆；使成块；  n. 一小方块 (糖)','a swelling under the skin, sometimes a sign of serious illness','There is a lump on his neck.','他脖子上有一个肿块。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1553,'curtail','curtail','/kɜːrˈteɪl/','vt. 削减；剥夺…特权','to reduce or limit (something)','You\'ll have to curtail your spending—we\'re almost out of money!','你必须削减开支——我们快没钱了。','curtail your spending','cur短+tail剪，割→减短；参考',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1554,'figure_out','figure out','/ˈfɪɡjər aʊt/','phr.想出','to think about somebody/something until you understand them/it; to calculate an amount or the cost of something','Let me figure out what I can make for dinner. OK, got it!','让我想想我能做什么当晚餐。啊，想到了！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1555,'charter','charter','/ˈtʃɑːrtər/','n. 宪章；特权，豁免权；租赁；  v. 包，租（汽车等）','an official document stating that a ruler or government allows a new organization, town or university to be established and gives it particular rights','The American Constitution is a charter that outlines a system of government.','美国宪法是一个概述政府系统的章程。','','chart纸板，图 + er表名词 → 纸上的东西 → charter契约',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1556,'floor','floor','/flɔːr/','n.地板，地面；楼层；底部；  vt.铺地板；击倒','the part of a room on which you stand','The floor of this room is made of wood.','这个房间的地板是木头做的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1557,'wail','wail','/weɪl/','vi. 恸哭；悲叹；  n. 恸哭；  vt. 哀悼','to make a loud, long cry of sadness or pain','The baby began to wail when he woke up and his mom wasn\'t there.','这个宝宝醒来发现妈妈不在身边，开始放声大哭。','wailed with regrets','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1558,'let_alone','let alone','/let əˈloʊn/','phr. 不打扰；更别说','not trouble sb.','The child is very sad; he should just be let alone for now.','那个小孩很悲伤；现在应该让他一个人呆会儿。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1559,'objective','objective','/əbˈdʒektɪv/','n.目标；目的；  adj.客观的','something you are trying to do or achieve; a goal or purpose','The objective behind the business is very clear.','这单生意的目标是很明确的。','','ob反对 + ject投掷，扔 + ive形容词后缀 → 反对扔的 → objective客观的；目标',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1560,'sometime','sometime','/ˈsʌmtaɪm/','adv. 在某一时候；  adj. 某一时间的','at a time that you do not know exactly or has not yet been decided','Although I failed the exam, I believe that I will make it sometime.','虽然我考试失败了，但我相信总有一天我会成功的。','','some某 + time时间 → sometime在某一时侯',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1561,'manual','manual','/ˈmænjuəl/','adj.手工的；手的；手动的；  n.手册；指南','operated or controlled by hand rather than automatically or using electricity, etc.','Wow, you can drive a manual transmission car?','哇，你能驾驶手动挡汽车？','','manu手 + al形容词后缀 → manual手工的；手册',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1562,'animal','animal','/ˈænɪml/','n. 动物','a living thing that is not a human being or plant','There are many kinds of animals on Earth.','地球上的动物种类繁多。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1563,'affiliation','affiliation','/əˌfɪliˈeɪʃn/','n.联系，从属关系','','Each of these hospitals has an affiliation with the medical college.','这些医院都与这所医学院有从属联系。','','af加强 + fili=filial + ation表名词 → 收养为儿子 → affiliation入会',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1564,'faculty','faculty','/ˈfæklti/','n.教职工，全体教员；院系；能力','all the teachers of a particular university or college','The official website of the Law School shows a profile for each faculty.','法学院的官方网站上列有学院全体教师的个人简介。','','facul做 + ty表名词 → 会做东西 → faculty能力',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1565,'fond','fond','/fɑːnd/','adj.喜欢的','feeling affection for somebody, especially somebody you have known for a long time; finding something pleasant or enjoyable, especially something you have liked or enjoyed for a long time;  liking to do something which other people find annoying or unpleasant, and doing it often; kind and loving','The man is very fond of his horse.','这位男士很喜欢他的马。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1566,'predecessor','predecessor','/ˈpredəsesər/','n. 前辈；（被取代的）原有事物','a person who did a job before somebody else','He learned a lot from his experienced predecessor.','他从经验丰富的前辈那里学到了很多东西。','','pre前 + decess消逝，死 + or表示人 → predecessor前辈；前身',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1567,'contest','contest','/ˈkɑːntest/','n.比赛，竞争；  v.争夺，争论','a competition in which people try to win something; a struggle to gain control or power','The girl in the middle seems to be the winner of the contest.','中间的女生好像是这场比赛的胜者。','','con共同 + test测试 → 共同测试 → contest比赛，竞赛',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1568,'inevitable','inevitable','/ɪnˈevɪtəbl/','adj.不可避免的，必然的','that you cannot avoid or prevent','An accident seems inevitable driving so dangerously!','如此危险驾驶，一场车祸似乎已不可避免！','','in不 + evit避免 + able形容词后缀, 可...的 → 不可避免的，必然的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1569,'individually','individually','/ˌɪndɪˈvɪdʒuəli/','adv. 单独地','apart from others','After they performed as a team, everyone was scored individually.','当她们作为一个团队完成表演后，每个人都被单独地评了分。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1570,'ultimately','ultimately','/ˈʌltɪmətli/','adv. 最终，最后','as the end result of a succession or process','Ultimately, he decided to go to the university close to his home.','最终，他决定去离家近的那所大学。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1571,'symmetrical','symmetrical','/sɪˈmetrɪkl/','adj. 对称的','(of a body, a design, an object, etc.) having two halves, parts or sides that are the same in size and shape','The photo of the two swans is completely symmetrical.','这张有两只天鹅的照片是完全对称的。','','symmetr=symmetry对称 + ical表形容词 → symmetrical对称的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1572,'panorama','panorama','/ˌpænəˈræmə/','n. 全景，概观','a view of a wide area of land; a description, study or set of pictures that presents all the different aspects or stages of a particular subject, event, etc.','This panorama shows the entire downtown skyline.','这张全景显示了整个城市的天际线。','','pan广泛的 + orama视力 → 广泛视力范围所及的 → panorama全景，全貌',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1573,'dispense','dispense','/dɪˈspens/','v.分发，分配；免除；执行','to give out something to people; to provide something, especially a service, for people; to prepare medicine and give it to people, as a job','The Red Cross dispensed food to the poor families.','红十字会在向贫困家庭分发食品。','','dis分开，分离 + pense花费 → 分开花费 → 分配',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1574,'watt','watt','/wɑːt/','n. 瓦，瓦特','a unit for measuring electrical power','The power of the light bulb is 12 watts.','这个灯泡的功率是12瓦。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1575,'dial','dial','/ˈdaɪəl/','v.拨（电话号码）；  n.拨号盘','to use a telephone by pushing buttons or turning the dial to call a number','I am dialing a number on my phone.','我正在手机上拨电话号码。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1576,'nature','nature','/ˈneɪtʃər/','n. 大自然','all the plants, animals and things that exist in the universe that are not made by people; the way that things happen in the physical world when it is not controlled by people','She loves to relax surrounded by nature.','她喜欢在大自然的环绕下进行放松。','','nat出生的 + ure状态 → 出生状态 → nature天性',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1577,'exquisite','exquisite','/ɪkˈskwɪzɪt/','adj. 精致的，精选的','extremely beautiful or carefully made','I\'ve spent all my cash to buy you this exquisite necklace.','我花了所有钱给你买这条精致的项链。','','ex全部 + qui安静 + site位于 → 被这精美的东西迷住了，全部人都安静地坐着 → exquisite精美的，精致的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1578,'attention_to','attention to','/əˈtenʃn tuː/','phr. 对 ... 的注意','','The teacher told him to pay attention to his spelling.','老师提醒他注意自己的拼写。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1579,'get_round_sth.','get round sth.','/ɡet raʊnd ˈsʌmθɪŋ/','v. 规避（法律），避开','prevent the occurrence of; prevent from happening','You can only get round the obstacle by going off the road.','你只能开出道路外才能避开那个障碍物。','get round the obstacle','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1580,'terrain','terrain','/təˈreɪn/','n. 地面，地形','used to refer to an area of land when you are mentioning its natural features, for example, if it is rough, flat, etc.','From grasslands to deserts, there are many different types of terrain around the world.','从草原到沙漠，世界上有很多种不同的地形。','','terr地 + ain表名词 → 地形；地域',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1581,'monitor','monitor','/ˈmɑːnɪtər/','n.显示器；监视器；班长；  vt.监视；监督；监测','a device that shows information or images on a screen','I want a new flat-screen computer monitor.','我想要一台新的纯平电脑显示器。','computer monitor','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1582,'confederate','confederate','/kənˈfedərət/','adj. 同盟的，联合的；  n. 同盟国，同盟者；  v. 结盟，联合','of or relating to the Confederacy of the American Civil War','Britain and the USA have been confederate allies since WWII.','自二战以来，英国就是美国的同盟国。','confederate allies','con共同 + feder联盟 + ate...的 → 共同联盟的 → confederate联合的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1583,'make_sb._out_to_be','make sb. out to be','/meɪk ˈsʌmbədi aʊt tu bi/','v. 把…说成','to describe (someone or something) in a specified and usually false way','The colleagues make her out to be a bad person.','同事们把她说成坏人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1584,'glacier','glacier','/ˈɡleɪʃər/','n. 冰川，冰河','a large mass of ice, formed by snow on mountains, that moves very slowly down a valley','The glacier is made up of big blocks of ice.','冰川由大冰块组成。','','glac冰 ＋ ier表名词，人或物 → glacier冰河，冰川',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1585,'trademark','trademark','/ˈtreɪdmɑːrk/','v.登记…作为商标；  n.特征','to register something as a trademark','This is the trademark of a popular APP.','这是一款很火的应用的商标。','','trade贸易 + mark记号，符号 → trademark商标',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1586,'annex','annex','/əˈneks/','vt. 并吞，强行占取；  n. 附属的建筑物','to add (an area or region) to a country, state, etc. :to take control of (a territory or place)','Austria was annexed by Germany.','奥地利曾被德国吞并。','','an表方向 ＋ nex绑，连接 → annex附件，附加',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1587,'infringe','infringe','/ɪnˈfrɪndʒ/','v. 侵犯，违反，侵害','(of an action, a plan, etc.) to break a law or rule','This magazine article infringed on the privacy of the actress.','这家杂志上的文章侵害了这位女演员的隐私。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1588,'lame','lame','/leɪm/','adj.瘸的，跛的；（解释或借口）无说服力的，站不住脚的，蹩脚的','(of people or animals) unable to walk well because of an injury to the leg or foot','He walked into the hospital with a lame leg.','他跛着腿走进医院。','a lame leg','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1589,'refrain_from','refrain from','/rɪˈfreɪn frʌm/','phr. 戒（烟）','to avoid doing something or hold yourself back from doing something','It\'s hard to refrain from smoking, but I did it.','戒烟很难，但我做到了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1590,'survival','survival','/sərˈvaɪvl/','n.生存；存活','the state of continuing to live or exist, often despite difficulty or danger','He taught me survival skills, like how to start a fire in the forest.','他教我野外求生技能，比如如何在森林里生火。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1591,'avoid','avoid','/əˈvɔɪd/','v.避免，防止','to prevent something bad from happening; to keep away from somebody/something; to try not to do something','The driver avoided hitting the dogs on the road.','司机避免了撞到路上的狗。','avoided hitting the dogs','a=out处于 ＋ void空 → 空出来 → avoid避开，避免',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1592,'be_annoyed_with','be annoyed with','/bi əˈnɔɪd wɪð/','phr. 被 ... 惹恼','be slightly angry or irritated with','The mother is very annoyed with her son\'s behavior.','这位母亲对她孩子的行为感到非常恼火。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1593,'salute','salute','/səˈluːt/','v.向……敬礼；敬礼；  n.致敬，欢迎','to touch the side of your head with the fingers of your right hand to show respect, especially in the armed forces','The policeman salutes me as I walk by.','当我走过时，这位警察向我敬礼。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1594,'solvent','solvent','/ˈsɑːlvənt/','adj. 有溶解力的；有偿付能力的；  n. 解决方法','a liquid substance that is used to dissolve another substance','The liquid is solvent in water.','这种液体溶于水。','','solv=solu溶解 ＋ ent形容词后缀，表示具有...性质的 → solvent有溶解力的；有还债力的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1595,'feast','feast','/fiːst/','n.盛宴；节日；  v.尽情地吃','a large or special meal, especially for a lot of people and to celebrate something','This special feast consists of meats, vegetables, bread, wine and more.','这场特别的盛宴上有肉、蔬菜、面包和葡萄酒以及其他食物。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1596,'cutting','cutting','/ˈkʌtɪŋ/','n.剪报','a piece cut off a plant that will be used to grow a new plant；an article or a story that you cut from a newspaper or magazine and keep','Many students in primary school save cuttings from newspapers.','许多小学生保存有剪报。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1597,'timing','timing','/ˈtaɪmɪŋ/','n. 时机','','With perfect timing, he captured the perfect shot of the smile.','他在完美的时机抓拍下了完美的笑容。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1598,'target','target','/ˈtɑːrɡɪt/','n.靶子；  vt.瞄准','an object that people practise shooting at, especially a round board with circles on it','Yes! I hit the target, right in the center!','太好了！我击中了靶子，正中红心！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1599,'inequality','inequality','/ˌɪnɪˈkwɑːləti/','n. 不平等；不等式','the unfair difference between groups of people in society, when some have more wealth, status or opportunities than others','There is an inequality in family status between cats, dogs and people.','猫、狗和人的家庭地位是不平等的。','','in不 + equal平等 + ity表名词，指具备某种性质 → inequality不平等；不同',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1600,'productivity','productivity','/ˌprɑːdʌkˈtɪvəti/','n.生产力；生产率，生产力','the rate at which a worker, a company or a country produces goods, and the amount produced, compared with how much time, work and money is needed to produce them','A worker\'s productivity depends on how he balances time, costs and quality.','一个工人的生产力取决于他如何平衡时间、成本和产品质量。','','product产品 ＋ ivity表名词 → productivity生产力，生产活动',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1601,'sociology','sociology','/ˌsoʊsiˈɑːlədʒi/','n. 社会学','the scientific study of the nature and development of society and social behaviour','Sociology is the study of how different societies work.','社会学是一门研究不同社会怎样运作的学科。','','socio=social社会 + logy学科 → sociology社会学',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1602,'millionaire','millionaire','/ˌmɪljəˈner/','n. 百万富翁，大富翁','a person who has a million pounds, dollars, etc.; a very rich person','This millionaire has more cash than he knows what to do with.','这个百万富翁钱多得不知道怎么花了。','','million百万 + aire人 → 拥有百万资产的人 → millionaire百万富翁',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1603,'Easter','Easter','/ˈiːstər/','n. 复活节','(in the Christian religion) a Sunday in March or April when Christians remember the death of Christ and his return to life','On Easter, Christians like to decorate eggs.','在复活节的时候，基督教徒喜欢做彩蛋。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1604,'qualification','qualification','/ˌkwɑːlɪfɪˈkeɪʃn/','n.资格证明；获得资格，合格','a skill or type of experience that you need for a particular job or activity','I\'m delighted that I received this qualification from my university.','拿到了大学毕业证，我很开心。','','qual=quality质量 + ification表名词 → qualification资格证明',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1605,'locate','locate','/ˈloʊkeɪt/','v.使……坐落于，位于，处于；找出……的位置','to find the exact position of somebody/something','Some important cities are located in the places marked on the map.','一些重要的城市位于地图上面标出来的地方。','','loc地方 + ate表动词 → 找到地方 → locate探明；查出',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1606,'impressive','impressive','/ɪmˈpresɪv/','adj.给人深刻印象的','making a strong impression; deserving attention, admiration, or respect','Big buildings are an impressive part of a city.','高楼大厦是城市中令人印象深刻的一部分。','','impress印象 + ive形容词后缀 → 有印象的 → impressive印象深刻的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1607,'preside','preside','/prɪˈzaɪd/','v.主持','to lead or be in charge of a meeting, ceremony, etc.','The head of the company presided over this business conference.','公司领导主持了本次商务会议。','','pre前面 + side坐 → 在前面坐 → preside主持',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1608,'coil','coil','/kɔɪl/','n. （一）卷，（一）圈；  v. 卷，盘绕','a series of circles formed by winding up a length of rope, wire, etc.','This is a coil of metal wire.','这是一卷金属线。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1609,'consume','consume','/kənˈsuːm/','vt.消耗，耗尽','to use something, especially fuel, energy or time','We\'ve consumed all of the toilet paper that we bought from the supermarket.','我们把从超市买来的厕纸都用完了。','','con全部 + sum拿取 + e → 全部拿光 → consume消费',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1610,'club','club','/klʌb/','n.社团，俱乐部；夜总会；球棒','(especially in compounds) a group of people who meet together regularly, for a particular activity, sport, etc.','People are having fun in the night club.','人们在夜店里玩得很开心。','night club','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1611,'formula','formula','/ˈfɔːrmjələ/','n. 公式，方程式；配方奶粉；方案；方法','a series of letters, numbers or symbols that represent a rule or law; letters and symbols that show the parts of a chemical compound, etc.','The boy learned math and science formulas at a young age.','这个男孩儿很小的时候就学会了一些数理公式。','math and science formulas','form形式 + ula表名词 → 形成模式的 → formula公式',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1612,'fascist','fascist','/ˈfæʃɪst/','adj. 法西斯主义的','an adherent of fascism or other right-wing authoritarian views','Fascist ideologies have poisoned many people\'s minds.','法西斯主义毒害了很多人的思想。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1613,'comic','comic','/ˈkɑːmɪk/','adj.滑稽的，使人发笑的；  n.连环漫画杂志','amusing and making you laugh; connected with comedy (= entertainment that is funny and that makes people laugh)','His comic actions often make us laugh.','他滑稽的动作经常使我们大笑。','','com作乐 + ic形容词后缀 → comic好笑的，滑稽的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1614,'streak','streak','/striːk/','n. 条纹，条痕，色线；  v. 成条纹','a long thin mark or line that is a different colour from the surface it is on; a part of a person’s character, especially an unpleasant part; a series of successes or failures, especially in a sport or in gambling','She drew several black streaks on the paper using the writing brush.','她用毛笔在纸上画了几条黑色条纹。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1615,'flu','flu','/fluː/','n. 流感','a common disease that is caused by a virus and that causes fever, weakness, body aches, and breathing problems','It seems as though the whole family has the flu.','似乎全家人都得了流感。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1616,'camera','camera','/ˈkæmərə/','n. 照相机，摄影机','a device that is used for taking photographs or for making movies, television programs, etc.','She is able to take high quality photos with that camera.','她能用那台照相机拍出高质量的照片。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1617,'turn_out','turn out','/tɜːrn aʊt/','phr.结果是',' be shown or be found to be','The experiment didn\'t quite turn out like how he had expected.','实验结果并不像他所设想的那样。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1618,'hasty','hasty','/ˈheɪsti/','adj. 匆忙的；仓促完成的；草率的','(of a person) acting or deciding too quickly, without enough thought','He was hasty when running to the office.','他跑向办公室的时候显得很匆忙。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1619,'scientist','scientist','/ˈsaɪəntɪst/','n. 科学家','a person who is trained in a science and whose job involves doing scientific research or solving scientific problems','They are distinguished scientists in the fields of biology and physics.','他们是生物和物理领域杰出的科学家。','','scient有知识的 + ist从事某种职业的人 → scientist科学家',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1620,'membership','membership','/ˈmembərʃɪp/','n. 会员资格；成员资格','the state of belonging to or being a part of a group or an organization; the state of being a member','I now have a membership in the VIP club.','现在我有这家VIP俱乐部的会员资格了。','','member成员 + ship表名词 → 成员资格',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1621,'encounter_with','encounter with','/ɪnˈkaʊntər wɪð/','n.  偶遇，邂逅','','He had a rather alarming encounter with a wild pig.','他曾经偶遇过一头野猪，真是惊险。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1622,'pungent','pungent','/ˈpʌndʒənt/','adj. 刺鼻的；刺激性的','having a strong taste or smell','The onions are very pungent! I\'ll have to shut my nose.','洋葱很刺鼻，我得捂住鼻子。','onions are very pungent','pung点，变尖 ＋ ent形容词后缀 → 尖的 → pungent尖锐的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1623,'obstinate','obstinate','/ˈɑːbstɪnət/','adj. 顽固的；较难治愈的','refusing to change your opinions, way of behaving, etc. when other people try to persuade you to; showing this','My boss is very obstinate and never agrees with me.','我的老板非常顽固，从不同意我的建议。','','ob反 + stin站 + ate……的 → 和别人反着站 → 顽固的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1624,'stripe','stripe','/straɪp/','n. 条纹；长条','a long narrow line of colour, that is a different colour from the areas next to it','The woman by the pool is wearing a black and white striped skirt.','池子边的这位女士穿着一个黑白相间的短裙。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1625,'rhyme','rhyme','/raɪm/','n.押韵短诗；  v.押韵','a word that has the same sound or ends with the same sound as another word','She is teaching the poem that is written in rhyme.','她正在教这首押韵诗。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1626,'move','move','/muːv/','v. 移动；  n. 迁居','to change the place where you live, have your work, etc.','He\'s using a truck to help him move house.','他正用卡车搬家。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1627,'engrave','engrave','/ɪnˈɡreɪv/','v. 雕刻','to cut words or designs on wood, stone, metal, etc.','The artist is engraving patterns into the wood.','艺术家在木头上雕刻图案。','engraving patterns','en饰以…”、“配以…” + grave 雕刻 → vt. 雕刻；铭记',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1628,'jeopardy','jeopardy','/ˈdʒepərdi/','n. 危险；（被告处于被判罪或受处罚的）危险境地','in a situation in which someone or something is exposed to possible injury, loss, or evil :in danger','The man put himself in jeopardy by standing next to the falling wall.','这个男人站在危墙边，将自己置于危险之中。','','jeopard危及 + y名词后缀 → jeopardy危险',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1629,'break','break','/breɪk/','v.打破，摔碎；  n.缝隙','to be damaged and separated into two or more parts, as a result of force','The football broke the glass into pieces.','足球把玻璃打碎了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1630,'term','term','/tɜːrm/','n.学期；  vt.把……称为','each of the various parts in a series, an equation, etc.','The autumn term in China begins from September 1st.','中国的秋季学期是从9月1日开始的。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1631,'take_sth._upon_oneself','take sth. upon oneself','/teɪk ˈsʌmθɪŋ əˈpɔːn wʌnˈself/','phr. 承担；担任','promise to do or accomplish','The father was sick, so the kids took it upon themselves to wash the car.','父亲生病了，所以孩子们承担起了洗车的工作。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1632,'will','will','/wɪl/','n.意志','used for talking about or predicting the future','He had a strong will, believing he could win the championship.','他意志坚强，相信自己一定能够夺冠。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1633,'milky','milky','/ˈmɪlki/','adj. 牛奶般的；乳白色的','like milk','She took great care of her milky skin.','她把她牛奶般的皮肤保养得真好。','milky skin','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1634,'no_fewer_than','no fewer than','/noʊ ˈfjuːə ðæn/','phr. 不少于，至少','used before a number to emphasize that it is larger that you might expect','OMG! I have no fewer than 20 books to read before my final examination.','我的天呐！在期末考试之前我至少有20本书要读。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1635,'investment','investment','/ɪnˈvestmənt/','n.投资','the act of giving time or effort to a particular task in order to make it successful','Buying property is a common type of investment nowadays.','购买房产是当今一种常见的投资方式。','','invest投资 + ment表名词 → investment投资',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1636,'foam','foam','/foʊm/','n.泡沫；泡沫橡胶','a chemical substance that forms or produces a soft mass of very small bubbles, used for washing, shaving, or putting out fires, for example','I made a heart with the foam.','我用泡沫做了个爱心的图案。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1637,'woolen','woolen','/ˈwʊlən/','adj.羊毛的；毛纺的','made of wool','He wanted to make a woolen scarf.','他想做一条羊毛围巾。','','wool羊毛 + en由……制成的 → woolen羊毛制的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1638,'proximate','proximate','/ˈprɑːksɪmət/','adj.直接的；最接近的','closest in degree or order (space or time) especially in a chain of causes and effects','The storm was the proximate cause of the flight delay.','暴风雨是航班延误的直接原因。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1639,'melancholy','melancholy','/ˈmelənkɑːli/','n. 忧郁，悲哀；  adj. 忧郁的，令人伤感的','a deep feeling of sadness that lasts for a long time and often cannot be explained','Her eyes were full of melancholy as she gazed out the window.','当她凝视窗外时，眼里充满了惆怅。','','melan黑 + chol黑胆汁 + y表形容词或名词 → 伤心得胆汁发黑 → melancholy忧郁（的）；令人伤感（的）',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1640,'pigeon','pigeon','/ˈpɪdʒɪn/','n.鸽子','a gray bird that is common in cities and that has a fat body and short legs','The pigeon is taking a rest in the tree.','这只鸽子正在树上休息。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1641,'keep_sb._down','keep sb. down','/kiːp ˈsʌmbədi daʊn/','v. 控制','cause to be embarrassed; cause to feel self-conscious','The pressure in her life really keeps her down.','生活中的压力让她倍感压抑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1642,'examination','examination','/ɪɡˌzæmɪˈneɪʃn/','n.考试，考查','inquiry; a close and careful study of someone or something to find signs of illness or injury','The students are taking an examination.','学生们正在参加考试。','','examin检查 + ation名词后缀 → examination检查',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1643,'numb','numb','/nʌm/','adj.麻木的，失去知觉的；  vt.使麻木，使失去知觉','if a part of your body is numb, you cannot feel anything in it, for example because of cold; unable to feel, think or react in the normal way','My hand was so numb that I could hardly move it.','我的手麻木了，几乎不能动。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1644,'costly','costly','/ˈkɔːstli/','adj. 昂贵的；价值高的','costing a lot of money, especially more than you want to pay','Actually, holding a wedding ceremony is much more costly than I thought.','实际上，举行婚礼比我想象中要贵得多。','','cost花费 + ly形容词后缀 → costly昂贵的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1645,'unclear','unclear','/ˌʌnˈklɪr/','adj. 不清楚的','','The little boy is unclear about how to work out the answer to the math problem.','这个小男孩不清楚如何算出数学题的正确答案。','','un不，没有 ＋ clear清楚 → unclear不清楚的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1646,'envy','envy','/ˈenvi/','n.妒忌；妒忌的对象；  v.嫉妒，羡慕','the feeling of wanting to be in the same situation as somebody else; the feeling of wanting something that somebody else has','The little puppy envies the big dog who has a ball to play with.','小狗嫉妒那只有球可以玩的大狗。','','en使 + vy=vid看到别人 → 妒忌',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1647,'deducible','deducible','/dɪˈduːsəbl/','adj. 可推论的','A sense of something not evident or deducible; an impression.','There is clearly a deducible connection among the patterns.','这些图案之间显然有一种可推论的联系。','deducible connection','de使成… ＋ duc引导，带来 ＋ ible形容词后缀 → 可称为引导的 → deducible可推论的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1648,'surprise','surprise','/sərˈpraɪz/','n.惊喜；惊奇，诧异；  vt.出其不意地袭击；使惊奇，使诧异，使感到意外','an event, a piece of news, etc. that is unexpected or that happens suddenly','She had a look of surprise as she opened her gift.','拆开礼物后，她露出了惊喜的表情。','','sur突然 + prise拿住，抓住 → 突然被抓住 → surprise吃惊',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1649,'investment_in','investment in','/ɪnˈvɛstmənt ɪn/','phr.在...方面投资','','I made an investment in property. ','我投资了房产。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1650,'tempt','tempt','/tempt/','v.诱惑；吸引','to attract somebody or make somebody want to do or have something, even if they know it is wrong','The squirrel is easily tempted by the acorn.','这只松鼠很容易被一颗橡子引诱。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1651,'escape','escape','/ɪˈskeɪp/','v.逃走，逃脱；  n.逃跑','to get away from a place where you have been kept as a prisoner or not allowed to leave; to get away from an unpleasant or dangerous situation; to avoid something unpleasant or dangerous;','The mooncake managed to escape from the rabbit.','月饼逃脱了月兔的追赶。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1652,'disconnect','disconnect','/ˌdɪskəˈnekt/','v. 断开，拆开，使分离','to remove a piece of equipment from a supply of gas, water or electricity; to officially stop the supply of telephone lines, water, electricity or gas to a building; to separate something from something; to break the contact between two people who are talking on the telephone','The phone company disconnected my phone service because I didn\'t pay my bill.','电话公司切断了对我的服务，因为我没有付我的账单。','','dis分开 + con共同 + nect连结 → 拆开，分离',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1653,'rap','rap','/ræp/','n.说唱；  v.敲击；表演说唱','a type of popular music with a fast strong rhythm and words which are spoken fast, not sung; a rap song','He is one of the most famous rap singers in China.','他是中国最著名的饶舌歌手之一。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1654,'inform_against','inform against','/ɪnˈfɔrm əˈɡenst/','phr. 告发','','He informed on his boss in exchange for a softer punishment.','他告发了自己的老大，以便自己能被从轻发落。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1655,'award','award','/əˈwɔːrd/','n.奖品；奖学金；  v.授予','(often in names of particular awards) a prize such as money, etc. for something that somebody has done','The actress got an award for her movie.','这个女演员凭其电影赢得了这个奖项。','got an award','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1656,'hospitable','hospitable','/hɑːˈspɪtəbl/','adj.好客的；有利的','(of a person) pleased to welcome guests; generous and friendly to visitors','He was very hospitable to the guests when they came to his house.','有人来访时，他表现得十分好客。','','hospit客人 ＋ able形容词后缀，…的 → 待客，好客 → hospitable好客的，招待周到的，殷勤的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1657,'prefer_to','prefer to','/prɪˈfɚ tu/','phr. 更喜欢,宁愿','','Most people prefer to stay indoors in winter. ','大多数人冬天喜欢呆在室内。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1658,'commentary','commentary','/ˈkɑːmənteri/','n.（广播员对球赛等的）实况报道，（电影的）解说词；评论，评论文章','a spoken description of an event that is given while it is happening, especially on the radio or television','People love this man\'s commentary on soccer games.','人们非常喜欢这个人对足球比赛的解说。','','com加强或引申 + ment思考，神智 + ary表示有……性质的 → n. (广播员对球赛等的)实况报道，(电影的)解说词；评论，评论文章',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1659,'carrier','carrier','/ˈkæriər/','n.搬运工，运送人','someone or something that carries something; a company that carries goods or passengers from one place to another, especially by air; a military vehicle or ship that carries soldiers or equipment from one place to another','The carrier takes the goods towards his truck.','搬运工把货物搬去他的货车那儿。','','carr搬运 + ier表示做某种工作的人 → carrier搬运工，运送人',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1660,'associate','associate','/əˈsoʊʃieɪt/','v.联系，联想；联合；  n.伙伴；同事，合作人；  adj.副的','to make a connection between people or things in your mind','I associate this picture with a star.','这图片让我联想到了星星。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1661,'England','England','/ˈɪŋɡlənd/','n. 英格兰，英国','a division of the United Kingdom, the southern part of the island of Great Britain','London is located in the south-east of England.','伦敦位于英格兰东南部。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1662,'malleable','malleable','/ˈmæliəbl/','adj. （金属）可锻的；（性格）可训练的','capable of being easily changed or influenced','Stainless steel is a kind of malleable alloy that can be easily made into different shapes.','不锈钢是一种可锻合金，它很容易被制成不同的形状。','','malle=mallet锤子 ＋ able能...的 → malleable可锻造的，可塑的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1663,'presumably','presumably','/prɪˈzuːməbli/','adv. 大概，据推测，可能','used to say that you think that sth is probably true','"The murderer is presumably a man who wears glasses and smokes."','“凶手大概是个戴眼镜且会抽烟的男人。”','','pre预先 + sum推测 + ably表副词→presumably大概',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1664,'think_about','think about','/θɪŋk əˈbaʊt/','phr. 考虑','to consider somebody/something when you are doing or planning something; to consider doing something','Let me think about your idea for a moment... No!','让我考虑一下你的想法⋯⋯不行！','think about your idea','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1665,'readily','readily','/ˈredɪli/','adv.欣然地；乐意地','quickly and without difficulty','The girl readily accepted his invitation to go to the live music show.','女孩欣然接受了他提出的去看现场音乐表演的邀请。','','readi=ready准备好的，情愿的 + ly……地 → readily乐意地，欣然地；容易地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1666,'scheme','scheme','/skiːm/','n.方案，计划；阴谋，诡计；  v.图谋，密谋','a clever and often dishonest plan to do or get something','The man is explaining the investment scheme to his colleagues.','这名男士正在向同事讲解投资方案。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1667,'gratuity','gratuity','/ɡrəˈtuːəti/','n. 赏钱，小费','an amount of money given to a person (such as a waiter or waitress) who has performed a service','He gave the paperboy a handsome gratuity.','他给了送报的小孩一笔丰厚的赏钱。','a handsome gratuity','gratu=grat感激，高兴 ＋ ity → 因感激给 → 赏钱 → gratuity小费',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1668,'smelly','smelly','/ˈsmeli/','adj.有臭味的','having a bad smell','I can\'t stand the smelly fruit anymore!','我受不了这么臭的水果了！','the smelly fruit','smell有...味道 + y...的 → smelly发臭的，有臭味的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1669,'give_sth._up','give sth. up','/ɡɪv ˈsʌmθɪŋ ʌp/','v. 戒烟；放弃','put an end to a state or an activity','This year, I\'m going to give smoking up for good.','今年我要彻底把烟戒了！','give smoking up for good','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1670,'yard','yard','/jɑːrd/','n.院','an area outside a building, usually with a hard surface and a surrounding wall','My yard is full of flowers and plants.','我的院子里种满了花花草草。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1671,'bell','bell','/bel/','n.铃，钟，门铃','a hollow metal object, often shaped like a cup, that makes a ringing sound when hit by a small piece of metal inside it; the sound that it makes','If you need any help, please just ring the bell.','如果需要任何帮助，您摇这个铃就可以了。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1672,'documentary','documentary','/ˌdɑːkjuˈmentri/','n.纪录片；  adj.纪实的；文献的','a film or a radio or television programme giving facts about something','This documentary shows us the life of a panda.','这部纪录片向我们展现了熊猫的生活状态。','','docu[=doc教] + ment名词后缀 + ary…的 → 用来告诉别人的 → documentary公文的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1673,'declare','declare','/dɪˈkler/','v.宣布，宣告；表明；（在击球员还未全部出局时）宣布结束赛局','to state something firmly and clearly','The priest declared the couple husband and wife.','这个牧师宣布这对男女正式结成夫妻。','','de加强 + clare澄清 → declare表明，声明',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1674,'competent','competent','/ˈkɑːmpɪtənt/','adj.有能力的，能干的','having enough skill or knowledge to do something well or to the necessary standard; of a good standard but not very good; having the power to decide something','She\'s a competent worker and is good at her job.','她是一个很有能力的员工，并且很擅长她的工作。','','com共同 + pet追寻，寻求 + ent……的 → competent有资格的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1675,'provoke','provoke','/prəˈvoʊk/','v.挑衅，激怒；对……挑衅','to say or do something that you know will annoy somebody so that they react in an angry way','The basketball player\'s dirty behavior really provoked his opponent.','这位篮球运动员卑鄙的行为真的激怒了他的对手。','','pro向前，在前 + voke喊 → 在你前面喊 → 激怒你 → provoke激怒，刺激',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1676,'ought','ought','/ɔːt/','v.应该，应当，本该','used to say what is the right thing to do; used to say what you advise or recommend','You ought to wipe your butt after pooping.','拉完㞎㞎应该擦屁股。','ought to','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1677,'bail','bail','/beɪl/','v.保释；  n.保释，保释人；保释金','an amount of money given to a court to allow a prisoner to leave jail and return later for a trial','The parents of this suspect paid a bunch of money to bail him out of jail.','嫌疑犯的父母付了一大笔钱来保释他出狱。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1678,'purpose','purpose','/ˈpɜːrpəs/','n.目的，意图；  v.打算','','They are all running for the same purpose—to win the race!','他们都为了同样的目的在奔跑——赢得比赛！','','pur始终 + pose放 → 始终放的东西 → purpose目的，意图',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1679,'steam','steam','/stiːm/','n.蒸汽；  v.冒水汽，冒热气','the hot gas that is created when water is boiled','Steam is coming from the pot. Turn off the stove!','水蒸气正在往锅外冒，关火吧！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1680,'announcer','announcer','/əˈnaʊnsər/','n.播音员','a person who introduces, or gives information about, programmes on the radio or television; a person who gives information about something in a station, an airport, etc., especially through a loudspeaker','She works as an announcer for a radio station.','她是一名电台主播。','','an 一再+ nounce 讲话，说出 + r表人 → n.[广播] 广播员；宣告者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1681,'session','session','/ˈseʃn/','n.会议','a formal meeting or series of meetings of a court, a parliament, etc.; a period of time when such meetings are held; a period of time that is spent doing a particular activity','An important session was held on investment policies.','一个关于投资政策的重要会议召开了。','An important session','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1682,'farther','farther','/ˈfɑːrðər/','adv.再往前地；  adj.更远的','(comparative of far) at or to a greater distance in space or time','We need to move farther to reach the destination.','我们需要再往前走才会到达目的地。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1683,'water_closet','water closet','/ˈwɔːtər klɑːzət/','phr. 盥洗室，厕所','a toilet in England','The water closet in the hotel is very clean.','酒店的盥洗室很干净。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1684,'fertilizer','fertilizer','/ˈfɜːrtəlaɪzər/','n. 肥料，化肥','a substance added to soil to make plants grow more successfully','She has many bags of fertilizer in her storage room.','她的储藏室里有许多袋肥料。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1685,'math','math','/mæθ/','n. 数学','mathematics, especially as a subject in school','The teacher is writing math equations on the blackboard.','老师正在黑板上写一些数学方程式。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1686,'diesel','diesel','/ˈdiːzl/','n.内燃机，柴油机','a type of heavy oil used as a fuel instead of petrol/gas; a vehicle that uses diesel fuel','The man is filling the diesel truck at the gas station.','那个男人正在加油站给柴油货车加油。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1687,'behalf','behalf','/bɪˈhæf/','n. 代表（某人），因为某人；利益；赞同，支持','as the representative of somebody or instead of them','Lord Bao attended the conference on behalf of Baicizhan.','包大人代表百词斩参加了这次会议。','on behalf of','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1688,'ancestral','ancestral','/ænˈsestrəl/','adj. 祖传的；祖先的','connected with or that belonged to people in your family who lived a long time ago','A big family of four generations live together in this ancestral home.','祖孙四代共同生活在这间祖宅中。','','an在先 + cestr=cestor走在……的人 + al……的 → 祖先的；祖传的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1689,'Wednesday','Wednesday','/ˈwenzdeɪ/','n. 星期三','the day of the week after Tuesday and before Thursday','I have an appointment on Wednesday.','我周三有个约会。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1690,'dissident','dissident','/ˈdɪsɪdənt/','n. 唱反调者；持不同政见者，意见不同的人；  adj. 持不同政见的，意见不同的','someone who strongly and publicly disagrees with and criticizes the government','The disillusioned dissident cat priest decided to convert to the dog religion.','这位持有不同意见的猫教士在幻想破灭后决定皈依狗教。','','dis分开 ＋ sid坐 ＋ ent形容词后缀 → dissident持不同意见的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1691,'strike','strike','/straɪk/','v.击打；袭击；罢工；  n.罢工；打击；袭击','to hit somebody/something hard or with force; to hit somebody/something with your hand or a weapon','Strike the ball flat and hard to knock it out of the stadium.','用力朝水平方向击球，这样就能把球打出场外。','Strike the ball','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1692,'similarity_between','similarity between','/ˌsɪməˈlærəti bɪˈtwiːn/','phr.……和……的相似之处','','There is a wonderful similarity between the twins.','这对双胞胎十分相像。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1693,'deem','deem','/diːm/','v. 认为，视为；知道，相信','(not usually used in the progressive tenses) to have a particular opinion about something','He deemed the music beautiful.','他觉得音乐悦耳。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1694,'carefully','carefully','/ˈkerfəli/','adv. 小心地，谨慎地','with a lot of attention or thought, so that you avoid hurting yourself, damaging something or doing something wrong','He pulled out the block very carefully.','他小心地抽出了这个木块。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1695,'tendency','tendency','/ˈtendənsi/','n. 趋向，趋势，倾向','if somebody/something has a particular tendency, they are likely to behave or act in a particular way','There\'s a good tendency for our company\'s business.','我们公司的业务有一个良好的趋势。','a good tendency for','tend倾向 + ency名词后缀；状态 → tendency倾向',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1696,'third','third','/θɜːrd/','num.第三的；第三；  n.三分之一','occupying the number three position in a series','The bronze medal was awarded for the third place.','铜牌被颁发给了第三名。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1697,'reproduction','reproduction','/ˌriːprəˈdʌkʃn/','n. 繁殖；复制品','the act or process of producing babies, young animals or plants','Cell reproduction can be very complicated sometimes!','有时候，细胞繁殖过程非常复杂。','','re一再，重新 ＋ product产品 ＋ ion名词后缀 → reproduction再生产',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1698,'plot','plot','/plɑːt/','n.情节，布局；  v.密谋','the series of events that form the story of a novel, play, film/movie, etc.; a secret plan made by a group of people to do something wrong or illegal; a small piece of land that is used or intended for a special purpose','This story has a romantic plot.','这个故事有一个浪漫的情节。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1699,'by_day','by day','/baɪ deɪ/','phr. 日间，在白天','in the daytime','He works in an office by day and drives a taxi by night.','他白天在办公室上班，晚上开出租车。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1700,'heroine','heroine','/ˈheroʊɪn/','n. 女英雄','a girl or woman who is admired by many for doing something brave or good','Every mother is a great heroine!','每位母亲都是伟大的英雄！','a great heroine','hero英雄 + ine表名词，人或物 → heroine女英雄',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1701,'coerce','coerce','/koʊˈɜːrs/','v. 强迫，压制','to make (someone) do something by using force or threats','The guide coerced tourists into buying souvenirs from the shop.','那位导游强迫游客到商店买纪念品。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1702,'milestone','milestone','/ˈmaɪlstoʊn/','n. 里程碑，划时代的事件','an important point in the progress or development of something :a very important event or advance','He considered achieving a PhD a major milestone in his life.','他认为取得博士学位是他人生中的一个重要里程碑。','','mile里程 ＋ stone石头 → 记录里程的石头 → milestone里程碑',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1703,'nurse','nurse','/nɜːrs/','n.护士；  v.护理，照顾；哺乳','a person who is trained to care for sick or injured people and who usually works in a hospital or doctor\'s office','The nurse is looking after her patient.','护士正在照顾病人。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1704,'negligence','negligence','/ˈneɡlɪdʒəns/','n. 疏忽','the failure to give somebody/something enough care or attention','Her negligence led to an unexpected disaster.','她的疏忽导致了这次意外灾难。','','neg没有 + lig选择，收集 + ence名词后缀 → 疏忽，过失',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1705,'in_order','in order','/ɪn ˈɔːrdər/','phr. 按顺序','appropriate or even needed in the circumstances','These players stand from left to right, in order of number.','运动选手们从左到右按数字顺序站立。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1706,'bound_to','bound to','/baʊnd tu/','phr. 一定会，必然','','He\'s bound to hurt himself if there\'s no protection for him.','如果没有保护，他一定会伤到自己。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1707,'demand','demand','/dɪˈmænd/','v.强烈要求；  n.需求','a very firm request for something; something that somebody needs; things that somebody/something makes you do, especially things that are difficult, make you tired, worried, etc.; the desire or need of customers for goods or services which they want to buy or use','He has always demanded some unreasonable requests from his children.','他总是要求子女们满足他的无理需求。','','de加强 + mand命令 → demand要求',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1708,'diver','diver','/ˈdaɪvər/','n. 潜水员','a person who works underwater, usually with special equipment','A diver swims underwater using special breathing equipment.','潜水员使用特殊的呼吸设备在水下游动。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1709,'wrongly','wrongly','/ˈrɔːŋli/','adv.错误地','without justice or fairness','The picture on the left shows the child covering her mouth wrongly when she coughs.','左图显示这个小孩咳嗽时捂嘴的方式不正确。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1710,'substitute','substitute','/ˈsʌbstɪtuːt/','vt.代替；  n.代替者，代替物','to take the place of somebody/something else; to use somebody/something instead of somebody/something else','You should substitute fruits for sweets.','你应该用水果代替甜食。','','sub在下面，副手，次一等 + stitute创建，建立 → 建在下面 → substitute代替，候补',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1711,'state','state','/steɪt/','n.州；状态，情况；  v.说明，陈述','an organized political community forming part of a country','Alaska is the northernmost state of America.','阿拉斯加是美国最北边的州。','','stat站立 + e强调 → state国家，状态',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1712,'steady','steady','/ˈstedi/','adj.坚定的，扎实的；稳定的，不变的；  v.（使）稳固','developing, growing, etc. gradually and in an even and regular way','The stone house is quite steady under the extreme weather.','石屋在极端天气中非常稳固。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1713,'abstain','abstain','/əbˈsteɪn/','v. 戒掉（烟\\酒等）','to decide not to do or have something, especially something you like or enjoy, because it is bad for your health or considered morally wrong','He took the doctor\'s advice and decided to abstain from alcohol.','他听取了医生的建议，决定戒酒。','','abs远离 + tain抓着的 → 远离拿着的烟 → abstain戒掉',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1714,'tiger','tiger','/ˈtaɪɡər/','n. 老虎','a large wild animal of the cat family, that has yellowish fur with black lines (= stripes) and lives in parts of Asia','A tiger is running in the snow.','一只老虎正在雪地上奔跑。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1715,'natural','natural','/ˈnætʃrəl/','adj.自然界的；天然的；正常的；天生的','existing in nature and not made or caused by people :coming from nature','There are more green trees in the natural environment than in the urban environment.','自然环境中的绿树比城市环境中的多。','','natur自然 + al形容词后缀…的 → natural自然（界）的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1716,'assessment','assessment','/əˈsesmənt/','n.评估，估价','an opinion or a judgement about somebody/something that has been thought about very carefully','The reason for the audit is to make an assessment about the data.','审计的原因是分析数据并做出评估。','','assess评定 + ment表示行为、行为的过程或结果 → assessment（为征税对财产所作的）估价',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1717,'puzzling','puzzling','/ˈpʌzlɪŋ/','adj. 令人迷惑的；  n. 解纵横题字谜的技巧','making somebody feel confused because they do not understand something','The end of the movie was puzzling. I don\'t really understand it.','电影的结尾很令人疑惑。我没有真正理解它。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1718,'edible','edible','/ˈedəbl/','adj. 可食的','fit or suitable to be eaten; not poisonous','Mushrooms on the left are edible.','左边的蘑菇是可食用的。','','ed吃 + ible能够……的 → edible可吃的，食用的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1719,'discern','discern','/dɪˈsɜːrn/','v. 辨别；识别；看出','to know, recognize or understand something, especially something that is not obvious','A night vision viewer helps to discern objects in the dark.','夜视仪有助于在夜间辨认物体。','','dis分开 + cern搞清，区别 → 分开搞清 → discern区别',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1720,'admit','admit','/ədˈmɪt/','v.承认；准许…进入','to say that you have done something wrong or illegal','His mother made him admit that he broke the vase.','他妈妈让小男孩承认是他把花瓶打碎了。','','ad去，往 + mit送，放出 → 送来 → admit许可进入',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1721,'piece','piece','/piːs/','n.块；篇；  v.接合','an amount that is cut or separated from a larger section of something','The yellow cup smashed into pieces.','这个黄杯子碎成了很多块。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1722,'add_up_to','add up to','/æd ʌp tu/','phr. 总计','to make a total amount of something','The things on this bill added up to 250 yuan.','这张账单上的东西加起来正好250块。','added up to 250 yuan','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1723,'normally','normally','/ˈnɔːrməli/','adv.通常，正常地','','Primary schools are normally open from Monday to Friday.','通常来说，小学在周一到周五上课。','','norm规则，规范 ＋ ally表示方式、程度、状态、“…地” → normally通常，正常地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1724,'maintenance','maintenance','/ˈmeɪntənəns/','n.维修；维护；保持；保养','the act of keeping something in good condition by checking or repairing it regularly','The boy is performing maintenance checks on his robot.','男孩正在检修他的机器人。','','main手 + ten拿住 + ance表名词 → 用手拿住 → maintenance维持',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1725,'be_on_edge','be on edge','/bi ɑn ɛdʒ/','phr.紧张不安','be nervous','He was on edge during the result checking procedure.','他在查成绩时候感到紧张不安。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1726,'yield_to','yield to','/jiːld tu/','phr.屈服于','','He yielded to the temptation after half an hour.','半小时后，他还是屈服于诱惑之下。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1727,'mar','mar','/mɑːr/','v. 毁坏，弄糟，玷污','to damage or spoil something good','The wedding was marred by the terrible weather.','婚礼被这糟糕的天气给毁了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1728,'precise','precise','/prɪˈsaɪs/','adj. 精确的','very accurate and exact','This instrument gives precise measurements.','这台仪器显示出精确的测量结果。','precise measurements','pre…前的，预先 + cise切 → 预先切好的 → precise精确的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1729,'enrolment','enrolment','/ɪnˈroʊlmənt/','n. 登记，注册','the act of enrolling','Enrolment now takes place entirely online.','注册如今都全部在网上完成。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1730,'benevolent','benevolent','/bəˈnevələnt/','adj. 慈爱的，仁慈的；乐善好施的；慈善的','(especially of people in authority) kind, helpful and generous; used in the names of some organizations that give help and money to people in need','She always likes to be by the side of her benevolent grandmother.','她总是喜欢依偎在慈爱的奶奶身边。','','bene善，好 + vol意愿 + ent...的 → 好意的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1731,'petroleum','petroleum','/pəˈtroʊliəm/','n. 石油','mineral oil that is found under the ground or the sea and is used to produce petrol/gas, paraffin, diesel oil, etc.','The marine drilling platform is used for the exploitation of petroleum and gas.','海上钻井平台用于油气开发。','','petr石 + oleum油 → petroleum石油',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1732,'tutor','tutor','/ˈtuːtər/','n.家庭教师，指导教师；  v.当……的家庭教师','a private teacher, especially one who teaches an individual student or a very small group','The tutor is helping the little boy with his homework.','这个家庭教师正在辅导小男孩的功课。','','tut保护 + or人 → tutor保护人，导师，教师',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1733,'referendum','referendum','/ˌrefəˈrendəm/','n. 公民投票，复决权','an event in which the people of a county, state, etc., vote for or against a law that deals with a specific issue :a public vote on a particular issue','A referendum requires all qualified citizens to vote.','全民公投要求所有选民参与投票。','','re再次 + fer带来，拿来 + endum表名词 → 提出候选人 → referendum公民投票选举',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1734,'shock','shock','/ʃɑːk/','v.使...震惊；使...震动；  n.震惊；震动','a strong feeling of surprise as a result of something happening, especially something unpleasant; the event that causes this feeling; a serious medical condition, usually the result of injury in which a person has lost a lot of blood and they are extremely weak; a violent shaking movement that is caused by an explosion, earthquake, etc.','She was shocked to see how much her stock value had fallen.','看到股票跌了这么多，她真是惊呆了！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1735,'canal','canal','/kəˈnæl/','n. 运河，河流','a tube inside the body through which liquid, food or air can pass','This city has many canals running through it.','这座城市有很多运河穿流其中。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1736,'faction','faction','/ˈfækʃn/','n. 派别，小集团，小派系；派系斗争，内讧','a small group of people within a larger one whose members have some different aims and beliefs to those of the larger group','The leaders of two opposing factions had a talk.','这两个敌对派系的领导人进行了会谈。','','fact做，制作 + ion名词后缀 → [一帮人]做 → 宗派，小集团',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1737,'in_advance','in advance','/ɪn ædˈvæns/','phr.提前，预先','','He booked his flight tickets in advance.','他提前订好了飞机票。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1738,'premature','premature','/ˌpriːməˈtʃʊr/','adj. 早产的，过早的，早熟的；  n. 早产儿','(of a birth or a baby) happening or being born before the normal length of pregnancy has been completed','The premature baby was so small that it was put into an incubator.','这个早产的婴儿太小了，被放到了保温箱里。','','pre预先 + mature成熟 → premature比预期时间早的，仓促的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1739,'transportation','transportation','/ˌtrænspɔːrˈteɪʃn/','n.运输工具','a system for carrying people or goods from one place to another using vehicles, roads, etc.; a vehicle or method of travel; the activity or business of carrying goods from one place to another using lorries/trucks, trains, etc.','Cars, trains, and planes are forms of transportation.','汽车、火车和飞机都是运输工具。','forms of transportation','trans转移 + port拿，运 + ation名词后缀 → 运输，运输业',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1740,'keep_sb._(sth.)_out_(of)','keep sb. (sth.) out (of)','/kiːp ˈsʌmbədi ˈsʌmθɪŋ aʊt ʌv/','v. 不让…入内','be far away from','It is the guard\'s duty to keep the tourists out of the private property.','保安的职责是不让游客进入私人住宅。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1741,'mini','mini','/ˈmɪni/','adj. 微型的；超短的','small; miniature','It\'s easy to find a parking space for this mini car.','想给这辆迷你轿车找个停车位是很容易的事情。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1742,'dentist','dentist','/ˈdentɪst/','n.牙医','a person whose job is to take care of people’s teeth','The dentist cleaned my teeth.','牙医清洗了我的牙齿。','','dent牙齿 + ist人 → dentist牙科医生',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1743,'endure','endure','/ɪnˈdʊr/','v.忍受，容忍','to experience and deal with something that is painful or unpleasant, especially without complaining','It is very hard to endure the toothache.','牙痛是难以忍受的。','','en艰难 + dure使……艰难 → endure度过，忍受',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1744,'dealer','dealer','/ˈdiːlər/','n. 经销商，商人，（俚）毒贩','a person whose business is buying and selling a particular product; a person who sells illegal drugs; the person who gives out the cards in a card game','The car dealer gave us a great deal on our new car.','买这辆新车时，汽车经销商给了我们很大的优惠。','','deal生意 + er名词后缀：行为的主动者，做某事的人 → n.经销商，商人',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1745,'grumble','grumble','/ˈɡrʌmbl/','v. 发牢骚；  n. 抱怨，怨言','to complain about somebody/something in a bad-tempered way; to make a deep continuous sound','My mom always grumbles about the mess as she cleans my room.','我妈打扫卫生的时候，总会对着杂乱的房间一阵咕哝。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1746,'symposium','symposium','/sɪmˈpoʊziəm/','n.专题报告会','a meeting at which experts have discussions about a particular subject; a small conference','Let\'s hold a symposium to talk about how to improve government policy.','我们举办一个专题研讨会来谈论如何提改善政府决策。','','sym共同，相同 + pos放 + ium名词后缀 → 放在一起讨论 → 专题讨论会',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1747,'zealous','zealous','/ˈzeləs/','adj.热情的，狂热的，热心的','showing great energy and enthusiasm for something, especially because you feel strongly about it','What a zealous bunch of sports fans! They love their team.','真是一群热情的粉丝！他们真心热爱这支球队。','','zeal热心 + ous形容词后缀 → zealous热心的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1748,'theme','theme','/θiːm/','n. 主题；  adj. 主题的','the subject or main idea in a talk, piece of writing or work of art','These guys held a party with a pirate theme.','这些人办了个海盗主题的派对。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1749,'weave','weave','/wiːv/','v. 编织；编进；  n. 织法；织物；  v. 织布','to make cloth, a carpet, a basket, etc. by crossing threads or strips across, over and under each other by hand or on a machine called a loom','The elder is weaving a basket.','老人正在编篮子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1750,'cram','cram','/kræm/','v. 仓促备考','to learn a lot of things in a short time, in preparation for an exam','The boy is cramming for the exam.','男孩在考试前拼命抱佛脚。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1751,'fight_for','fight for','/faɪt fɔr/','phr. 为…而战斗','endeavor vigorously to do something','The goats are fighting for their homeland.','山羊们正在为它们的家园而战。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1752,'metro','metro','/ˈmetroʊ/','n. 地铁','the underground railway system in some cities','The metro is empty.','地铁里空无一人。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1753,'school-leaver','school-leaver','/ˌskuːl ˈliːvər/','n. （英）学校毕业生','a person who has just left school, especially when they are looking for a job','The school-leaver has finished his time at the school.','这名毕业生的校园时光已经结束了。','','school学校 ＋ leav=leave离开 ＋ er名词后缀 → school-leaver学校毕业生',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1754,'take_account_of','take account of','/teɪk əˈkaʊnt ʌv/','phr. 考虑到','to consider about, to think about','Money, time, route—you should take account of everything when you plan to travel.','钱，时间，路线——计划去旅行时你应该考虑到所有问题。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1755,'surface','surface','/ˈsɜːrfɪs/','n.表面；外表，外观；  v.浮出水面','the top layer of an area of water or land','There is some oil on the surface of the soup.','汤的表面有一些油花。','','sur超过，在上面 + face脸面 → surface表面',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1756,'topsoil','topsoil','/ˈtɑːpsɔɪl/','n. 表层土，上层土','the upper layer of soil in which plants have most of their roots','The topsoil in this region is very thin.','这个地区的表层土壤很薄。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1757,'bureaucracy','bureaucracy','/bjʊˈrɑːkrəsi/','n. 官僚主义；政府机构','the system of official rules and ways of doing things that a government or an organization has, especially when these seem to be too complicated','The bureaucracy always makes people go through unnecessary procedures.','官僚主义总是让人们走一些不必要的程序。','','bureau政府机构 + cracy统治 → bureaucracy官僚政治',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1758,'double_up','double up','/ˈdʌbəl ʌp/','phr. 弯着身子',' bend over or curl up, usually with laughter or pain','The kids all doubled up with laughter.','孩子们都笑弯了腰。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1759,'export','export','/ˈekspɔːrt/','v.出口，输出；  n.出口，输出；出口商品','to sell and send goods to another country','Our company exports products to many different countries.','我们公司向许多国家出口货物。','','ex出 + port拿，引申为港口 → 拿出港口 → 出口',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1760,'discharge_from','discharge from','/dɪsˈtʃɑrdʒ frʌm/','phr. 允许离开(使...免职)','','The doctor agreed to discharge her from the hospital.','医生同意让她出院。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1761,'steadily','steadily','/ˈstedəli/','adv.持续地，稳步地；有规则地','at a steady rate or pace','The sales performance of the employee grows steadily.','这个员工的销售业绩在持续增长。','','steadi=steady稳定的 ＋ ly...地 → 站得稳地 → steadily稳定地；稳固地；有规则地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1762,'speculate','speculate','/ˈspekjuleɪt/','v.推测，猜测；投机，做投机买卖','to form an opinion about something without knowing all the details or facts','They are speculating about why their colleague is upset.','他们在推测他们的同事为什么难过。','','specul环顾 + ate动词后缀 → 看准了 → speculate思考，投机',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1763,'yes','yes','/jes/','excl. 答话时表示正确或真实；  n. 是；肯定','an answer that shows that you agree with an idea, a statement, etc.; a person who says ‘yes’','Yes, I promise to be a good boy.','好，我保证做一个好男孩！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1764,'bring_to','bring to','/brɪŋ tu/','phr. 使恢复知觉',' bring back to consciousness','The lifeguard brought the drowned man to.','救生员让溺水者恢复了意识。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1765,'checkpoint','checkpoint','/ˈtʃekpɔɪnt/','n. 检查站，关卡，记录点','a place, especially on a border between two countries, where people have to stop so their vehicles and documents can be checked','These people are lining up to go through the security checkpoint.','这些人正排队通过安全检查站。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1766,'hum','hum','/hʌm/','v.发出嗡嗡声，哼（歌曲）；  n.轰鸣声，嗡嗡声','to make a low continuous sound','I can\'t sleep when the fly is humming around my ear.','苍蝇在我耳朵旁嗡嗡直叫，害得我睡不着。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1767,'corrupt','corrupt','/kəˈrʌpt/','adj.腐败的；  v.使腐败','to have a bad effect on somebody and make them behave in an immoral or dishonest way','The corrupt behavior of the rat is simply despicable.','那只老鼠的腐败行为是可鄙的。','','cor共同 + rupt断 → 全部断 → corrupt变坏的，腐败的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1768,'ceremony','ceremony','/ˈserəmoʊni/','n.典礼','a public or religious occasion that includes a series of formal or traditional actions','The student was awarded her certificate during the graduation ceremony.','这位毕业生在毕业典礼上被授予毕业证书。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1769,'Thanksgiving','Thanksgiving','/ˌθæŋksˈɡɪvɪŋ/','n. 感恩节','a public holiday in the US (on the fourth Thursday in November) and in Canada (on the second Monday in October), originally to give thanks to God for the harvest and for health; the expression of thanks to God','Roast turkey is a traditional food served on Thanksgiving.','烤火鸡是感恩节的传统食物。','','thank感谢 + s复数 + giv给予 + ing名词后缀 → Thanksgiving感恩节',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1770,'degrade','degrade','/dɪˈɡreɪd/','v. 贬低；降低品格（身价、价值等）','to show or treat somebody in a way that makes them seem not worth any respect or not worth taking seriously','The mayor degraded himself in the eyes of the people when he accepted a bribe.','市长收受贿赂时，他已经贬低了自己在人民眼中的形象。','','de向下 + grade步，级 → 向下降级 → 降级；退化',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1771,'in_addition','in addition','/ɪn əˈdɪʃn/','phr.除此之外，另外','used when you want to mention another person or thing after something else','He was a great boyfriend. In addition, he knew first aid.','除了做一个优秀的男朋友，他还知道急救知识。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1772,'financial','financial','/faɪˈnænʃl/','adj.金融的，财政的，财务的','connected with money and finance','Online banking makes it easier to manage your financial accounts.','网上银行使得管理金融账目更加容易。','','financ=finance金融 + ial属于……的 → financial财政的，金融的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1773,'roller','roller','/ˈroʊlər/','n. 滚柱，滚筒，滚轴','a cylinder that turns around in a machine or device','Use the roller to paint the walls.','用滚筒来刷墙。','','roll滚 + er表示物 → roller滚柱，滚筒，滚轴',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1774,'heating','heating','/ˈhiːtɪŋ/','n.加热，供暖，暖气装置','the process of supplying heat to a room or building; a system used to do this','The house has an underfloor heating system.','这房子有一套地暖系统。','','heat热 + ing名词/形容词后缀 → heating加热，加热的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1775,'lost_and_found','lost and found','/ˌlɔːst ən ˈfaʊnd/','phr. 失物招领处','Lost and found things are things which someone has lost and which someone else has found.','This sign shows that the lost and found is here.','这个标示表明这里是失物招领处。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1776,'aunt','aunt','/ænt/','n. 小姨，姑妈，伯母，舅妈','the sister of your father or mother or the wife of your uncle','The woman with yellow hair is the boy\'s aunt.','黄头发的女人是这个男孩的小姨。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1777,'jungle','jungle','/ˈdʒʌŋɡl/','n.丛林','an area of tropical forest where trees and plants grow very thickly','The boy explored through the jungle.','这个小男孩在丛林里探险。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1778,'methodology','methodology','/ˌmeθəˈdɑːlədʒi/','n. 方法论，方法学；（某一学科的）一套方法','a set of methods and principles used to perform a particular activity','Teaching methodologies vary according to the subject.','教学方法要随着科目而变。','','method方法 + ology……学 → methodology方法学',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1779,'memorandum','memorandum','/ˌmeməˈrændəm/','n. 便签，备忘录','A memorandum is a written report that is prepared for a person or committee in order to provide them with information about a particular matter.','Did you get the memorandum about the meeting tomorrow?','你拿到明天会议的便签了吗？','','memor记忆 ＋ andum东西 → [帮助]记的东西 → memorandum备忘录',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1780,'as_well','as well','/əz wel/','phr.同样地；也','in like or similar manner; besides; in addition','If restaurants close because of the virus, then cinemas should close as well.','如果餐馆因为病毒而关闭，那么电影院也应该关闭。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1781,'crazy','crazy','/ˈkreɪzi/','adj. 疯狂的，荒唐的','(often in compounds) very enthusiastic or excited about something; liking somebody very much; in love with somebody','The fan went crazy when he saw the actor.','当这个影迷看到那个演员时，他变得疯狂起来。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1782,'climax','climax','/ˈklaɪmæks/','n. 高潮，最令人兴奋（或感兴趣）的部分','the most exciting or important event or point in time; the most exciting part of a play, piece of music, etc. that usually happens near the end; the highest point of sexual pleasure','Everyone cried at the movie’s touching climax.','电影的高潮部分太感人了，大家都哭了。','','cli倾斜+max最大 → 斜坡的最高处 → 高潮',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1783,'midst','midst','/mɪdst/','n.中部，中间','(used after a preposition) the middle part of something','I saw her in their midst, standing and laughing.','我看见她站在他们中间，笑容灿烂。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1784,'arrangement','arrangement','/əˈreɪndʒmənt/','n. 布置；组合体','the way things are done or organized','The arrangement of tables looks so crowded.','桌子布置得很挤。','','arrange安排 + ment名词后缀 → arrangement排列，布置',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1785,'make_up_one\'s_mind','make up one\'s mind','/meɪk ʌp wʌnz maɪnd/','phr. 下决心，决定','reach, make, or come to a decision about something','Think about it before you make up your mind.','在决定之前要先想一想。','make up your mind','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1786,'logically','logically','/ˈlɑːdʒɪkli/','adv. 逻辑上，合逻辑地，有条理地','','By thinking logically it\'s easier to understand and complete complicated problems or tasks.','通过逻辑思维，我们更容易理解和完成复杂的问题或任务。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1787,'negative','negative','/ˈneɡətɪv/','adj.消极的，负面的；  n.否定','bad or harmful; considering only the bad side of something/somebody; lacking enthusiasm or hope','He received too many negative comments from others.','他收到了太多负面的评价。','','negat否认 + ive形容词后缀 → 否认的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1788,'building','building','/ˈbɪldɪŋ/','n.建筑；大楼','a structure such as a house or school that has a roof and walls','In this modern city center, every building looks the same.','在这座现代化城市的中心，每栋建筑看起来都一样。','','build建造 + ing某种行为的产物 → building建筑物',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1789,'ramp_up','ramp up','/ræmp ʌp/','phr. 提高，斜升，提升',' bolster or strengthen','He is trying to ramp up sales.','他在努力提升销售额。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1790,'controversy','controversy','/ˈkɑːntrəvɜːrsi/','n.争论，辩论','public discussion and argument about something that many people strongly disagree about, disapprove of, or are shocked by','Which kind of flavor is more delicious? There was controversy over the result.','哪种味道更美味？关于这个问题的讨论结果引起了争议。','','contro相反 + vers转变 + y表状态、行为 → 使结论向相反方向转变 → controversy争论；议论',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1791,'fragile','fragile','/ˈfrædʒl/','adj. 易碎的；易损坏的；虚弱的；脆弱的','easily broken or damaged','These vases are very fragile. Please be careful!','这些花瓶非常易碎，请小心一些！','','frag打碎 + ile能…的 → 能碎的 → fragile易碎的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1792,'kilogram','kilogram','/ˈkɪləɡræm/','n.千克','a unit for measuring weight; 1 000 grams','They sell rice by the kilogram.','他们按公斤出售大米。','','kilo一千 + gram克 → kilogram一千克，公斤',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1793,'goal','goal','/ɡoʊl/','n. 目标；（进球）得分','the act of kicking or hitting the ball into the goal; a point that is scored for this','The boy\'s goal is to become as strong as the man in the poster.','男孩的目标是变得像海报里的男人一样强壮。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1794,'millions_of','millions of','/ˈmɪljənz əv/','phr. 成百万上千万，数以百万计','a an extremely large but unspecified number, quantity, or amount that is greater than one million','There are millions of dollars in the vault.','这个金库里有数百万美元。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1795,'embarrass','embarrass','/ɪmˈbærəs/','vt.使...尴尬','to make somebody feel shy, awkward or ashamed, especially in a social situation','He was embarrassed when he couldn\'t afford the bill.','当他付不起账单时，他很尴尬。','','em进入…之中，包围 + barrass套子 → 进入套子 → embarrass使难堪',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1796,'get_down_to_business','get down to business','/ɡet daʊn tu ˈbɪznəs/','phr. 着手干正事','start to do sth.','They got down to business as soon as their coffees were served.','咖啡一端上来，他们就正式开始工作了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1797,'grade','grade','/ɡreɪd/','n.等级，成绩；  v.给（试卷或作业）评分','a mark given in an exam or for a piece of school work','The little girl is delighted with her excellent grade.','小女孩为她的优异成绩而感到高兴。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1798,'appetizing','appetizing','/ˈæpɪtaɪzɪŋ/','adj. 促进食欲的','','The freshly baked cake looks very appetizing to the girl!','新鲜出炉的蛋糕对这个女孩来说看着十分可口！','','ap加强动作+peti追寻，寻求+zing...的→ 促进食欲的，开胃的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1799,'insurrection','insurrection','/ˌɪnsəˈrekʃn/','n. 造反，叛乱','a situation in which a large group of people try to take political control of their own country with violence','Peasants always start insurrections during bad years with food shortages.','农民总在灾年因为缺少食物而发动造反。','','in表强调 + surrect波浪 + ion名词后缀→ 大片反抗浪潮 → insurrection造反',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1800,'shame','shame','/ʃeɪm/','n.羞愧；  vt.使感到羞耻','a feeling of guilt, regret, or sadness that you have because you know you have done something wrong','He felt a deep sense of shame because he cheated in the exam.','他因考试作弊而深感羞愧。','sense of shame','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1801,'panda','panda','/ˈpændə/','n. 熊猫','a large animal with black-and-white fur that looks like a bear, lives in China, and eats mostly bamboo shoots','I wish I was a panda because they eat and play all day.','我希望我是个熊猫，这样可以整天有吃有玩的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1802,'lamp','lamp','/læmp/','n. 灯，台灯','a device that produces light','An oil lamp burned in darkness.','一盏油灯在黑暗中发着光。','An oil lamp','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1803,'holly','holly','/ˈhɑːli/','n.冬青树（等于holm oak）','a bush or small tree with hard shiny leaves with sharp points and bright red berries in winter, often used as a decoration at Christmas','How cute! Someone decorated my Christmas mince pie with holly!','太可爱了！有人用冬青树叶装饰我的圣诞肉馅饼！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1804,'bang','bang','/bæŋ/','n.巨响；重击；  v.发出砰的一声；重击；猛敲；砰地关上','a sudden loud noise','After a gust of wind, the door was suddenly shut with a bang.','一阵风过后，门突然关上，发出一声巨响。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1805,'come_out_with','come out with','/kʌm aʊt wɪð/','phr. 提出，发表，讲出','to give expression to','She came out with some fantastic ideas during the meeting.','她在开会的时候发表了一个很棒的点子。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1806,'biologist','biologist','/baɪˈɑːlədʒɪst/','n. 生物学家','a scientist who studies biology','Zoologists, botanists and microbiologists are all kinds of biologists.','动物学家、植物学家和微生物学家都是生物学家。','','bio生物 + logist……学家 → biologist生物学家',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1807,'Switzerland','Switzerland','/ˈswɪtsərlənd/','n.瑞士','a country in central Europe','There are many snowy mountains in Switzerland. It\'s so cold!','瑞士有很多雪山，非常冷！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1808,'immensely','immensely','/ɪˈmensli/','adv. 极大地','to an exceedingly great extent or degree','She\'s an immensely talented young tennis player.','她是一位年轻且极具天赋的网球运动员。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1809,'portion','portion','/ˈpɔːrʃn/','n.一部分；份额；分担的责任；  vt.把……分成份额','one part of something larger; an amount of food that is large enough for one person; a part of something that is shared with other people','Every month the couple manage to save a small portion of their salaries.','这对夫妇每个月都设法从工资里省下一小部分钱。','','port部分，分开 + ion名词后缀 → portion一部分',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1810,'outcome','outcome','/ˈaʊtkʌm/','n. 结果，后果','something that happens as a result of an activity or process','The final outcome of the football game is 0:0.','这场足球比赛的最后结果是0 : 0。','final outcome','out出 + come来 → outcome结果',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1811,'pull_out','pull out','/pʊl aʊt/','v.拔出，离开，度过难关，恢复健康','','After the battle the troops pulled out by helicopter.','交战后，部队坐直升机撤退了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1812,'improper','improper','/ɪmˈprɑːpər/','adj. 不成体统的，不合礼仪的','not suited or appropriate to the situation','His clothes were improper for the funeral.','他在葬礼上穿成这样是不太合适的。','','im不 + proper适当的 → improper不适当的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1813,'cookie','cookie','/ˈkʊki/','n.饼干；曲奇','a small flat sweet cake for one person, usually baked until crisp','Chocolate cookies are my favorite.','巧克力饼干是我的最爱。','','cook=cake蛋糕 + ie名词后缀，表示小称及爱称 → cookie小甜饼；饼干',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1814,'surfing','surfing','/ˈsɜːrfɪŋ/','n.冲浪','','Surfing is one of his favorite sports.','冲浪是他最喜欢的运动之一。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1815,'dawn','dawn','/dɔːn/','n.黎明；  v.开始','the time of day when sunlight first begins to appear','The rooster standing on the field crows at dawn.','田野里的公鸡在黎明时分打鸣。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1816,'integrate','integrate','/ˈɪntɪɡreɪt/','v.（使）成为一体，（使）合并','','Our department\'s four teams must integrate together to work on new projects.','我们部门的四个小组必须合力推进新项目。','','integr完整 ＋ ate使… → 使…完整 → integrate使一体，使结合',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1817,'tough','tough','/tʌf/','adj.健壮的；棘手的','physically strong and likely to be violent','Stay away from that man—he looks tough.','离那个男的远一点，他看起来很健壮。','looks tough','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1818,'pass_on','pass on','/pæs ɔn/','phr. 传给','pass from physical life and lose all bodily attributes and functions necessary to sustain life','The father passed on the key to the house to the new couple.','父亲把房子的钥匙传给了这对新人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1819,'script','script','/skrɪpt/','n. 剧本，脚本，手稿','a written text of a play, film/movie, broadcast, talk, etc.; writing done by hand','The actor is reading a line of the movie script.','这名演员正在读电影剧本里的一句台词。','movie script','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1820,'worry','worry','/ˈwɜːri/','v.（使）焦虑，（使）烦恼；  n.烦恼，焦虑，担忧','to think about problems or fears :to feel or show fear and concern because you think that something bad has happened or could happen','Being in the hospital makes him worry about money.','在医院住院，他很担忧他的钱。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1821,'droop','droop','/druːp/','v. 低垂，凋萎，萎靡','','The flowers drooped in the sun.','花朵在阳光下枯萎了。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1822,'cabin','cabin','/ˈkæbɪn/','n.（简陋的）小屋；  v.住在小屋里','a small house or shelter, usually made of wood','We like to go to our small log cabin in the woods.','我们喜欢去我们在树林里的小木屋。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1823,'assign_to','assign to','/əˈsaɪn tu/','phr.分派给','','The manager assigned him to work on reception. ','经理指派他去做接待工作。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1824,'bring_(call)_sth._to_mind','bring (call) sth. to mind','/brɪŋ kɔːl ˈsʌmθɪŋ tu maɪnd/','v. 想起某事','remind sb of doing sth','The dumplings brought happy childhood memories to mind.','这些饺子让人想起了童年的快乐回忆。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1825,'herald','herald','/ˈherəld/','n. 使者；预兆；  v. 预告；为……欢呼','(in the past) a person who carried messages from a ruler','As a herald, Zhangqian went to the Western Regions to deal with foreign affairs.','张骞作为使节，出使西域去处理外交事务。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1826,'transistor','transistor','/trænˈzɪstər/','n. 晶体管；半导体收音机','a small electronic device used in computers, radios, televisions, etc. for controlling an electric current as it passes along a circuit','Transistors are small but necessary to make computers.','晶体管虽小，可对于制造电脑是必要的。','','tran超过，横过，超 + sist站立 + or名词后缀 → transistor半导体，半导体收音机',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1827,'subdue','subdue','/səbˈduː/','v. 征服，压制，减轻','to bring somebody/something under control, especially by using force; to calm or control your feelings','The police subdue the criminal and pin him to the ground.','警察制服了犯人并将他压倒在地。','','sub在下面，次一等 + due从属 → 从属在下面 → subdue征服',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1828,'wildly','wildly','/ˈwaɪldli/','adv. 极其地','to an extreme or greatly exaggerated degree','The bear became wildly excited when he found all that honey.','当熊发现那一堆蜂蜜时，他变得极其兴奋。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1829,'into','into','/ˈɪntuː/','prep.进入，到……里面','to a position in or inside something','This sign means that you are allowed to enter into the room.','这个标志表明允许你进入这个房间。','enter into','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1830,'in_one\'s_face','in one\'s face','/ɪn wʌnz feɪs/','adv.直截了当地，不留情面地','in a direct way that shows anger or disrespect for someone','Several friends laughed at the man in his face.','几个朋友不留情面地嘲笑这个人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1831,'suggestion','suggestion','/səˈdʒestʃən/','n.建议，意见；细微的迹象','an idea or a plan that you mention for somebody else to think about','The shopping guide gives her some suggestions about the skirt.','导购给了她一些选裙子的建议。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1832,'terrified','terrified','/ˈterɪfaɪd/','adj. 恐惧的','very frightened','The mouse was terrified of the cat.','这只老鼠非常怕猫。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1833,'tribe','tribe','/traɪb/','n. 部落','(in developing countries) a group of people of the same race, and with the same customs, language, religion, etc., living in a particular area and often led by a chief; a large number of people','The primal tribe people make the fire with wood.','原始部落的人用木柴生火。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1834,'hypothetical','hypothetical','/ˌhaɪpəˈθetɪkl/','adj. 假设的，假定的','based on situations or ideas which are possible and imagined rather than real and true','The physicist proposed a hypothetical theory that an alien civilization does exist.','这位物理学家提出了外星文明存在的假说。','','hypothe假设 + tical形容词缀 → hypothetical假设的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1835,'daring','daring','/ˈderɪŋ/','adj.大胆的；鲁莽的','brave; willing to do dangerous or unusual things; involving danger or taking risks','It\'s such a daring move to jump into the water from here!','从这里跳进大海是一个多么大胆的举动啊！','','dar=dare敢于 + ing形容词后缀 → 大胆的，勇敢的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1836,'outward','outward','/ˈaʊtwərd/','adj. 外面的；  adv. 外面地，向外地','going away from a particular place, especially one that you are going to return to','We all enjoy this outward journey.','我们都很享受这次户外旅行。','','out外边 + ward向…… → outward向外的，向外',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1837,'ring_sb._back','ring sb. back','/rɪŋ ˈsʌmbədi bæk/','phr. 回电话','to telephone somebody again, for example because they were not there when you called earlier, or to return a call they made to you','Oh, I missed a call from my mother. I\'ll ring her back.','啊，我错过了妈妈的来电，我得给她回电话。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1838,'inconvenient','inconvenient','/ˌɪnkənˈviːniənt/','adj. 不便的，打扰的；打扰的','causing trouble or problems, especially concerning what you need or would like yourself','The man received a call at an inconvenient time.','这电话来得不是时候。','','in不 + con共同，全部 + ven来 + ient形容词后缀 → 不便的，打扰的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1839,'to_the_delight_of','to the delight of','/tu ðə dɪˈlaɪt ʌv/','phr. 令…感到喜悦','happily, delightfully','To the delight of the little boy, his mother gave him a toy car.','令这个小男孩开心的是，妈妈带了一个玩具车来给他。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1840,'dish','dish','/dɪʃ/','n. 菜肴；碟，盘子','food that is prepared in a particular way','Add a slice of lemon to flavor the dish.','加上一片柠檬为这道菜肴调味。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1841,'blueprint','blueprint','/ˈbluːprɪnt/','n. 蓝图，设计图，计划；  vt. 制成蓝图，计划','a plan which shows what can be achieved and how it can be achieved','When we build a building, we always follow the blueprint as exactly as we can.','建造建筑物的时候，我们通常会严格按照设计图来做。','follow the blueprint','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1842,'at_full_speed','at full speed','/æt fʊl spiːd/','phr. 全速','without delay','The car was travelling at full speed.','汽车正全速行进。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1843,'several','several','/ˈsevrəl/','det.几个；  adj.各自的，分别的','more than two but not very many','I have several apples for you!','我给你准备了几个苹果！','several apples','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1844,'deception','deception','/dɪˈsepʃn/','n. 欺骗，诡计','the act of deliberately making somebody believe something that is not true (= of deceiving them); a trick intended to make somebody believe something that is not true','Nowadays, photos often become “photos of deception”.','现在的照片大多变成了“照骗”。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1845,'pass_sth._off','pass sth. off','/pæs ˈsʌmθɪŋ ɔːf/','phr. 冒充，假装','','The trader used some paint to pass the old horse off as an exotic zebra.','这位商人用一些颜料让这匹老马冒充成了异域的斑马。','pass the old horse off','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1846,'transmit','transmit','/trænsˈmɪt/','v.发射；传输；发送','to send an electronic signal, radio or television broadcast, etc.','The tower transmits the TV signal.','这座塔负责发射电视信号。','','trans横过，超过 + mit送 → 横着送消息 → transmit传播，传送',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1847,'innumerable','innumerable','/ɪˈnuːmərəbl/','adj. 数不清的；无数的','too many to be counted; very many','There are innumerable stars in the night sky.','夜空中有数不清的星星。','','in不 + numer数目 + able能……的 → 数不清的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1848,'memoir','memoir','/ˈmemwɑːr/','n.回忆录','an account written by somebody, especially somebody famous, about their life and experiences','His memoir records the events of his whole life.','他的回忆录记录了他的一生中发生的事件。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1849,'training','training','/ˈtreɪnɪŋ/','n.训练，锻炼','the process of preparing to take part in a sports competition by doing physical exercises','He performs strength training in the gym.','他在健身房做力量训练。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1850,'famine','famine','/ˈfæmɪn/','n. 饥荒；严重的缺乏','a situation in which many people do not have enough food to eat','These poor African kids suffer a lot from famine.','这些可怜的非洲儿童饱受饥荒之苦。','suffer a lot from famine','fam饿 + ine表名词 → famine饥荒',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1851,'archives','archives','/ˈɑːrkaɪvz/','n. 档案室，档案','collection of records especially about an institution','The archives contain millions of papers.','这个档案室里面有上百万份文件。','','arch统治者，统治，主要的 ＋ ives表示东西 → 统治的东西 → archives档案',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1852,'affectionate','affectionate','/əˈfekʃənət/','adj. 充满深情的，挚爱的','showing caring feelings and love for somebody','The affectionate couple are smiling at each other.','这对深情的夫妇互相微笑。','','af一再 + fect做，制作 + ion名词后缀 + ate...的 → 一再做而充满感情的 → affectionate深情的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1853,'icy','icy','/ˈaɪsi/','adj.结冰的','very cold; covered with ice','The man is swimming in the icy lake.','这个男人正在冰湖里游泳。','','ic=ice冰 + y……的 → icy似冰的，多冰的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1854,'among','among','/əˈmʌŋ/','prep.在……中间，在……之中','surrounded by somebody/something; in the middle of somebody/something','There is an apple among the other fruits.','这个苹果在这些水果之中。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1855,'toll','toll','/toʊl/','n. （道路等的）通行费；伤亡人数；  v. 敲钟','an amount of money that you are required to pay for the use of a road or bridge','You have to pay the toll if you ride the freeway.','如果你走高速路的话得付通行费。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1856,'solve','solve','/sɔːlv/','vt.解决','to find a way of dealing with a problem or difficult situation','He helped the girl to solve the math problem.','他帮女孩解答了这道数学题。','','solv松的 + e → solve解决',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1857,'durable','durable','/ˈdʊrəbl/','adj.耐用的，长久的；  n.耐用品','likely to last for a long time without breaking or getting weaker','We want a durable vehicle for this rough road.','我们要在这条起伏不平的路上行驶，所以想要一辆耐用的车。','','dur持久，坚硬 + able能……的 → 持久的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1858,'harassment','harassment','/həˈræsmənt/','n. 骚扰；扰乱；烦恼事','the act of annoying or worrying somebody by putting pressure on them or saying or doing unpleasant things to them','Harassment from bullies can be very depressing.','来自恶霸的骚扰很让人沮丧。','','harass骚扰 + ment名词后缀 → harassment骚扰',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1859,'approve','approve','/əˈpruːv/','v.称许；赞成；批准','to think that somebody/something is good, acceptable or suitable; to officially agree to a plan, request, etc.; to say that something is good enough to be used or is correct','They all approve of my good performance.','他们都称许我良好的表现。','','ap加强 + prove证明 → approve承认，赞成',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1860,'innovation','innovation','/ˌɪnəˈveɪʃn/','n.创新，革新；新事物，新方法','the introduction of new things, ideas or ways of doing something; a new idea, way of doing something, etc. that has been introduced or discovered','The age of innovation is upon us! Hurry up with my dinner!','我们正在步入一个创新的时代！赶快把我的晚餐做好端上来！','','in进入 + nov新 + ation名词后缀 → innovation创新',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1861,'ratio_of_sth._to_sth.','ratio of sth. to sth.','/ˈreɪʃioʊ əv ˈsʌmθɪŋ tuː ˈsʌmθɪŋ/','phr.……和……的比例','','The ratio of boys to girls is 3 to 2.','男生和女生的比例是3比2。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1862,'lay_(sth.)_bare','lay (sth.) bare','/leɪ ˈsʌmθɪŋ ber/','phr. 揭露；显示','make known to the public information that was previously known only to a few people or that was meant to be kept a secret','After solving the mystery, the detective laid bare the truth to everyone.','侦探解开谜团后，向大家揭露了真相。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1863,'engineer','engineer','/ˌendʒɪˈnɪr/','n.工程师；技师；火车司机；  vt.设计；建造','a person whose job involves designing and building engines, machines, roads, bridges, etc.; a person who is trained to repair machines and electrical equipment','The two engineers are discussing their new building plans.','这两个工程师正在讨论新的建筑计划。','','engine发动机 + er人 → engineer工程师',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1864,'ascertain','ascertain','/ˌæsərˈteɪn/','v. 探知，弄清，查明（真相等）','to find out the true or correct information about something','The detective searched this room to ascertain the facts of the case.','侦探搜查了这个房间以便查明案情。','','as一再 + certain确实 → 确定，查明',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1865,'quest','quest','/kwest/','n. 探索，寻求；  v. 寻找，搜索','the act of searching for something','In her quest to find out the truth, she came to the Forbidden City.','她为了探寻真相来到紫禁城。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1866,'tune_in_to','tune in to','/tun ɪn tu/','phr. 收看','','He tunes in to this show every week.','他每周都收看这个节目。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1867,'chess','chess','/tʃes/','n.棋；国际象棋','a game for two people played on a board marked with black and white squares on which each playing piece (representing a king, queen, castle, etc.) is moved according to special rules. The aim is to put the other player’s king in a position from which it cannot escape (= to checkmate it).','The girl is playing chess with her dad.','女孩正在和爸爸下棋。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1868,'woollen','woollen','/ˈwʊlən/','adj. 羊毛（制）的，羊毛的','made of wool','When I look at that sheep, I imagine a warm woollen sweater.','当看到这只羊时，我想到了一件温暖的羊绒毛衣。','warm woollen sweater','wooll羊毛 + en表示由…制成的，含有…质的，似…的 → woollen羊毛制的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1869,'diverse_from','diverse from','/daɪˈvɜːrs frəm/','phr. 和 ... 不一样','','The meaning of the smiling emoji is diverse from what it was.','这个微笑表情的含义与过去的不同了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1870,'substantiate','substantiate','/səbˈstænʃieɪt/','v. 证实；使实体化','to prove the truth of (something)','Magellan sailing around the world substantiates that the earth is not flat.','麦哲伦的环球航行证实了地球不是平的。','','sub下面+stant站立+i+ate动词后缀→把理论物质化→证实',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1871,'shareholder','shareholder','/ˈʃerhoʊldər/','n. 股东，股票持有者','an owner of shares in a company or business','Shareholders are expecting rapid market growth by next month.','股东们期望下个月市场快速增长。','','share股份 + holder持有人 → shareholder股东',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1872,'ruinous','ruinous','/ˈruːɪnəs/','adj.破坏性的，毁灭性的','causing or likely to cause damage or destruction','The ruinous tornado completely destroyed our town. ','极具破坏性的龙卷风彻底毁了我们的小镇。','','ruin毁坏 + ous...的 → adj. 破坏性的，毁灭性的；零落的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1873,'cumbersome','cumbersome','/ˈkʌmbərsəm/','adj. 笨重的；麻烦的','hard to handle or manage because of size or weight','This gift box is too cumbersome; I\'ll never carry it home.','这个礼物盒太笨重了，我绝对没办法把它带回家。','','cumber躺的东西，障碍+some有点…的→有障碍的,笨重的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1874,'roommate','roommate','/ˈruːmmeɪt/','n.室友','','He is playing the guitar, and his roommate is reading.','他正在弹吉他，他的室友正在看书。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1875,'seeming','seeming','/ˈsiːmɪŋ/','adj.表面上的','appearing as such but not necessarily so','Despite his seeming happiness, he was disappointed not to win first prize.','尽管他表面上很开心，但实际上他对没有获得一等奖感到很失望。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1876,'had_better_(do)','had better (do)','/hæd ˈbetər doʊ/','phr. 最好（做）','it would be best','Tomorrow is Monday! You had better finish your homework before then.','明天就是星期一了！你最好在那之前完成作业。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1877,'fried','fried','/fraɪd/','adj. 油炸的，油煎的','cooked in hot oil','All I wanted was a plate of delicious fried foods.','我只是想要一盘美味的油炸食物。','delicious fried foods','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1878,'butt','butt','/bʌt/','n.屁股','the thick end of a weapon or tool; the part of a cigarette or cigar that is left after it has been smoked; the part of the body that you sit on','Corgis have the cutest butts of all kinds of dogs.','柯基有着所有狗狗中最可爱的屁股。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1879,'misunderstand','misunderstand','/ˌmɪsʌndərˈstænd/','v. 误解，误会','to fail to understand somebody/something correctly','He misunderstood the way of cooking smoked meat.','他误解了做烟熏肉的方法。','','mis错误，坏 + understand理解 → misunderstand误解',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1880,'crash','crash','/kræʃ/','v.碰撞；坠落；崩溃；  n.撞车；坠落；轰隆声','an accident in which a vehicle hits something, for example another vehicle, usually causing damage and often injuring or killing the passengers','The car behind crashed into the car in front!','后面的车撞上前面那辆了！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1881,'teen','teen','/tiːn/','n.(13～19岁的)青少年','being of the age 13 through 19','These teens come from different countries, but they have become good friends.','虽然这些青少年来自不同的国家，但他们成了很好的朋友。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1882,'denote','denote','/dɪˈnoʊt/','vt. 指出；代表（或表示）','to mean something','The red color is usually used to denote error.','红色一般用于指出错误。','','de加强 + note知道，注意 → 加强注意 → 指示',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1883,'diner','diner','/ˈdaɪnər/','n. 用餐者','a person eating a meal (especially in a restaurant)','There is only one diner eating in this restaurant.','这家餐馆里只有一名用餐者。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1884,'pretentious','pretentious','/prɪˈtenʃəs/','adj. 做作的，自命不凡的，炫耀的','having or showing the unpleasant quality of people who want to be regarded as more impressive, successful, or important than they really are','Get that pretentious look off your face! You\'re not cool!','别摆着一副自命不凡的样子！你一点都不酷！','','pre提前 ＋ tent延伸 ＋ ious形容词后缀 → pretentious自负的；虚伪的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1885,'echo','echo','/ˈekoʊ/','n.回声；  vt.重复；流传','if a sound echoes, it is reflected off a wall, the side of a mountain, etc. so that you can hear it again','If you shout in this valley, you\'ll hear an echo.','在这个山谷里大喊，你就可以听见回声。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1886,'eminence','eminence','/ˈemɪnəns/','n.卓越；高处','the quality of being famous and respected, especially in a profession','He is a scientist of great eminence.','他是一位卓越的科学家。','','e出 + min伸出，突出 + ence名词后缀 → 伸出的状态 → eminence杰出，著名',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1887,'plan','plan','/plæn/','n.平面图；  v.计划，打算','a detailed map of a building, town, etc.; a set of things to do in order to achieve something, especially one that has been considered in detail in advance; something that you intend to do or achieve','The architect is drawing up plans.','建筑师正在画平面图。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1888,'depiction','depiction','/dɪˈpɪkʃn/','n. 描画，描绘','','The painting on the wall is a vivid depiction of life in ancient China.','墙上的这幅画是对中国古代生活的生动描绘。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1889,'send_off','send off','/send ɔːf/','phr. 【体】罚下场，给…送行','send away towards a designated goal','He was sent off by the referee.','他被裁判罚下场了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1890,'recyclable','recyclable','/ˌriːˈsaɪkləbl/','adj.可循环再用的，可回收利用的','possible to use again','These things are recyclable, which means they can be used again after they\'ve been already used.','这些是可回收利用资源，这意味着它们在被使用过后还能被重新利用。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1891,'disturbance','disturbance','/dɪˈstɜːrbəns/','n. 扰乱，打扰；骚乱，混乱','the act of disturbing somebody/something or the fact of being disturbed; actions that make you stop what you are doing, or that upset the normal state that something is in','The loud music was such a disturbance whilst I was trying to work.','在我工作时，如此大声的音乐简直是巨大的干扰！','','disturb打扰 + ance表名词 → disturbance骚动，动乱',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1892,'lobby','lobby','/ˈlɑːbi/','n.门厅，大厅；游说团；  vt.向（议员、政府官员等）进行游说（或疏通）','','The lobby of this building was recently furnished, adding new sofas and tables.','这栋楼的大厅刚装修过，添了新沙发和桌子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1893,'halt','halt','/hɔːlt/','vt.使停止；  n.停住，终止','to stop; to make somebody/something stop','You should halt when you see a policeman make this gesture.','看到警察做出这个手势时，你应该要止步。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1894,'civic','civic','/ˈsɪvɪk/','adj.市民的；城市的','connected with the people who live in a town or city','Civic Center Plaza is the cultural and political center of San Francisco.','市中心广场是旧金山市的文化政治中心。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1895,'latent','latent','/ˈleɪtnt/','adj. 潜在的，隐伏的，不易察觉的','existing, but not yet very noticeable, active or well developed','The latent talent of a child is enormous.','孩子的潜在天赋是巨大的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1896,'myth','myth','/mɪθ/','n.神话；杜撰出来的人（或事物）','a story from ancient times, especially one that was told to explain natural events or to describe the early history of a people; this type of story','They are a well-known couple in Chinese myth.','他们是中国神话中一对广为人知的夫妇。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1897,'implement','implement','/ˈɪmplɪment/','n.工具，器具；  vt.实施，执行','a tool or an instrument, often one that is quite simple and that is used outdoors','I use these implements to take care of my garden.','我用这些工具来打理我的花园。','','im进 + ple满，填满 + ment名词后缀 → 装入并填满 → implement完成，实施',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1898,'could','could','/kəd/','aux.能','used as the past tense of ‘can’','She could run fast when she was young, but can\'t now!','她年轻的时候可以跑得很快，但她现在不能了。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1899,'shave','shave','/ʃeɪv/','v.剃，刮；  n.剃须，修面','to cut hair from the skin, especially the face, using a razor','The man is shaving in front of the mirror.','这个男人在镜子前刮胡子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1900,'cut_across','cut across','/kʌt əˈkrɔs/','v. 抄近路通过','cut using a diagonal lines','The boy decided to cut across a field to get home.','男孩决定抄近路通过一片田野回家。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1901,'longitudinal','longitudinal','/ˌlɑːndʒəˈtuːdnl/','adj. 纵向的','of or relating to lines of longitude','His trousers have longitudinal stripes, unlike his T-shirt.','跟他的T恤不同，他的裤子上有纵向条纹。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1902,'reluctance','reluctance','/rɪˈlʌktəns/','n. 不愿意，勉强','the feeling of being unwilling to do something and hesitating before you do it, because you do not want to do it or because you are not sure that it is the right thing to do','I can see her reluctance clearly.','我能看出她明显不情愿。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1903,'verify','verify','/ˈverɪfaɪ/','v. 查证，证明，证实','to prove, show, find out, or state that (something) is true or correct','This card can verify the man\'s identity.','这个证件可以证实此人的身份。','','veri真实 ＋ fy使... → 使真实 → verify核实',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1904,'highly','highly','/ˈhaɪli/','adv.高度地，非常，赞许地','very','I highly recommend you today\'s special dish—snail and goose liver with red wine!','我强烈向你推荐今天的特别菜品，蜗牛、鹅肝配红酒！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1905,'drain_away','drain away','/dreɪn əˈweɪ/','phr. 流尽','to empty or dry something by allowing the water to flow out of or off it, or become empty or dry in this way','The waste water is drained away from the city through this pipe.','废水通过这根水管从城市排出去了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1906,'regard...as','regard...as','/rɪˈɡɑːrd æz/','phr.将……认为','','She regards him as her biggest enemy.','她将他视为自己最大的敌人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1907,'missionary','missionary','/ˈmɪʃəneri/','n. 传教士','a person who is sent to a foreign country to teach people about Christianity','He travelled around the world as a missionary.','他以传教士的身份游历世界各地。','','miss送，放出 + ion表行为过程 + ary形容词或名词后缀 → missionary传教士的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1908,'watchful','watchful','/ˈwɑːtʃfl/','adj.注意的，警惕的','paying attention to what is happening in case of danger, accidents, etc.','The cat is keeping a watchful eye on the newcomer.','这只猫对于新来的（猫）非常警惕。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1909,'semester','semester','/sɪˈmestər/','n. 一学期','one of the two periods that the school or college year is divided into','A school year often contains two semesters.','一学年通常包含两个学期。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1910,'relay','relay','/ˈriːleɪ/','n.接力赛跑；  v.转播','a race between teams in which each member of the team runs or swims one section of the race','In a 400-meter relay, a runner passes a baton to the next person.','在400米接力比赛中，运动员将接力棒传给下一个人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1911,'every','every','/ˈevri/','det.每个，每一；每隔（一定的数目或时间）的，每……之中的','used with singular nouns to refer to all the members of a group of things or people','Every snowman has a carrot nose.','每一个雪人都有一个胡萝卜鼻子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1912,'mile','mile','/maɪl/','n. 英里','a unit for measuring distance equal to 1 609 metres or 1 760 yards','The road sign says the service station is 72 miles away.','路标指示离下一个服务区还有72英里。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1913,'break_down','break down','/brek daʊn/','phr. 发生故障；（精神）垮下来','make a mathematical, chemical, or grammatical analysis of; break down into components or essential features','The man\'s car breaks down, so he has to stop and call for help.','这个男人的车抛锚了，所以他不得不停下来寻求帮助。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1914,'in_the_event_of','in the event of','/ɪn ðə ɪˈvent əv/','phr. 如果发生','','In the event of a fire, please use the fire extinguisher.','如果发生火灾，请用灭火器灭火。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1915,'grateful','grateful','/ˈɡreɪtfl/','adj.感激的','feeling or showing thanks because somebody has done something kind for you or has done as you asked','Everyone was so grateful to the medical team that they lined the road, waving thankfully.','每个人都非常感谢医疗队。他们站在路边，满怀谢意地与医疗队员们挥手告别。','','grate感激，高兴 + ful多…的 → grateful感谢的；愉快的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1916,'at_all_events','at all events','/ət ɔːl ɪ\'vents/','n. 无论如何','','He knew the weather was bad this week, but he went running at all events.','他知道这周天气不好，但他无论如何都坚持跑步。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1917,'persecution','persecution','/ˌpɜːrsɪˈkjuːʃn/','n.迫害','the act of persecuting (especially on the basis of race or religion)','Animals not belonging to the cat family are facing persecution and being imprisoned.','不属于猫科的动物正面临着迫害和被监禁。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1918,'quickly','quickly','/ˈkwɪkli/','adv. 迅速地，快速地','fast; soon; after a short time','She runs and eats so quickly.','她跑步和吃饭都超快。','','quick迅速的 + ly表副词 → quickly迅速地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1919,'opera_house','opera house','/ˈɑːprə haʊs/','n. 歌剧院，艺术剧院','a theater where operas are performed','Sydney Opera House is a famous building around the world.','悉尼歌剧院是一座举世闻名的建筑。','Sydney Opera House','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1920,'grass','grass','/ɡræs/','n.草；  v.种植草','an area of ground covered with grass','It feels great to lie down on the grass.','躺在草地上感觉真好。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1921,'detest','detest','/dɪˈtest/','vt. 厌恶，憎恨，痛恨','to dislike (someone or something) very strongly','The internet bullies bothered the boy because they detest him so much.','网络暴民对他的百般憎恨让他苦恼不已。','','de不 + test证据 → 不愿作证 → detest嫌恶',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1922,'southeast','southeast','/ˌsaʊθˈiːst/','n.东南（方）；  adv.向东南；  adj.东南方的','the direction or region at an equal distance between south and east','There is a log cabin in the southeast of the forest.','树林的东南方有一个小木屋。','','south南部 + east东部 → southeast东南方，向东南，东南方的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1923,'magnanimous','magnanimous','/mæɡˈnænɪməs/','adj.宽宏大量的，大度的','having or showing a generous and kind nature','He was magnanimous in defeat and praised his opponent\'s skill.','他对失败表现得很大度，并且赞扬了对手的才能。','','magn大 + anim生命 + ous...的 → 大生命 → magnanimous心胸博大的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1924,'record','record','/rɪˈkɔːrd/','v.录制，录（音、像）；记录；  n.记录','to keep a permanent account of facts or events by writing them down, filming them, storing them in a computer, etc.','They are using the camera to record the meeting.','他们正在使用摄像机来记录这场会议。','','re再 + cord心脏 → 一再放在心上 → record记录',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1925,'frantically','frantically','/ˈfræntɪkli/','adv.疯狂地；紧张慌乱地','in an uncontrolled manner','She is working frantically, because she has so many tasks to do.','她忙得不可开交，因为她有非常多的任务要做。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1926,'vacancy','vacancy','/ˈveɪkənsi/','n. （职位）空缺','a job that is available for somebody to do','There\'s a job vacancy—let me apply!','这儿有个职位空缺，我要申请！','','vac空 + ancy性质，状况 → vacancy空白，空缺',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1927,'garment','garment','/ˈɡɑːrmənt/','n. 服装','a piece of clothing','We have all kinds of garments for you to wear.','我们有各式各样的服装供你穿。','garments for you to wear','gar装饰，供应 + ment表名词 → 装饰的东西 → garment衣服',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1928,'toast','toast','/toʊst/','n. 烤面包，吐司；敬酒；  v. 为……祝酒','the act of a group of people wishing somebody happiness, success, etc. by drinking a glass of something, especially alcohol, at the same time','There are two slices of toast and some butter on the table.','桌上有两片吐司和一些黄油。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1929,'fright','fright','/fraɪt/','n. 恐怖，惊吓','a feeling of fear; an experience that makes you feel fear','The man shouted out in fright.','那个男人吓得大叫。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1930,'crow','crow','/kroʊ/','n.乌鸦；  v.（婴儿）欢叫','a large bird, completely or mostly black, with a rough unpleasant cry','Three crows sat on the branch under the moonlight.','月光下，三只乌鸦坐在树枝上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1931,'grim','grim','/ɡrɪm/','adj. 严酷的，无情的；令人沮丧的，令人失望的','looking or sounding very serious','It\'s very hard for the patient to accept the grim result.','对这位病人来说，很难接受如此糟糕的结果。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1932,'essay','essay','/ˈeseɪ/','n.论文；随笔；  v.尝试','a short piece of writing on a particular subject, written in order to be published','The girl is busy writing her essay right now.','这个女孩正忙着写她的论文。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1933,'cent','cent','/sent/','n. 分币','a coin and unit of money worth 1% of the main unit of money in many countries, for example of the US dollar or of the euro','This coin is only worth one cent.','这枚硬币只值1美分。','worth one cent','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1934,'on_the_side','on the side','/ɑːn ðə saɪd/','phr. 作为兼职',' without official authorization','His main job is a writer, but he also runs a stall on the side. ','他的主业是作家，但也同时兼职摆地摊。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1935,'traverse','traverse','/trəˈvɜːrs/','v. 横越；穿过','to cross an area of land or water','It seemed impossible to traverse the entire Asian continent by car, but they did it!','驾车横越亚洲大陆看上去是不可能的，但他们做到了！','','tra横过，超过 + verse转 → 超过 → traverse横渡，横越',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1936,'toxic','toxic','/ˈtɑːksɪk/','adj.有毒的；  n.毒物','containing poison; poisonous','The green stuff in the bottle is toxic. ','瓶子里的绿色东西是有毒的。','','tox毒 + ic形容词后缀 → toxic有毒的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1937,'composure','composure','/kəmˈpoʊʒər/','n. 镇静，沉着','the state of being calm and in control of your feelings or behaviour','The man kept his composure when doing a split on two moving trucks.','这个男人镇定自若地在两辆行进的卡车上劈叉。','','com一起 + pos放 + ure名词后缀 → 精神放到一起 → composure镇静，沉着',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1938,'now_that','now that','/naʊ ðæt/','phr. 既然','','Now that it is raining outside, I\'d better stay at home.','既然外面下雨，那我最好还是呆家里吧。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1939,'chin','chin','/tʃɪn/','n. 下巴','the part of the face below the mouth and above the neck','In cartoons, most witches have a twisted face with a long chin.','动画片里，大部分女巫都有一张扭曲的脸和长长的下巴。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1940,'wicked','wicked','/ˈwɪkɪd/','adj. 邪恶的，恶毒的','morally bad','This wicked man is slapping the elderly disabled man.','这个坏蛋居然在扇那个残疾老人耳光！','This wicked man','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1941,'arouse','arouse','/əˈraʊz/','vt.唤起','','Being aroused from sleep is the beginning of his day.','他新的一天从被闹钟唤醒开始。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1942,'honor','honor','/\'ɑːnər/','n.荣誉','something that you are very pleased or proud to do because people are showing you great respect','She got an honor for her excellent grades.','她因出色的学习成绩而获得了这项荣誉。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1943,'artery','artery','/ˈɑːrtəri/','n. 动脉；干线','any of the tubes that carry blood from the heart to other parts of the body','We can feel our pulse by touching the arteries in our wrists.','我们可以通过触摸手腕里的动脉来感受脉搏。','','arter管道 + y表名词 → artery动脉',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1944,'mineral','mineral','/ˈmɪnərəl/','adj.矿物的；  n.矿物，矿物质','of, relating to, containing, or resembling minerals','We should drink more mineral water—it\'s good for our health.','我们应该多喝矿泉水，这对我们的健康有好处。','mineral water','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1945,'lock','lock','/lɑːk/','n.锁；  v.锁上','to fasten something with a lock; to be fastened with a lock','The door is locked; we can\'t get in!','这扇门锁上了，我们进不去！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1946,'imprisonment','imprisonment','/ɪmˈprɪznmənt/','n.关押','the act of putting somebody in a prison or another place from which they cannot escape; the state of being there','Draven was sentenced to seven years\' imprisonment.','德雷文被判处七年监禁。','','im加以…… + pris拿住，抓住 + on + ment表示行为、行为的过程或结果 → imprisonment关押',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1947,'animate','animate','/ˈænɪmeɪt/','v.使有生气，使活泼；  adj.有生命的','','The boy\'s special brush pen can animate anything he draws.','马良的神笔能使他画的任何东西都活过来。','','anim生命 + ate动词后缀 → animate使有生命',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1948,'routine','routine','/ruːˈtiːn/','n.常规；  adj.例行的，惯例的','the normal order and way in which you regularly do things; a situation in which life is boring because things are always done in the same way','This is the girl\'s daily routine.','这是小女孩每天都要做的事。','','rout(e)路线 + ine形容词后缀 → 路线设置好的 → routine常规的，例行的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1949,'equity','equity','/ˈekwəti/','n. 公平，公正；抵押资产的净值','the value of a piece of property (such as a house) after any debts that remain to be paid for it (such as the amount of a mortgage) have been subtracted','To ensure equity, the old millionaire left each son exactly the same amount.','为了保证公平，这位年迈的百万富翁给每个儿子留下了一样多的钱。','','equi相等，平均 + ty名词后缀 → equity公平，公正',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1950,'buddy','buddy','/ˈbʌdi/','n.密友，好朋友，伙伴','a close friend','He is my best buddy. We always hang out together.','他是我最好的朋友，我们总是一起玩。','best buddy','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1951,'mining','mining','/ˈmaɪnɪŋ/','n.采矿；矿业','','Strip mining has destroyed the land here.','露天采矿破坏了这里的土地。','','min表示“矿场” + ing [名词后缀]表示行为、状态、情况及其他 → mining矿业；采矿',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1952,'unity','unity','/ˈjuːnəti/','n. 团结，一致；统一体','the state of being in agreement and working together; the state of being joined together to form one unit','Our group\'s strength lies in our unity.','我们队伍的力量来源于我们的团结！','','uni一个 + ty名词后缀 → 成为一个整体 → 联合；统一体；团结',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1953,'ventilation','ventilation','/ˌventɪˈleɪʃn/','n. 通风设备，通风','the fact of allowing fresh air to enter and move around a room, building, etc.','The ventilation equipment in the ceiling keeps the air fresh.','天花板上的通风设备能让空气清新。','The ventilation equipment','ventil=vent风 ＋ ation表名词 → ventilation通风，换风',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1954,'innocence','innocence','/ˈɪnəsns/','n.天真无邪，单纯；无知，头脑简单','lack of knowledge and experience of the world, especially of evil or unpleasant things','Nothing compares to the innocence of a child.','什么也比不上孩子的天真无邪。','','in无 ＋ noc伤害，毒 ＋ ence名词后缀 → innocence无害；天真',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1955,'box','box','/bɑːks/','n. 盒子，箱子；  v. 拳击','(especially in compounds) a container made of wood, cardboard, metal, etc. with a flat stiff base and sides and often a lid, used especially for holding solid things','The box of books is really heavy.','这一箱书可真沉。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1956,'hospital','hospital','/ˈhɑːspɪtl/','n. 医院','a large building where people who are ill/sick or injured are given medical treatment and care','The patient was taken to the hospital for treatment.','病人被带进医院进行治疗。','taken to the hospital','hospit客人 + al名词词尾 → 客气对待病人的地方 → hospital医院',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1957,'civilize','civilize','/ˈsɪvəlaɪz/','v. 教育；使文明','to educate and improve a person or a society; to make somebody’s behaviour or manners better','Someone must have civilized the caveman to put his litter into the trash can.','一定是有人教育了原始人，让他把垃圾扔进垃圾桶里。','','civil文明的 + ize动词后缀 → civilize使文明化',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1958,'signify','signify','/ˈsɪɡnɪfaɪ/','vt.表示；  vi.具有重要性','to be a sign of something','Traffic signs signify different things you must do on the road.','交通标志显示了你在公路上必须遵守的各种规则。','','sign记号，信号 + ify动词后缀，…化 → 用信号表示 → signify象征',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1959,'report','report','/rɪˈpɔːrt/','n.报道；报告，汇报；  v.报道；报告，汇报','a written or spoken description of a situation, event, etc.','She wrote a newspaper report about him.','她写了一篇关于他的新闻报道。','','re回 + port拿，带 → 把消息、情况等带回来 → report报告，汇报',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1960,'schoolbag','schoolbag','/\'skuːlbæg/','n. 书包','a bag that children use to carry books and other things to and from school','He really likes his purple schoolbag.','他很喜欢他的紫色书包。','his purple schoolbag','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1961,'lion','lion','/ˈlaɪən/','n. 狮子','a large powerful animal of the cat family, that hunts in groups and lives in parts of Africa and southern Asia. Lions have yellowish-brown fur and the male has a mane','The lion is standing proudly, facing the sun.','这头狮子面向太阳骄傲地站着。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1962,'wreckage','wreckage','/ˈrekɪdʒ/','n. 残骸；破坏','the parts of a vehicle, building, etc. that remain after it has been badly damaged or destroyed','The ship was destroyed years ago; you can still see the wreckage today.','多年前那艘船就毁了，直到今天你都能看到它的残骸。','','wreck残骸 + age场所，物品 → wreckage残骸，碎片',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1963,'petitioner','petitioner','/pəˈtɪʃənər/','n. 请愿人','(formal) a person who makes a formal request to somebody in authority','These two petitioners are seeking people to sign their appeal for a new school bus.','这两位请愿者正寻求更多人在他们的新校车申请书上签字。','','pet追寻，寻求 + ition行为过程 + er表名词，人 → petitioner请愿者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1964,'perspire','perspire','/pərˈspaɪər/','v. 出汗，流汗','to produce a clear liquid from your skin when you are hot or nervous','The two friends perspire from the heat.','两个好朋友热得一身汗。','perspire from the heat','per贯穿，自始至终+spire呼吸→全身呼吸→perspire出汗',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1965,'afflict','afflict','/əˈflɪkt/','v. 使痛苦；使苦恼','to affect somebody/something in an unpleasant or harmful way','She is afflicted by a bad headache.','头痛使她遭罪。','','af一再+flict打击→一再打击→折磨',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1966,'behavior','behavior','/bɪ\'heɪvjə/','n.行为，举止','the way that somebody behaves, especially towards other people','People\'s behavior often reflects their personal qualities.','人们的举止通常可以体现出他们的个人素质。','','be表示动作 + hav持有 + ior表名词 → 人持有的动作 → behavior举止行为',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1967,'crafty','crafty','/ˈkræfti/','adj. 狡猾的，诡计多端的','clever at getting what you want, especially by indirect or dishonest methods','A crafty look appeared on his face.','他脸上露出狡猾的神情。','','craft工艺 + y形容词后缀 → crafty巧妙的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1968,'young','young','/jʌŋ/','adj.初期的','not yet old; not as old as others','Our company is quite young, founded one month ago.','我们公司很新，于一个月前成立。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1969,'hamper','hamper','/ˈhæmpər/','v. 阻碍，妨碍，牵制；  n. （有盖的）大篮子','to prevent somebody from easily doing or achieving something','This huge ball hampered the man\'s progress on the obstacle course.','这个大球阻碍了男人的闯关之路。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1970,'jeep','jeep','/dʒiːp/','n. 吉普车','a small strong vehicle used, especially by the army, for driving over rough ground','This man is driving a jeep with luggage strapped to the roof.','这个人开着一辆吉普车，行李捆在车顶上。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1971,'in_person','in person','/ɪn ˈpɜːrsn/','phr.亲自','in the flesh; without involving anyone else','Despite his tight schedule, he decided to take his daughter to school in person.','尽管时间很紧，他还是决定亲自送孩子上学。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1972,'fickle','fickle','/ˈfɪkl/','adj. （在感情等方面）反复无常的，轻浮的，善变的','changing opinions often','Immediately, the lollipop made the fickle boy smile through his tears.','棒棒糖马上让这个喜怒无常的男孩儿破涕为笑了。','the fickle boy','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1973,'first_of_all','first of all','/fɜːrst əv ɔːl/','phr. 首先','before anyone or anything else; at the beginning','We have to clean our house. First of all, let\'s sweep the floor.','我们需要把房子打扫一下。首先，让我们来把地扫了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1974,'frank','frank','/fræŋk/','adj.坦白的，直率的；清楚表明的，明显的','honest and direct in what you say, sometimes in a way that other people might not like','The boy replied to the teacher in a very frank manner.','这个男生在课堂上的回答非常坦率。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1975,'intelligence','intelligence','/ɪnˈtelɪdʒəns/','n.智力；情报；理解力','the ability to learn, understand and think in a logical way about things; the ability to do this well','Stephen Hawking was a man of great intelligence.','斯蒂芬·霍金是一个智商很高的人。','','intel在…中间 + lig选择，收集 + ence名词后缀 → 从中选出好的 → 智力',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1976,'rebel','rebel','/rɪˈbel/','v. 造反，反抗，反叛；  n. 造反者','to fight against or refuse to obey an authority, for example a government, a system, your parents, etc.','The little boy often rebels against his mother.','这个小男孩经常反抗他的母亲。','','re相反 + bel斗争 → 反打 → 反叛 → rebel反抗，造反',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1977,'trek','trek','/trek/','n. 艰苦跋涉；  v. 拉（货车），搬运','to travel by walking through an area with many mountains, rivers, etc., for pleasure and adventure','These hikers are on a trek across the snowy mountain.','这群远足者正徒步翻过这座雪山。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1978,'representation','representation','/ˌreprɪzenˈteɪʃn/','n.代表；陈述','the fact of having representatives who will speak or vote for you or on your behalf','All the animal representations have attended this international conference.','动物代表们都出席了此次国际会议。','','re反对 ＋ pre提前 ＋ sent感觉 ＋ ation名词后缀 → 反对预先提出的东西 → representation抗议；代表（权）',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1979,'stubborn','stubborn','/ˈstʌbərn/','adj. 顽固的；难对付的','determined not to change your opinion or attitude','Both of them are stubborn and don\'t want to say sorry first.','他俩都很顽固，不愿意第一个道歉。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1980,'use_up','use up','/juːz ʌp/','phr. 用完','to use all of something so that there is none left','The endless work means she has used up all her energy.','她已经被干不完的活耗去了所有力气。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1981,'cynical','cynical','/ˈsɪnɪkl/','adj. 愤世嫉俗的；恶意的','believing that people only do things to help themselves rather than for good or honest reasons','With that cynical outlook, he feels disappointed about the society.','抱着那种愤世嫉俗的观点，他对这个社会感到非常失望。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1982,'prosperity','prosperity','/prɑːˈsperəti/','n.繁荣，兴旺，发达','the state of being successful, especially in making money','The prosperity of the city is evident from this busy nighttime scene.','这忙碌的夜景显示着这座城市的繁荣。','','prosper繁荣 + ity表名词 → prosperity繁荣昌盛',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1983,'unload','unload','/ˌʌnˈloʊd/','v. 卸（货）','to remove things from a vehicle or ship after it has taken them somewhere','It\'s going to take all afternoon to unload these boxes.','要把这些箱子卸下来得花一个下午的时间。','','un由……中弄出 + load装载 → 把东西从车上弄下来 → unload卸货',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1984,'productive','productive','/prəˈdʌktɪv/','adj. 富有成效的','making goods or growing crops, especially in large quantities','He had a productive day, cleaning most of the weeds out of his garden.','他清除了花园里大多数的杂草，度过了颇有成效的一天。','','product产品 + ive形容词后缀 → 生产的；多产的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1985,'vowel','vowel','/ˈvaʊəl/','n.元音字母；元音','a letter that represents a vowel sound. In English the vowels are a, e, i, o and u.','English has five vowels - a, e, i, o, and u.','英语中有五个元音字母，它们是a、e、i、o、u。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1986,'ceramic','ceramic','/səˈræmɪk/','adj. 陶器的，陶瓷的；  n. 陶瓷制品','made of clay that has been heated to a very high temperature so that it becomes hard','These ceramic cups look simple but delicate.','这些陶瓷杯子简约却精美。','ceramic cups','ceram陶土+ic...的 → 陶瓷',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1987,'reward','reward','/rɪˈwɔːrd/','n.奖品，报酬；回报','a thing that you are given because you have done something good, worked hard, etc.','Lord Bao receives a gift in reward for his hard work.','包大人收到了一份奖励他辛苦工作的礼物。','in reward for','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1988,'greed','greed','/ɡriːd/','n. 贪欲，贪婪；贪吃','a strong desire for more wealth, possessions, power, etc. than a person needs','He has an insatiable greed for money.','他对金钱贪得无厌。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1989,'wary','wary','/ˈweri/','adj. 谨慎的，小心的，提防的','careful when dealing with somebody/something because you think that there may be a danger or problem','The cat has a wary stare at someone coming close.','猫咪谨慎地盯着正在靠近它的人。','a wary stare','war注视，看护 + y形容词后缀 → 警惕的，谨慎的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1990,'pass_away','pass away','/pæs əˈweɪ/','v. 死，逝世','pass from physical life and lose all bodily attributes and functions necessary to sustain life','He passed away in his sleep last night.','他昨夜在睡梦中逝去。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1991,'atrocity','atrocity','/əˈtrɑːsəti/','n. 残暴，暴行','a very cruel or terrible act or action','What the general did in the battle was an atrocity.','这个将军在战役中的所作所为是一场暴行。','','atroc残酷 ＋ ity名词后缀 → atrocity暴行；凶恶',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1992,'abrupt','abrupt','/əˈbrʌpt/','adj.突然的；唐突的，鲁莽的','sudden and unexpected, often in an unpleasant way','The abrupt bang gave him a fright.','气球突然爆炸，把他吓了一跳。','','ab分离，脱离 + rupt裂，破坏 → abrupt不连贯的，突然的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1993,'instruction','instruction','/ɪnˈstrʌkʃn/','n.说明；指导','the action or process of teaching; the act of instructing someone','She follows the instructions to take her medicine.','她按照说明书的指示服药。','follows the instruction','instruct指导 + ion名词后缀 → instruction指导',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1994,'set_about','set about','/set əˈbaʊt/','phr. 着手进行','to start doing or dealing with something, especially something that needs a lot of time and effort','The woman set about cleaning the house.','她准备开始打扫房子了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1995,'imitate','imitate','/ˈɪmɪteɪt/','vt.模仿','to copy the way a person speaks or behaves, in order to amuse people; to copy somebody/something','The boy imitates his father by shaving in the mirror.','小男孩对着镜子模仿父亲刮胡子。','','imit想象，相象 + ate做 → 做得相象 → imitate模仿',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1996,'competence','competence','/ˈkɑːmpɪtəns/','n.能力，胜任','the ability to do something well; a skill that you need in a particular job or for a particular task','The girl showed her competence on stage and received an award for her performance.','女孩在舞台上展现了自己的能力，并且获了奖。','','com共同 + pet追寻，寻求 + ence名词后缀 → 竞争的[能力] → 资格',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1997,'paperback','paperback','/ˈpeɪpərbæk/','n. 平装书，平装本，简装本','a book that has a thick paper cover','I will choose the paperback version of the book as it is cheaper.','我会选择这本书的平装版，因为它更便宜。','','paper纸 + back背部的 → 平装本',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1998,'foster','foster','/ˈfɔːstər/','adj.收养的；  v.培养，促进','to take another person’s child into your home for a period of time, without becoming his or her legal parents','This foster child will now be a part of their family.','这个收养的孩子现在将成为他们家庭中的一部分。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (1999,'red','red','/red/','adj. 红色的；  n. 红色','having the color of blood','I like painting with red paint, because red is a lucky color.','我画画的时候喜欢用红色的颜料，因为红色象征着幸运。','red','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2000,'courage','courage','/ˈkɜːrɪdʒ/','n.勇气，胆量','the ability to do something dangerous, or to face pain or opposition, without showing fear','It needs a lot of courage for the little girl to climb the rock wall.','小女孩攀登这块岩壁需要很大的勇气。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2001,'deadline','deadline','/ˈdedlaɪn/','n.截止期限，最后期限','a date or time when something must be finished; the last day, hour, or minute that something will be accepted','The employee worked overtime to meet the deadline.','为了赶上最后期限，这名员工正加班加点地工作。','meet the deadline','dead死亡 + line直线，线条 → 死亡期限 → 最后期限',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2002,'fill_up...with...','fill up...with...','/fɪl ʌp wɪð/','phr. 用…把…装满','an action or instance of filling up something','She fills up her bottle with water at the water tap.','她在水龙头那里把瓶子灌满了水。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2003,'outgoing','outgoing','/ˈaʊtɡoʊɪŋ/','adj.外向的；乐于助人的','at ease in talking to others','She is very friendly and outgoing.','她很友好，很外向。','friendly and outgoing','out外 + going走 → outgoing 外向的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2004,'constitution','constitution','/ˌkɑːnstəˈtuːʃn/','n. 组成，结构；宪法，章程','the system of laws and basic principles that a state, a country or an organization is governed by','The chemical constitution of vitamin B6 seems quite complex.','维他命b6的化学构造看起来很复杂。','','constitut组成 + ion名词后缀 → constitution构成；宪法',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2005,'run_over','run over','/rʌn ˈoʊvər/','phr. 匆匆浏览',' injure or kill by running over, as with a vehicle','He is running over his notes before the exam.','他正在考试前匆匆浏览笔记。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2006,'compromise','compromise','/ˈkɑːmprəmaɪz/','n.妥协，折中；  v.使遭受危险','an agreement made between two people or groups in which each side gives up some of the things they want so that both sides are happy at the end','The seller made a compromise and sold the dress at 50 yuan.','商家做出了妥协，以50元的价格卖出了那条裙子。','','com共同 + pro前面 + mise送，放出 → 共同承诺、遵守一项决定 → 妥协，和解',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2007,'Olympic','Olympic','/əˈlɪmpɪk/','adj.奥林匹克运动会的','connected with the Olympic Games','The five rings are the symbol of the Olympic Games.','五环是奥运会的象征。','the Olympic Games','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2008,'feel_up_to','feel up to','/fiːl ʌp tu/','phr. 觉得能够胜任,觉得身体挺得住','to have the energy to do something','I don\'t feel up to going out tonight, I\'m sick.','我今晚不想出去，我不太舒服。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2009,'hardware','hardware','/ˈhɑːrdwer/','n.五金器具；（计算机）硬件；重武器','things (such as tools or parts of machines) that are made of metal; the machinery and electronic parts of a computer system','He bought a lot of hardware from that store.','他从那家店买了很多五金器具。','','hard硬 + ware物件 → hardware五金器具',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2010,'sterling','sterling','/ˈstɜːrlɪŋ/','n. 英国货币；  adj. 出色的，优秀的；英币的','British money','They call it a "pound sterling" because it used to represent a pound of sterling silver.','他们称之为"英镑"，因为它过去代表一磅纯银。','pound sterling','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2011,'sprinkler','sprinkler','/ˈsprɪŋklər/','n. 洒水装置，洒水车','a device that is used to spray water on plants or soil','The sprinkler waters the grass several times a day.','洒水装置一天给草坪浇好几次水。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2012,'surrender_to','surrender to','/səˈrendər tu/','phr.屈服，投降','','He finally surrendered to temptation and ate the cupcake. ','他最终还是屈服于诱惑，吃掉了那个小蛋糕。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2013,'chair','chair','/tʃer/','n. 椅子；主席（职位）','a piece of furniture for one person to sit on, with a back, a seat and four legs','Sitting in the dentist chair always fills me with fear.','当坐在牙医的椅子上时，我总是不由自主地害怕。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2014,'solid','solid','/ˈsɑːlɪd/','adj. 结实的；坚固的；固体的；  n. 固体','strong and made well','This safe is very solid!','这个保险箱非常结实！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2015,'stunning','stunning','/ˈstʌnɪŋ/','adj.极美妙的，令人印象深刻的','extremely attractive or impressive','This house has a stunning view of the sunset.','这栋房子可以看到极美妙的日落。','','stunn=stun使目瞪口呆 ＋ ing形容词后缀 → 使人目瞪口呆的 → stunning极好的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2016,'nausea','nausea','/ˈnɔːziə/','n. 作呕，恶心','the feeling you have in your stomach when you think you are going to vomit','I feel a little nausea today; maybe it was something I ate.','今天我感觉有点恶心；也许跟我吃的东西有关。','feel a little nausea','naus海+ea[=ia病]→海上的病→晕船，作呕',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2017,'digestion','digestion','/daɪˈdʒestʃən/','n.消化系统','the system in your body which digests your food; the ability to digest food; the process of digesting food','Human\'s digestion includes esophagus, stomach, intestines and so on.','人的消化系统包括食道、胃和肠等。','','di分开+gest带来，产生+ion名词后缀 → 消化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2018,'imply','imply','/ɪmˈplaɪ/','vt.暗示；意味着','to express (something) in an indirect way :to suggest (something) without saying or showing it plainly','The little boy implied his craving for this cherry.','小男孩暗示了他对这颗樱桃的渴望。','','im进入 + ply重叠，折叠 → 重叠表达 → imply 暗示，意味',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2019,'supreme','supreme','/suːˈpriːm/','adj.至高的；最重要的','very great or the greatest in degree','The king has supreme power in his country.','国王在他的国家里拥有至高的权利。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2020,'pay_off','pay off','/peɪ ɔːf/','v. 付清；取得成功，使得益','to finish paying money owed for something','After years of hard work, I finally paid off my debts.','经过多年的努力工作，我终于还清了债务。','paid off my debts','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2021,'in_sb.\'s_favour','in sb.\'s favour','/ɪn ˈsʌmbədiz ˈfeɪvər/','phr. 对某人有利','in one\'s grant of favor or advantage to one over another (especially to a country or countries in matters of international trade, such as levying duties)','The score is ten to four in our favour.','现在比分是10比4，对我们有利。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2022,'vent','vent','/vent/','n.通风口，排气口；（上衣背部或两侧的）开衩；  v.发泄（情绪）；泄露','an opening that allows air, gas or liquid to pass out of or into a room, building, container, etc.; the opening in the body of a bird, fish, reptile or other small animal, through which waste matter is passed out; a long thin opening at the bottom of the back or side of a coat or jacket','The vent takes old air out and pushes fresh air in.','通风孔将废气排出去，新鲜的空气送进来。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2023,'make_the_most_of','make the most of','/meɪk ðə moʊst ɑv/','v. 充分利用','to show or use to the best advantage','She has a short holiday, so she decides to make the most of it.','她的假期很短，所以她决定好好利用它。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2024,'seduce','seduce','/sɪˈduːs/','v.引诱，诱使，诱惑，勾引','to make someone want to do something by making it seem very attractive or interesting to them','The tourists were seduced by the beauty of the lake.','游客们被湖泊的美景吸引住了。','','se分开，离开，区别开+duce引→引开→勾引别人',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2025,'creativity','creativity','/ˌkriːeɪˈtɪvəti/','n. 创造力','the ability to create','His creativity made him famous on the internet.','他的创造力让他火遍全网。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2026,'gone','gone','/ɡɔːn/','adj.逝去的','not present; having left','Her husband has been gone for many years.','她丈夫已经去世多年。','has been gone','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2027,'pick_sb._(sth.)_out','pick sb. (sth.) out','/pɪk ˈsʌmbədi ˈsʌmθɪŋ aʊt/','v. 认出，挑选','select, or choose from a number of alternatives','He picked his friend out at once—even in the crowd.','即使在人群里，他也一眼认出了他的朋友。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2028,'stiff','stiff','/stɪf/','adj.僵直的，酸痛的','painful to move or use','"Ouch—my back is so stiff!" the athlete complained.','“哎哟——我的背好僵！” 运动员抱怨道。','back is so stiff','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2029,'postmortem','postmortem','/ˌpoʊs(t)ˈmɔrtəm/','n. 验尸，尸体解剖；  adj. 事后的，死后的，事后检查或详论的','an examination of a dead body to find out the cause of death','He is doing a postmortem of the crocodile.','他正在做鳄鱼的尸体解剖。','','post后 + mortem死，致死的 → postmortem死后的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2030,'face_up_to','face up to','/feɪs ʌp tu/','phr. 大胆面向','','He has to face up to his failure instead of running away from it.','他必须直面自己的失败而不是逃避。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2031,'tractor','tractor','/ˈtræktər/','n. 拖拉机，牵引车','a powerful vehicle with two large and two smaller wheels, used especially for pulling farm machinery','We use tractors to farm.','我们用拖拉机来耕地。','','tract拉 + or名词后缀，物 → 拉东西 → tractor拖拉机',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2032,'devote...to','devote...to','/dɪˈvot tu/','phr. 把……献于','to use (time, money, energy, attention, etc.) for (something)','The monk devoted his life to his faith.','这个僧人将他的一生都献给了信仰。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2033,'hostage','hostage','/ˈhɑːstɪdʒ/','n.人质','a person who is captured and held prisoner by a person or group, and who may be injured or killed if people do not do what the person or group is asking','The monkey held the boy hostage in exchange for bananas.','这只猴子为了索要香蕉，抓住了那个男孩当人质。','','host客人[古法语中] + age表名词 → 把客人[留住] → hostage人质',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2034,'vehicle','vehicle','/ˈviːəkl/','n.交通工具，车辆','a thing that is used for transporting people or goods from one place to another, such as a car or lorry/truck','The vehicle drives off while carrying a container.','那辆车载着一个集装箱开走了。','','veh带来 + icle=le表名词 → 开车把人带来 → vehicle车辆，机动车',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2035,'get_over','get over','/ɡet ˈoʊvər/','phr.熬过','','She was heartbroken when she broke up with her boyfriend, but eventually she got over it.','她和男朋友分手后十分伤心，但她最终熬了过去。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2036,'define...as','define...as','/dɪˈfaɪn əz/','phr. 给……下定义','','Different people may define "happiness" as what they wish most at that moment.','不同的人可能会把“幸福”定义为他们目前最希望得到的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2037,'mushroom','mushroom','/ˈmʌʃrʊm/','n.蘑菇；  v.迅速发展','a fungus with a round flat head and short stem','"Give me back my hat," said the mushroom sadly.','"把帽子还给我! " 蘑菇难过地说道。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2038,'chapel','chapel','/ˈtʃæpl/','n. 小教堂；私人祈祷室','a small building or room used for Christian worship in a school, prison, large private house, etc.','We go to the chapel to praise God.','我们去小教堂祷告。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2039,'strain','strain','/streɪn/','n.负担；  v.拉紧；劳累；过度使用','pressure on somebody/something because they have too much to do or manage, or something very difficult to deal with; the problems, worry or anxiety that this produces','Her kid\'s summer course fees put her under great financial strain.','孩子的暑假班费用使她承受着很大的经济负担。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2040,'familiar','familiar','/fəˈmɪliər/','adj.熟悉的；不拘礼节的；亲密的；随便的；  n.密友；常客；高级官吏的家属','well known to you; often seen or heard and therefore easy to recognize','His owner\'s voice is very familiar to the dog.','狗对他主人的声音很熟悉。','','famili家庭 + ar……的 → familiar熟悉的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2041,'expulsion','expulsion','/ɪkˈspʌlʃn/','n. 驱逐','the act of forcing someone to leave a place (such as a country or a school) :the act of expelling someone','The soldiers penalize the criminal with expulsion.','士兵处罚这个罪犯的方式是将他驱逐出境。','','ex出 + puls驱动，推 + ion名词后缀 → 推出去 → expulsion驱逐',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2042,'thumb','thumb','/θʌm/','n.拇指；  vt.以拇指示意；  vi.<口语>做手势要求搭车','the short thick finger at the side of the hand, slightly apart from the other four','We gave our thumbs up to show our agreement.','我们竖起拇指以表赞同。','gave our thumbs up','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2043,'mourning','mourning','/ˈmɔːrnɪŋ/','n. 服丧','black clothing that is worn to show that you are mourning for someone who has died','The black armband showed the boy was in mourning.','手臂上的黑纱显示这个男孩正在服丧。','','mourn哀悼 + ing名词后缀 → mourning哀痛',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2044,'inherent','inherent','/ɪnˈhɪrənt/','adj. 生来就有的；内在的，固有的','that is a basic or permanent part of somebody/something and that cannot be removed','The baby girl has an inherent love of beauty.','这个小女孩天生就爱美。','an inherent love of','in里面 + her粘附 + ent有...性质的 → 天生与身体内连着 → 天赋的，生来的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2045,'erection','erection','/ɪˈrekʃn/','n.建造；建筑物；直立','the act of building or putting up','The erection of the new hospital took three months.','这所新医院的建造花了三个月的时间。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2046,'result','result','/rɪˈzʌlt/','n.结果，成效；  v.导致','a thing that is caused or produced because of something else; the mark/grade you get in an exam or in a number of exams','He was pretty excited after finding out his exam results.','他在得知考试成绩后非常开心。','','re反问 + sult跳 → 反馈回来 → result结果',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2047,'robbery','robbery','/ˈrɑːbəri/','n.抢掠，抢夺','the crime of stealing money or goods from a bank, shop/store, person, etc., especially using violence or threats','I saw a bank robbery.','我目击了一场银行抢劫案。','','robb=rob抢 + ery行为，情况 → robbery抢劫',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2048,'attach_to','attach to','/əˈtætʃ tu/','phr. 缚上，系上，附加','to fix, fasten, join sth to sth','Many people are attached to their mobile phones and can\'t live without them.','许多人被手机束缚住，不能离开手机生活。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2049,'toy','toy','/tɔɪ/','n.玩具；  v.不认真考虑；玩弄','an object for children to play with; an object that you have for enjoyment or pleasure rather than for a serious purpose','I like this toy. It can be used to scare others.','我喜欢这个玩具，它可以用来吓人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2050,'peel','peel','/piːl/','v. 剥皮，削皮，去壳；  n. 果皮，外皮','to take the outer layer off fruit, vegetables, etc.; to remove a layer, covering, etc. from the surface of something; to come off the surface of something; (of a covering) to come off in strips or small pieces; (of a surface) to lose strips or small pieces of its covering','This man is peeling potatoes.','这个男人正在削土豆皮。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2051,'precipice','precipice','/ˈpresəpɪs/','n. 悬崖；危险的处境，灾难的边缘，濒危点','a very steep side of a mountain or cliff','Be careful at the precipice—you might fall off.','在悬崖边得小心——你有可能摔下去。','at the precipice','pre….前的，预先 ＋ cipice头 → 在前面是尽头 → precipice峭壁',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2052,'enforce','enforce','/ɪnˈfɔːrs/','v.执行，实施','to make sure that people obey a particular law or rule','The new parking restrictions will be strictly enforced.','新的停车规定将被严格执行。','','en进入 + force强大，力量 → 进入力量 → 强行',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2053,'radioactivity','radioactivity','/ˌreɪdioʊækˈtɪvəti/','n. 放射性，放射现象','the spontaneous emission of a stream of particles or electromagnetic rays in nuclear decay','He wears a red radiation suit to protect himself from the radioactivity.','他穿了一套红色防辐射服来保护自己不受辐射伤害。','','radio光线 ＋ act行动，做 ＋ ivity表示情况、状态、“...性”、“...力” → radioactivity放射性；[核]放射能力',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2054,'suspicious_of','suspicious of','/səˈspɪʃəs əv/','phr. 对 ... 怀疑的','','She is suspicious of his motives for suddenly being so nice to her.','他突然对她特别好，这不禁让她怀疑其动机。','','',4,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2055,'practical','practical','/ˈpræktɪkl/','adj.实用的，可行的；实际的，实践的','(of a person) good at making or repairing things','Sneakers are more practical than boots for runners.','对于跑步者来说，运动鞋比靴子更实用。','','pract实践 + ical…的 → 实践的 → practical实践的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2056,'lover','lover','/ˈlʌvər/','n.恋人，爱人；爱好者','a partner in a romantic or sexual relationship','The lovers embraced each other tightly.','这对恋人紧紧相拥在一起。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2057,'retire','retire','/rɪˈtaɪər/','v.退休；退役','older people leave their job and usually stop working completely.','The retired couple are traveling together.','这对已经退休的夫妻正在一起旅行。','','re回，向后 + tire拉 → 拉回去撤离 → retire退休',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2058,'again_and_again','again and again','/əˈɡen ənd əˈɡen/','phr. 再三地；反复地','repeatedly','That salesman keeps knocking at my door again and again.','那个推销员一遍又一遍地敲着我的门。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2059,'summer','summer','/ˈsʌmər/','n.夏季；  adj.夏季的，在夏季的；  vi.避暑','the warmest season of the year that is after spring and before autumn','During summer, people like to eat watermelons and go swimming.','在夏天，人们喜欢吃西瓜和去游泳。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2060,'voluntary','voluntary','/ˈvɑːlənteri/','adj.自愿的；无偿的；  n.即兴曲','(of work) done by people who choose to do it without being paid','Giving blood is 100% voluntary: Nobody will force you to do it.','献血是百分之百自愿的，没人会强迫你去做。','100% voluntary','volunt自愿，意愿 + ary形容词后缀 → voluntary志愿的，自愿的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2061,'impossible','impossible','/ɪmˈpɑːsəbl/','adj.不可能的；  n.不可能的事','that cannot exist or be done; not possible','It\'s almost impossible for her to push that massive rock.','她要推动那块巨大的石头几乎不可能。','','im不，无，非 + possible可能的 → impossible不可能的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2062,'luxurious','luxurious','/lʌɡˈʒʊriəs/','adj.奢侈的，豪华的','very comfortable; containing expensive and enjoyable things','My apartment cost me a lot—I hope you find it sufficiently luxurious.','这个公寓花了我一大笔钱——我希望你觉得它足够奢华。','','luxur奢侈 + ious……的 → luxurious奢侈的，豪华的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2063,'worm','worm','/wɜːrm/','n.虫，蠕虫；  v.蠕动','a long thin creature with no bones or legs, that lives in soil; the young form of an insect when it looks like a short worm','Worms make good fish food.','蠕虫能做很好的鱼食。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2064,'resign','resign','/rɪˈzaɪn/','v.辞职，放弃','to officially tell somebody that you are leaving your job, an organization, etc.','After much consideration, the employee resigned from his job.','深思熟虑后，这位员工辞职了。','resigned from','re再 + sign签名 → 再次签名 → resign辞职',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2065,'botanical','botanical','/bəˈtænɪkl/','adj.植物（学）的','connected with the science of botany','This picture displays several botanical species.','这张图展示了几个植物物种。','','botan=botany植物学 + ical表形容词 → 植物学的 → botanical植物学的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2066,'demographic','demographic','/ˌdeməˈɡræfɪk/','adj. 人口学的；人口统计学的','of or relating to the study of changes that occur in large groups of people over a period of time :of or relating to demography','The demographic charts show the aging population in four of these countries.','人口统计图表显示了其中四个国家的人口老龄化情况。','','demo人民 + graph写，记录 + ic…的 → demographic人口统计的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2067,'ancestry','ancestry','/ˈænsestri/','n.祖先；血统','the family or the race of people that you come from','It\'s interesting to look back at human ancestry.','回头研究人类的祖先是件有趣的事情。','','ancest(or)祖先 + ry名词后缀 → ancestry祖先，世系，血统',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2068,'immersion','immersion','/ɪˈmɜːrʃn/','n. 沉浸','sinking until covered completely with water','The car gradually sank into the river until total immersion.','汽车逐渐沉入河里，直到完全沉没。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2069,'a_kind_of','a kind of','/ə kaɪnd əv/','phr. 一种，一类','used to show that something you are saying is not exact','Is a tomato a kind of fruit?','番茄是一种水果吗？','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2070,'bulk','bulk','/bʌlk/','n.大批；容量；体积；  adj.大量的；散装的；  v.膨胀；显得重要','the (large) size or quantity of something','Buying tomatoes in bulk is more economical than buying in small quantities.','批量采购番茄比少量购买实惠很多。','in bulk','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2071,'excerpt','excerpt','/ˈeksɜːrpt/','n.摘录，节选；  v.摘，选','a short piece of writing, music, film, etc. taken from a longer whole','I took an excerpt from this book and used it in my essay. ','我摘录了这条定义用在我的论文里面。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2072,'vulnerability','vulnerability','/ˌvʌlnərəˈbɪləti/','n.脆弱，弱点','the state of being vulnerable or exposed','The vulnerability of an eggshell is clear once it begins to crack.','一旦蛋壳开始破裂，它就会变得十分脆弱。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2073,'stability','stability','/stəˈbɪləti/','n.稳定，稳定性','the quality or state of being steady and not changing or being disturbed in any way (= the quality of being stable)','Walking a tightrope requires extreme stability.','走钢丝需要极强的稳定性。','extreme stability','st=stable稳定的 + ability能力 → stability稳定性',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2074,'meet','meet','/miːt/','v.满足','to come together formally in order to discuss something','This production chain ensures that the supply of milk meets the demands.','这条生产链保证了牛奶的供应满足需求。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2075,'taste_in','taste in','/teɪst ɪn/','n. 对 ... 的审美能力','','His taste in clothes differs from that of his friend.','他和他朋友的服装品味不同。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2076,'brain','brain','/breɪn/','n.脑','the organ inside the head that controls movement, thought, memory and feeling','Your brain is the organ inside your head that controls your body\'s activities.','大脑是在你的脑袋里控制身体活动的器官。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2077,'in_comparison_to','in comparison to','/in kəmˈpærɪsn tu/','phr. 与…相比','compared with','I am so small in comparison to the giant.','和巨人相比我太渺小了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2078,'even','even','/ˈiːvn/','adj.实力相当的；  adv.甚至；  v.使打平，使相等','(of an amount of something) equal or the same for each person, team, place, etc.','It was an even match so neither side could defeat the other.','这是一场势均力敌的比赛，谁也没法打败对方。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2079,'energetic','energetic','/ˌenərˈdʒetɪk/','adj.精力充沛的，充满活力的','having or showing a lot of energy','These elementary school students are very energetic.','这群小学生精力非常充沛。','','energ活力 + etic形容词后缀 → energetic充满活力的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2080,'structural','structural','/ˈstrʌktʃərəl/','adj.结构的，构造的','connected with the way in which something is built or organized','The structural design of a building is a very complex work.','房屋的结构设计是一项十分复杂的工作。','','struct建立 + ur=ure表情况 + al属于...的 → a.结构的，构造的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2081,'atmospheric','atmospheric','/ˌætməsˈferɪk/','adj. 大气的，大气层的','related to the earth’s atmosphere','Atmospheric layers of gas surround the Earth and allow us to breathe!','大气层包裹着地球，让我们能够呼吸。','','atmo=vapor蒸汽 + spher层 + ic…的 → atmospheric大气的，大气层的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2082,'language','language','/ˈlæŋɡwɪdʒ/','n.语言，语言文字','any one of the systems of human language that are used and understood by a particular group of people','People from different countries speak different languages.','不同国家的人讲不同的语言。','speak different languages','langu语言 + age表示状态、情况及其他 → language语言，语言课程',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2083,'have_fun_with','have fun with','/hæv fʌn wɪð/','phr. 玩得高兴','enjoy oneself','The father is having fun with his kids.','爸爸和他的孩子正玩得开心。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2084,'put_away','put away','/pʊt əˈweɪ/','phr. 放好；把…收起来；储存','place in a place where something cannot be removed or someone cannot escape','He finally made the bed and put away the clothes.','他终于整理了床铺、放好了衣服。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2085,'suicide','suicide','/ˈsuːɪsaɪd/','n.自杀','a course of action that is likely to ruin your career, position in society, etc.','To avoid being cooked, the egg committed suicide by jumping off the edge.','为了不被做成食物，鸡蛋从边上跳下去自杀了。','committed suicide','sui自己 + cid杀 + e行为 → suicide自杀',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2086,'realm','realm','/relm/','n.国土；领域','a country that is ruled by a king or queen','The old king is particularly satisfied with the size of his realm.','老国王对国土面积的大小特别满意。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2087,'tired_of','tired of','/ˈtaɪərd əv/','phr. 厌倦',' having a strong distaste from surfeit','He\'s sick and tired of his work. ','他厌倦了他的工作。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2088,'Mexico','Mexico','/ˈmeksɪkoʊ/','n. 墨西哥','a Republic in southern North America; became independent from Spain in 1810','The flag of Mexico has an eagle on it.','墨西哥的国旗上有一只鹰。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2089,'disposition','disposition','/ˌdɪspəˈzɪʃn/','n.性情，性格；排列，部署','the natural qualities of a person’s character','He has an unhealthy disposition; he gets angry so easily.','他的性情不好，很容易就会发火。','','dis分开 + posit放 + ion名词后缀 → 分开放 → 安排；引申为人的喜好，心情 → disposition性情；安排',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2090,'arrogant','arrogant','/ˈærəɡənt/','adj. 傲慢的，妄自尊大的','behaving in a proud, unpleasant way, showing little thought for other people','The arrogant man refused to listen to anyone else\'s ideas.','那个傲慢的男人拒绝听从其他人的想法。','','ar一再 + rog要求，问 + ant……的 → 一再要求的 → arrogant傲慢的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2091,'enterprise','enterprise','/ˈentərpraɪz/','n.企业（或事业）单位，公司','a company or business','This small enterprise specializes in milk and dairy products.','这家小企业专营牛奶和乳制品。','','enter进入 + prise拿住，抓住 → 进入抓住 → enterprise事业，进取心',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2092,'fluctuate','fluctuate','/ˈflʌktʃueɪt/','v. 波动；起伏；涨落','to change frequently in size, amount, quality, etc., especially from one extreme to another','The value fluctuates up and down.','价格上下波动。','','fluctu波浪 + ate动词后缀 → fluctuate波动',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2093,'plug','plug','/plʌɡ/','n.插头；  vt.插入（插头），接通（电源）；补足','a small plastic object with two or three metal pins that connects a piece of electrical equipment to the main supply of electricity','He wants to pull out the plug.','他想把插头拔出来。','pull out the plug','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2094,'detriment','detriment','/ˈdetrɪmənt/','n.损害，不利，伤害；损害物','something that will cause damage or injury to something or someone','Staying up very late is a detriment to one’s health.','熬夜有害身体健康。','a detriment to one’s health','de坏+tri=trit摩擦+ment表名词→磨坏了→损害',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2095,'concede','concede','/kənˈsiːd/','v.承认失败；承认；让步','to admit that something is true, logical, etc.','In the fight with this crazy kangaroo, I had no choice but to concede.','在与这只疯狂的袋鼠的战斗中，我除了认输，别无选择。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2096,'scorn','scorn','/skɔːrn/','vt. 鄙视；  n. 鄙视；  vt. 对……不屑一顾','a strong feeling that somebody/something is stupid or not good enough, usually shown by the way you speak','She scorned her work colleague who just read magazines all day.','她看不起那个整天看杂志的同事。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2097,'govern','govern','/ˈɡʌvərn/','v. 统治，管理；居支配地位','to legally control a country or its people and be responsible for introducing new laws, organizing public services, etc.','The boss governs his business empire.','老板统治着他的商业帝国。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2098,'architect','architect','/ˈɑːrkɪtekt/','n.建筑师；设计师','a person whose job is designing buildings','The architect is looking at a model of the building he designed.','这位建筑师正在看他设计的建筑模型。','','archi表示统治，主要的 + tect表示建筑 → 统治〔建筑〕的人 → architect建筑师',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2099,'disturb','disturb','/dɪˈstɜːrb/','v. 打扰，妨碍；使烦恼','to interrupt somebody when they are trying to work, sleep, etc.','His snoring really disturbs me at night!','晚上，他的呼噜声真的很打扰我！','','dis分开 + turb骚乱 → 分开了 → disturb扰乱，打扰',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2100,'illiterate','illiterate','/ɪˈlɪtərət/','n. 文盲，目不识丁者；  adj. 缺乏（某方面）知识的','(of a person) not knowing how to read or write','Illiterates cannot read.','文盲无法阅读。','','il不，无 + literate认字的 → illiterate不识字的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2101,'melon','melon','/ˈmelən/','n.瓜','a large fruit with hard green, yellow or orange skin, sweet flesh and juice and a lot of seeds','They served different kinds of melon at the graduation party.','在毕业派对上，他们提供了不同种类的瓜。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2102,'eager_for','eager for','/ˈiːɡər fɔːr/','phr. 渴望，热切希望','','Fans were already crowding outside, eager for the show.','粉丝们早已挤在外面，迫不及待想看演出。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2103,'improvise','improvise','/ˈɪmprəvaɪz/','v. 即席创作，临时凑成','to speak or perform without preparation','The guitarist threw away his music sheet and began to improvise.','吉他手扔掉了乐谱开始即兴演奏。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2104,'summarize','summarize','/ˈsʌməraɪz/','v. 作概括；作总结','to give a summary of something (= a statement of the main points)','I don’t want to read the whole thing. Could you just summarize the book for me?','我不想再看这个东西了，你能就帮我概括一下这本书吗？','','summar总，加 + ize动词后缀 → summarize概括',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2105,'defective','defective','/dɪˈfektɪv/','adj. 有缺陷的','having a fault or faults; not perfect or complete','The young woman received a parcel with defective goods.','这位年轻女子收到了一个商品有缺陷的包裹。','','de不 + fect做，制作 + ive形容词后缀 → defective有缺陷的；不完美的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2106,'cubic','cubic','/ˈkjuːbɪk/','adj.立方体的，立体的','having the shape of a cube; measured or expressed in cubic units; used to show that a measurement is the volume of something, that is the height multiplied by the length and the width','There is a cubic cake on the plate.','盘子里有一块方形的蛋糕。','','cub=cube立方 + ic……的 → 立方形的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2107,'supervise','supervise','/ˈsuːpərvaɪz/','v.监督；指导；管理','to be in charge of somebody/something and make sure that everything is done correctly, safely, etc.','The teacher supervises the students doing the exam.','老师正在监督学生考试。','','super在…上面 + vise看 → 在上面看 → 临视 → supervise监督',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2108,'Roman','Roman','/ˈroʊmən/','adj.罗马的，罗马文字的，罗马人的；  n.罗马天主教的','connected with ancient Rome or the Roman Empire','This is a Roman historical relic that is still standing in Rome.','这处古罗马遗迹依然伫立于罗马。','','Rom=Rome罗马 + an属于……的 → Roman罗马的，罗马人',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2109,'be_worthy_of','be worthy of','/bi ˈwɚði ʌv/','phr. 值得，配得上，当之无愧','having the qualities that deserve somebody/something','The boy\'s kind act is worthy of praise.','小男孩善良的举动值得表扬。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2110,'misfortune','misfortune','/ˌmɪsˈfɔːrtʃuːn/','n. 不幸，灾祸','bad luck; an unfortunate accident, condition or event','She had the misfortune to break her foot when a rock fell on it.','石头掉下来的时候，她的脚不幸地被砸了。','','mis错误，坏 + fortune幸运的 → misfortune不幸',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2111,'credit_to','credit to','/ˈkredɪt tu/','phr. 赞赏，归功于，把…归于','thanks to, owe to','The award winning scientist gave credit to the rest of his team.','这名获奖的科学家将成就归功于他的团队。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2112,'student','student','/ˈstuːdnt/','n. 学生；学者; 大学生','a person who is studying at a school, especially a secondary school','The students are reading the book.','学生们正在看书。','','stud=study学习 + ent人 → student学生',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2113,'founding','founding','/ˈfaʊndɪŋ/','n.成立，建立','the act of starting something for the first time; introducing something new','We celebrate the founding of People\'s Republic of China on October 1st every year. ','我们每年10月1日都会庆祝中华人民共和国的成立。','','found创办 + ing动名词后缀 → founding创办的；发起的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2114,'distraction','distraction','/dɪˈstrækʃn/','n.使人分心的事物','something that makes it difficult to think or pay attention','Texting while driving is a serious distraction for drivers, and can have serious consequences.','开车时发短信是一件让驾驶员分心的事，可能引起严重的后果。','','dis分开，分离 + tract拉 + ion名词后缀 → distraction心神烦乱，精神错乱',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2115,'field','field','/fiːld/','n.田野；运动场','an open area of land without trees or buildings','There is a large field around the farm house.','农舍周围有一大片田野。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2116,'pirate','pirate','/ˈpaɪrət/','n. 海盗；剽窃者','(especially in the past) a person on a ship who attacks other ships at sea in order to steal from them','We\'re going to dress up as pirates for the costume party.','我们在化装舞会中要打扮成海盗的样子。','','pir坏的 + ate做 → 做坏事 → pirate抢夺，引申为海盗',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2117,'terse','terse','/tɜːrs/','adj. 简洁的，简明的','brief and direct in a way that may seem rude or unfriendly','He made a terse statement about this matter.','他对这件事做出了一个简洁的声明。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2118,'costume','costume','/ˈkɑːstuːm/','n.服装，戏装','the clothes worn by actors in a play or film/movie, or worn by somebody to make them look like somebody/something else; the clothes worn by people from a particular place or during a particular historical period','The three kids are each wearing different costumes.','这三个孩子分别穿着不同的戏服。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2119,'exclusion','exclusion','/ɪkˈskluːʒn/','n. 被排除在外的事物','a person or thing that is not included in something','The girl was upset about her exclusion from the group.','这个女孩因被排除在小组之外而烦恼。','exclusion from the group','ex出+clus关闭+ion名词后缀→拒绝，排除，排外',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2120,'prosper','prosper','/ˈprɑːspər/','v. （生意等）成功；（城市、文化、植物生长等）繁荣','to develop in a successful way; to be successful, especially in making money','After struggling initially, his business began to prosper.','经过最初的奋斗，他的生意开始取得成功。','','pro前面 + sper希望 → 希望在前面 → prosper繁荣',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2121,'sow','sow','/soʊ/','v.播种；  n.母猪','to plant or spread seeds in or on the ground','The first stage to grow crops is to sow the seeds.','培育庄稼的第一步是播种。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2122,'invader','invader','/ɪnˈveɪdər/','n.侵略者','an army or a country that enters another country by force in order to take control of it; a soldier fighting in such an army','The soldiers are defending their land from the invaders.','士兵们正在抵御侵略者，保卫他们的土地。','','in进入 + vad行走 + er名词后缀，表示人 → invader入侵者',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2123,'go_on_about_sth.','go on about sth.','/ɡoʊ ɔːn əˈbaʊt ˈsʌmθɪŋ/','v. 喋喋不休','chatter without stop','He goes on about his opinions, and they can\'t stand it.','他喋喋不休地说着自己的观点，他们实在是受不了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2124,'monopoly','monopoly','/məˈnɑːpəli/','n. 垄断；垄断商品；专卖商品','the complete control of trade in particular goods or the supply of a particular service; a type of goods or a service that is controlled in this way','The biggest company has a monopoly in the market!','最大的那家公司垄断了市场！','','mono单个，一个 + poly工艺学校 → 独家卖 → monopoly垄断',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2125,'background','background','/ˈbækɡraʊnd/','n. 图片背景，底色；出身；背景；时代背景','the part of a picture, photograph or view behind the main objects, people, etc.; a colour or design on which something is painted, drawn, etc.','I have a photograph with the sea in the background.','我有张照片的背景是大海。','','back背后 + ground场地 → background背景，后台',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2126,'tireless','tireless','/ˈtaɪərləs/','adj.不知疲倦的','showing sustained enthusiastic action with unflagging vitality','He is a tireless worker who always efficiently finishes his tasks.','他是一个工作起来不知疲倦的人，总能高效地完成任务。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2127,'variation','variation','/ˌveriˈeɪʃn/','n.变化','a change, especially in the amount or level of something','The temperature in the desert shows great variation throughout the day.','沙漠中一天内的气温变化很大。','','vari变化 + ation名词后缀 → variation变化，变动，变更',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2128,'approximate','approximate','/əˈprɑːksɪmət/','adj.近似的；  v.接近，近似','almost correct or accurate, but not completely so','The approximate value of this car is 3,000 dollars.','这辆车价值大约3 000美元。','','ap不断 + proxim接近 + ate表动词 → 不断靠近 → approximate接近的，近似的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2129,'industrialization','industrialization','/ɪnˌdʌstriələˈzeɪʃn/','n. 工业化','the process of developing industries in a country or an area','Urban industrialization has given many people factory jobs.','城市的工业化给很多人提供了工厂的工作。','','industrial工业的 + ization表名词，发展过程 → 工业化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2130,'flux','flux','/flʌks/','n. 流动，不断的变动','continuous movement and change; a flow; an act of flowing','The shape of clouds is always in a state of flux.','云的形态总在不断地变化之中。','','flu流动 + x → 流动；变迁',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2131,'crowd','crowd','/kraʊd/','v.挤满；聚集在……周围；涌入（人的脑海）；  n.人群，观众；民众；朋友','a large number of people gathered together in a public place, for example in the streets or at a sports game','Many people are crowding on the train.','许多人正挤在这趟列车上。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2132,'lavish...on','lavish...on','/ˈlævɪʃ ɑn/','phr. 大肆花费','spend too much on something','She lavishes so much money on shopping.','她在购物上大肆花费了很多钱。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2133,'supersede','supersede','/ˌsuːpərˈsiːd/','v. 紧接着而到来；代替','to take the place of (someone or something that is old, no longer useful, etc.) :to replace (someone or something)','Robots superseding humans at playing Weiqi has become a reality.','机器人替代真人下围棋已成为现实。','','super在…上面+sede坐→坐上去→淘汰以前的东西→淘汰，取代',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2134,'furnished','furnished','/ˈfɜːrnɪʃt/','adj. 有家具的','(of a house, room, etc.) containing furniture','This apartment is now furnished.','这套公寓现在配有家具。','','furnish家具 + ed形容词后缀 → furnished家具，有家具的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2135,'turn_over','turn over','/tɜrn ˈoʊvər/','quant. 翻动，犁翻（土地），翻转','to change position so that the other side is facing towards the outside or the top','The green car turned over during the accident.','那辆绿色轿车在事故中翻车了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2136,'discontent','discontent','/ˌdɪskənˈtent/','n. 不满；  adj. 不满的','a feeling of being unhappy because you are not satisfied with a particular situation; something that makes you have this feeling','From the look on their faces, you could see their discontent at the food they were given.','从他们表情可以看出他们对被提供的食物非常不满。','','dis不 + con全部 + tent拿住 → 不能全部拿住 → discontent不满足的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2137,'easily','easily','/ˈiːzəli/','adv.容易地','in an easy manner :without difficulty','My four-year-old son can already solve math problems easily.','我那四岁的儿子已经可以轻松地解决数学问题了。','solve math problems easily','easi=easy容易的 + ly 表副词...地 → 容易地；无疑地',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2138,'whereabouts','whereabouts','/ˈwerəbaʊts/','n.下落，行踪，去向，所在之处；  adv.在何处，靠近什么地方','the location of a person or thing','The man anxiously asked if anyone knew the whereabouts of his dog.','那个男人焦急地询问是否有人知道他的狗的下落。','','where哪里 ＋ about在附近的 ＋ s表示地点等 → whereabouts下落；行踪',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2139,'geological','geological','/ˌdʒiːəˈlɑːdʒɪkl/','adj. 地质学的','of or relating to or based on geology','The team is conducting a geological inspection.','这个小组正在进行地质学考察。','','geo地球土地 + logical...学的 → geological地质学的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2140,'alienate','alienate','/ˈeɪliəneɪt/','v.疏远；挑拨','to make somebody feel that they do not belong in a particular group','He was alienated by his friends just because he was different.','他因为与众不同而被他的朋友们疏远了。','','ali其他的，改变状态 + en表形容词或名词 + ate使 → 把别人当外国人 → alienate疏远',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2141,'sleepiness','sleepiness','/ˈsliːpinəs/','n. 想睡，困倦','a very sleepy state','She\'s trying to suppress her sleepiness by drinking coffee.','她想靠喝咖啡来抑制睡意。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2142,'numerous','numerous','/ˈnuːmərəs/','adj.为数众多的，许多的','existing in large numbers','The stadium is filled with numerous sports fans.','体育场里坐满了体育爱好者。','numerous sports fans','numer数 + ous形容词后缀 → numerous无数的，许多的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2143,'powerful','powerful','/ˈpaʊərfl/','adj.强有力的；有权势的，有影响力的','being able to produce great physical force; having the ability to control or influence people or things','He lifts us up easily with his powerful arms.','他用强健的手臂轻松地把我们举起来了。','powerful arms','power力量 + ful表形容词，“有…的” → powerful有力的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2144,'consideration','consideration','/kənˌsɪdəˈreɪʃn/','n.体贴，体谅，顾及；考虑，思考','the quality of being sensitive towards others and thinking about their wishes and feelings','She shows a lot of consideration for her mother.','她很体贴她的母亲。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2145,'reconciliation','reconciliation','/ˌrekənsɪliˈeɪʃn/','n.和解，和好；修好；调停，调解','an end to a disagreement and the start of a good relationship again; the process of making it possible for two different ideas, facts, etc. to exist together without being opposed to each other','After the argument, the two girls finally made up and hugged in reconciliation.','两个女孩在争吵后，最终拥抱和好了。','','re重新 + con共同 + cil召集 + iation表名词 → 重新召集到一起 → reconciliation和解',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2146,'shameful','shameful','/ˈʃeɪmfl/','adj. 令人感到羞耻的，丢脸的；伤风败俗的，猥亵的，不体面的','that should make you feel ashamed','His action is so shameful as he even occupied other\'s seat!','他占座的行为真是可耻！','','shame耻辱 + ful形容词后缀 → shameful可耻的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2147,'soon','soon','/suːn/','adv.立刻，不久','in a short time from now; a short time after something else has happened','It\'ll soon be the New Year.','马上就到新年了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2148,'suburban','suburban','/səˈbɜːrbən/','adj.郊区的，市郊的','living in or relating to a suburb or to suburbs in general','Most residential houses are in suburban areas, away from the skyscrapers downtown.','大多数住宅位于郊区，远离市中心的摩天大楼。','','suburb郊区 + an形容词后缀 → suburban 郊区的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2149,'waitress','waitress','/ˈweɪtrəs/','n. 女服务员','a woman whose job is to serve customers at their tables in a restaurant, etc.','The waitress brought us two plates of salad.','女服务员给我们端来两盘沙拉。','','wait等待 + ress女性 → waitress女服务员',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2150,'render','render','/ˈrendər/','v.提供，给予；使成为，致使，使处于（某种状态）；粉刷，往（墙上）抹灰','to cause somebody/something to be in a particular state or condition','The kind teacher rendered a lot of financial assistance to her poor students.','善良的老师为贫困生提供了很多经济援助。','','rend给 + er表动词 → 给 → render使成为，给予',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2151,'infirmary','infirmary','/ɪnˈfɜːrməri/','n. 医院，医务室（尤指学校等附设的病房或配药处）','a place where sick people stay and are cared for in a school, prison, summer camp, etc.','An infirmary is a small hospital where patients are taken care of.','医务处是用于照顾病人的小医院。','','infirm体弱的 + ary名词后缀：场所 → 接纳虚弱者的地方→ infirmary 诊所',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2152,'ban','ban','/bæn/','vt.禁止','to order somebody not to do something, go somewhere, etc., especially officially','Smoking is banned in public places.','公共场所禁止吸烟。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2153,'hedge','hedge','/hedʒ/','n. 篱笆，树篱；保障','a row of bushes or small trees planted close together, usually along the edge of a field, garden/yard or road','The man is trimming the green hedge.','这个男人正在修剪绿绿的树篱。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2154,'eraser','eraser','/ɪˈreɪsər/','n. 橡皮擦，擦除器','a small piece of rubber or a similar substance, used for removing pencil marks from paper; a piece of soft material used for removing chalk marks from a blackboard','A pencil eraser is used to remove written mistakes on paper.','铅笔橡皮擦是用来擦除纸上的书写错误的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2155,'prejudice_against','prejudice against','/ˈprɛdʒədɪs əˈɡenst/','n. 使抱偏见(使怀成见)','','The fox prejudiced against the tiger because of the scars on him.','狐狸因为老虎身上的伤疤而对其持有偏见。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2156,'satisfy','satisfy','/ˈsætɪsfaɪ/','v.满足；（使）满意；符合……的标准','to make somebody pleased by doing or giving them what they want','The boy went to a fast food restaurant to satisfy his desire for a hamburger.','小男孩去快餐店满足了自己想吃汉堡的欲望。','satisfy his desire','satis足够，饱足 + fy化 → satisfy使…满足',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2157,'obstruct','obstruct','/əbˈstrʌkt/','v. 阻碍，妨碍，阻塞，堵塞','to block a road, an entrance, a passage, etc. so that somebody/something cannot get through, see past, etc.; to prevent somebody/something from doing something or making progress, especially when this is done deliberately','The barricade obstructs the road.','路障阻碍了道路。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2158,'dove','dove','/dʌv/','n. 鸽子','a bird of the pigeon family. The white dove is often used as a symbol of peace.','The dove is an international symbol of peace.','鸽子在全世界都代表和平。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2159,'corrosion','corrosion','/kəˈroʊʒn/','n. 侵蚀，腐蚀状态','the process of destroying something slowly, especially by chemical action; the condition that results from this process','The corrosion of this metal joint indicates its need for replacement.','这个金属接头的腐蚀情况表明它需要更换了。','','cor全部 + ros咬 + ion名词后缀 → corrosion腐蚀',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2160,'scrutinize','scrutinize','/ˈskruːtənaɪz/','v. 仔细检查，细看','to look at or examine somebody/something carefully','The businesswoman scrutinizes the documents for the program.','这名女商人在仔细查看项目文件。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2161,'pinpoint','pinpoint','/ˈpɪnpɔɪnt/','v. 准确地解释或说明；  adj. 精确的；  n. 针尖，极小之物，极不重要的事物','to find and show the exact position of somebody/something or the exact time that something happened; to be able to give the exact reason for something or to describe something exactly','I pinpointed the enemy\'s position with the flag.','我用旗子标明了敌人确切的位置。','pinpointed the enemy\'s position','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2162,'write','write','/raɪt/','v.（以文字）说','to make letters or numbers on a surface, especially using a pen or a pencil','The price of this shirt is written on the label. ','标签上写明了这件衬衫的价格。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2163,'be_conducive_to','be conducive to','/bi kənˈdusɪv tu/','phr. 有助于','to lead or contribute to a result','A good all-round lifestyle is conducive to good health.','运动有助于健康。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2164,'linen','linen','/ˈlɪnɪn/','n. 亚麻桌布；亚麻布','sheets, tablecloths, pillowcases, etc.','The linen tablecloth is rough to the touch.','这些亚麻桌布摸起来很粗糙。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2165,'detail','detail','/ˈdiːteɪl/','n.细节；  vt.详述','a small individual fact or item; a less important fact or item; the small facts or features of something, when you consider them all together','When the leaf is seen up close, you can see a lot of fine details.','近距离看树叶时，你可以看到很多细节。','a lot of fine details','de向下 + tail切割 → detail 细节',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2166,'succeed_in','succeed in','/səkˈsid ɪn/','phr. 取得成功','to be successful in your job, earning money, power, respect, etc.','After years of hard work, he finally succeeded in the music industry.','在多年的努力过后，他终于在音乐行业取得成功。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2167,'junction','junction','/ˈdʒʌŋkʃn/','n. 路口；连接，接合','the place where two or more roads or railway/railroad lines meet','Turn left at the junction of the two highways.','在这两条公路的交叉路口左拐。','','junct结合，连接 + ion名词后缀 → 连接的地方 → junction接合，交汇点',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2168,'visit','visit','/ˈvɪzɪt/','vt.拜访；  n.访问参观，游览；  v.看望，探望；参观，访问','to make an official visit to somebody, for example to perform checks or give advice','Our neighbors always visit us after work.','邻居下班之后经常来串门。','','vis看，观看 + it → visit参观',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2169,'passport','passport','/ˈpæspɔːrt/','n. 护照；途径，手段','an official document that identifies you as a citizen of a particular country, and that you may have to show when you enter or leave a country','I had to show my passport to the immigration official.','我必须向移民局官员出示护照。','','pass通过 + port港口 → 通过港口的凭证 → passport护照',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2170,'next_to','next to','/ˈnekst tu/','prep. 相邻，紧挨着','in or into a position right beside somebody/something','Our houses are located right next to each other.','我们的房子彼此紧邻。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2171,'return','return','/rɪˈtɜːrn/','v.返回；归还','to come or go back from one place to another','Return to where you came from.','从哪儿来回哪儿去。','Return to','re回，向后 + turn转 → return回来，返回',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2172,'counterfeit','counterfeit','/ˈkaʊntərfɪt/','v.伪造，仿造；  n.仿制品，伪造物；  adj.仿造的，假冒的','to make an exact copy of something in order to trick people into thinking that it is the real thing','He counterfeits a zebra by painting on a donkey.','他给驴子涂上颜色来冒充斑马。','','counter相反 ＋ feit=do做 → 做（与真品）相反的 → counterfeit假冒的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2173,'then_and_there','then and there','/ðen ænd ðer/','phr. 当场，立即','immediately','After the lightning struck him, he died then and there.','雷电打在他身上，他当场死亡。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2174,'concern_about','concern about','/kənˈsɚn əˈbaʊt/','phr. 忧虑，担心，关心','','People are much more concerned about the environment than before.','人们比以前更关心环境了。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2175,'around','around','/əˈraʊnd/','prep.在……周围；  adv.大约，四处','surrounding somebody/something; on each side of something; on, to or from the other side of somebody/something','They sit around the teacher.','他们围坐在老师身边。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2176,'vocabulary','vocabulary','/vəˈkæbjəleri/','n.词汇（量）；词（汇）表','all the words in a particular language; all of the words known and used by a person','There are plenty of words in the vocabulary which are related to business.','词汇表中的许多单词都与商业有关。','','vocabul=vocable词 + ary表名词 → vocabulary词汇',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2177,'degenerate','degenerate','/dɪˈdʒenəreɪt/','v. 堕落，衰减；  adj. 腐化的，颓废的，退化的；  n. 堕落者','to become worse, for example by becoming lower in quality or weaker','How had his life degenerated to the point that he was living in a public park?','他怎么会沦落到住在公园里的地步？','','de坏 + gener出生，产生 + ate使 → 往坏产生 → 堕落',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2178,'metallic','metallic','/məˈtælɪk/','adj. 金属的；金属般的','made of or containing metal','The metallic armor will protect me in the war!','在战斗中，这件金属盔甲可以保护我！','','metal金属 + l + ic……的 → metallic金属的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2179,'valley','valley','/ˈvæli/','n.山谷，溪谷，低谷','an area of low land between hills or mountains, often with a river flowing through it; the land that a river flows through','A small stream flows through the valley.','一条小溪流过山谷。','through the valley','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2180,'paid','paid','/peɪd/','adj.付费的','receive money for the work that they do','The video-sharing website offers a paid service, which allows users to skip ads.','这家视频分享网站提供付费服务，允许用户跳过广告。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2181,'disgust','disgust','/dɪsˈɡʌst/','v. 使作呕，使厌恶；  n. 恶心','if something disgusts you, it makes you feel shocked and almost ill/sick because it is so unpleasant','What really disgusts me isn\'t one worm, but a half one in an apple.','真正让我恶心的不是在苹果中发现一条虫，而是半条虫。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2182,'store','store','/stɔːr/','n. 商店；储存品；  v. 贮藏，储存','a large shop that sells many different types of goods','I took my daughter to the grocery store to buy some food.','我带着女儿去杂货店买一些食物。','the grocery store','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2183,'varied','varied','/ˈverid/','adj. 多变的，各种各样的','of many different types; not staying the same, but changing often','The table was covered with a varied assortment of tools.','桌上放满了各种各样的工具。','','vari变化 + ed形容词后缀，…的 → varied多变化的，各式各样的，不同的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2184,'calmly','calmly','/ˈkɑːmli/','adv.平静地','with self-possession (especially in times of stress)','Despite her naughty children and messy room, she still somehow manages to work calmly.','尽管孩子们调皮捣蛋，房间内乱七八糟，她还是设法平静地工作。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2185,'hardy','hardy','/ˈhɑːrdi/','adj.吃苦耐劳的；（植物）耐寒的；勇敢的；  n.强壮的人','strong and able to survive difficult conditions and bad weather','Soldiers are hardy—even cold weather can\'t stop them from training.','士兵们是吃苦耐劳的，即使是严寒的天气也不能阻止他们进行训练。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2186,'get_somewhere','get somewhere','/ɡet ˈsʌmwer/','v. 有所成就','achieve something','After all his hard work and effort, he was finally getting somewhere.','凭借他的刻苦和努力，他最终有所成就。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2187,'virtually','virtually','/ˈvɜːrtʃuəli/','adv. 几乎；实际上','almost or very nearly, so that any slight difference is not important','The screen is so vivid that the pictures were virtually right there in front of me.','屏幕里的东西那么栩栩如生，仿佛那些画面（实际上）就在我的眼前。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2188,'increase','increase','/ɪnˈkriːs/','v. 增加，提高；  n. 增加，增强，提高','to become or to make something greater in amount, number, value, etc.','The population has increased dramatically in recent years.','近年来，人口急剧增加。','','in向内 + crease生长 → increase增加',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2189,'deepen','deepen','/ˈdiːpən/','v. 挖深，使变深；使……更糟糕','if colour or light deepens or if something deepens it, it becomes darker','The pit has been deepened by the worker.','这个坑已经被工人挖深了。','','deep深的 + en变成 → 加深，使深',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2190,'yak','yak','/jæk/','n. 牦牛','','Yaks have thick fur because they live in the high mountains.','牦牛有厚皮毛，因为他们住在高山地区。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2191,'cotton','cotton','/ˈkɑːtn/','n.棉花','a soft, white material that grows on the seeds of a tall plant and that is used to make cloth','Cotton feels soft and can be used to make clothes.','棉花摸起来很柔软，可以用来制作衣服。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2192,'oversight','oversight','/ˈoʊvərsaɪt/','n.疏忽，失察','the fact of making a mistake because you forget to do something or you do not notice something','Due to an oversight by the employee, a broken teddy left the factory.','因为这位员工的一个疏忽，一只破了的泰迪熊出厂了。','','over越过 + sight眼光 → 越过漏洞没看见 → oversight疏忽',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2193,'buffer','buffer','/ˈbʌfər/','v. 缓冲；  n. 缓冲，缓冲区','(of a computer) to hold data for a short time before using it; to reduce the harmful effects of something','Ugh, this video is buffering.','呃，视频正在缓冲。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2194,'tenant','tenant','/ˈtenənt/','n. 承租人，租客，佃户','a person who pays rent for the use of a room, building, land, etc. to the person who owns it','We showed the new tenants around the apartment.','我们带新租客去看了房。','','ten握住 + ant人 → 拿钱租房之人 → tenant佃户；房客',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2195,'keep_sth._to_oneself','keep sth. to oneself','/kiːp ˈsʌmθɪŋ tu wʌnˈself/','v. 不让他人分享，独自享用','to remain solitary or apart from other people','The little boy refused to share as he wanted to keep the snacks to himself.','这个小男孩只想独自享用零食，拒绝和别人分享。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2196,'ultimate','ultimate','/ˈʌltɪmət/','adj.根本的；最终的','from which something originally comes','The sun is the ultimate source of energy.','太阳是能量的根本来源。','','ult(er)那边的 + im最高级后缀 + ate形容词后缀 → 最那边的，最终的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2197,'pump','pump','/pʌmp/','v. 抽水，抽取；  n. 打气筒；泵，抽水（机）','to make water, air, gas, etc. flow in a particular direction by using a pump or something that works like a pump','The man is going to pump some water.','这个男人打算抽点水出来。','pump some water','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2198,'presently','presently','/ˈprezntli/','adv.一会儿，不久，目前，马上','at the time you are speaking or writing; now; used to show that something happened after a short time; used to show that something will happen soon','Don\'t worry. The doctors will be here presently.','别担心，医生马上就到。','','present目前 + ly副词后缀 → presently一会儿，目前',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2199,'electoral','electoral','/ɪˈlektərəl/','adj.选举的，选举人的','connected with elections','The ballot, ballot box, and candidate are all associated with electoral activities.','选票、投票箱和候选人都与选举活动有关。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2200,'bankruptcy','bankruptcy','/ˈbæŋkrʌptsi/','n.破产','the state of being bankrupt','A number of different debts drove the company into bankruptcy.','许多不同的债务迫使这家公司破产了。','','bank柜台 + rupt断裂 + cy名词后缀 → 破产',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2201,'incident','incident','/ˈɪnsɪdənt/','n.事件；事变，（军事）冲突','something that happens, especially something unusual or unpleasant','The headmaster is speaking to the two boys about the classroom incident.','校长正在和这两个男孩谈论教室事件。','','in进入 + cid降临 + ent表名词 → incident偶然事件',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2202,'modem','modem','/ˈmoʊdem/','n. 调制解调器','a device that changes the form of electric signals so that information can be sent through telephone lines from one computer to another computer','I bought a new modem to connect my computer to the Internet.','我买了一个新的调制解调器让电脑能联网。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2203,'traffic','traffic','/ˈtræfɪk/','n.交通，车流；交通运输','the vehicles that are on a road at a particular time; the movement of ships, trains, aircraft, etc. along a particular route','The cars are hardly moving in the traffic jam.','车子在交通堵塞中艰难地移动。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2204,'trolly','trolly','/\'trɒlɪ/','n. 手推车，小车，无轨电车，有轨电车','a small vehicle with wheels that can be pushed or pulled along and is used for carrying things','She pushes the trolly when her daddy sits in it.','她推着购物车，她爸爸坐在里面。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2205,'bring_in','bring in','/brɪŋ ɪn/','phr. 增加，赚取，产生，引进','to attract somebody/something to a place or business; to make or earn a particular amount of money','The new project brings in a great amount of money for his company.','新项目为他的公司增加了巨额的收入。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2206,'get_at','get at','/ɡet æt/','phr.够得着，触及',' reach or gain access to','This little boy was trying to get at the apple on the table. ','小男孩努力想够到桌上的苹果。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2207,'senior','senior','/ˈsiːniər/','adj. 年长的；资格老的，地位较高的；  n. （大学或高中）毕业生','for senior citizens (= older people, especially those who have retired from work)','The senior citizens in the community often have fun talking to each other.','社区里的老年人们经常在一起愉快地聊天。','senior citizens','sen年老 + ior表示人 → 上年纪的人 → senior长辈',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2208,'corresponding','corresponding','/ˌkɔːrəˈspɑːndɪŋ/','adj.相应的；符合的，一致的；通信的','having the same characteristics as something else: matching something else','Each medal winner should stand on the corresponding platform.','每一位奖牌得主都要站在相应的领奖台上。','the corresponding platform','correspond符合，通信 + ing形容词后缀 → corresponding 相应的；通信的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2209,'microscope','microscope','/ˈmaɪkrəskoʊp/','n. 显微镜','a device used for producing a much larger view of very small objects so that they can be seen clearly','The scientist is looking at the sample under the microscope.','科学家正在显微镜下观察样本。','under the microscope','micro微，小 + scope看 → 看小东西 → microscope显微镜',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2210,'diagram','diagram','/ˈdaɪəɡræm/','n.图表','a simple drawing using lines to explain where something is, how something works, etc.','The diagram in this textbook shows how the water cycle works.','这本教科书中的图解展示了水循环的过程。','','dia穿过，二者之间 + gram写，图 → 交叉对着画 → 图表',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2211,'flourish','flourish','/ˈflɜːrɪʃ/','vi.茂盛；繁荣，兴旺','to grow well; to be healthy and happy','Plants flourish with enough sunlight. ','植物有充足的阳光就会茂盛。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2212,'arcade','arcade','/ɑːrˈkeɪd/','n. 游乐场所，游戏厅；有拱廊的街道','a place where you can play games on machines which you use coins to operate','The young boy spent the whole day playing games at the arcade.','这个年轻的男孩在游戏厅玩了一整天了。','playing games at the arcade','arc弓+ade表名词→连拱廊，如cascade瀑布',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2213,'across','across','/əˈkrɔːs/','prep.越过，横跨；  adv.横过','from one side to the other side of something; on the other side of something;','She got across the stream by walking on the rocks.','她踩在石头上穿过了小溪。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2214,'hand_in','hand in','/hænd ɪn/','phr.上交，递交','to give something to a person in authority, especially a piece of work or something that is lost','He\'s handing in his homework to the teacher.','他正在把自己的作业上交给老师。','handing in his homework','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2215,'dome','dome','/doʊm/','n. 圆屋顶，穹顶','a round roof with a circular base; a thing or a building shaped like a dome','This building has a large glass dome at the top of it.','这个建筑的顶部有一个大大的玻璃圆顶。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2216,'be_apparent_to','be apparent to','/bi əˈpærənt tə/','phr. 清楚，明显','If something is apparent to you, it is clear and obvious to you.','It is apparent to the man that the woman is pregnant.','这个人明显知道这位女士怀孕了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2217,'dozen','dozen','/ˈdʌzn/','n.一打，十二个','a group of twelve of the same thing','A dozen eggs now cost twenty dollars—how expensive!','一打鸡蛋现在要20美元——好贵啊！','A dozen eggs','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2218,'sense','sense','/sens/','n.感官；  v.觉得，意识到','one of the five powers (sight, hearing, smell, taste and touch) that your body uses to get information about the world around you','I\'m blind, but I can read this book using my sense of touch.','我是盲人，但是我能用我的触觉来读这本书。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2219,'bunk','bunk','/bʌŋk/','n. （火车等）床铺，铺位，卧铺；  v. 睡（在床铺上），去睡','a narrow bed that is usually attached to a wall, especially in a ship','If you want a top bunk in the train, you\'d better book one as soon as you can.','如果你想要火车的上铺床位，你最好赶紧订票。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2220,'plaza','plaza','/ˈplæzə/','n.广场；购物中心','an open public area that is usually near city buildings and that often has trees and bushes and places to sit, walk, and shop','The plaza in front of the cathedral bustled with tourists.','大教堂前的广场上满是游客。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2221,'adulthood','adulthood','/ˈædʌlthʊd/','n. 成人期','','They remained good friends into adulthood.','成年后，她们也一直是好朋友。','','adult成人 ＋ hood表示时期，情况，状态，性质，身份，资格等 → adulthood成年；成人期',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2222,'take_exception_to','take exception to','/teɪk ɪkˈsepʃən tu/','phr. 反对','If you take exception to something, you feel offended or annoyed by it, usually with the result that you complain about it.','The celebrities took exception to the flashing cameras.','这些名人反对被相机拍摄。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2223,'together','together','/təˈɡeðər/','adv.一起；同时；  adj.自信而妥当的','with or near to somebody/something else; with each other','This place is even more beautiful to me because we\'re here together.','因为有你在身边，所以这个地方变得分外美丽。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2224,'so_long_as','so long as','/soʊʊ lɔːŋ æz/','phr. 只要','only if；since; to the extent that','So long as you keep trying, you can always win the race.','只要你继续努力，你总能赢得比赛。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2225,'token','token','/ˈtoʊkən/','n.礼券，代金券；象征；筹码，代币；  adj.象征性的','a piece of paper that you can collect when you buy a particular product and then exchange for something; a piece of paper that you pay for and that somebody can exchange for something in a shop/store','Collect three tokens and you\'ll get a free bottle of beer.','集齐三张礼券可以换一瓶免费啤酒。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2226,'talkative','talkative','/ˈtɔːkətɪv/','adj.多话的，多嘴的','liking to talk a lot','The two friends become super talkative when they meet each other.','这两个朋友一见面就变得滔滔不绝。','','talk讲话 ＋ ative...的 → talkative好说话的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2227,'irrational','irrational','/ɪˈræʃənl/','adj.无理性的，失去理智的','not based on, or not using, clear logical thought','It seems irrational to spend all your money on new shoes.','把所有钱都花在买新鞋子上是不理智的。','','ir不，无 + rational合理的 → irrational不合理的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2228,'superior','superior','/suːˈpɪriər/','adj.较高级的，上层的；  n.上级','a person of higher rank, status or position; used in titles for the head of a religious community','The boy\'s five-stripe badge shows that he is superior to the other boy.','他肩上的五道杠表明他比另一个人级别高。','','super在上面 + ior表形容词，较…的 → superior在上面的，超越的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2229,'opposition','opposition','/ˌɑːpəˈzɪʃn/','n.反对',' the action of opposing something that you disapprove or disagree with','They both have shown their opposition to the other direction.','他们同时表示了对去往另一个方向的反对。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2230,'none_the_less','none the less','/nʌn ðə les/','phr. 还是','in spite of that; nevertheless','This phone is outdated but I like it none the less.','这个手机现在已经过时了，尽管如此，我还是很喜欢它。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2231,'generous_with_sth.','generous with sth.','/ˈdʒenərəs wɪð ˈsʌmθɪŋ/','phr.在……方面大方','','He\'s generous with money, always helping the poor.','他在金钱方面很大方，一直帮助穷人。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2232,'bribery','bribery','/ˈbraɪbəri/','n. 行贿，受贿','the giving or taking of bribes','The squirrel had immersed himself in bribery for a long time.','这只松鼠长期陷于受贿之中。','','bribe贿赂 + ry表名词 → bribery贿赂',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2233,'telescope','telescope','/ˈtelɪskoʊp/','n.望远镜；  v.缩短，精简；（使）套入；  adj.套筒的，伸缩式的','a piece of equipment shaped like a tube, containing lenses, that you look through to make objects that are far away appear larger and nearer','You can see many distant stars through the telescope.','通过望远镜，你可以看到许多遥远的星星。','','tele远，传送 + scope看 → 看远方 → 望远镜',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2234,'penguin','penguin','/ˈpeŋɡwɪn/','n. 企鹅','a black and white bird that lives in the Antarctic. Penguins cannot fly but use their wings for swimming. There are several types of penguin, some of them very large but some of them quite small.','Penguins live in cold places.','企鹅生活在寒冷的地方。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2235,'let_down','let down','/let daʊn/','phr. 使失望，辜负','to fail to help sb; to disappoint sb','My father always lets me down; he never plays with me.','我爸爸总是令我失望；他从来不陪我玩。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2236,'can\'t_help_but_do_sth.','can\'t help but do sth.','/kænt help bət du ˈsʌmθɪŋ/','phr. 忍不住做某事','unable to stop doing something','I can\'t help but laugh out loud when my mom tickles me.','我妈挠我痒痒的时候我忍不住大笑起来。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2237,'refer','refer','/rɪˈfɜːr/','v.参考，查看；求助于','to send somebody/something to somebody/something for help, advice or a decision','She refers to the book while she cooks.','在做菜时她会参考那本书。','','re再次 + fer带来，拿来 → 再次带来 → refer提到；指点',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2238,'by_reason_of','by reason of','/baɪ ˈriːzən əv/','n. 由于','','She was asked for help by reason of her experience in dealing with this disease.','因为她在治疗这种疾病方面有丰富的经验，所以病人向她寻求帮助。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2239,'take_sth._apart','take sth. apart','/teɪk ˈsʌmθɪŋ əˈpɑːrt/','phr. 拆开','divide into pieces','The boy took the fan apart to find out what was wrong with it.','男孩把风扇拆开，想知道它出了什么毛病。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2240,'southeastern','southeastern','/ˌsaʊθ\'iːstən/','adj. 东南方的','situated in or oriented toward the southeast','This city is in the Southeastern United States.','这个城市在美国东南部。','Southeastern United States','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2241,'claim_for','claim for','/kleɪm fɔːr/','phr.要求支付……的费用','','I want to make an insurance claim for the damage to my car.','我想对我的汽车遭受的损失提出保险索赔。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2242,'enactment','enactment','/ɪˈnæktmənt/','n. 颁布','the process of a law becoming official; a law which has been made official','The enactment of the regulation on garbage classification gained lots of support.','垃圾分类条例的颁布得到了广泛的支持。','','enact颁布 + ment表名词 →（法令）颁布',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2243,'obsessive','obsessive','/əbˈsesɪv/','adj.强迫性的','thinking about something or someone too much or in a way that is not normal :having an obsession','I\'m obsessive about pattern; I cannot bear any disorder.','我对图案排列有强迫症，不能忍受任何乱序。','obsessive about','obsess使着迷 + ive形容词后缀 → obsessive 着迷的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2244,'normalisation','normalisation','/ˌnɔːrmələˈzeɪʃn/','n. 正常化，标准化','the act of making something fit a normal pattern or condition; the fact of starting to fit a normal pattern or condition','We saw the normalisation of his heartbeat after we gave him medicine.','给他药以后，我们看到他心跳变得正常了（正常化）。','','normal正常的 + isation名词后缀 → normalisation正常化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2245,'cosmic','cosmic','/ˈkɑːzmɪk/','adj. 宇宙的；广大无边的','connected with the whole universe','Stars and planets form part of the cosmic system.','恒星和行星是宇宙系统的一部分。','','cosm宇航 + ic……的 → 宇宙的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2246,'saturation','saturation','/ˌsætʃəˈreɪʃn/','n.饱和（状态）；浸润，浸透','the state or process that happens when no more of something can be accepted or added because there is already too much of it or too many of them','The car park has reached saturation, meaning there are no spaces left.','这家停车场已经达到饱和状态，意味着没有空余车位了。','','satur足够，饱足 + ation名词后缀 → 饱和',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2247,'opening','opening','/ˈoʊpnɪŋ/','n. 开口；孔；开始；开幕；职位空缺','a space or hole that somebody/something can pass through','We can escape the cave through this opening.','我们可以从这个开口逃出洞穴。','','open开启 + ing名词后缀 → opening开幕，开口',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2248,'wealth','wealth','/welθ/','n.财富，财产；大量','a large amount of money, property, etc. that a person or country owns','Save your wealth in case you need it later.','储存你的财富，以备不时之需。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2249,'least','least','/liːst/','det.最少的，最小的；  adv.最少地，最小地','smallest in size, amount, degree, etc.','Piggy has the least toes among his friends.','小猪的脚趾头在他的朋友里面是最少的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2250,'profess','profess','/prəˈfes/','v. 表示，承认；宣称','to state openly that you have a particular belief, feeling, etc.','They publicly professed their love for each other.','他们公开承认了对彼此的爱。','professed their love','pro向前，在前 + fess说 → 在前面说坦白 → profess公开表明，坦白',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2251,'frail','frail','/freɪl/','adj. 脆弱的，不坚实的','(especially of an old person) physically weak and thin; weak; easily damaged or broken','The frail old lady needs a walking stick to walk.','这位虚弱的老太太需要拐杖的帮助来走路。','','frail=fract打碎的 → frail脆弱的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2252,'bring_up','bring up','/brɪŋ ʌp/','phr. 养育；呕出','raise a child','A mother should bring up her child with love and care.','母亲应该用爱心和关怀来养育她的孩子。','bring up her child','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2253,'connect_to','connect to','/kəˈnekt tuː/','phr.连接，相连','to join a computer or a mobile device to the Internet or to a computer network','These days it\'s very easy to connect to the Internet.','现在上网很容易。','connect to the Internet','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2254,'spontaneous','spontaneous','/spɑːnˈteɪniəs/','adj. 自发的，无意识的；自然的，天真率直的','not planned but done because you suddenly want to do it; often doing things without planning to, because you suddenly want to do them','The father made a spontaneous decision to take his family to the beach that day.','爸爸做了个心血来潮的决定，想在那天带着全家去海滩。','','spont=spond承诺 + aneous表形容词 → 自内心承诺 → 自愿的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2255,'out_of_style','out of style','/aʊt əv staɪl/','phr. 不时髦的，过时的','out of fashion, not fashion','The clothes he is wearing are out of style.','他穿的衣服已经过时了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2256,'struggle_against','struggle against','/\'strʌɡl əˈɡenst/','phr.同……做斗争','to exert strenuous effort against sth.','To get across the park, I had to struggle against the bad weather.','为了穿过公园，我必须与恶劣的天气做斗争。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2257,'irritating','irritating','/ˈɪrɪteɪtɪŋ/','adj. 刺激的，使人烦恼的','annoying, especially because of something somebody continuously does or something that continuously happens','The irritating customer succeeds in enraging him.','那位恼人的顾客成功激怒了他。','','irritat=irritate刺激 ＋ ing形容词后缀 → irritating刺激的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2258,'fall_ill','fall ill','/fɔːl ɪl/','phr. 患病，病倒','be sick','The man fell ill, so he had to stay in bed and rest.','这个男人病倒了，他必须卧床休息。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2259,'freshman','freshman','/ˈfreʃmən/','n.大学一年级生','a first-year student at a university or college; a first-year student at high school (1) or junior high school','Freshmen always have lots of things to do in their first few days at college.','在入学的头几天，新生们通常有很多事要做。','','fresh新鲜 + man人 → freshman新手，生手',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2260,'interesting','interesting','/ˈɪntrəstɪŋ/','adj. 有趣的，吸引人的','attracting your attention because it is special, exciting or unusual','Watching cartoons is more interesting for the little boy than doing his homework.','对这个小男孩来说，看动画片比做作业更有趣。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2261,'spend_time_on','spend time on','/spend taɪm ɔːn/','phr. 花时间做某事','take time to do something','Many people spend too much time on their phones and computers.','人们在手机和电脑上花的时间太多了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2262,'refrigerant','refrigerant','/rɪ\'frɪdʒərənt/','n. 制冷剂，冷冻剂；  adj. 退热的','a cooling substance, such as ice or solid carbon dioxide','A refrigerant is used to keep things such as air-conditioners or refrigerators cold.','制冷剂用以制冷，常用在空调或是冰箱等物体中。','','re再 ＋ friger冷 ＋ ant形容词后缀 → 再冷下来的东西 → refrigerant退烧药',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2263,'stocking','stocking','/ˈstɑːkɪŋ/','n.长（筒）袜','either of a pair of thin pieces of clothing that fit closely over a woman’s legs and feet','The girl in woolen stockings is relaxing with a cup of coffee.','这个穿着羊毛长筒袜的女孩正在喝咖啡放松。','woolen stockings','stock筒状物 + ing名词后缀 → stocking长筒袜',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2264,'generic','generic','/dʒəˈnerɪk/','adj. 属的，类的；非商标的；  n. 无注册商标产品','of or relating to a whole group or class','When you wear that skirt, you look like the generic woman on the bathroom sign!','当你穿上那条裙子的时候，你看起来就像厕所标志上的那个女人。','the generic woman','gen出生，产生+er活力，活动+ic,属于...的 → 科属的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2265,'lose_control_of','lose control of','/luz kənˈtrol ʌv/','v. 失控','to have something out of control','She lost control of her emotions.','她的情绪已失控。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2266,'rainbow','rainbow','/ˈreɪnboʊ/','n. 彩虹；呈彩虹状；彩虹状的；使呈彩虹状','a curved band of different colours that appears in the sky when the sun shines through rain','A rainbow arched across the sky.','一道彩虹横跨天际。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2267,'westward','westward','/ˈwestwərd/','adv. 向西；  adj. 西方的；  n. 西部','','The ship sailed westward across the Pacific Ocean.','这艘船穿过太平洋向西行驶。','','west西 ＋ ward向… → westward向西的；西方的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2268,'counteraction','counteraction','/kaʊntə\'rækʃn/','n. 反对的行动','action intended to nullify the effects of some previous action','The cats plotted their counteraction for when the dogs attacked again.','猫为应对狗的再次攻击，策划了它们的反击行动。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2269,'pancake','pancake','/ˈpænkeɪk/','n. 烙饼，薄饼','a thin flat round cake made from a mixture of flour, eggs and milk that is fried on both sides, usually eaten hot for breakfast in the US, and in Britain either as a dessert with sugar, jam, etc. or as a main course with meat, cheese, etc.','There are some pancakes with berries and maple syrup on the table.','桌子上有一些双莓枫糖浆烤薄饼。','','pan面包 + cake蛋糕 → pancake薄烤饼',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2270,'misguided','misguided','/ˌmɪsˈɡaɪdɪd/','adj. 被引入歧途的；被误导的；  v. 使入歧途','having wrong or improper goals or values','In a misguided attempt at a shortcut, he drove straight into the cornfield.','他试图抄近路，但是他直接误入了一片玉米地。','','mis 表示“错误，坏” + guid表示“引导” + ed [形容词后缀]，加在动词之后，表示“已...的”、“被...的”、“...了的” → misguided被误导的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2271,'wharf','wharf','/wɔːrf/','n. 码头','a flat structure built beside the sea or a river where boats can be tied up and goods unloaded','There is a ship at the wharf.','码头停着一艘船。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2272,'semicircle','semicircle','/ˈsemisɜːrkl/','n. 半圆形','half of a circle','This useful gadget allows you to draw a semicircle as well as a straight line.','这个有用的小工具能让你画半圆和直线。','draw a semicircle','semi半 + circle圆 → 半圆',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2273,'lose_track_of','lose track of','/luːz træk ʌv/','phr. 失去线索，失去消息，失去联系','to be unable to find marks left by someone; to be unable to find or get in touch with someone','The footprints disappeared in the snow; we lost track of our prey!','脚印在雪地里消失了，我们无法继续追踪猎物了！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2274,'plummet','plummet','/ˈplʌmɪt/','v. 垂直或突然地堕下，骤然下降','to fall straight down','The eagle plummets to the earth to catch the rabbit.','老鹰冲到地面去抓兔子。','plummets to the earth','plum=plumb铅锤+met量度→铅很重，所以下落很快 → 突然下落',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2275,'whenever','whenever','/wenˈevər/','conj.无论何时','at any time that; on any occasion that','You can call customer service whenever you want.','无论何时，你都可以呼叫客服。','','when何时 + ever究竟 → whenever无论何时，随时',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2276,'man-made','man-made','/ˌmæn ˈmeɪd/','adj.人工的，人造的','made by people rather than by nature','This park has a man-made lake.','这个公园里有一个人工湖。','man-made lake','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2277,'not_any_more','not any more','/nɒt ˈeni mɔr/','phr. 不再','no longer','The flower isn\'t colourful any more.','这朵花已不再鲜艳。','isn\'t colourful any more','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2278,'apologise','apologise','/əˈpɑːlədʒaɪz/','vi. 道歉，认错','to say that you are sorry for doing something wrong or causing a problem','I should apologise to my friend for what I did.','我应该为我的所作所为向我朋友道歉。','apologise to','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2279,'syndrome','syndrome','/ˈsɪndroʊm/','n.【医】综合征；典型表现','a set of physical conditions that show you have a particular disease or medical problem','Many people suffer from post-holiday syndrome after a long vacation.','很多人在长假后患上了“节后综合征”。','','syn一起 + drome前行 → syndrome并发症',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2280,'mouthful','mouthful','/ˈmaʊθfʊl/','n.一口，满口','an amount of food or drink that you put in your mouth at one time','Eat up one more big mouthful, then you can have dessert!','再吃一大口，你就能吃甜食了！','','mouth嘴巴 + ful名词后缀，表充满时的量 → mouthful一口',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2281,'show_off','show off','/ʃəʊ ɒf/','phr. 炫耀，卖弄','to show people somebody/something that you are proud of','The girl is showing off her diamond ring.','那个女孩正在炫耀她的钻石戒指。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2282,'analytic(al)','analytic(al)','/ˌænə\'lɪtɪkl/','adj.分析的；分解的','using or skilled in using analysis (i.e. separating a whole--intellectual or substantial--into its elemental parts or basic principles)','He has a very analytic mind, he loves to take things apart and see how they work.','他有一个善于分析的头脑，爱把东西拆开后观察每部分具体怎么工作。','analytic mind','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2283,'make_sense_of','make sense of','/mek sɛns ʌv/','phr. 了解...的意义，理解','When you make sense of something, you succeed in understanding it.','He is trying to make sense of this complicated book.','他试着去理解这本复杂的书。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2284,'fire','fire','/ˈfaɪər/','n. 火；火灾；  v. 解雇','the light and heat and especially the flame produced by burning','There is a fire burning by the sea.','海边有一堆燃烧的火。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2285,'chaos','chaos','/ˈkeɪɑːs/','n.混乱，纷乱','a state of complete confusion and lack of order','This kitchen is in chaos!','厨房里一片狼藉！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2286,'sorrow','sorrow','/ˈsɑːroʊ/','n.悲伤；伤心事；  v.感到悲伤；为……悲痛','a feeling of great sadness because something very bad has happened','Her tears are full of sorrow.','她的眼泪充满悲伤。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2287,'eastward','eastward','/ˈiːstwərd/','adv. 向东；  adj. 向东的','towards the east','He followed the map eastward, towards the treasure.','他沿着地图向东行进，朝着宝藏而去。','','east东 + ward向… → eastward向东的，向东',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2288,'rewind','rewind','/ˌriːˈwaɪnd/','v. 倒回（磁带等），倒带','to make something such as a film or a recording go backwards','Wait, what did he say? Rewind the track a bit so I can hear it again.','等等，他说了什么？把音轨倒回去一点让我再听一遍。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2289,'refuge','refuge','/ˈrefjuːdʒ/','n.保护区；避难所，收容所；  v.避难，寻求庇护；给以庇护，提供庇护','shelter or protection from danger, trouble, etc.','This is a wetland refuge for birds.','这是一个鸟类湿地保护区。','','re回 + fuge逃 → 逃到安全地方 → refuge避难',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2290,'donkey','donkey','/ˈdɔːŋki/','n. 驴；傻瓜','an animal of the horse family, with short legs and long ears. People ride donkeys or use them to carry heavy loads.','The donkey is trying to eat a carrot.','这头驴子正在努力吃一根胡萝卜。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2291,'a_great_deal','a great deal','/ə ɡreɪt dil/','phr. 大量','to a very great degree or extent','He has a great deal of work to do.','他有大量的工作要做。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2292,'clip','clip','/klɪp/','n. 回形针，夹子；  v. 夹住','(often in compounds) a small metal or plastic object used for holding things together or in place','Use this paper clip to hold the sheets together.','用回形针把这些纸夹在一起。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2293,'penniless','penniless','/ˈpeniləs/','adj.身无分文的，贫穷的','','I have a nice suit, but as you can see, I\'m penniless.','虽然我穿着漂亮的外套，但是如你所见，我身无分文。','','penni=penny便士 ＋ less表示“无…的”、“不…的” → penniless身无分文的；贫穷的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2294,'bug','bug','/bʌɡ/','n.错误，故障；  vt.使厌烦','a fault in a machine, especially in a computer system or program','The programmer is trying to fix the bug in the software.','程序员正在努力修复软件的故障。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2295,'stagnate','stagnate','/ˈstæɡneɪt/','v. 停滞不前，停止，不景气','to stop developing or making progress','The growth of this company has stagnated over recent years.','最近几年，这家公司的经济增长出现了停滞。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2296,'puncture','puncture','/ˈpʌŋktʃər/','v. 刺破（车胎等），扎，穿孔；  n. 刺孔，刺','to make a small hole in something; to get a small hole; to suddenly make somebody feel less confident, proud, etc.','One of the tyres was punctured by a nail.','有个车轮被钉子刺穿了。','','punct点，变尖 + ure名词后缀 → 点[进去] → puncture穿孔，刺穿',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2297,'superb','superb','/suːˈpɜːrb/','adj. 极好的；壮丽的','excellent; of very good quality','Her piano performance is superb.','她的钢琴表演很精彩。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2298,'permanent','permanent','/ˈpɜːrmənənt/','adj.长久的，持久的，永恒的','lasting for a long time or for all time in the future; existing all the time','He hopes to find a permanent job.','他希望找到一份长久的工作。','','per贯穿，自始至终 + man留住 + ent形容词后缀 → 永久留住 → permanent永恒的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2299,'suspicion','suspicion','/səˈspɪʃn/','n.怀疑','a feeling that somebody has done something wrong, illegal or dishonest, even though you have no proof; the feeling that you cannot trust somebody/something','The two men raised the suspicion of the policeman.','这两人引起了警察的怀疑。','','su=sus下面 + spic环顾，检查 + ion表名词 → 在下面看 → 怀疑',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2300,'corrode','corrode','/kəˈroʊd/','v.受腐蚀；腐蚀，侵蚀','to destroy something slowly, especially by chemical action; to be destroyed in this way','The metal corroded because you left it out in the rain for too long.','由于长时间淋雨，该金属被腐蚀了。','','cor全部 ＋ rode咬 → 全部咬掉 → corrode腐蚀，侵蚀',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2301,'submerge','submerge','/səbˈmɜːrdʒ/','v. 沉没，淹没','to go under the surface of water or liquid; to put something or make something go under the surface of water or liquid','The car was almost submerged by the floodwater!','汽车就快被洪水淹没了！','','sub在下面 + merge沉 → submerge淹没',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2302,'elated','elated','/iˈleɪtɪd/','adj. 振奋的；得意洋洋的','very happy and excited','People were elated at the news that Beijing had won the bid of 2022 Winter Olympics.','听到北京2022冬奥会申办成功的消息，人们都很振奋。','elated at','elat=elate使高兴+ed形容词后缀 → 兴高采烈的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2303,'sale','sale','/seɪl/','n.廉价出售','the act of selling something :the exchange of goods, services, or property for money','All the clothes are on sale.','所有衣服都在打折。','on sale','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2304,'kill','kill','/kɪl/','v.杀死；使停止','to make somebody/something die','The policeman shot the criminal and killed him.','这位警察把罪犯击毙了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2305,'simple-minded','simple-minded','/ˌsɪmpl ˈmaɪndɪd/','adj. 愚蠢的，头脑简单的','lacking subtlety and insight','The simple-minded  person thinks he can go to the moon through a hot-air balloon.','这个头脑简单的人认为他可以通过坐热气球去月球。','','simple简单 ＋ -mind头脑 ＋ ed构成形容词 → simple-minded头脑简单的；愚蠢的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2306,'be_obsessed_with','be obsessed with','/bi əbˈsest wɪð/','v. 对…着迷；（指恐惧等）缠住','be preoccupied with something','Modern folks are totally obsessed with their phones.','现代人总是沉迷于他们的手机。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2307,'Iceland','Iceland','/ˈaɪslənd/','n. 冰岛','an island republic on the island of Iceland; became independent of Denmark in 1944','Iceland is an island that lies off the north west of Europe.','冰岛是欧洲以西隔海相望的一个岛屿。','','Ice冰的 + land土地 → Iceland冰岛(欧洲岛名，在大西洋北部，近北极圈)',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2308,'holy','holy','/ˈhoʊli/','adj. 神圣的，圣洁的','connected with God or a particular religion','For the people of the tribe, the totem is a holy symbol.','对于这个部落的人来说，这根图腾是一个神圣的象征。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2309,'Atlantic','Atlantic','/æt\'læntɪk/','adj. 大西洋的；  n. 大西洋','of, relating to, or found in, on, or near the Atlantic Ocean','The northern part of Atlantic Ocean lies between Europe and North America.','北大西洋位于欧洲和北美洲之间。','','',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2310,'cycling','cycling','/ˈsaɪklɪŋ/','n. 骑脚踏车兜风；骑脚踏车消遣','the sport or activity of riding a bicycle','The couple love to go cycling in the countryside together.','这对夫妻喜欢一起在乡间骑脚踏车兜风。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2311,'marathon','marathon','/ˈmærəθɑːn/','n.马拉松赛跑；  adj.漫长而累人的；  v.参加马拉松赛跑','a running race that is about 26 miles (42 kilometers) long','To win a marathon, you need super-human endurance levels.','你需要拥有超乎常人的耐力才能赢得马拉松比赛。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2312,'congestion','congestion','/kənˈdʒestʃən/','n. 拥挤，充血','excessive crowding','This crossroad always has bad congestion because there are no traffic lights.','因为没有红绿灯，这个十字路口常常发生严重的交通堵塞。','','con 共同 + gest 带来 + ion [名词后缀]情况→共同带来的情况会阻塞→ n.拥塞, 充血',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2313,'diagnose','diagnose','/ˌdaɪəɡˈnoʊs/','v. 诊断（疾病），对（病人）下诊断结论','to say exactly what an illness or the cause of a problem is','The doctor diagnosed the patient with lung cancer.','医生诊断他患有肺癌。','','dia穿过，二者之间 + gnos知道 + e → diagnose诊断(疾病)，对（病人）下诊断结论',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2314,'heroin','heroin','/ˈheroʊɪn/','n. 海洛因','a powerful illegal drug made from morphine, that some people take for pleasure and can become addicted to','Heroin is a dangerous drug.','海洛因是一种危险的毒品。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2315,'supervisor','supervisor','/ˈsuːpərvaɪzər/','n.监督员，管理者，导师','a person who supervises somebody/something','The supervisor is overseeing the construction progress.','监督员正在督查施工进度。','','super在上面 ＋ vis看 ＋ or表示人 → supervisor监督人，检查员',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2316,'congress','congress','/ˈkɑːŋɡrəs/','n.国会；代表大会；议会；立法机关','(in the US and some other countries) the name of the group of people who are elected to make laws, in the US consisting of the Senate and the House of Representatives','A congress is a large meeting that is held to discuss national policies.','国会是讨论国家大事的大型会议。','','con共同 + gress行走 → 走到一起 → congress代表大会',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2317,'pharmaceutical','pharmaceutical','/ˌfɑːrməˈsuːtɪkl/','adj. 制药的，药物的；  n. 药物','of or relating to the production and sale of drugs and medicine','This ancient medical book introduces some pharmaceutical knowledge.','这本古代医学书介绍了一些药物知识。','pharmaceutical knowledge','pharmaceut制药 + ical ...的 → pharmaceutical制药（学）的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2318,'grill','grill','/ɡrɪl/','v.烤；拷问；  n.烤架','to cook food under or over a very strong heat; to cook food over a fire, especially outdoors; to ask somebody a lot of questions about their ideas, actions, etc., often in an unpleasant way','She\'s grilling the meat right now.','她正在烤肉。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2319,'northern','northern','/ˈnɔːrðərn/','adj. 北部的，北方的，有北方特征的','located in the north or facing north; connected with or typical of the north part of the world or a region','Canada is located in northern North America.','加拿大位于北美洲北部。','','north北 + ern形容词后缀 → northern 北方的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2320,'violent','violent','/ˈvaɪələnt/','adj.暴力的，粗暴的；强烈的，猛烈的','','Some violent pictures in this cartoon will have a negative effect on the boy.','这部动画片中的一些暴力画面会对这个男孩产生负面影响。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2321,'in_line_for','in line for','/ɪn laɪn fɔr/','adv.排队；即可得到','form a queue, form a line, stand in line','We wait in line for our job interviews.','我们排队等待工作面试。','wait in line for','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2322,'heartache','heartache','/ˈhɑːrteɪk/','n. 心痛；悲叹','a strong feeling of sadness or worry','The man is suffering the heartache of a failed relationship.','这个男人正在承受一段失败感情所带来的心痛。','','heart心 + ache痛 → heartache心痛',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2323,'gaudy','gaudy','/ˈɡɔːdi/','adj. （服饰、装饰、文风等）华丽而俗气的；  n. 华丽而俗气的廉价饰物','too bright and heavily decorated','That dress is gaudy and looks like a bedsheet.','那条裙子好俗气，看起来就像一条床单。','dress is gaudy','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2324,'excrement','excrement','/ˈekskrɪmənt/','n. 排泄物，粪便','solid waste passed out of the body','It is a piece of excrement !','这是一坨便便。','a piece of excrement','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2325,'magic','magic','/ˈmædʒɪk/','n.魔术，戏法；  adj.有魔力的，魔术的','the art of doing tricks that seem impossible in order to entertain people; the secret power of appearing to make impossible things happen by saying special words or doing special things; the art of doing tricks that seem impossible in order to entertain people','Pulling a rabbit out of a hat is the most classic magic trick.','从帽子里拉出一只兔子是最经典的魔术戏法。','magic trick','mag=mage魔术师 + ic…术 → magic魔术',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2326,'wool','wool','/wʊl/','n.（羊等动物的）毛','the soft fine hair that covers the body of sheep, goats and some other animals; long thick thread made from animal’s wool, used for knitting; cloth made from animal’s wool, used for making clothes, etc.','Lend me your wool please. I\'ll make you a pretty sweater.','借我点儿你的羊毛，我要给你织一件漂亮的毛衣。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2327,'sausage','sausage','/ˈsɔːsɪdʒ/','n. 香肠','a mixture of finely chopped meat, fat, bread, etc. in a long tube of skin, cooked and eaten whole or served cold in thin slices','I could eat sausage for breakfast, lunch, or dinner.','我早、中、晚餐都可以吃香肠。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2328,'retaliation','retaliation','/rɪˌtæliˈeɪʃn/','n. 报复；反击','action taken in return for an injury or offense','The boy pulled her hair, who kicked him in retaliation.','这个男孩扯了她的头发，她踢了男孩一脚作为报复。','','re相反 ＋ tali=other，tochange ＋ ation名词后缀 → 相反的方向做出反应 → retaliation报复；反击',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2329,'embryo','embryo','/ˈembrioʊ/','n. 【动物学】胚胎','a young animal or plant in the very early stages of development before birth, or before coming out of its egg or seed, especially a human egg in the first eight weeks after fertilization','Embryos take shape in the womb of a woman.','胚胎在女性的子宫里成形。','','em使 + bry发芽 + o表名词 → embryo胚胎，萌芽',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2330,'listener','listener','/ˈlɪsənər/','n.倾听者','someone who listens attentively','She\'s a good listener who always hears you out when you have problems.','她是个很好的倾听者。当你遇到问题时，她总是愿意听你把话说完。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2331,'learn_know_sth._by_heart','learn/know sth. by heart','/lɜːrn noʊ ˈsʌmθɪŋ baɪ hɑːrt/','phr. 记住，背下','keep in mind','The teacher was happy because her student learned the poem by heart.','老师很高兴，因为她的学生记住了这首诗。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2332,'oxygen','oxygen','/ˈɑːksɪdʒən/','n.氧气','a chemical element. Oxygen is a gas that is present in air and water and is necessary for people, animals and plants to live.','The patient is given a mask for oxygen.','医生给病人戴上氧气罩来供氧。','','oxy含氧的 + gen出生，产生 → 氧气',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2333,'basement','basement','/ˈbeɪsmənt/','n.地下室','a room or rooms in a building, partly or completely below the level of the ground','Many workers in Beijing live in the basement.','在北京，很多打工的人都住在地下室里。','','base基础 + ment表名词 → 在底下的地方 → 地下室',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2334,'fly','fly','/flaɪ/','v.飞行；  n.蝇，苍蝇','to move through the air with wings','I\'d like to fly up towards the sun, like an eagle.','我想像老鹰一样高高飞向太阳。','fly up','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2335,'literacy','literacy','/ˈlɪtərəsi/','n.读写能力；识字；有文化；教养','the ability to read and write','Chinese teachers mainly cultivate the students\' literacy.','语文老师主要培养孩子的读写能力。','','liter文字,字母 + acy表名词 → 认字，有文化',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2336,'verge','verge','/vɜːrdʒ/','n. 边缘；边界；  v. 接近；濒临','an edge or rim; margin','The verge of the road is covered with lovely blue flowers.','路的边缘长满了可爱的蓝色花朵。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2337,'eldest','eldest','/ˈeldɪst/','adj. 最年长的，最老的；  n. 最年长者','(of people, especially of three or more members of the same family) oldest','My older brother is the eldest child in our family.','我的大哥是家里最大的小孩。','','eld高龄 + est表示最高级“最……” → adj.最年长的；年事最高的（old的最高级）n.最年长者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2338,'cart','cart','/kɑːrt/','n. 手推车，运货马车；  v. 用车装载','a vehicle with two or four wheels that is pulled by a horse and used for carrying loads; a basket or table with wheels that can be pushed or pulled along and is used for carrying things; a light vehicle with wheels that you pull or push by hand','Carts are useful for carrying goods in the supermarket.','在超市里用手推车装商品很方便。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2339,'fear','fear','/fɪr/','v.害怕；敬畏；  n.恐惧','to be frightened of somebody/something or frightened of doing something','The girl feared the dog because it might bite her.','这个女孩害怕这只狗，因为它可能会咬她。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2340,'economically','economically','/ˌekəˈnɑːmɪkli/','adv. 经济上地；经济实用地','in a way connected with the trade, industry and development of wealth of a country, an area or a society','The USA is the economically strongest country over the world in 2017.','2017年，美国在经济方面是最强的国家。','','eco经济 + nom学术领域 + ic ..的 + ally表示方式、程度、状态、“...地” → economically节俭地，经济实用地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2341,'stamp','stamp','/stæmp/','n.印，章；邮票；  v.贴邮票于','a design or words made by stamping something onto a surface','The stamp on the pig shows the good quality of it.','猪身上盖的章表示猪的质量合格。','The stamp on the pig','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2342,'regard..._as','regard... as','/rɪˈɡɑrd æz/','phr. 把……看作','look sth  as sth','They love their dog so much that they regard it as part of their family.','他们爱狗爱到把它视为家庭中的一员。','regard it as part of their family','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2343,'balance','balance','/ˈbæləns/','n.平衡；  v.保持平衡；平衡','a situation in which different things exist in equal, correct or good amounts','Look, he can keep balance on that rope!','看啊，他能在那根绳索上保持平衡！','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2344,'dignity','dignity','/ˈdɪɡnəti/','n.威严；尊严','the fact of being given honour and respect by people','The king sat there with such regal dignity.','国王端坐在那里，浑身透着王者的威严。','','dign值得，高贵 + ity抽象名词 → dignity威严，庄严',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2345,'agitation','agitation','/ˌædʒɪˈteɪʃn/','n.摇动；焦虑，忧虑','worry and anxiety that you show by behaving in a nervous way','Apparently she is in a state of agitation.','显然她此刻身处忧虑之中。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2346,'chasm','chasm','/ˈkæzəm/','n. （地壳，冰上的）裂口，深坑，峡谷','a deep hole or opening in the surface of the earth','The wolf looked curiously down the chasm.','狼好奇地望着裂口下面。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2347,'flutter','flutter','/ˈflʌtər/','v. 飘动，飘扬；（鸟等）振翼，拍翅而飞；  n. 激动不安，紧张','to move lightly and quickly; to make something move in this way','The white flag flutters in the wind.','白色的旗帜在风中飘扬着。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2348,'teenage','teenage','/ˈtiːneɪdʒ/','adj.青少年（13～19岁）的','being of the age 13 through 19','Teenage children are aged between thirteen and nineteen years old.','青少年的年龄在13到19岁之间。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2349,'hut','hut','/hʌt/','n. 小屋','a small, simply built house or shelter','My hut is at the foot of the snow mountain.','我的小屋在雪山脚下。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2350,'silver','silver','/ˈsɪlvər/','n.银，银子；  adj.银色的','a soft grayish-white metal that is very valuable and is used to make jewelry, coins, knives, forks, etc.','I got a silver medal, meaning that I came in second place.','我得了一枚银牌，这意味着我拿了第二名。','silver medal','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2351,'play_a_part','play a part','/pleɪ ə pɑrt/','phr. 扮演角色','get involved in','Each member of our team plays a part in our success.','我们团队的每个成员都在我们的成功中起着作用。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2352,'copy','copy','/ˈkɑːpi/','v.抄写；  n.副本，拷贝','to make a version of (something) that is exactly or almost exactly like the original; to make a copy or duplicate of (something)','He is copying the picture from the book.','他正在临摹这本书上的图画。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2353,'by_virtue_of','by virtue of','/baɪ ˈvɜːrtʃuː əv/','n. 凭借，依靠','','By virtue of her outstanding acting, she won the Oscar for Best Actress!','她凭借精湛演技获得了奥斯卡最佳女演员奖！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2354,'pave','pave','/peɪv/','v. 铺（路），铺筑','to cover a surface with flat stones or bricks','The trail had been paved with stone.','这条小径用石子铺成。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2355,'convergence','convergence','/kənˈvɜːrdʒəns/','n. 汇聚','the occurrence of two or more things coming together','There is growing convergence between the two groups of people.','这两群人在逐渐汇聚。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2356,'participate_in','participate in','/pɑrˈtɪsəˌpet ɪn/','phr. 参与，参加','be involved in.','All participants are willing to participate in the meeting discussion.','所有与会者都积极参与会议讨论。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2357,'pharmacy','pharmacy','/ˈfɑːrməsi/','n.药房；药剂学；配药业，制药业；一批备用药品','a shop/store, or part of one, that sells medicines and drugs; a place in a hospital where medicines are prepared; the study of how to prepare medicines and drugs','You can find any medicine you need at this pharmacy.','在这家药房你能找到任何你需要的药物。','','pharm药剂 + acy构成抽象名词，表示性质、状态 → 药房，药剂学，配药业',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2358,'participate','participate','/pɑːrˈtɪsɪpeɪt/','vi.参与，加入','to take part in or become involved in an activity','The girl participates in the group discussion.','这个女孩儿加入了小组讨论。','','parti=part部分，分开 + cip抓住 + ate动词后缀 → 抓住机会成为其中一部分 → 参加',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2359,'dangerous','dangerous','/ˈdeɪndʒərəs/','adj.有危险的，引起危险的','likely to injure or harm somebody, or to damage or destroy something','It\'s very dangerous to open the car door without looking back.','不看后面就打开车门是很危险的。','','danger危险 + ous……的 → 有危险的 → dangerous危险的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2360,'normal','normal','/ˈnɔːrml/','adj.正常的，一般的','usual and ordinary, and is what people expect','I was glad when the doctor told me my heart beat was normal.','当医生告诉我，我的心跳正常的时候，我很开心。','','norm规则，规范 + al形容词后缀 → 有规范的 → normal正常的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2361,'grit','grit','/ɡrɪt/','n. 沙粒；决心，勇气；  v. 下定决心，咬紧牙关','very small pieces of sand or stone','They would spread grit on roads in winter to make them less slippery.','冬天，他们会在路上撒上沙粒，使路面不那么滑。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2362,'small','small','/smɔːl/','adj.小的；少的','not large in size, number, degree, amount, etc','This is a small model of my real house.','这是我房子的一个小模型。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2363,'duck','duck','/dʌk/','n.鸭；鸭肉；  v.回避，躲闪','a common bird that lives on or near water and has short legs, webbed feet','Ducks are swimming happily in the water.','鸭子们在水中欢快地游着。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2364,'action','action','/ˈækʃn/','n.行为；  v.务必对……进行处理','the process of doing something in order to make something happen or to deal with a situation; a thing that somebody does; the way a part of the body moves or functions; the mechanical parts of a piano, gun, clock, etc. or the way the parts move','It is a polite action to offer your seat to old people.','给老人让座是一个有礼貌的行为。','','act行动 + ion表行为，情况 → action行为',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2365,'restaurant','restaurant','/ˈrestrɑːnt/','n.餐馆','a place where you can buy and eat a meal','It is expensive to eat at this fancy restaurant.','在这家高档餐厅吃饭很贵。','fancy restaurant','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2366,'grateful_to_sb._for...','grateful to sb. for...','/ˈɡreɪtfl tuː ˈsʌmbədi fɔːr/','phr.就……对某人表示感激','','She felt grateful to the girl for the food.','她就这些食物对女孩表示感激。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2367,'electrode','electrode','/ɪˈlektroʊd/','n. 电极','either of two points (or terminals ) by which an electric current enters or leaves a battery or other electrical device','Attach the electrodes to the battery to jump-start the car.','连接电池的电极，以启汽车引擎。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2368,'vestige','vestige','/ˈvestɪdʒ/','n. 遗迹，（生）退化的器官，残余，微量（一般用于否定句）','a small part of something that still exists after the rest of it has stopped existing; usually used in negative sentences, to say that not even a small amount of something exists','The frescos on the wall are a last vestige of an ancient culture.','这幅壁画是古老文化的最后遗迹。','vestige of an ancient culture','vestig脚印，踪迹 + e → 痕迹；残余',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2369,'flabby','flabby','/ˈflæbi/','adj. （肌肉）松软的，意志薄弱的','out of condition; not strong or robust; incapable of exertion or endurance','As I\'m getting older, my arms are getting more and more flabby.','我年纪大了之后手臂肌肉就变得越来越柔软松弛了。','','flab软的，胖的 + b + y...的 → flabby（肌肉等）不结实的，松弛的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2370,'congratulate...on','congratulate...on','/kənˈɡrætʃuleɪt ɔːn/','phr. 祝贺……','to tell somebody that you are pleased about their success or achievements','Let me congratulate you on graduating with such a good degree.','让我祝贺你，带着这么好的学位毕业了！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2371,'ridge','ridge','/rɪdʒ/','n.脊，山脉','a narrow area of high land along the top of a line of hills; a high pointed area near the top of a mountain; a raised line on the surface of something; the point where two sloping surfaces join; a long narrow area of high pressure in the atmosphere','The aerial view of the ridges of this snowy mountain is quite magnificent.','这座雪山山脊的鸟瞰景色相当壮观。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2372,'role','role','/roʊl/','n. 角色','an actor’s part in a play, film/movie, etc.','The actress played challenging roles in many different TV series.','这名女演员在不同的电视剧里尝试了具有挑战性的角色。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2373,'licence','licence','/ˈlaɪsns/','n.许可证，执照','','See! I told you I have a driving licence!','看吧！我都跟你说了我有驾照的！','driving licence','licen=allow允许 + ce → licence特许，许可证',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2374,'put_in_order','put in order','/pʊt ɪn ˈɔrdɚ/','phr. 整理，排列','sort out, arrange something in order','These dolls have been put in order of largest to smallest.','这些娃娃按照从大到小的顺序排列着。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2375,'leadership','leadership','/ˈliːdərʃɪp/','n. 领导，领导地位；领导能力','the leaders of a group, organization, or country','Under his leadership, they made it to the top!','他们在他的领导下登上了山顶！','','lead 带领 + er 表人 + ship资格 → leadership领导',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2376,'meal','meal','/miːl/','n.一餐','the food that is eaten at a meal','The family enjoyed a tasty meal.','这家人享受了一顿美餐。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2377,'brief','brief','/briːf/','adj.简短的，简洁的；  n.摘要，概要；职责；  v.做……的摘要','the instructions that a person is given explaining what their job is and what their duties are; a legal case that is given to a lawyer to argue in court; a piece of work for a barrister; a written summary of the facts that support one side of a legal case, that will be presented to a court','The brief letter explains why she wants to quit.','这封简短的信解释了她为何想辞职。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2378,'propagate','propagate','/ˈprɑːpəɡeɪt/','vt. 传播，宣传；  v. 繁殖，增殖','to spread an idea, a belief or a piece of information among many people','The doctor is propagating the importance of wearing a mask.','医生正在宣传戴口罩的重要性。','','pro很多 + pag合同，商定 + ate表动词 → 传播,宣传',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2379,'conduct','conduct','/kənˈdʌkt/','v.指挥；进行；组织，安排，带领；传导（电、热等）；  n.行为举止；引导','to organize and/or do a particular activity','He is conducting an orchestra.','他正指挥着一支交响乐团。','','con共同 + duct引导，带来 → 引导大家一起做→conduct指挥',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2380,'disobey','disobey','/ˌdɪsəˈbeɪ/','v. 不服从','to not do what someone or something with authority tells you to do :to refuse or fail to obey rules, laws, etc.','The police stopped the driver who disobeyed the rules.','警察拦下了这个违反交通规则的司机。','','dis否定 + obey服从 → disobey不服从，违背',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2381,'word_of_mouth','word of mouth','/wɚd ʌv maʊθ/','phr. 口头语，口碑','the passing of information from person to person by oral communication','News can be spread very fast through word of mouth.','消息可以在口口相传中很快传播。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2382,'thirst','thirst','/θɜːrst/','n. 渴；干渴，缺水','the feeling of needing or wanting a drink','The precious water can satisfy his thirst.','这瓶宝贵的水能让他解渴。','satisfy his thirst','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2383,'wavelength','wavelength','/ˈweɪvleŋθ/','n. 波长','the distance between two similar points on a wave of energy, such as light or sound','The wavelength of light determines the color you see.','光的波长决定肉眼所看到得颜色。','','wave波 + length长度 → 波长',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2384,'bitterly','bitterly','/ˈbɪtərli/','adv. （形容不快或伤痛）极其，非常；伤心地，愤怒地','in a way that shows feelings of sadness or ange','This lemon has bitterly sour flavor.','这柠檬有股强烈的酸味。','','bitter苦涩的 + ly…地 → bitterly苦涩地，惨痛地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2385,'bleach','bleach','/bliːtʃ/','v. 漂白，使脱色；  n. 漂白剂','to become white or pale by a chemical process or by the effect of light from the sun; to make something white or pale in this way','She has bleached her hair blonde.','她把头发漂染成了金色。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2386,'reproduce','reproduce','/ˌriːprəˈduːs/','v.繁殖','if people, plants, animals, etc. reproduce or reproduce themselves, they produce young','Crocodiles reproduce by laying eggs on land.','鳄鱼通过在陆地上产卵来繁殖后代。','','re一再，重新 + produce生产 → reproduce再生产，再造',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2387,'coastal','coastal','/ˈkoʊstl/','adj. 海岸的','of or near a coast','This coastal road has wonderful views of the mountains and the sea.','在这条沿海公路上可以看到美丽的山海景色。','','coast海岸 + al...的 → coastal海岸的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2388,'coincide','coincide','/ˌkoʊɪnˈsaɪd/','v.巧合，一致，相符','(of two or more events) to take place at the same time; (of ideas, opinions, etc.) to be the same or very similar; (of objects or places) to meet; to share the same space','My birthday coincides with my wedding anniversary.','我的生日和我的结婚纪念日碰巧是同一天。','','co共同 + in进 + cide掉下 → 共同掉进来 → 巧合',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2389,'frightened','frightened','/ˈfraɪtnd/','adj.受惊的，受恐吓的','afraid; feeling fear','The looks on their faces show that they are frightened by something.','从他们脸上的表情可以看出他们被什么东西给吓到了。','frightened by','fright惊恐 + en表动词 + ed…的 → frightened受惊的，受恐吓的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2390,'deployment','deployment','/dɪˈplɔɪmənt/','n. 部署','the distribution of forces in preparation for battle or work','The dog ordered the deployment of 100 troops to help the cats fight monkeys.','这只狗下令派遣了100名狗士兵帮助小猫们与猴子作战。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2391,'mine','mine','/maɪn/','n. 矿，矿山；  v. 开采，采矿；  pron. 我的（所有物）','a deep hole or holes under the ground where minerals such as coal, gold, etc. are dug','Will he find any gold in the mine?','他能在矿里找到金子吗？','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2392,'screw','screw','/skruː/','n. 螺丝；螺旋；  vi. 敲诈勒索；  vt. 用螺钉固定','a thin pointed piece of metal like a nail with a raised spiral line (called a thread ) along it and a line or cross cut into its head. Screws are turned and pressed into wood, metal, etc. with a screwdriver in order to fasten two things together.','At each turn, the screw goes further into the piece of wood.','每转一圈，这块木头里的螺丝钉就钻得更深了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2393,'bound','bound','/baʊnd/','adj.必然的；有义务的；  v.束缚；跳跃着前行；  n.跳跃','certain or likely to happen, or to do or be something','The prisoner is bound to face his execution.','这名罪犯必然会面临极刑。','is bound to','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2394,'sick','sick','/sɪk/','adj.生病的；  n.病人；  v.呕吐','affected with a disease or illness','The sick boy fell asleep in the bed.','这个生病的男孩在床上睡着了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2395,'ample','ample','/ˈæmpl/','adj.富足的；丰满的；宽敞的','enough or more than enough; (of a person’s figure) large, often in an attractive way','We\'re lucky to have an ample amount of food to eat.','我们非常幸运能吃到这么多食物。','','ampl大，宽 + e → 很大，很宽 → ample富足的；宽敞的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2396,'goddess','goddess','/ˈɡɑːdəs/','n.女神；绝代佳人','a woman who is loved or admired very much by other people','Artemis, the goddess of hunting, was one of the figures in ancient Greek mythology.','狩猎女神阿尔忒弥斯是古希腊神话中的人物之一。','','godd=god神 + ess女性 → goddess女神',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2397,'stock','stock','/stɑːk/','n.存货；股票；  adj.储备的','a supply of something that is available for use','The stock was enough to fulfill the demand for the next three months.','库存足够满足接下来三个月的需求了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2398,'stipulate','stipulate','/ˈstɪpjuleɪt/','v.规定；保证；要求以……为条件','to state clearly and firmly that something must be done, or how it must be done','The confidentiality agreements stipulate that moviegoers can not reveal any plot of the movie.','保密协议规定，所有观影人都不得透露影片的任何情节。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2399,'compulsory','compulsory','/kəmˈpʌlsəri/','adj. 强制的，必修的','that must be done because of a law or a rule','You must follow traffic signs; obedience is compulsory.','遵守交通指示牌，服从(它的命令)是你必须做的。','','com共同 + puls驱动，推 + ory……的 → compulsory强制性的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2400,'exactly','exactly','/ɪɡˈzæktli/','adv.精确地，准确地','used to emphasize that something is correct in every way or in every detail','I want all my grass to be exactly the same height!','我要我的草都完全一样高。','exactly the same height','exact精确的 + ly副词后缀 → exactly精确地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2401,'play_a_joke','play a joke','/pleɪ eɪ dʒoʊk/','phr. 开玩笑','make fun of somebody or something','They played a joke on him by putting a "kick me" note on his back.','他们对他开了个玩笑，在他背上放了个“踢我”的纸条。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2402,'permissive','permissive','/pərˈmɪsɪv/','adj.放任的，纵容的','not preventive','The woman is very permissive of the dog, tolerating the mess that others might not tolerate!','这位女士对这只狗很纵容，甚至可以容忍其他人容忍不了的脏乱！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2403,'envelop','envelop','/ɪnˈveləp/','v. 包围，包上；  n. 信封（同“envelope”）','to wrap somebody/something up or cover them or it completely','The sea envelops the island.','大海包围着这座小岛。','','en在...里面 + velop包裹起来 → envelop包住',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2404,'stranger','stranger','/ˈstreɪndʒər/','n. 陌生人','someone who you have not met before or do not know','Kids, be careful of strangers offering candy!','小朋友，小心拿糖给你吃的陌生人！','','strang陌生的 + er人 → stranger陌生人；新来者',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2405,'rapture','rapture','/ˈræptʃər/','n. 狂喜','a feeling of extreme pleasure and happiness','When she won the tennis game she went into rapture.','当她赢得网球比赛时，简直欣喜若狂。','','rapt捕，夺 + ure名词后缀 → rapture狂喜，着迷',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2406,'midday','midday','/ˌmɪdˈdeɪ/','n. 中午，正午','12 o’clock in the middle of the day; the period around this time','It\'s too hot at midday, so don\'t go outside.','正午时分太热了，所以别出门啊。','','mid=middle中间的 + day天 → 一天的中间 → midday正午',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2407,'oilfield','oilfield','/ˈɔɪlfiːld/','n. 油田','a region rich in petroleum deposits (especially one with producing oil wells)','There were many big machines in the oilfield.','油田上有许多大型机器。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2408,'anything','anything','/ˈeniθɪŋ/','pron. 任何事','a thing of any kind','Welcome! Is there anything I can help you with?','欢迎光临！请问有什么可以帮您的吗？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2409,'intention','intention','/ɪnˈtenʃn/','n.打算，意图','what you intend or plan to do; your aim','I have every intention of buying a house, so I must start saving now.','我一心想买房，所以现在必须开始存钱了。','','intent意图 + ion表名词 → 有意图做某事 → intention有意图，故意',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2410,'yoke','yoke','/joʊk/','n. 牛轭；枷锁；纽带；  v. 结合；连结','a long piece of wood that is fastened across the necks of two animals, especially oxen, so that they can pull heavy loads','The two oxen are attached together by a yoke over their necks.','脖子上的牛轭将这两头牛拴在了一起。','a yoke over their necks','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2411,'glide','glide','/ɡlaɪd/','vi.滑翔；滑动；  n.滑翔，滑行；滑音，过渡音','to move smoothly and quietly, especially as though it takes no effort','The birds glide over the open ocean.','鸟儿们在广阔的海面上滑翔。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2412,'pamper','pamper','/ˈpæmpər/','v. 纵容，过分关怀，精心照料','to treat (someone or something) very well :to give (someone or something) a lot of attention and care','It\'s very common to see the grandparents pamper their grandson.','爷爷奶奶纵容自己的孙子，这种现象很常见。','pamper their grandson','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2413,'pathos','pathos','/ˈpeɪθɑːs/','n. 悲怆，哀婉','a quality that causes people to feel sympathy and sadness','Usually, some movies have pathos, which pull at people\'s emotions.','一般来说，有些电影有令人落泪的感伤力。','','path痛苦+os表名词 →痛苦',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2414,'catfish','catfish','/ˈkætfɪʃ/','n. 鲶鱼','','Catfish are a fish with spines around their mouths that resemble a cat\'s whiskers.','鲶鱼是一种嘴周围长有刺的鱼，它们嘴边的刺看起来像猫的胡须。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2415,'medicinal','medicinal','/məˈdɪsɪnl/','adj. 药物的','having the properties of medicine','The herb has medicinal properties.','这种植物具有药效。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2416,'hierarchical','hierarchical','/ˌhaɪəˈrɑːrkɪkl/','adj.分等级的','arranged in a hierarchy','Our company has a hierarchical structure, with the CEO at the top.','我们公司等级分明，最高层的是首席执行官。','','hier阶层的 + arch统治者，首要的 + ical……的 → adj.分层的；等级体系的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2417,'open','open','/ˈoʊpən/','adj.空缺的，开放的','allowing things or people to go through','The job is still open for applicants.','这个职位仍对应聘者开放。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2418,'be_ignorant_of','be ignorant of','/bi ˈɪɡnərənt ʌv/','phr. 不知道，不了解','lacking knowledge or information about something','To be ignorant of social injustice will only make things worse.','对社会不公平的不管不顾只会使情况变得更糟。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2419,'look_down_on','look down on','/lʊk daʊn ɑːn/','phr. 轻视','regard with contempt','He looked down on the character who wears T-shirt and shorts.','他看不起那个穿T恤和短裤的角色。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2420,'protective','protective','/prəˈtektɪv/','adj.防护的，保护的','providing or intended to provide protection; having or showing a wish to protect somebody/something; intended to give an advantage to your own country’s industry','Construction workers must wear protective equipment.','建筑工人必须穿戴防护装备。','','protect保护 + ive形容词后缀 → protective保护的，防护的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2421,'extended','extended','/ɪkˈstendɪd/','adj. 延长的，伸展的','relatively long in duration; tediously protracted','The shop now has extended hours until midnight.','这家商店现在的营业时间延长到了半夜12点。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2422,'gasp','gasp','/ɡæsp/','v.喘气；气喘吁吁地说出；  n.喘气','to take a quick deep breath with your mouth open, especially because you are surprised or in pain','The old man is gasping while going upstairs.','在上楼梯时，老人大口喘着气。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2423,'shaft','shaft','/ʃæft/','n.柄；轴；杆状物；  vt.苛刻地对待；给……装杆','the long narrow part of an arrow, hammer, golf club, etc.','The shaft of the axe is made of wood.','斧头的柄是木头做的。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2424,'Netherlands','Netherlands','/\'neðərləndz/','n.荷兰','','Netherlands is well-known for tulips and windmills.','荷兰因风车和郁金香举世闻名。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2425,'night','night','/naɪt/','n.夜晚；  adj.夜晚的','the darkness that occurs during the nighttime','When night falls, the moon begins to shine.','夜幕降临，月亮开始照耀大地。','night falls','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2426,'angrily','angrily','/ˈæŋɡrəli/','adv. 气愤地','with anger','The man is shouting angrily!','这个男人正愤怒地大吼！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2427,'source','source','/sɔːrs/','n.来源；出处','a person, book or document that provides information, especially for study, a piece of written work or news','Milk, delivered straight from the source.','牛奶，从源头新鲜直送。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2428,'jockey','jockey','/ˈdʒɑːki/','n.赛马的骑师','defeat someone in an expectation through trickery or deceit','The two jockeys are competing to win the race.','两位赛马的骑师正为赢得比赛而互相竞争。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2429,'tangle','tangle','/ˈtæŋɡl/','v. （使）缠结；（使）乱作一团；  n. 纠缠；纠结；复杂的问题；困惑','to twist something into an untidy mass; to become twisted in this way','That stupid dog got tangled up in our decorations.','那条愚蠢的狗被缠在了装饰品中。','got tangled up','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2430,'crossroads','crossroads','/ˈkrɔːsroʊdz/','n.十字路口','a place where two roads meet and cross','People are walking at the crossroads.','人们漫步在十字路口。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2431,'website','website','/ˈwebsaɪt/','n.网站','a place connected to the Internet, where a company or an organization, or an individual person, puts information','Users visit this website to search for the information they want.','用户访问这个网站来搜索他们想要的信息。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2432,'BC','BC','/ˌbiː ˈsiː/','abbr. 公元前（Before Christ）','','Confucius was born in 551 BC.','孔子出生于公元前551年。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2433,'app','app','/æp/','n. 应用程序','','I have a lot of apps on my phone.','我的手机上有很多应用程序。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2434,'left-wing','left-wing','/ˌleft ˈwɪŋ/','adj. 左翼的','strongly supporting the ideas of socialism','Those radicals are supporting the left-wing party to win the election.','这些激进分子支持左翼分子赢得大选。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2435,'culmination','culmination','/ˌkʌlmɪˈneɪʃn/','n.最高潮','a final climactic stage','Winning the Nobel Prize was the culmination of his career.','赢得诺贝尔奖是他职业生涯的最高潮。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2436,'spit','spit','/spɪt/','v.吐（唾沫）；  n.唾沫，口水','to force liquid, food, etc. out of your mouth','The boy is so rude that he spits towards the dog!','这个小男孩真是太粗鲁了，他居然向狗吐口水！','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2437,'cartoonist','cartoonist','/kɑːrˈtuːnɪst/','n. 漫画家','a person who draws cartoons','He is one of the most popular cartoonists in the world right now.','他现在是全世界最受欢迎的漫画家之一。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2438,'criminal','criminal','/ˈkrɪmɪnl/','n.罪犯；  adj.犯罪的，犯法的','a person who commits a crime','The convicted criminal is having his mug shot taken.','那个已定罪的罪犯正在拍面部照片。','','crimin罪 + al表名词 → criminal罪犯',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2439,'exponent','exponent','/ɪkˈspoʊnənt/','n. 【数】指数；说明者，说明物；  adj. 说明的','a symbol that is written above and to the right of a number to show how many times the number is to be multiplied by itself','The exponent of 2 is 2, so the answer is 4.','2指数为2，所以答案是4。','','ex出 ＋ pon放置 ＋ ent表示人 → 把[内容]放出来 → exponent讲解者',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2440,'conservative','conservative','/kənˈsɜːrvətɪv/','adj.保守的；保守党的；  n.保守主义者','','The man has such a conservative attitude; he even despises the couple holding hands.','他的态度如此保守，连情侣牵手都看不惯。','','conserv保留 + a + tive形容词后缀 → conservative保守的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2441,'save_one\'s_life','save one\'s life','/seɪv wʌnz laɪf/','phr. 挽救某人生命','rescue sb\'s life','The fireman saved the boy\'s life from the fire.','消防员从火灾中救出了小男孩。','saved the boy\'s life','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2442,'in_and_out','in and out','/ɪn ənd aʊt/','phr. 进进出出','change of position, inside and outside','So many commuters pass in and out of the subway station every day.','每天都有很多通勤者在地铁站进进出出。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2443,'lessen','lessen','/ˈlesn/','v. 减轻；减少','to become or make something become smaller, weaker, less important, etc.','Let\'s lessen the volume before our neighbors come over.','我们把音量调小点吧，不然邻居会来敲门的。','','less减少 + en动词后缀 → lessen减少，减轻',3,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2444,'Italy','Italy','/ˈɪtəli/','n.意大利','a republic in southern Europe on the Italian Peninsula; was the core of the Roman Republic and the Roman Empire between the 4th century BC and the 5th century AD','The national flag of Italy has three colors—green, white and red.','意大利国旗有三种颜色——绿色、白色和红色。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2445,'vitality','vitality','/vaɪˈtæləti/','n.活力，生命力','a lively or energetic quality','Regular exercise can increase a person\'s natural glow and vitality.','定期锻炼能让人精神焕发，更富活力。','','vital有活力的+ity表名词→vitality活力',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2446,'hunter','hunter','/ˈhʌntər/','n. 猎人；搜寻者','a person who hunts wild animals','The man with a hound is an experienced hunter.','这个带着猎犬的男人是个经验丰富的猎人。','','hunt打猎 ＋ er名词后缀 → hunter猎人',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2447,'serving','serving','/ˈsɜːrvɪŋ/','n.（供一人食用、饮用的）一份','an individual quantity of food or drink taken as part of a meal','She\'s making individual servings of soup for people to take.','她正把汤分成单人份供人们自取。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2448,'set_on_sb.','set on sb.','/set ɔːn ˈsʌmbədi/','v. 攻击','attack someone physically or emotionally','The runaway criminal was set on by a police dog.','那个逃跑的犯人被警犬攻击了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2449,'mountainous','mountainous','/ˈmaʊntənəs/','adj. 多山的；巨大的','having many mountains','Airplanes cannot land in this mountainous area.','飞机不能在这片山区着陆。','','mountain山 + ous形容词后缀 → mountainous多山的；巨大的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2450,'culprit','culprit','/ˈkʌlprɪt/','n. 罪犯，犯人，犯错者','a person who has done something wrong or against the law; a person or thing responsible for causing a problem','We found the culprit and brought him into the police station for questioning.','我们找到了罪犯，并把他带到了警署盘问。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2451,'reach','reach','/riːtʃ/','v.伸手够到；抵达；达到，发展到；与……取得联系','to arrive at the place that you have been travelling to','The baby boy is trying to reach for the red ball.','小宝宝正努力伸手去够红球。','reach for','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2452,'concession','concession','/kənˈseʃn/','n. 让步；特许，特许权','the act of giving up something or doing something in order to reach agreement','The mother made a concession and allowed the boy to continue watching TV.','妈妈让步了，同意让小男孩再多看一会儿电视。','made a concession','conces让步 + sion名词后缀 → concession 让步，妥协',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2453,'magnetosphere','magnetosphere','/mæg\'niːtəˌsfɪə/','n. 磁气圈','the region surrounding a planet, such as the earth, in which the behaviour of charged particles is controlled by the planet\'s magnetic field','The earth\'s magnetic field can be measured anywhere in its magnetosphere.','地球的磁场可以在磁气圈里任意位置被测量到。','','magneto磁的 ＋ sphere球 → magnetosphere磁气圈',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2454,'put','put','/pʊt/','v.改变（某人的）状况','to cause (someone or something) to be in a particular place or position','Being stuck in a traffic jam had put him in a bad mood.','遇上堵车使他心情不好。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2455,'evacuate','evacuate','/ɪˈvækjueɪt/','v.疏散','to move people from a place of danger to a safer place','The teacher is evacuating students from the burning building.','老师正在疏散起火大楼里的学生。','','e出 + vacu空 + ate动词后缀 → 空出去 → evacuate腾空；清除',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2456,'hypocrisy','hypocrisy','/hɪˈpɑːkrəsi/','n. 伪善；虚伪','behaviour in which somebody pretends to have moral standards or opinions that they do not actually have','This environmental worker\'s hypocrisy even made him dump trash in the ocean after collecting it.','这个环卫工很伪善，他收集完垃圾后竟然朝海里倒。','','hypo 欠缺 + cris 评论，观点 + y名词后缀 → 掩饰真实情感的 → hypocrisy伪善，虚伪',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2457,'bring_forth','bring forth','/brɪŋ fɔːrθ/','phr. 产生',' bring into existence','This apple tree always brings forth lots of fruit.','这棵苹果树总是结出很多果实。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2458,'postcode','postcode','/ˈpoʊstkoʊd/','n. <英>邮政编码','a group of letters and numbers that are used as part of an address so that post/mail can be separated into groups and delivered more quickly','Don\'t forget to write down the postcode before sending the letter!','在寄信前别忘了填邮政编码！','','post 邮件，邮政 + code 编码 → postcode（英）邮政编码',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2459,'calf','calf','/kæf/','n.小腿','the muscular back part of the leg below the knee','Your calf muscles will be sore after a long run.','经过长跑，你小腿肌肉会酸痛。','calf muscles','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2460,'posthumous','posthumous','/ˈpɑːstʃəməs/','adj. 死后的；著作者死后出版的','happening, done, or published after someone\'s death','The artist would never have expected that he would achieve such posthumous fame today.','这个艺术家做梦也想不到会今天他会赢得如此高的声誉。','achieve such posthumous fame','post后+hum土，引申为死+ous...的→死后的，遗腹的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2461,'jazz','jazz','/dʒæz/','n.爵士乐','a type of music with strong rhythms, in which the players often improvise (= make up the music as they are playing), originally created by African American musicians','Jazz music has become popular all over the world.','爵士乐在全球流行了。','Jazz music','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2462,'theft','theft','/θeft/','n.偷盗，盗窃','the crime of stealing something from a person or place','Theft is everywhere, even on the internet.','盗窃无处不在，甚至网上也有。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2463,'aggression','aggression','/əˈɡreʃn/','n.攻击性；侵略性','angry or violent behavior or feelings','This cat looks full of aggression.','这只猫看起来充满了攻击性。','','ag一再 + gress走 + ion名词后缀 → 一再往前走 → 进攻，侵略',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2464,'utensil','utensil','/juːˈtensl/','n. 工具，（厨房）用具','a tool that is used in the house','Knives, spoons and forks are dinner utensils.','叉、勺和刀是餐桌用具。','','ut用 + ensil表物品 → utensil用具',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2465,'grandchildren','grandchildren','/\'ɡræntʃɪldrən/','n. 孙子孙女们','','The old couple love their grandchildren very much.','这对老夫妇非常爱他们的孙子孙女们。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2466,'wade','wade','/weɪd/','v. 跋涉；涉水而行，淌水','to walk with an effort through something, especially water or mud','A flock of flamingos are wading in water.','一群火烈鸟在水里行走。','','wad=vad行走 + e → wade跋涉，涉水',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2467,'outdrive','outdrive','/aʊt\'draɪv/','v.驾车快于','','He outdrove his opponent and won the race.','他开车比对手快，赢得了比赛。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2468,'perpetuate','perpetuate','/pərˈpetʃueɪt/','vt. 使永久存在，使不朽；  adj. 长存的','to cause (something that should be stopped, such as a mistaken idea or a bad situation) to continue','As long as there were still clean plates, he perpetuated the mess in the kitchen.','只要还有干净的盘子，他就会把厨房里的脏乱状态延续下去。','','per全部，永久 ＋ petu=pet追寻，寻求 ＋ ate使... → perpetuate追求永久',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2469,'reign','reign','/reɪn/','v.占主导地位，统治，当政；  n.（君主）统治时期','to rule as king, queen, emperor, etc.;  to be the best or most important in a particular situation or area of skill','The king reigned over all the people in his land.','国王统治着他的国土上的所有人民。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2470,'plaintive','plaintive','/ˈpleɪntɪv/','adj. 表示悲痛的，伤心的','expressing suffering or sadness :having a sad sound','She was plaintive when I told her we had to break up.','当我告诉她我们必须分手时，她很痛苦。','','plaint抱怨 ＋ ive...的 → plaintive痛苦的，伤心的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2471,'theoretical','theoretical','/ˌθiːəˈretɪkl/','adj.理论（上）的','concerned with the ideas and principles on which a particular subject is based, rather than with practice and experiment','These books are too theoretical; I cannot read them.','这些书理论性太强了，我都读不懂。','','theore=theory理论 + t + ical……的 → theoretical理论（上）的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2472,'presence','presence','/ˈprezns/','n.出席，到场','the fact of being in a particular place; the state of being present','Every morning the teacher checks the presence in class.','老师每天早上都在课堂上检查我们的出勤情况。','checks the presence','pres前 + ence名词后缀 → presence出席，到场',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2473,'partially','partially','/ˈpɑːrʃəli/','adv. 部分地','partly; not completely','The sun is only partially visible during a solar eclipse.','日食发生时，只有一部分太阳可见。','','partial部分的 + ly副词后缀 → partially部分地',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2474,'sunlight','sunlight','/ˈsʌnlaɪt/','n.阳光','the light from the sun','The sunlight brightens the green field.','阳光照亮了绿地。','','sun太阳 + light光亮 → sunlight日光',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2475,'clear_away','clear away','/klɪr əˈweɪ/','phr. 把…收走','remove from sight','The waitress is clearing away the plates.','女服务生正在收盘子。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2476,'optimistic','optimistic','/ˌɑːptɪˈmɪstɪk/','adj.乐观的，乐观主义的','expecting good things to happen or something to be successful; showing this feeling','She stays optimistic, despite her condition.','即使身体很差，她也始终保持乐观。','','optim最好 + ist人 + ic…的 → optimistic乐观的',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2477,'precipitate','precipitate','/prɪˈsɪpɪteɪt/','adj. 突如其来的，仓促的，迅猛的；  v. 【气象】凝结；促成，使……沉淀，猛摔；  n. 沉淀物，冷凝物','to suddenly force somebody/something into a particular state or condition','They did not expect the rain to be precipitate as quickly as it did.','他们没料到这雨下得如此突然。','','pre…前的，预先 + cipit头 + ate做，造成 → precipitate加速，促进',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2478,'relieved','relieved','/rɪˈliːvd/','adj. 放心的，宽慰的','feeling happy because something unpleasant has stopped or has not happened','The parents were relieved that their child\'s operation was successful.','孩子的手术成功了，这对父母松了一口气。','','reliev=relieve宽慰 + ed形容词后缀 → 放心的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2479,'fascism','fascism','/ˈfæʃɪzəm/','n. 法西斯主义','a political theory advocating an authoritarian hierarchical government (as opposed to democracy or liberalism)','Many people believe that fascism caused World War II.','很多人认为法西斯主义导致了第二次世界大战。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2480,'retain','retain','/rɪˈteɪn/','v. 保持，保留，保存','to keep something; to continue to have something; to continue to hold or contain something;','Hot water can retain its heat for hours in the vacuum cup.','热水能在保温杯里保持温度好几个小时。','','re回 + tain握住 → 拿回来 → retain保留',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2481,'bruise','bruise','/bruːz/','n. （人体组织或表皮等跌、碰撞后产生的）青肿，挫伤；  v. 撞伤，碰伤，（使）挫伤，擦伤（表皮、表面）；打击','a blue, brown or purple mark that appears on the skin after somebody has fallen, been hit, etc.','The doctor is pressing the bruise with his finger.','医生正在用手指按压瘀伤。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2482,'endeavor','endeavor','/ɪnˈdevər/','n. 尝试，努力，尽力；  v. 努力，尽力','an attempt to do something, especially something new or difficult','Climbing this mountain is a risky endeavor.','爬这座山是一次冒险的尝试。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2483,'once','once','/wʌns/','conj.一旦，当……的时候','on one occasion only; one time','Once they knew the price of that house, they decided to take it.','他们一知道那房子的价格，就决定买下它。','','on=one一 + ce次 → 一次',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2484,'be_keen_on','be keen on','/bi kin ɑn/','phr. 渴望，喜爱，爱好，热衷于','to like someone or something','He is keen on reading and he reads every night before going to bed.','他很喜欢阅读，每晚都要读了才睡觉。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2485,'selfish','selfish','/ˈselfɪʃ/','adj.自私的','caring only about yourself rather than about other people','The selfish boy doesn\'t share the candies with the other kids.','这个自私的小男孩不跟其他小朋友分享糖果。','','self自己 + ish形容词后缀 → selfish自私的',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2486,'on_fire','on fire','/ɑːn faɪr/','phr. 着火','lighted up by or as by fire or flame','This car is on fire.','这辆车着火了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2487,'spiritual','spiritual','/ˈspɪrɪtʃuəl/','adj.精神（上）的；宗教（上）的','of or relating to a person\'s spirit','Living a simple life, she devoted herself to the pursuit of spiritual world.','她过着简朴的生活，致力于追求自己的精神世界。','','spirit精神 + ual形容词后缀  → spiritual精神的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2488,'dwarf','dwarf','/dwɔːrf/','n.侏儒；  vt.发育不全；  adj.矮生动物或植物的；发育不全的','an extremely small person, who will never grow to a normal size because of a physical problem; a person suffering from dwarfism','The Seven Dwarves were happy when staying with Snow White.','七个小矮人和白雪公主在一起时非常开心。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2489,'noise','noise','/nɔɪz/','n.噪声','a sound, especially when it is loud, unpleasant or disturbing; extra electrical or electronic signals that are not part of the signal that is being broadcast or transmitted and which may damage it; information that is not wanted and that can make it difficult for the important or useful information to be seen clearly','The machines outside are making a loud noise.','外面的机器发出了巨大的噪声。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2490,'inductive','inductive','/ɪnˈdʌktɪv/','adj. 归纳的，感应的，诱导的','using particular facts and examples to form general rules and principles','We\'ll have to use inductive reasoning to find the next shape in the series.','我们得用归纳推理找到系列中的下一个图像。','inductive reasoning','induct引导，感应 + ive形容词后缀 → inductive 感应的，归纳的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2491,'permanence','permanence','/ˈpɜːrmənəns/','n.持久；永久','the state of lasting for a long time or for all time in the future','The permanence of the stone lion means it has been with my family for generations.','这座石狮子一直都在，陪伴了我家几代人的成长。','','per始终 + man逗留 + ence表名词 → permanence永恒，持久',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2492,'exact','exact','/ɪɡˈzækt/','adj.确切的，精密严谨的','correct in every detail; (of people) very accurate and careful about details; (of a science) using accurate measurements and following set rules','The exact height of the tree is 5.386 meters.','这棵树的准确高度是5.386米。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2493,'submit','submit','/səbˈmɪt/','v.提交','to give a document, proposal, etc. to somebody in authority so that they can study or consider it','The man is submitting the report to his boss.','这个男人正在把报告递交给他的老板。','','sub下面 + mit送，放出 → 送下去 → submit屈服',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2494,'cop','cop','/kɑːp/','n. 【口语】警察；  v. 抓住、发现（某人）在干坏事；获得；遭受；握住','to receive or suffer something unpleasant; to notice something','"You! Stop, immediately!" Shouted the cop.','“你！站住！立刻！”警察喊道。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2495,'bank','bank','/bæŋk/','n.银行；  v.把钱存入银行','an organization that provides various financial services, for example keeping or lending money','Is my bank a safe place to keep my money?','我的银行是保管钱的安全之所吗？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2496,'generally','generally','/ˈdʒenrəli/','adv.普遍地，广泛地 ；一般地，通常；笼统地，概括地','in most cases','The weather this week will be generally rainy, with few chances of sunshine.','这个星期的天气主要都是下雨，几乎没有晴天。','','gener出生 + ally……地 → 出生具有普遍性 → 通常地；通常强调普遍性',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2497,'west','west','/west/','n.西方，西部；  adj.西的，西方的；  adv.向西方','the direction where the sun sets :the direction that is the opposite of east','On the compass, "W" stands for west.','在指南针上，“W”代表西方。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2498,'impress','impress','/ɪmˈpres/','v.使……有深刻印象','if a person or thing impresses you, you feel admiration for them or it; to make somebody understand how important, serious, etc. something is by emphasizing it; to have a great effect on something, especially somebody’s mind, imagination, etc.','The Great Wall really impressed the two foreign tourists.','长城给这两个外国游客留下了深刻的印象。','','im入，向内 + press挤压 → 压进去 → 印入头脑 → impress 使有印象，使铭记',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2499,'snap','snap','/snæp/','v.使咔嚓一声折断，吧嗒关上或打开；  n.吧嗒声；  adj.仓促的，突然的','to break quickly with a short, sharp to break something suddenly with a sharp noise; to be broken in this way','He was so angry that he snapped the pencil in two.','他太生气了，把铅笔咔嚓折成了两半。','snapped the pencil','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2500,'on_sale','on sale','/ɑːn seɪl/','phr.在打折，廉价出售；待售的；拍卖的','','All the shoes are on sale today.','今天所有的鞋子都在打折。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2501,'acquisition','acquisition','/ˌækwɪˈzɪʃn/','n. 获得；掌握；获得物；取得物','the act of getting something, especially knowledge, a skill, etc.','Reading is essential to the acquisition of knowledge.','阅读对于获取知识来说是必要的。','','ac加强 + quis询问 + ition名词后缀 → 通过询问得到 → 获得；增添的人(或物)',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2502,'annually','annually','/ˈænjuəli/','adv.一年一次；每年','once a year','The college entrance exam is held annually.','高考每年都会举办一次。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2503,'step','step','/step/','n.脚步，脚步声；  vi.走，举步','the act of lifting your foot and putting it down in order to walk or move somewhere; the sound this makes','He\'s so excited to see his baby girl take her first step.','看到他的宝贝女儿迈出第一步，他激动极了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2504,'frozen','frozen','/ˈfroʊzn/','adj. 冷冻的；  v. 使…冻住','(of food) kept at a very low temperature in order to preserve it; (of people or parts of the body) extremely cold; (of rivers, lakes, etc.) with a layer of ice on the surface; (especially of ground) so cold that it has become very hard; unable to move because of a strong emotion such as fear or horror','The forest stream became frozen during winter.','森林里的小溪在冬天结冰了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2505,'discriminate','discriminate','/dɪˈskrɪmɪneɪt/','v. 歧视；区别，辨别','to treat one person or group worse/better than another in an unfair way','Discriminating against others is a bad behavior.','歧视他人是不好的行为。','','dis分开，分离 + crimin分辨 + ate动词后缀 → discriminate分辩开',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2506,'squirrel','squirrel','/ˈskwɜːrəl/','n. 松鼠；  v. 储存','a small animal with a long thick tail and red, grey or black fur. Squirrels eat nuts and live in trees.','This squirrel is trying to remember where he hid the nuts.','这只松鼠正试着回想他把坚果藏哪儿了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2507,'insurgent','insurgent','/ɪnˈsɜːrdʒənt/','n. 叛乱分子；  adj. 叛乱的，起事的','a person fighting against the government or armed forces of their own country','The insurgent animals assembled at the farm and wanted to escape.','叛乱的动物们聚集在农场，想要逃跑。','','in内部 + surg升起 + ent……的 → 内部升起来 → insurgent起义的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2508,'renovate','renovate','/ˈrenəveɪt/','vt.更新，修复','to repair and paint an old building, a piece of furniture, etc. so that it is in good condition again','The man, accompanied by his dog, is renovating his own home.','这个男人正在狗狗的陪伴下整修自己的家。','','re重新 + nov新的 + ate造成 → 重新翻新 → renovate翻新',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2509,'humor','humor','/ˈhjuːmər/','n.幽默，诙谐','the quality in something that makes it funny or amusing; the ability to laugh at things that are amusing','This fun kids\' cartoon is full of humor.','这部有趣的儿童卡通片十分幽默。','','',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2510,'pamphlet','pamphlet','/ˈpæmflət/','n.小册子','a very thin book with a paper cover, containing information about a particular subject','This restaurant gives out hundreds of pamphlets to pedestrians every day.','这家餐厅每天向行人发数百份宣传册。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2511,'slum','slum','/slʌm/','n. 贫民窟，贫民区，陋巷','an area of a city that is very poor and where the houses are dirty and in bad condition','The living conditions in this slum are shockingly poor.','这个贫民窟的生活条件差得惊人。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2512,'throng','throng','/θrɔːŋ/','v.群集，蜂拥；  n.一大群人','to go somewhere or be present somewhere in large numbers','The crowds thronged into the mall.','人群涌进了大厅。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2513,'poetry','poetry','/ˈpoʊətri/','n.诗歌，诗作','a collection of poems; poems in general','I like reading poetry from the Tang Dynasty.','我很喜欢读唐朝的诗歌。','','poet诗人 ＋ ry集合 → poetry诗歌',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2514,'reveal','reveal','/rɪˈviːl/','vt.揭示','to make something known to somebody','He opened the curtain to reveal a landscape painting.','他掀开帘布，一幅风景画展现在我们眼前。','','re相反 + veal=veil盖上 → 与掩盖相反 → reveal揭露',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2515,'autonomy','autonomy','/ɔːˈtɑːnəmi/','n. 人身自由；自治权','the ability to act and make decisions without being controlled by anyone else','Parents give the child autonomy to make her favorite juice.','父母给了这个孩子自主权去做她喜欢的果汁。','','auto自己 + nomy系统，统治 → 自己统治 → autonomy自治',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2516,'raise','raise','/reɪz/','v.举起，抬高；筹集；增加，提高','to lift or move (something or someone) to a higher position','The kitten raises his friend up to steal the fish.','这只小猫咪把朋友举起来偷鱼。','raises his friend up','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2517,'out_of_control','out of control','/aʊt əv kənˈtroʊl/','phr. 失去控制','impossible to control successfully','The forest fire was completely out of control.','这场森林火灾彻底失控了。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2518,'humiliate','humiliate','/hjuːˈmɪlieɪt/','vt. 羞辱；使蒙耻','to make somebody feel ashamed or stupid and lose the respect of other people','The poor boy was badly humiliated at school.','那个可怜的男孩在学校遭受了严重的羞辱。','','hum土，地 ＋ ili ＋ ate使之成… → 使人贴到地上 → humiliate羞辱，侮辱',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2519,'search','search','/sɜːrtʃ/','v.搜索；  n.探求','to look carefully for something/somebody; to examine a particular place when looking for somebody/something','The police is searching for the jewel thief.','警察正在搜寻珠宝大盗。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2520,'key','key','/kiː/','n. 钥匙；  adj. 关键的','a specially shaped piece of metal used for locking a door, starting a car, etc.','The man in the white T-shirt is holding his keys.','穿白色T恤的男人拿着他的钥匙。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2521,'Friday','Friday','/ˈfraɪdeɪ/','n.星期五','the day of the week after Thursday and before Saturday','It\'s finally Friday!','终于到星期五了！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2522,'late','late','/leɪt/','adv.迟，晚','arriving, happening or done after the expected, arranged or usual time','She stayed up late working.','她工作到很晚。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2523,'dog','dog','/dɔːɡ/','n. 狗，犬，犬科动物','an animal with four legs and a tail, often kept as a pet or trained for work, for example hunting or guarding buildings. There are many types of dog, some of which are wild.; a male dog, fox or wolf','Your dog is really cute.','你的狗真可爱。','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2524,'value','value','/ˈvæljuː/','vt.重视；给……定价，评价','(not used in the progressive tenses) to think that somebody/something is important','Which do you value more—the economy or the environment?','经济和环境，你更重视哪个呢？','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2525,'from_time_to_time','from time to time','/frəm taɪm tu  taɪm/','phr.不时地','occasionally but not regularly','I go jogging from time to time.','我时不时地去慢跑一下。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2526,'interfere_with','interfere with','/ˌɪntərˈfɪr wɪð/','phr. 妨碍','to hinder','His late arrival interfered with the progress of the meeting.','他的迟到妨碍了开会的进程。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2527,'switch_off','switch off','/swɪtʃ ɔːf/','phr. 关上（点灯、电视等）','','He is about to switch off the light.','他正要把灯关了。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2528,'retention','retention','/rɪˈtenʃn/','n.保留，保持','the action of keeping something rather than losing it or stopping it; the action of keeping liquid, heat, etc. inside something rather than letting it escape; the ability to remember things','Water retention is vital for a cactus to survive in the desert.','仙人掌要想在沙漠中存活，保存水分很重要。','','re又 + ten握住 + tion表名词 → retention保留；持久力',2,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2529,'Australian','Australian','/ɔːˈstreɪliən/','adj.澳大利亚的；澳大利亚人的；  n.澳大利亚人','belonging or relating to Australia, or to its people or culture','Kangaroos are native Australian animals.','袋鼠是澳大利亚的本地动物。','','Australi澳大利亚 + an...的/人 → Australian澳大利亚的',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2530,'dare','dare','/der/','v.敢于；  n.激将','(not usually used in the progressive tenses) to be brave enough to do something','He dares to walk along the rope!','他竟然敢走钢丝！','','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2531,'vote_in','vote in','/vot ɪn/','phr. 选举(选出来)','elect in a voting process','Many people came to vote in the recent elections.','许多人去参加选举投票。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2532,'correspondence','correspondence','/ˌkɔːrəˈspɑːndəns/','n. 信件，函件；通信，通信联系','the letters or e-mails that people write to each other','For a correspondence course, you study at home and communicate with tutors by post.','函授课程是指你在家学习并通过邮寄方式与导师交流。','correspondence course','cor共同 + respond回答 + ence表名词 → correspondence通信；通信联系',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2533,'set_down','set down','/set daʊn/','phr.放下',' put down in writing; of texts, musical compositions, etc','He set his schoolbag down on the sofa and turned on the TV.','他把书包放在沙发上，并打开了电视。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2534,'fester','fester','/ˈfestər/','v. 化脓；使……痛苦；  n. 脓疮，脓疱','to become painful and infected','The wound on her knee began to fester since it wasn\'t treated well.','她的伤口因为没处理，开始溃烂了。','began to fester','',0,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`sentence_phrase`,`word_etyma`,`level`,`weight`) VALUES (2535,'knife','knife','/naɪf/','n. 小刀，刀，餐刀','a usually sharp blade attached to a handle that is used for cutting or as a weapon','A knife is used to cut things up.','刀是用来切东西的。','','',1,0);
INSERT INTO `word_en`(`id`,`w_code`,`word`,`accent`,`mean_cn`,`mean_en`,`sentence`,`sentence_trans`,`